/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.heartbeat;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.transport.HeartbeatSender;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import com.alibaba.csp.sentinel.transport.heartbeat.HeartbeatMessage;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpClient;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpRequest;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpResponse;
import com.alibaba.csp.sentinel.util.function.Tuple2;
import java.net.InetSocketAddress;
import java.util.List;

public class SimpleHttpHeartbeatSender
implements HeartbeatSender {
    private static final int OK_STATUS = 200;
    private static final long DEFAULT_INTERVAL = 10000L;
    private final HeartbeatMessage heartBeat = new HeartbeatMessage();
    private final SimpleHttpClient httpClient = new SimpleHttpClient();
    private final List<Tuple2<String, Integer>> addressList;
    private int currentAddressIdx = 0;

    public SimpleHttpHeartbeatSender() {
        List newAddrs = TransportConfig.getConsoleServerList();
        if (newAddrs.isEmpty()) {
            RecordLog.warn((String)"[SimpleHttpHeartbeatSender] Dashboard server address not configured or not available", (Object[])new Object[0]);
        } else {
            RecordLog.info((String)("[SimpleHttpHeartbeatSender] Default console address list retrieved: " + newAddrs), (Object[])new Object[0]);
        }
        this.addressList = newAddrs;
    }

    public boolean sendHeartbeat() throws Exception {
        if (TransportConfig.getRuntimePort() <= 0) {
            RecordLog.info((String)"[SimpleHttpHeartbeatSender] Command server port not initialized, won't send heartbeat", (Object[])new Object[0]);
            return false;
        }
        Tuple2<String, Integer> addrInfo = this.getAvailableAddress();
        if (addrInfo == null) {
            return false;
        }
        InetSocketAddress addr = new InetSocketAddress((String)addrInfo.r1, (int)((Integer)addrInfo.r2));
        SimpleHttpRequest request = new SimpleHttpRequest(addr, TransportConfig.getHeartbeatApiPath());
        request.setParams(this.heartBeat.generateCurrentMessage());
        try {
            SimpleHttpResponse response = this.httpClient.post(request);
            if (response.getStatusCode() == 200) {
                return true;
            }
            if (this.clientErrorCode(response.getStatusCode()) || this.serverErrorCode(response.getStatusCode())) {
                RecordLog.warn((String)("[SimpleHttpHeartbeatSender] Failed to send heartbeat to " + addr + ", http status code: " + response.getStatusCode()), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            RecordLog.warn((String)("[SimpleHttpHeartbeatSender] Failed to send heartbeat to " + addr), (Throwable)e);
        }
        return false;
    }

    public long intervalMs() {
        return 10000L;
    }

    private Tuple2<String, Integer> getAvailableAddress() {
        if (this.addressList == null || this.addressList.isEmpty()) {
            return null;
        }
        if (this.currentAddressIdx < 0) {
            this.currentAddressIdx = 0;
        }
        int index = this.currentAddressIdx % this.addressList.size();
        return this.addressList.get(index);
    }

    private boolean clientErrorCode(int code) {
        return code > 399 && code < 500;
    }

    private boolean serverErrorCode(int code) {
        return code > 499 && code < 600;
    }
}

