/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.web;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.servlet.callback.RequestOriginParser;
import com.alibaba.csp.sentinel.adapter.servlet.callback.UrlCleaner;
import com.alibaba.csp.sentinel.adapter.servlet.callback.WebCallbackManager;
import com.alibaba.csp.sentinel.adapter.servlet.util.FilterUtil;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

public class SentinelWebInterceptor
implements HandlerInterceptor {
    public static final String SENTINEL_ENTRY_ATTR_KEY = "$$sentinel_web_entry";
    public static final String SPRING_WEB_CONTEXT = "sentinel_spring_web_context";
    private static final String EMPTY_ORIGIN = "";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Object pattern = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        String target = pattern != null ? (String)pattern : FilterUtil.filterTarget((HttpServletRequest)request);
        UrlCleaner urlCleaner = WebCallbackManager.getUrlCleaner();
        if (urlCleaner != null) {
            target = urlCleaner.clean(target);
        }
        if (StringUtil.isEmpty((String)target)) {
            return true;
        }
        String origin = this.parseOrigin(request);
        ContextUtil.enter((String)SPRING_WEB_CONTEXT, (String)origin);
        try {
            Entry entry = SphU.entry((String)target, (int)1, (EntryType)EntryType.IN);
            request.setAttribute(SENTINEL_ENTRY_ATTR_KEY, (Object)entry);
            return true;
        }
        catch (BlockException ex) {
            WebCallbackManager.getUrlBlockHandler().blocked(request, response, ex);
            return false;
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Object e = request.getAttribute(SENTINEL_ENTRY_ATTR_KEY);
        if (e == null) {
            return;
        }
        Entry entry = (Entry)e;
        if (ex != null) {
            Tracer.traceEntry((Throwable)ex, (Entry)entry);
        }
        entry.exit();
        request.removeAttribute(SENTINEL_ENTRY_ATTR_KEY);
    }

    private String parseOrigin(HttpServletRequest request) {
        RequestOriginParser originParser = WebCallbackManager.getRequestOriginParser();
        String origin = EMPTY_ORIGIN;
        if (originParser != null && StringUtil.isEmpty((String)(origin = originParser.parseOrigin(request)))) {
            return EMPTY_ORIGIN;
        }
        return origin;
    }
}

