/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.filter.stat;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.FilterEventAdapter;
import com.alibaba.druid.filter.stat.StatFilterMBean;
import com.alibaba.druid.proxy.jdbc.CallableStatementProxy;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementExecuteType;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.sql.visitor.ParameterizedOutputVisitorUtils;
import com.alibaba.druid.stat.JdbcConnectionStat;
import com.alibaba.druid.stat.JdbcDataSourceStat;
import com.alibaba.druid.stat.JdbcResultSetStat;
import com.alibaba.druid.stat.JdbcSqlStat;
import com.alibaba.druid.stat.JdbcStatContext;
import com.alibaba.druid.stat.JdbcStatManager;
import com.alibaba.druid.stat.JdbcStatementStat;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class StatFilter
extends FilterEventAdapter
implements StatFilterMBean {
    private static final Log LOG = LogFactory.getLog(StatFilter.class);
    public static final String ATTR_UPDATE_COUNT = "stat.updteCount";
    public static final String ATTR_TRANSACTION = "stat.tx";
    protected JdbcDataSourceStat dataSourceStat;
    @Deprecated
    protected final JdbcStatementStat statementStat = JdbcStatManager.getInstance().getStatementStat();
    @Deprecated
    protected final JdbcResultSetStat resultSetStat = JdbcStatManager.getInstance().getResultSetStat();
    private boolean connectionStackTraceEnable = false;
    protected final AtomicLong resetCount = new AtomicLong();
    protected long slowSqlMillis = 3000L;
    private String dbType;
    private boolean mergeSql = false;
    public static final String ATTR_NAME_CONNECTION_STAT = "stat.conn";
    public static final String ATTR_NAME_STATEMENT_STAT = "stat.stmt";

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    @Override
    public boolean isConnectionStackTraceEnable() {
        return this.connectionStackTraceEnable;
    }

    @Override
    public void setConnectionStackTraceEnable(boolean connectionStackTraceEnable) {
        this.connectionStackTraceEnable = connectionStackTraceEnable;
    }

    public JdbcDataSourceStat getDataSourceStat() {
        return this.dataSourceStat;
    }

    @Override
    public void reset() {
        this.dataSourceStat.reset();
        this.resetCount.incrementAndGet();
    }

    @Override
    public long getResetCount() {
        return this.resetCount.get();
    }

    public boolean isMergeSql() {
        return this.mergeSql;
    }

    public void setMergeSql(boolean mergeSql) {
        this.mergeSql = mergeSql;
    }

    public String mergeSql(String sql) {
        if (!this.mergeSql) {
            return sql;
        }
        try {
            sql = ParameterizedOutputVisitorUtils.parameterize(sql, this.dbType);
        }
        catch (Exception e) {
            LOG.error("merge sql error", e);
        }
        return sql;
    }

    @Override
    public synchronized void init(DataSourceProxy dataSource) {
        this.dataSourceStat = dataSource.getDataSourceStat();
        if (this.dbType == null || this.dbType.trim().length() == 0) {
            this.dbType = dataSource.getDbType();
        }
        this.initFromProperties(dataSource.getConnectProperties());
        this.initFromProperties(System.getProperties());
    }

    private void initFromProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        String property = properties.getProperty("druid.stat.mergeSql");
        if ("true".equals(property)) {
            this.mergeSql = true;
        } else if ("false".equals(property)) {
            this.mergeSql = false;
        }
        property = properties.getProperty("druid.stat.slowSqlMillis");
        if (property != null && property.trim().length() > 0) {
            property = property.trim();
            try {
                this.slowSqlMillis = Long.parseLong(property);
            }
            catch (Exception e) {
                LOG.error("property 'druid.stat.slowSqlMillis' format error");
            }
        }
    }

    @Override
    public synchronized void destory() {
        if (this.dataSource == null) {
            return;
        }
        this.dataSource = null;
    }

    @Override
    public ConnectionProxy connection_connect(FilterChain chain, Properties info) throws SQLException {
        long nanoSpan;
        ConnectionProxy connection = null;
        long startNano = System.nanoTime();
        long startTime = System.currentTimeMillis();
        long nowTime = System.currentTimeMillis();
        this.dataSourceStat.getConnectionStat().beforeConnect();
        try {
            connection = chain.connection_connect(info);
            nanoSpan = System.nanoTime() - startNano;
        }
        catch (SQLException ex) {
            this.dataSourceStat.getConnectionStat().connectError(ex);
            throw ex;
        }
        this.dataSourceStat.getConnectionStat().afterConnected(nanoSpan);
        if (connection != null) {
            JdbcConnectionStat.Entry statEntry = this.getConnectionInfo(connection);
            this.dataSourceStat.getConnections().put(connection.getId(), statEntry);
            statEntry.setConnectTime(new Date(startTime));
            statEntry.setConnectTimespanNano(nanoSpan);
            statEntry.setEstablishNano(System.nanoTime());
            statEntry.setEstablishTime(nowTime);
            statEntry.setConnectStackTrace(new Exception());
            this.dataSourceStat.getConnectionStat().setActiveCount(this.dataSourceStat.getConnections().size());
        }
        return connection;
    }

    @Override
    public void connection_close(FilterChain chain, ConnectionProxy connection) throws SQLException {
        long nowNano = System.nanoTime();
        this.dataSourceStat.getConnectionStat().incrementConnectionCloseCount();
        JdbcConnectionStat.Entry connectionInfo = this.getConnectionInfo(connection);
        long aliveNanoSpan = nowNano - connectionInfo.getEstablishNano();
        JdbcConnectionStat.Entry existsConnection = (JdbcConnectionStat.Entry)this.dataSourceStat.getConnections().remove(connection.getId());
        if (existsConnection != null) {
            this.dataSourceStat.getConnectionStat().afterClose(aliveNanoSpan);
        }
        chain.connection_close(connection);
    }

    @Override
    public void connection_commit(FilterChain chain, ConnectionProxy connection) throws SQLException {
        chain.connection_commit(connection);
        this.dataSourceStat.getConnectionStat().incrementConnectionCommitCount();
    }

    @Override
    public void connection_rollback(FilterChain chain, ConnectionProxy connection) throws SQLException {
        chain.connection_rollback(connection);
        this.dataSourceStat.getConnectionStat().incrementConnectionRollbackCount();
        this.dataSourceStat.getConnectionStat().incrementConnectionRollbackCount();
    }

    @Override
    public void connection_rollback(FilterChain chain, ConnectionProxy connection, Savepoint savepoint) throws SQLException {
        chain.connection_rollback(connection, savepoint);
        this.dataSourceStat.getConnectionStat().incrementConnectionRollbackCount();
    }

    @Override
    public void statementCreateAfter(StatementProxy statement) {
        this.dataSourceStat.getStatementStat().incrementCreateCounter();
        super.statementCreateAfter(statement);
    }

    @Override
    public void statementPrepareCallAfter(CallableStatementProxy statement) {
        this.dataSourceStat.getStatementStat().incrementPrepareCallCount();
        JdbcSqlStat sqlStat = this.createSqlStat(statement, statement.getSql());
        statement.setSqlStat(sqlStat);
    }

    @Override
    public void statementPrepareAfter(PreparedStatementProxy statement) {
        this.dataSourceStat.getStatementStat().incrementPrepareCounter();
        JdbcSqlStat sqlStat = this.createSqlStat(statement, statement.getSql());
        statement.setSqlStat(sqlStat);
    }

    @Override
    public void statement_close(FilterChain chain, StatementProxy statement) throws SQLException {
        chain.statement_close(statement);
        this.dataSourceStat.getStatementStat().incrementStatementCloseCounter();
        JdbcStatContext context = JdbcStatManager.getInstance().getStatContext();
        if (context != null) {
            context.setName(null);
            context.setFile(null);
            context.setSql(null);
        }
    }

    @Override
    protected void statementExecuteUpdateBefore(StatementProxy statement, String sql) {
        this.internalBeforeStatementExecute(statement, sql);
    }

    @Override
    protected void statementExecuteUpdateAfter(StatementProxy statement, String sql, int updateCount) {
        this.internalAfterStatementExecute(statement, updateCount);
    }

    @Override
    protected void statementExecuteQueryBefore(StatementProxy statement, String sql) {
        this.internalBeforeStatementExecute(statement, sql);
    }

    @Override
    protected void statementExecuteQueryAfter(StatementProxy statement, String sql, ResultSetProxy resultSet) {
        this.internalAfterStatementExecute(statement, new int[0]);
    }

    @Override
    protected void statementExecuteBefore(StatementProxy statement, String sql) {
        this.internalBeforeStatementExecute(statement, sql);
    }

    @Override
    protected void statementExecuteAfter(StatementProxy statement, String sql, boolean result) {
        this.internalAfterStatementExecute(statement, new int[0]);
    }

    @Override
    protected void statementExecuteBatchBefore(StatementProxy statement) {
        String sql = statement.getBatchSql();
        int batchSize = statement.getBatchSqlList().size();
        JdbcSqlStat sqlStat = statement.getSqlStat();
        if (sqlStat == null) {
            sqlStat = this.createSqlStat(statement, sql);
            statement.setSqlStat(sqlStat);
        }
        if (sqlStat != null) {
            sqlStat.addExecuteBatchCount(batchSize);
        }
        this.internalBeforeStatementExecute(statement, sql);
    }

    @Override
    protected void statementExecuteBatchAfter(StatementProxy statement, int[] result) {
        this.internalAfterStatementExecute(statement, result);
    }

    private final void internalBeforeStatementExecute(StatementProxy statement, String sql) {
        JdbcStatContext statContext;
        JdbcSqlStat sqlStat;
        this.dataSourceStat.getStatementStat().beforeExecute();
        JdbcStatementStat.Entry statementStat = this.getStatementInfo(statement);
        ConnectionProxy connection = statement.getConnectionProxy();
        JdbcConnectionStat.Entry connectionCounter = this.getConnectionInfo(connection);
        statementStat.setLastExecuteStartNano(System.nanoTime());
        statementStat.setLastExecuteSql(sql);
        connectionCounter.setLastSql(sql);
        if (this.connectionStackTraceEnable) {
            connectionCounter.setLastStatementStatckTrace(new Exception());
        }
        if ((sqlStat = statement.getSqlStat()) == null) {
            sqlStat = this.createSqlStat(statement, sql);
            statement.setSqlStat(sqlStat);
        }
        if ((statContext = JdbcStatManager.getInstance().getStatContext()) != null) {
            sqlStat.setName(statContext.getName());
            sqlStat.setFile(statContext.getFile());
        }
        if (sqlStat != null) {
            sqlStat.setExecuteLastStartTime(System.currentTimeMillis());
            sqlStat.incrementRunningCount();
            try {
                boolean inTransaction;
                boolean bl = inTransaction = !statement.getConnectionProxy().getAutoCommit();
                if (inTransaction) {
                    sqlStat.incrementInTransactionCount();
                }
            }
            catch (SQLException e) {
                LOG.error("getAutoCommit error", e);
            }
        }
    }

    private final void internalAfterStatementExecute(StatementProxy statement, int ... updateCountArray) {
        JdbcStatementStat.Entry entry = this.getStatementInfo(statement);
        long nowNano = System.nanoTime();
        long nanoSpan = nowNano - entry.getLastExecuteStartNano();
        this.dataSourceStat.getStatementStat().afterExecute(nanoSpan);
        JdbcSqlStat sqlStat = statement.getSqlStat();
        if (sqlStat != null) {
            long millis;
            sqlStat.incrementExecuteSuccessCount();
            for (int updateCount : updateCountArray) {
                sqlStat.addUpdateCount(updateCount);
            }
            sqlStat.decrementRunningCount();
            sqlStat.addExecuteTime(statement.getLastExecuteType(), nanoSpan);
            statement.setLastExecuteTimeNano(nanoSpan);
            if (!statement.isFirstResultSet() && statement.getLastExecuteType() == StatementExecuteType.Execute) {
                try {
                    int updateCount = statement.getUpdateCount();
                    sqlStat.addUpdateCount(updateCount);
                }
                catch (SQLException e) {
                    LOG.error("getUpdateCount error", e);
                }
            }
            if ((millis = nanoSpan / 1000000L) >= this.slowSqlMillis) {
                StringBuilder buf = new StringBuilder();
                buf.append('[');
                int index = 0;
                for (JdbcParameter parameter : statement.getParameters().values()) {
                    Object value;
                    if (index != 0) {
                        buf.append(',');
                    }
                    if ((value = parameter.getValue()) == null) {
                        buf.append("null");
                    } else if (value instanceof String) {
                        char ch;
                        int i;
                        buf.append('\"');
                        String text = (String)value;
                        if (text.length() > 100) {
                            for (i = 0; i < 97; ++i) {
                                ch = text.charAt(i);
                                if (ch == '\'') {
                                    buf.append('\\');
                                    buf.append(ch);
                                    continue;
                                }
                                buf.append(ch);
                            }
                            buf.append("...");
                        } else {
                            for (i = 0; i < text.length(); ++i) {
                                ch = text.charAt(i);
                                if (ch == '\'') {
                                    buf.append('\\');
                                    buf.append(ch);
                                    continue;
                                }
                                buf.append(ch);
                            }
                        }
                        buf.append('\"');
                    } else if (value instanceof Number) {
                        buf.append(value.toString());
                    } else if (value instanceof Date) {
                        Date date = (Date)value;
                        buf.append(date.getClass().getSimpleName());
                        buf.append('(');
                        buf.append(date.getTime());
                        buf.append(')');
                    } else if (value instanceof Boolean) {
                        buf.append(value.toString());
                    } else if (value instanceof InputStream) {
                        buf.append("<InputStream>");
                    } else if (value instanceof Clob) {
                        buf.append("<Clob>");
                    } else if (value instanceof NClob) {
                        buf.append("<NClob>");
                    } else if (value instanceof Blob) {
                        buf.append("<Blob>");
                    } else {
                        buf.append('<');
                        buf.append(value.getClass().getName());
                        buf.append('>');
                    }
                    ++index;
                }
                buf.append(']');
                sqlStat.setLastSlowParameters(buf.toString());
            }
        }
    }

    @Override
    protected void statement_executeErrorAfter(StatementProxy statement, String sql, Throwable error) {
        JdbcStatementStat.Entry counter = this.getStatementInfo(statement);
        ConnectionProxy connection = statement.getConnectionProxy();
        JdbcConnectionStat.Entry connectionCounter = this.getConnectionInfo(connection);
        long nanoSpan = System.nanoTime() - counter.getLastExecuteStartNano();
        this.dataSourceStat.getStatementStat().error(error);
        this.dataSourceStat.getStatementStat().afterExecute(nanoSpan);
        connectionCounter.error(error);
        JdbcSqlStat sqlStat = statement.getSqlStat();
        if (sqlStat != null) {
            sqlStat.error(error);
            sqlStat.addExecuteTime(statement.getLastExecuteType(), nanoSpan);
            statement.setLastExecuteTimeNano(nanoSpan);
        }
        super.statement_executeErrorAfter(statement, sql, error);
    }

    @Override
    protected void resultSetOpenAfter(ResultSetProxy resultSet) {
        this.dataSourceStat.getResultSetStat().beforeOpen();
        resultSet.setConstructNano();
    }

    @Override
    public void resultSet_close(FilterChain chain, ResultSetProxy resultSet) throws SQLException {
        JdbcSqlStat sqlStat;
        long nanoSpan = System.nanoTime() - resultSet.getConstructNano();
        int fetchCount = resultSet.getFetchRowCount();
        this.dataSourceStat.getResultSetStat().afterClose(nanoSpan);
        this.dataSourceStat.getResultSetStat().addFetchRowCount(fetchCount);
        this.dataSourceStat.getResultSetStat().incrementCloseCounter();
        String sql = resultSet.getSql();
        if (sql != null && (sqlStat = resultSet.getSqlStat()) != null) {
            sqlStat.addFetchRowCount(fetchCount);
            long stmtExecuteNano = resultSet.getStatementProxy().getLastExecuteTimeNano();
            sqlStat.addResultSetHoldTimeNano(stmtExecuteNano, nanoSpan);
        }
        chain.resultSet_close(resultSet);
    }

    public JdbcConnectionStat.Entry getConnectionInfo(ConnectionProxy connection) {
        JdbcConnectionStat.Entry counter = (JdbcConnectionStat.Entry)connection.getAttributes().get(ATTR_NAME_CONNECTION_STAT);
        if (counter == null) {
            String dataSourceName = connection.getDirectDataSource().getName();
            connection.getAttributes().put(ATTR_NAME_CONNECTION_STAT, new JdbcConnectionStat.Entry(dataSourceName, connection.getId()));
            counter = (JdbcConnectionStat.Entry)connection.getAttributes().get(ATTR_NAME_CONNECTION_STAT);
        }
        return counter;
    }

    public JdbcStatementStat.Entry getStatementInfo(StatementProxy statement) {
        JdbcStatementStat.Entry counter = (JdbcStatementStat.Entry)statement.getAttributes().get(ATTR_NAME_STATEMENT_STAT);
        if (counter == null) {
            statement.getAttributes().put(ATTR_NAME_STATEMENT_STAT, new JdbcStatementStat.Entry());
            counter = (JdbcStatementStat.Entry)statement.getAttributes().get(ATTR_NAME_STATEMENT_STAT);
        }
        return counter;
    }

    @Override
    public long getConnectionActiveCount() {
        return this.dataSourceStat.getConnections().size();
    }

    @Override
    public long getConnectionCloseCount() {
        return this.dataSourceStat.getConnectionStat().getCloseCount();
    }

    @Override
    public long getConnectionCommitCount() {
        return this.dataSourceStat.getConnectionStat().getCommitCount();
    }

    @Override
    public long getConnectionConnectCount() {
        return this.dataSourceStat.getConnectionStat().getConnectCount();
    }

    @Override
    public long getConnectionConnectMillis() {
        return this.dataSourceStat.getConnectionStat().getConnectMillis();
    }

    @Override
    public long getConnectionConnectingMax() {
        return this.dataSourceStat.getConnectionStat().getConnectingMax();
    }

    @Override
    public long getConnectionRollbackCount() {
        return this.dataSourceStat.getConnectionStat().getConnectMillis();
    }

    @Override
    public long getConnectionConnectAliveMillis() {
        return this.dataSourceStat.getConnectionConnectAliveMillis();
    }

    @Override
    public long getConnectionConnectErrorCount() {
        return this.dataSourceStat.getConnectionStat().getConnectErrorCount();
    }

    @Override
    public Date getConnectionConnectLastTime() {
        return this.dataSourceStat.getConnectionStat().getConnectLastTime();
    }

    @Override
    public long getStatementCloseCount() {
        return this.dataSourceStat.getStatementStat().getCloseCount();
    }

    @Override
    public long getStatementCreateCount() {
        return this.dataSourceStat.getStatementStat().getCreateCount();
    }

    @Override
    public long getStatementExecuteMillisTotal() {
        return this.dataSourceStat.getStatementStat().getExecuteMillisTotal();
    }

    @Override
    public Date getStatementExecuteErrorLastTime() {
        return this.dataSourceStat.getStatementStat().getLastErrorTime();
    }

    @Override
    public Date getStatementExecuteLastTime() {
        return this.dataSourceStat.getStatementStat().getExecuteLastTime();
    }

    @Override
    public long getStatementPrepareCallCount() {
        return this.dataSourceStat.getStatementStat().getPrepareCallCount();
    }

    @Override
    public long getStatementPrepareCount() {
        return this.dataSourceStat.getStatementStat().getPrepareCount();
    }

    @Override
    public long getStatementExecuteErrorCount() {
        return this.dataSourceStat.getStatementStat().getErrorCount();
    }

    @Override
    public long getStatementExecuteSuccessCount() {
        return this.dataSourceStat.getStatementStat().getExecuteSuccessCount();
    }

    @Override
    public long getResultSetHoldMillisTotal() {
        return this.dataSourceStat.getResultSetStat().getHoldMillisTotal();
    }

    @Override
    public long getResultSetFetchRowCount() {
        return this.dataSourceStat.getResultSetStat().getFetchRowCount();
    }

    @Override
    public long getResultSetOpenCount() {
        return this.dataSourceStat.getResultSetStat().getOpenCount();
    }

    @Override
    public long getResultSetCloseCount() {
        return this.dataSourceStat.getResultSetStat().getCloseCount();
    }

    @Override
    public String getConnectionUrl() {
        if (this.dataSource == null) {
            return null;
        }
        return this.dataSource.getUrl();
    }

    public JdbcSqlStat createSqlStat(StatementProxy statement, String sql) {
        String contextSql;
        JdbcStatContext context = JdbcStatManager.getInstance().getStatContext();
        String string = contextSql = context != null ? context.getSql() : null;
        if (contextSql != null && contextSql.length() > 0) {
            return this.dataSourceStat.createSqlStat(contextSql);
        }
        sql = this.mergeSql(sql);
        return this.dataSourceStat.createSqlStat(sql);
    }

    public JdbcSqlStat getSqlCounter(String sql) {
        sql = this.mergeSql(sql);
        return this.getSqlStat(sql);
    }

    public JdbcSqlStat getSqlStat(String sql) {
        sql = this.mergeSql(sql);
        return this.dataSourceStat.getSqlStat(sql);
    }

    @Override
    public TabularData getSqlList() throws JMException {
        return this.dataSourceStat.getSqlList();
    }

    public static StatFilter getStatFilter(DataSourceProxy dataSource) {
        for (Filter filter : dataSource.getProxyFilters()) {
            if (!(filter instanceof StatFilter)) continue;
            return (StatFilter)filter;
        }
        return null;
    }

    public JdbcSqlStat getSqlStat(long id) {
        return this.dataSourceStat.getSqlStat(id);
    }

    @Override
    public CompositeData getStatementExecuteLastError() throws JMException {
        return this.dataSourceStat.getStatementStat().getLastError();
    }

    public final ConcurrentMap<Long, JdbcConnectionStat.Entry> getConnections() {
        return this.dataSourceStat.getConnections();
    }

    @Override
    public TabularData getConnectionList() throws JMException {
        return this.dataSourceStat.getConnectionList();
    }

    public static enum Feature {

        private final int mask = 1 << this.ordinal();

        public final int getMask() {
            return this.mask;
        }

        public static boolean isEnabled(int features, Feature feature) {
            return (features & feature.getMask()) != 0;
        }

        public static int config(int features, Feature feature, boolean state) {
            features = state ? (features |= feature.getMask()) : (features &= ~feature.getMask());
            return features;
        }
    }
}

