/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.hdriver.impl;

import com.alibaba.druid.hdriver.impl.mapping.HMappingTable;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;

public class HEngine {
    private static final Log LOG = LogFactory.getLog(HEngine.class);
    private static ConcurrentMap<String, HEngine> engines = new ConcurrentHashMap<String, HEngine>();
    private final String url;
    private HTablePool tablePool;
    private int htablePoolMaxSize = 256;
    private Configuration config;
    private ConcurrentMap<String, HMappingTable> mappings = new ConcurrentHashMap<String, HMappingTable>();

    public static HEngine getHEngine(String url, Properties connectProperties) {
        HEngine engine = (HEngine)engines.get(url);
        if (engine == null) {
            engine = new HEngine(url, connectProperties);
            engines.putIfAbsent(url, engine);
            engine = (HEngine)engines.get(url);
        }
        return engine;
    }

    public HEngine(String url, Properties connectProperties) {
        String propValue;
        this.url = url;
        this.config = new Configuration(false);
        if (connectProperties != null && (propValue = connectProperties.getProperty("htable.pool.size")) != null) {
            try {
                this.htablePoolMaxSize = Integer.parseInt(propValue);
            }
            catch (NumberFormatException ex) {
                LOG.error("parse property 'htable.pool.size' error", ex);
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public HTablePool getTablePool() {
        return this.tablePool;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public ConcurrentMap<String, HMappingTable> getMappings() {
        return this.mappings;
    }

    public synchronized HTableInterface getHTable(String tableName) {
        if (this.tablePool == null) {
            this.tablePool = new HTablePool(this.config, this.htablePoolMaxSize);
        }
        return this.tablePool.getTable(tableName);
    }

    public HBaseAdmin getHBaseAdmin() throws IOException {
        return new HBaseAdmin(this.config);
    }
}

