/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.hdriver.impl;

import com.alibaba.druid.hdriver.HResultSet;
import com.alibaba.druid.hdriver.HStatement;
import com.alibaba.druid.hdriver.impl.HResultSetMetaDataImpl;
import com.alibaba.druid.hdriver.impl.mapping.HMapping;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.jdbc.ResultSetBase;
import com.alibaba.druid.util.jdbc.ResultSetMetaDataBase;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.util.Bytes;

public class HScannerResultSetImpl
extends ResultSetBase
implements HResultSet {
    private HStatement statement;
    private ResultScanner scanner;
    private HTableInterface htable;
    private Result result;
    private byte[] family = Bytes.toBytes((String)"d");
    private HMapping mapping;

    public HScannerResultSetImpl(HStatement statement, HTableInterface htable, ResultScanner scanner) {
        super(statement);
        this.statement = statement;
        this.htable = htable;
        this.scanner = scanner;
    }

    public HMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(HMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public HStatement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            this.result = this.scanner.next();
            return this.result != null && !this.result.isEmpty();
        }
        catch (IOException ex) {
            throw new SQLException("read next error", ex);
        }
    }

    @Override
    public HResultSetMetaDataImpl getMetaData() throws SQLException {
        return (HResultSetMetaDataImpl)this.metaData;
    }

    public void setMetaData(HResultSetMetaDataImpl metaData) {
        this.metaData = metaData;
    }

    @Override
    public boolean previous() throws SQLException {
        return false;
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
    }

    @Override
    public Object getObjectInternal(int columnIndex) throws SQLException {
        ResultSetMetaDataBase.ColumnMetaData column = this.getMetaData().getColumn(columnIndex);
        return this.getObjectInternal(column.getColumnName(), column.getColumnType());
    }

    public Object getObjectInternal(String columnName, int type) throws SQLException {
        byte[] bytes = this.getBytes(columnName);
        switch (type) {
            case -6: {
                return bytes[0];
            }
            case 5: {
                return Bytes.toShort((byte[])bytes);
            }
            case 4: {
                return Bytes.toInt((byte[])bytes);
            }
            case -5: {
                return Bytes.toLong((byte[])bytes);
            }
            case 3: {
                return Bytes.toBigDecimal((byte[])bytes);
            }
            case 16: {
                return Bytes.toBoolean((byte[])bytes);
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return Bytes.toString((byte[])bytes);
            }
            case 91: {
                return new Date(Bytes.toLong((byte[])bytes));
            }
            case 93: {
                return new Timestamp(Bytes.toLong((byte[])bytes));
            }
        }
        return bytes;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        byte[] bytes = this.getBytes(columnIndex);
        return Bytes.toString((byte[])bytes);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        byte[] bytes = this.getBytes(columnName);
        return Bytes.toString((byte[])bytes);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        ResultSetMetaDataBase.ColumnMetaData column = this.getMetaData().getColumn(columnIndex);
        return this.getBytes(column.getColumnName());
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        if ("@ROW".equals(columnName)) {
            return this.result.getRow();
        }
        if ("id".equals(columnName)) {
            return this.result.getRow();
        }
        byte[] qualifier = Bytes.toBytes((String)columnName);
        byte[] value = this.result.getValue(this.family, qualifier);
        this.wasNull = value == null;
        return value;
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        byte[] bytes = this.getBytes(columnName);
        if (bytes == null) {
            return 0;
        }
        return Bytes.toInt((byte[])bytes);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        byte[] bytes = this.getBytes(columnIndex);
        if (bytes == null) {
            return 0;
        }
        return Bytes.toInt((byte[])bytes);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        byte[] bytes = this.getBytes(columnName);
        if (bytes == null) {
            return null;
        }
        return Bytes.toBigDecimal((byte[])bytes);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        byte[] bytes = this.getBytes(columnIndex);
        if (bytes == null) {
            return null;
        }
        return Bytes.toBigDecimal((byte[])bytes);
    }

    @Override
    public void close() throws SQLException {
        JdbcUtils.close((Closeable)this.scanner);
        try {
            this.htable.close();
        }
        catch (Exception ex) {
            throw new SQLException("close error", ex);
        }
        super.close();
    }
}

