/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.mock;

import com.alibaba.druid.mock.MockConnection;
import com.alibaba.druid.mock.MockResultSet;
import com.alibaba.druid.util.jdbc.PreparedStatementBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MockPreparedStatement
extends PreparedStatementBase
implements PreparedStatement {
    private final String sql;

    public MockPreparedStatement(MockConnection conn, String sql) {
        super(conn);
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    @Override
    public MockConnection getConnection() throws SQLException {
        return (MockConnection)super.getConnection();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        MockConnection conn = this.getConnection();
        if (conn != null && conn.getDriver() != null) {
            return this.getConnection().getDriver().createResultSet(this);
        }
        if (conn != null) {
            conn.handleSleep();
        }
        return new MockResultSet(this);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkOpen();
        if (this.getConnection() != null) {
            this.getConnection().handleSleep();
        }
        return 0;
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkOpen();
        if (this.getConnection() != null) {
            this.getConnection().handleSleep();
        }
        return false;
    }
}

