/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.mock.handler;

import com.alibaba.druid.mock.MockResultSet;
import com.alibaba.druid.mock.MockResultSetMetaData;
import com.alibaba.druid.mock.MockStatement;
import com.alibaba.druid.mock.handler.MockExecuteHandler;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlBooleanExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.CobarShowStatus;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.util.jdbc.ResultSetMetaDataBase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class MySqlMockExecuteHandlerImpl
implements MockExecuteHandler {
    @Override
    public ResultSet executeQuery(MockStatement statement, String sql) throws SQLException {
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        List<SQLStatement> stmtList = parser.parseStatementList();
        if (stmtList.size() > 1) {
            throw new SQLException("not support multi-statment. " + sql);
        }
        if (stmtList.size() == 0) {
            throw new SQLException("executeQueryError : " + sql);
        }
        SQLStatement stmt = stmtList.get(0);
        if (stmt instanceof CobarShowStatus) {
            return this.showStatus(statement);
        }
        if (!(stmt instanceof SQLSelectStatement)) {
            throw new SQLException("executeQueryError : " + sql);
        }
        SQLSelect select = ((SQLSelectStatement)stmt).getSelect();
        SQLSelectQuery query = select.getQuery();
        if (query instanceof SQLSelectQueryBlock) {
            return this.executeQuery(statement, (SQLSelectQueryBlock)query);
        }
        throw new SQLException("TODO");
    }

    public ResultSet executeQuery(MockStatement statement, SQLSelectQueryBlock query) throws SQLException {
        SQLTableSource from = query.getFrom();
        if (from instanceof SQLExprTableSource) {
            String ident;
            SQLExpr expr = ((SQLExprTableSource)from).getExpr();
            if (expr instanceof SQLIdentifierExpr && "dual".equalsIgnoreCase(ident = ((SQLIdentifierExpr)expr).getName())) {
                return this.executeQueryFromDual(statement, query);
            }
            throw new SQLException("TODO : " + query);
        }
        if (from == null) {
            return this.executeQueryFromDual(statement, query);
        }
        throw new SQLException("TODO");
    }

    public ResultSet showStatus(MockStatement statement) throws SQLException {
        MockResultSet rs = new MockResultSet(statement);
        MockResultSetMetaData metaData = rs.getMockMetaData();
        Object[] row = new Object[]{"on"};
        ResultSetMetaDataBase.ColumnMetaData column = new ResultSetMetaDataBase.ColumnMetaData();
        column.setColumnType(-9);
        metaData.getColumns().add(column);
        rs.getRows().add(row);
        return rs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultSet executeQueryFromDual(MockStatement statement, SQLSelectQueryBlock query) throws SQLException {
        MockResultSet rs = new MockResultSet(statement);
        MockResultSetMetaData metaData = rs.getMockMetaData();
        Object[] row = new Object[query.getSelectList().size()];
        int size = query.getSelectList().size();
        for (int i = 0; i < size; ++i) {
            ResultSetMetaDataBase.ColumnMetaData column = new ResultSetMetaDataBase.ColumnMetaData();
            SQLSelectItem item = query.getSelectList().get(i);
            SQLExpr expr = item.getExpr();
            if (expr instanceof SQLIntegerExpr) {
                row[i] = ((SQLNumericLiteralExpr)expr).getNumber();
                column.setColumnType(4);
            } else if (expr instanceof SQLNumberExpr) {
                row[i] = ((SQLNumericLiteralExpr)expr).getNumber();
                column.setColumnType(3);
            } else if (expr instanceof SQLCharExpr) {
                row[i] = ((SQLCharExpr)expr).getText();
                column.setColumnType(12);
            } else if (expr instanceof SQLNCharExpr) {
                row[i] = ((SQLNCharExpr)expr).getText();
                column.setColumnType(-9);
            } else if (expr instanceof MySqlBooleanExpr) {
                row[i] = ((MySqlBooleanExpr)expr).getValue();
                column.setColumnType(-9);
            } else if (expr instanceof SQLNullExpr) {
                row[i] = null;
            } else {
                if (!(expr instanceof SQLMethodInvokeExpr)) throw new SQLException("TODO");
                SQLMethodInvokeExpr methodInvokeExpr = (SQLMethodInvokeExpr)expr;
                if (!"NOW".equalsIgnoreCase(methodInvokeExpr.getMethodName())) throw new SQLException("TODO");
                row[i] = new Timestamp(System.currentTimeMillis());
            }
            metaData.getColumns().add(column);
        }
        rs.getRows().add(row);
        return rs;
    }
}

