/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.FilterChainImpl;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.ConnectionFactory;
import com.alibaba.druid.pool.DruidAbstractDataSourceMBean;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.ExceptionSorter;
import com.alibaba.druid.pool.PreparedStatementHolder;
import com.alibaba.druid.pool.ValidConnectionChecker;
import com.alibaba.druid.pool.WrapperAdapter;
import com.alibaba.druid.pool.vendor.NullExceptionSorter;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.proxy.jdbc.TransactionInfo;
import com.alibaba.druid.stat.JdbcDataSourceStat;
import com.alibaba.druid.stat.JdbcStatManager;
import com.alibaba.druid.util.ConcurrentIdentityHashMap;
import com.alibaba.druid.util.DruidLoaderUtils;
import com.alibaba.druid.util.Histogram;
import com.alibaba.druid.util.IOUtils;
import com.alibaba.druid.util.JdbcUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.sql.DataSource;

public abstract class DruidAbstractDataSource
extends WrapperAdapter
implements DruidAbstractDataSourceMBean,
DataSource,
DataSourceProxy,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_INITIAL_SIZE = 0;
    public static final int DEFAULT_MAX_ACTIVE_SIZE = 8;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MIN_IDLE = 0;
    public static final int DEFAULT_MAX_WAIT = -1;
    public static final String DEFAULT_VALIDATION_QUERY = null;
    public static final boolean DEFAULT_TEST_ON_BORROW = true;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final long DEFAULT_TIME_BETWEEN_CONNECT_ERROR_MILLIS = 30000L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    protected boolean defaultAutoCommit = true;
    protected Boolean defaultReadOnly;
    protected Integer defaultTransactionIsolation;
    protected String defaultCatalog = null;
    protected String name;
    protected String username;
    protected String password;
    protected String jdbcUrl;
    protected String driverClass;
    protected Properties connectionProperties = new Properties();
    protected PasswordCallback passwordCallback;
    protected NameCallback userCallback;
    protected ConnectionFactory connectionFactory;
    protected int initialSize = 0;
    protected int maxActive = 8;
    protected int minIdle = 0;
    protected int maxIdle = 8;
    protected long maxWait = -1L;
    protected String validationQuery = DEFAULT_VALIDATION_QUERY;
    protected int validationQueryTimeout = -1;
    private boolean testOnBorrow = true;
    private boolean testOnReturn = false;
    private boolean testWhileIdle = false;
    protected boolean poolPreparedStatements = false;
    protected boolean sharePreparedStatements = false;
    protected int maxPoolPreparedStatementPerConnectionSize = 10;
    protected boolean inited = false;
    protected PrintWriter logWriter = new PrintWriter(System.out);
    protected List<Filter> filters = new ArrayList<Filter>();
    protected ExceptionSorter exceptionSorter = null;
    protected Driver driver;
    protected int queryTimeout;
    protected int transactionQueryTimeout;
    protected long createErrorCount;
    protected long createTimespan;
    protected int maxWaitThreadCount = -1;
    protected boolean accessToUnderlyingConnectionAllowed = true;
    protected long timeBetweenEvictionRunsMillis = -1L;
    protected int numTestsPerEvictionRun = 3;
    protected long minEvictableIdleTimeMillis = 1800000L;
    protected boolean removeAbandoned;
    protected long removeAbandonedTimeoutMillis = 300000L;
    protected boolean logAbandoned;
    protected int maxOpenPreparedStatements = -1;
    protected List<String> connectionInitSqls;
    protected String dbType;
    protected long timeBetweenConnectErrorMillis = 30000L;
    protected ValidConnectionChecker validConnectionChecker = null;
    protected final AtomicLong errorCount = new AtomicLong();
    protected final AtomicLong dupCloseCount = new AtomicLong();
    protected final ConcurrentIdentityHashMap<DruidPooledConnection, DruidDataSource.ActiveConnectionTraceInfo> activeConnections = new ConcurrentIdentityHashMap();
    protected long id;
    protected Date createdTime;
    protected int connectionErrorRetryAttempts = 30;
    protected boolean breakAfterAcquireFailure = false;
    protected long transactionThresholdMillis = 0L;
    protected final AtomicLong commitCount = new AtomicLong();
    protected final AtomicLong startTransactionCount = new AtomicLong();
    protected final AtomicLong rollbackCount = new AtomicLong();
    protected final AtomicLong cachedPreparedStatementHitCount = new AtomicLong();
    protected final AtomicLong preparedStatementCount = new AtomicLong();
    protected final AtomicLong closedPreparedStatementCount = new AtomicLong();
    protected final AtomicLong cachedPreparedStatementCount = new AtomicLong();
    protected final AtomicLong cachedPreparedStatementDeleteCount = new AtomicLong();
    protected final AtomicLong cachedPreparedStatementMissCount = new AtomicLong();
    protected final Histogram transactionHistogram = new Histogram(10L, 100L, 1000L, 10000L, 100000L);
    private boolean dupCloseLogEnable = true;
    private ObjectName objectName;
    private final AtomicLong executeCount = new AtomicLong();
    protected Throwable createError;
    protected Throwable lastError;
    protected long lastErrorTimeMillis;
    protected Throwable lastCreateError;
    protected long lastCreateErrorTimeMillis;
    protected boolean isOracle = false;
    protected boolean useOracleImplicitCache = true;
    protected final ReentrantLock lock = new ReentrantLock(true);
    protected int modCount = 0;
    private final AtomicLong connectionIdSeed = new AtomicLong(10000L);
    private final AtomicLong statementIdSeed = new AtomicLong(20000L);
    private final AtomicLong resultSetIdSeed = new AtomicLong(50000L);
    private final AtomicLong transactionIdSeed = new AtomicLong(50000L);

    public boolean isOracle() {
        return this.isOracle;
    }

    protected int getModCount() {
        return this.modCount;
    }

    public void setOracle(boolean isOracle) {
        if (this.inited) {
            throw new IllegalStateException();
        }
        this.isOracle = isOracle;
    }

    @Override
    public boolean isUseOracleImplicitCache() {
        return this.useOracleImplicitCache;
    }

    @Override
    public void setUseOracleImplicitCache(boolean useOracleImplicitCache) {
        if (this.useOracleImplicitCache != useOracleImplicitCache) {
            boolean isOracleDriver10;
            this.useOracleImplicitCache = useOracleImplicitCache;
            boolean bl = isOracleDriver10 = this.isOracle() && this.driver != null && this.driver.getMajorVersion() == 10;
            if (isOracleDriver10) {
                this.getConnectProperties().setProperty("oracle.jdbc.FreeMemoryOnEnterImplicitCache", "true");
            } else {
                this.getConnectProperties().remove("oracle.jdbc.FreeMemoryOnEnterImplicitCache");
            }
        }
    }

    public Throwable getLastCreateError() {
        return this.lastCreateError;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public long getLastErrorTimeMillis() {
        return this.lastErrorTimeMillis;
    }

    public Date getLastErrorTime() {
        if (this.lastErrorTimeMillis <= 0L) {
            return null;
        }
        return new Date(this.lastErrorTimeMillis);
    }

    public long getLastCreateErrorTimeMillis() {
        return this.lastCreateErrorTimeMillis;
    }

    public Date getLastCreateErrorTime() {
        if (this.lastErrorTimeMillis <= 0L) {
            return null;
        }
        return new Date(this.lastCreateErrorTimeMillis);
    }

    @Override
    public int getTransactionQueryTimeout() {
        if (this.transactionQueryTimeout <= 0) {
            return this.queryTimeout;
        }
        return this.transactionQueryTimeout;
    }

    public void setTransactionQueryTimeout(int transactionQueryTimeout) {
        this.transactionQueryTimeout = transactionQueryTimeout;
    }

    public long getExecuteCount() {
        return this.executeCount.get();
    }

    public void incrementExecuteCount() {
        this.executeCount.incrementAndGet();
    }

    public boolean isDupCloseLogEnable() {
        return this.dupCloseLogEnable;
    }

    public void setDupCloseLogEnable(boolean dupCloseLogEnable) {
        this.dupCloseLogEnable = dupCloseLogEnable;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public Histogram getTransactionHistogram() {
        return this.transactionHistogram;
    }

    public void incrementCachedPreparedStatementCount() {
        this.cachedPreparedStatementCount.incrementAndGet();
    }

    public void decrementCachedPreparedStatementCount() {
        this.cachedPreparedStatementCount.decrementAndGet();
    }

    public void incrementCachedPreparedStatementDeleteCount() {
        this.cachedPreparedStatementDeleteCount.incrementAndGet();
    }

    public void incrementCachedPreparedStatementMissCount() {
        this.cachedPreparedStatementMissCount.incrementAndGet();
    }

    @Override
    public long getCachedPreparedStatementMissCount() {
        return this.cachedPreparedStatementMissCount.get();
    }

    @Override
    public long getCachedPreparedStatementAccessCount() {
        return this.cachedPreparedStatementMissCount.get() + this.cachedPreparedStatementHitCount.get();
    }

    @Override
    public long getCachedPreparedStatementDeleteCount() {
        return this.cachedPreparedStatementDeleteCount.get();
    }

    @Override
    public long getCachedPreparedStatementCount() {
        return this.cachedPreparedStatementCount.get();
    }

    public void incrementClosedPreparedStatementCount() {
        this.closedPreparedStatementCount.incrementAndGet();
    }

    @Override
    public long getClosedPreparedStatementCount() {
        return this.closedPreparedStatementCount.get();
    }

    public void incrementPreparedStatementCount() {
        this.preparedStatementCount.incrementAndGet();
    }

    @Override
    public long getPreparedStatementCount() {
        return this.preparedStatementCount.get();
    }

    public void incrementCachedPreparedStatementHitCount() {
        this.cachedPreparedStatementHitCount.incrementAndGet();
    }

    @Override
    public long getCachedPreparedStatementHitCount() {
        return this.cachedPreparedStatementHitCount.get();
    }

    @Override
    public long getTransactionThresholdMillis() {
        return this.transactionThresholdMillis;
    }

    @Override
    public void setTransactionThresholdMillis(long transactionThresholdMillis) {
        this.transactionThresholdMillis = transactionThresholdMillis;
    }

    public abstract void logTransaction(TransactionInfo var1);

    @Override
    public long[] getTransactionHistogramValues() {
        return this.transactionHistogram.toArray();
    }

    public long[] getTransactionHistogramRanges() {
        return this.transactionHistogram.getRanges();
    }

    @Override
    public long getCommitCount() {
        return this.commitCount.get();
    }

    public void incrementCommitCount() {
        this.commitCount.incrementAndGet();
    }

    @Override
    public long getRollbackCount() {
        return this.rollbackCount.get();
    }

    public void incrementRollbackCount() {
        this.rollbackCount.incrementAndGet();
    }

    @Override
    public long getStartTransactionCount() {
        return this.startTransactionCount.get();
    }

    public void incrementStartTransactionCount() {
        this.startTransactionCount.incrementAndGet();
    }

    @Override
    public boolean isBreakAfterAcquireFailure() {
        return this.breakAfterAcquireFailure;
    }

    public void setBreakAfterAcquireFailure(boolean breakAfterAcquireFailure) {
        this.breakAfterAcquireFailure = breakAfterAcquireFailure;
    }

    @Override
    public int getConnectionErrorRetryAttempts() {
        return this.connectionErrorRetryAttempts;
    }

    public void setConnectionErrorRetryAttempts(int connectionErrorRetryAttempts) {
        this.connectionErrorRetryAttempts = connectionErrorRetryAttempts;
    }

    @Override
    public long getDupCloseCount() {
        return this.dupCloseCount.get();
    }

    @Override
    public int getMaxPoolPreparedStatementPerConnectionSize() {
        return this.maxPoolPreparedStatementPerConnectionSize;
    }

    @Override
    public void setMaxPoolPreparedStatementPerConnectionSize(int maxPoolPreparedStatementPerConnectionSize) {
        if (maxPoolPreparedStatementPerConnectionSize > 0) {
            this.poolPreparedStatements = true;
        }
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
    }

    @Override
    public boolean isSharePreparedStatements() {
        return this.sharePreparedStatements;
    }

    public void setSharePreparedStatements(boolean sharePreparedStatements) {
        this.sharePreparedStatements = sharePreparedStatements;
    }

    public void incrementDupCloseCount() {
        this.dupCloseCount.incrementAndGet();
    }

    public ValidConnectionChecker getValidConnectionChecker() {
        return this.validConnectionChecker;
    }

    public void setValidConnectionChecker(ValidConnectionChecker validConnectionChecker) {
        this.validConnectionChecker = validConnectionChecker;
    }

    @Override
    public String getValidConnectionCheckerClassName() {
        if (this.validConnectionChecker == null) {
            return null;
        }
        return this.validConnectionChecker.getClass().getName();
    }

    public void setValidConnectionCheckerClassName(String validConnectionCheckerClass) throws Exception {
        Class<?> clazz = DruidLoaderUtils.loadClass(validConnectionCheckerClass);
        ValidConnectionChecker validConnectionChecker = null;
        if (clazz != null) {
            validConnectionChecker = (ValidConnectionChecker)clazz.newInstance();
        }
        this.validConnectionChecker = validConnectionChecker;
    }

    @Override
    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void addConnectionProperty(String name, String value) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.connectionProperties.put(name, value);
    }

    public Collection<String> getConnectionInitSqls() {
        List<String> result = this.connectionInitSqls;
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public void setConnectionInitSqls(Collection<Object> connectionInitSqls) {
        if (connectionInitSqls != null && connectionInitSqls.size() > 0) {
            ArrayList<String> newVal = null;
            for (Object o : connectionInitSqls) {
                String s;
                if (o == null || (s = o.toString()).trim().length() <= 0) continue;
                if (newVal == null) {
                    newVal = new ArrayList<String>();
                }
                newVal.add(s);
            }
            this.connectionInitSqls = newVal;
        } else {
            this.connectionInitSqls = null;
        }
    }

    @Override
    public long getTimeBetweenConnectErrorMillis() {
        return this.timeBetweenConnectErrorMillis;
    }

    public void setTimeBetweenConnectErrorMillis(long timeBetweenConnectErrorMillis) {
        this.timeBetweenConnectErrorMillis = timeBetweenConnectErrorMillis;
    }

    @Override
    public int getMaxOpenPreparedStatements() {
        return this.maxPoolPreparedStatementPerConnectionSize;
    }

    public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
        this.setMaxPoolPreparedStatementPerConnectionSize(maxOpenPreparedStatements);
    }

    @Override
    public boolean isLogAbandoned() {
        return this.logAbandoned;
    }

    @Override
    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    public int getRemoveAbandonedTimeout() {
        return (int)(this.removeAbandonedTimeoutMillis / 1000L);
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        this.removeAbandonedTimeoutMillis = removeAbandonedTimeout * 1000;
    }

    public void setRemoveAbandonedTimeoutMillis(long removeAbandonedTimeoutMillis) {
        this.removeAbandonedTimeoutMillis = removeAbandonedTimeoutMillis;
    }

    @Override
    public long getRemoveAbandonedTimeoutMillis() {
        return this.removeAbandonedTimeoutMillis;
    }

    @Override
    public boolean isRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    @Override
    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    @Deprecated
    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    @Override
    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    @Override
    public int getMaxWaitThreadCount() {
        return this.maxWaitThreadCount;
    }

    public void setMaxWaitThreadCount(int maxWaithThreadCount) {
        this.maxWaitThreadCount = maxWaithThreadCount;
    }

    @Override
    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    @Override
    public int getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public void setValidationQueryTimeout(int validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean accessToUnderlyingConnectionAllowed) {
        this.accessToUnderlyingConnectionAllowed = accessToUnderlyingConnectionAllowed;
    }

    @Override
    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    @Override
    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    @Override
    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    @Override
    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    @Override
    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    @Override
    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    @Override
    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    @Override
    public Integer getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(Integer defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public PasswordCallback getPasswordCallback() {
        return this.passwordCallback;
    }

    public void setPasswordCallback(PasswordCallback passwordCallback) {
        this.passwordCallback = passwordCallback;
    }

    public void setPasswordCallbackClassName(String passwordCallbackClassName) throws Exception {
        Class<?> clazz = DruidLoaderUtils.loadClass(passwordCallbackClassName);
        this.passwordCallback = clazz != null ? (PasswordCallback)clazz.newInstance() : null;
    }

    public NameCallback getUserCallback() {
        return this.userCallback;
    }

    public void setUserCallback(NameCallback userCallback) {
        this.userCallback = userCallback;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int seconds) {
        this.queryTimeout = seconds;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "DataSource-" + System.identityHashCode(this);
    }

    public String getNameInternal() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public void setPoolPreparedStatements(boolean poolPreparedStatements) {
        this.poolPreparedStatements = poolPreparedStatements;
    }

    @Override
    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWaitMillis) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.maxWait = maxWaitMillis;
    }

    @Override
    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.minIdle = minIdle;
    }

    @Override
    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.maxIdle = maxIdle;
    }

    @Override
    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.initialSize = initialSize;
    }

    @Override
    public long getCreateErrorCount() {
        return this.createErrorCount;
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.maxActive = maxActive;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.password = password;
    }

    @Override
    public Properties getConnectProperties() {
        return this.connectionProperties;
    }

    public void setConnectProperties(Properties connectionProperties) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.connectionProperties = connectionProperties;
    }

    public void setConnectionProperties(String connectionProperties) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        if (connectionProperties == null) {
            this.connectionProperties.clear();
            return;
        }
        String[] entries = connectionProperties.split(";");
        Properties properties = new Properties();
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i];
            if (entry.length() <= 0) continue;
            int index = entry.indexOf(61);
            if (index > 0) {
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                properties.setProperty(name, value);
                continue;
            }
            properties.setProperty(entry, "");
        }
        this.connectionProperties = properties;
    }

    @Override
    public String getUrl() {
        return this.jdbcUrl;
    }

    @Override
    public String getRawJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setUrl(String jdbcUrl) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.jdbcUrl = jdbcUrl;
    }

    @Override
    public String getDriverClassName() {
        return this.driverClass;
    }

    public void setDriverClassName(String driverClass) {
        if (this.inited) {
            throw new UnsupportedOperationException();
        }
        this.driverClass = driverClass;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    protected void initConnectionFactory() throws SQLException {
        this.connectionFactory = this.createConnectionFactory();
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        return new DruidPoolConnectionFactory(this);
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    @Override
    public int getDriverMajorVersion() {
        if (this.driver == null) {
            return -1;
        }
        return this.driver.getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        if (this.driver == null) {
            return -1;
        }
        return this.driver.getMinorVersion();
    }

    public ExceptionSorter getExceptionSorter() {
        return this.exceptionSorter;
    }

    public void setExceptionSorter(ExceptionSorter exceptionSoter) {
        this.exceptionSorter = exceptionSoter;
    }

    public void setExceptionSorterClassName(String exceptionSorter) throws Exception {
        this.setExceptionSorter(exceptionSorter);
    }

    public void setExceptionSorter(String exceptionSorter) throws Exception {
        if (exceptionSorter == null) {
            this.exceptionSorter = NullExceptionSorter.getInstance();
            return;
        }
        if ((exceptionSorter = exceptionSorter.trim()).length() == 0) {
            this.exceptionSorter = NullExceptionSorter.getInstance();
            return;
        }
        Class<?> clazz = DruidLoaderUtils.loadClass(exceptionSorter);
        this.exceptionSorter = (ExceptionSorter)clazz.newInstance();
    }

    @Override
    public List<Filter> getProxyFilters() {
        return this.filters;
    }

    public void setProxyFilters(List<Filter> filters) {
        if (filters != null) {
            this.filters.addAll(filters);
        }
    }

    public String[] getFilterClasses() {
        List<Filter> filterConfigList = this.getProxyFilters();
        ArrayList<String> classes = new ArrayList<String>();
        for (Filter filter : filterConfigList) {
            classes.add(filter.getClass().getName());
        }
        return classes.toArray(new String[classes.size()]);
    }

    public void setFilters(String filters) throws SQLException {
        String[] filterArray;
        if (filters == null || filters.length() == 0) {
            return;
        }
        for (String item : filterArray = filters.split("\\,")) {
            DruidLoaderUtils.loadFilter(this.filters, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnection(Connection conn) throws SQLException {
        String query = this.getValidationQuery();
        if (conn.isClosed()) {
            throw new SQLException("validateConnection: connection closed");
        }
        if (this.validConnectionChecker != null) {
            if (!this.validConnectionChecker.isValidConnection(conn, this.validationQuery, this.validationQueryTimeout)) {
                throw new SQLException("validateConnection false");
            }
            return;
        }
        if (null != query) {
            ResultSet rs;
            Statement stmt;
            block7: {
                stmt = null;
                rs = null;
                try {
                    stmt = conn.createStatement();
                    if (this.getValidationQueryTimeout() > 0) {
                        stmt.setQueryTimeout(this.getValidationQueryTimeout());
                    }
                    if ((rs = stmt.executeQuery(query)).next()) break block7;
                    throw new SQLException("validationQuery didn't return a row");
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(rs);
                    JdbcUtils.close(stmt);
                    throw throwable;
                }
            }
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean testConnectionInternal(Connection conn) {
        try {
            ResultSet rset;
            Statement stmt;
            block8: {
                boolean bl;
                if (this.validConnectionChecker != null) {
                    return this.validConnectionChecker.isValidConnection(conn, this.validationQuery, this.validationQueryTimeout);
                }
                if (conn.isClosed()) {
                    return false;
                }
                if (null == this.validationQuery) {
                    return true;
                }
                stmt = null;
                rset = null;
                try {
                    stmt = conn.createStatement();
                    if (this.getValidationQueryTimeout() > 0) {
                        stmt.setQueryTimeout(this.validationQueryTimeout);
                    }
                    if ((rset = stmt.executeQuery(this.validationQuery)).next()) break block8;
                    bl = false;
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(rset);
                    JdbcUtils.close(stmt);
                    throw throwable;
                }
                JdbcUtils.close(rset);
                JdbcUtils.close(stmt);
                return bl;
            }
            JdbcUtils.close(rset);
            JdbcUtils.close(stmt);
            return true;
        }
        catch (SQLException ex) {
            return false;
        }
    }

    public Set<DruidPooledConnection> getActiveConnections() {
        return this.activeConnections.keySet();
    }

    void removeActiveConnection(DruidPooledConnection conn) {
        this.activeConnections.remove(conn);
    }

    @Override
    public List<String> getActiveConnectionStackTrace() {
        ArrayList<String> list = new ArrayList<String>();
        for (DruidDataSource.ActiveConnectionTraceInfo traceInfo : this.activeConnections.values()) {
            list.add(IOUtils.toString(traceInfo.getStackTrace()));
        }
        return list;
    }

    public long getCreateTimespanNano() {
        return this.createTimespan;
    }

    @Override
    public long getCreateTimespanMillis() {
        return this.createTimespan / 1000000L;
    }

    @Override
    public Driver getRawDriver() {
        return this.driver;
    }

    @Override
    public long createConnectionId() {
        return this.connectionIdSeed.incrementAndGet();
    }

    @Override
    public long createStatementId() {
        return this.statementIdSeed.getAndIncrement();
    }

    @Override
    public long createResultSetId() {
        return this.resultSetIdSeed.getAndIncrement();
    }

    @Override
    public long createTransactionId() {
        return this.transactionIdSeed.getAndIncrement();
    }

    void initStatement(DruidPooledConnection conn, Statement stmt) throws SQLException {
        int queryTimeout;
        boolean transaction = !conn.getConnectionHolder().isUnderlyingAutoCommit();
        int n = queryTimeout = transaction ? this.getTransactionQueryTimeout() : this.getQueryTimeout();
        if (queryTimeout > 0) {
            stmt.setQueryTimeout(queryTimeout);
        }
    }

    public abstract void handleConnectionException(DruidPooledConnection var1, Throwable var2) throws SQLException;

    protected abstract void recycle(DruidPooledConnection var1) throws SQLException;

    abstract void incrementCreateCount();

    public CompositeDataSupport getCompositeData() throws JMException {
        StatFilter statFilter = null;
        JdbcDataSourceStat stat = null;
        for (Filter filter : this.getProxyFilters()) {
            if (!(filter instanceof StatFilter)) continue;
            statFilter = (StatFilter)filter;
        }
        if (statFilter != null) {
            stat = statFilter.getDataSourceStat();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ID", this.getID());
        map.put("URL", this.getUrl());
        map.put("Name", this.getName());
        map.put("FilterClasses", this.getFilterClasses());
        map.put("CreatedTime", this.getCreatedTime());
        map.put("RawDriverClassName", this.getDriverClassName());
        map.put("RawUrl", this.getUrl());
        map.put("RawDriverMajorVersion", this.getRawDriverMajorVersion());
        map.put("RawDriverMinorVersion", this.getRawDriverMinorVersion());
        map.put("Properties", this.getProperties());
        if (stat != null) {
            map.put("ConnectionActiveCount", stat.getConnectionActiveCount());
            map.put("ConnectionActiveCountMax", stat.getConnectionStat().getActiveMax());
            map.put("ConnectionCloseCount", stat.getConnectionStat().getCloseCount());
            map.put("ConnectionCommitCount", stat.getConnectionStat().getCommitCount());
            map.put("ConnectionRollbackCount", stat.getConnectionStat().getRollbackCount());
            map.put("ConnectionConnectLastTime", stat.getConnectionStat().getConnectLastTime());
            map.put("ConnectionConnectErrorCount", stat.getConnectionStat().getConnectErrorCount());
            Throwable lastConnectionConnectError = stat.getConnectionStat().getConnectErrorLast();
            if (lastConnectionConnectError != null) {
                map.put("ConnectionConnectErrorLastTime", stat.getConnectionStat().getErrorLastTime());
                map.put("ConnectionConnectErrorLastMessage", lastConnectionConnectError.getMessage());
                map.put("ConnectionConnectErrorLastStackTrace", IOUtils.getStackTrace(lastConnectionConnectError));
            } else {
                map.put("ConnectionConnectErrorLastTime", null);
                map.put("ConnectionConnectErrorLastMessage", null);
                map.put("ConnectionConnectErrorLastStackTrace", null);
            }
            map.put("StatementCreateCount", stat.getStatementStat().getCreateCount());
            map.put("StatementPrepareCount", stat.getStatementStat().getPrepareCount());
            map.put("StatementPreCallCount", stat.getStatementStat().getPrepareCallCount());
            map.put("StatementExecuteCount", stat.getStatementStat().getExecuteCount());
            map.put("StatementRunningCount", stat.getStatementStat().getRunningCount());
            map.put("StatementConcurrentMax", stat.getStatementStat().getConcurrentMax());
            map.put("StatementCloseCount", stat.getStatementStat().getCloseCount());
            map.put("StatementErrorCount", stat.getStatementStat().getErrorCount());
            Throwable lastStatementError = stat.getStatementStat().getLastException();
            if (lastStatementError != null) {
                map.put("StatementLastErrorTime", stat.getStatementStat().getLastErrorTime());
                map.put("StatementLastErrorMessage", lastStatementError.getMessage());
                map.put("StatementLastErrorStackTrace", IOUtils.getStackTrace(lastStatementError));
            } else {
                map.put("StatementLastErrorTime", null);
                map.put("StatementLastErrorMessage", null);
                map.put("StatementLastErrorStackTrace", null);
            }
            map.put("StatementExecuteMillisTotal", stat.getStatementStat().getMillisTotal());
            map.put("StatementExecuteLastTime", stat.getStatementStat().getExecuteLastTime());
            map.put("ConnectionConnectingCount", stat.getConnectionStat().getConnectingCount());
            map.put("ResultSetCloseCount", stat.getResultSetStat().getCloseCount());
            map.put("ResultSetOpenCount", stat.getResultSetStat().getOpenCount());
            map.put("ResultSetOpenningCount", stat.getResultSetStat().getOpenningCount());
            map.put("ResultSetOpenningMax", stat.getResultSetStat().getOpenningMax());
            map.put("ResultSetFetchRowCount", stat.getResultSetStat().getFetchRowCount());
            map.put("ResultSetLastOpenTime", stat.getResultSetStat().getLastOpenTime());
            map.put("ResultSetErrorCount", stat.getResultSetStat().getErrorCount());
            map.put("ResultSetOpenningMillisTotal", stat.getResultSetStat().getAliveMillisTotal());
            map.put("ResultSetLastErrorTime", stat.getResultSetStat().getLastErrorTime());
            Throwable lastResultSetError = stat.getResultSetStat().getLastError();
            if (lastResultSetError != null) {
                map.put("ResultSetLastErrorMessage", lastResultSetError.getMessage());
                map.put("ResultSetLastErrorStackTrace", IOUtils.getStackTrace(lastResultSetError));
            } else {
                map.put("ResultSetLastErrorMessage", null);
                map.put("ResultSetLastErrorStackTrace", null);
            }
            map.put("ConnectionConnectCount", stat.getConnectionStat().getConnectCount());
            Throwable lastConnectionError = stat.getConnectionStat().getErrorLast();
            if (lastConnectionError != null) {
                map.put("ConnectionErrorLastMessage", lastConnectionError.getMessage());
                map.put("ConnectionErrorLastStackTrace", IOUtils.getStackTrace(lastConnectionError));
            } else {
                map.put("ConnectionErrorLastMessage", null);
                map.put("ConnectionErrorLastStackTrace", null);
            }
            map.put("ConnectionConnectMillisTotal", stat.getConnectionStat().getConnectMillis());
            map.put("ConnectionConnectingCountMax", stat.getConnectionStat().getConnectingMax());
            map.put("ConnectionConnectMillisMax", stat.getConnectionStat().getConnectMillisMax());
            map.put("ConnectionErrorLastTime", stat.getConnectionStat().getErrorLastTime());
            map.put("ConnectionAliveMillisMax", stat.getConnectionConnectAliveMillisMax());
            map.put("ConnectionAliveMillisMin", stat.getConnectionConnectAliveMillisMin());
            map.put("ConnectionHistogram", stat.getConnectionHistogramValues());
            map.put("StatementHistogram", stat.getStatementStat().getHistogramValues());
        } else {
            map.put("ConnectionActiveCount", null);
            map.put("ConnectionActiveCountMax", null);
            map.put("ConnectionCloseCount", null);
            map.put("ConnectionCommitCount", null);
            map.put("ConnectionRollbackCount", null);
            map.put("ConnectionConnectLastTime", null);
            map.put("ConnectionConnectErrorCount", null);
            map.put("ConnectionConnectErrorLastTime", null);
            map.put("ConnectionConnectErrorLastMessage", null);
            map.put("ConnectionConnectErrorLastStackTrace", null);
            map.put("StatementCreateCount", null);
            map.put("StatementPrepareCount", null);
            map.put("StatementPreCallCount", null);
            map.put("StatementExecuteCount", null);
            map.put("StatementRunningCount", null);
            map.put("StatementConcurrentMax", null);
            map.put("StatementCloseCount", null);
            map.put("StatementErrorCount", null);
            map.put("StatementLastErrorTime", null);
            map.put("StatementLastErrorMessage", null);
            map.put("StatementLastErrorStackTrace", null);
            map.put("StatementExecuteMillisTotal", null);
            map.put("ConnectionConnectingCount", null);
            map.put("StatementExecuteLastTime", null);
            map.put("ResultSetCloseCount", null);
            map.put("ResultSetOpenCount", null);
            map.put("ResultSetOpenningCount", null);
            map.put("ResultSetOpenningMax", null);
            map.put("ResultSetFetchRowCount", null);
            map.put("ResultSetLastOpenTime", null);
            map.put("ResultSetErrorCount", null);
            map.put("ResultSetOpenningMillisTotal", null);
            map.put("ResultSetLastErrorTime", null);
            map.put("ResultSetLastErrorMessage", null);
            map.put("ResultSetLastErrorStackTrace", null);
            map.put("ConnectionConnectCount", null);
            map.put("ConnectionErrorLastMessage", null);
            map.put("ConnectionErrorLastStackTrace", null);
            map.put("ConnectionConnectMillisTotal", null);
            map.put("ConnectionConnectingCountMax", null);
            map.put("ConnectionConnectMillisMax", null);
            map.put("ConnectionErrorLastTime", null);
            map.put("ConnectionAliveMillisMax", null);
            map.put("ConnectionAliveMillisMin", null);
            map.put("ConnectionHistogram", new long[0]);
            map.put("StatementHistogram", new long[0]);
        }
        return new CompositeDataSupport(JdbcStatManager.getDataSourceCompositeType(), map);
    }

    public long getID() {
        return this.id;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public abstract int getRawDriverMajorVersion();

    @Override
    public abstract int getRawDriverMinorVersion();

    @Override
    public abstract String getProperties();

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public void closePreapredStatement(PreparedStatementHolder stmtHolder) {
        if (stmtHolder == null) {
            return;
        }
        this.closedPreparedStatementCount.incrementAndGet();
        JdbcUtils.close(stmtHolder.getStatement());
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }

    protected void cloneTo(DruidAbstractDataSource to) {
        to.defaultAutoCommit = this.defaultAutoCommit;
        to.defaultReadOnly = this.defaultReadOnly;
        to.defaultTransactionIsolation = this.defaultTransactionIsolation;
        to.defaultCatalog = this.defaultCatalog;
        to.name = this.name;
        to.username = this.username;
        to.password = this.password;
        to.jdbcUrl = this.jdbcUrl;
        to.driverClass = this.driverClass;
        to.connectionProperties = this.connectionProperties;
        to.passwordCallback = this.passwordCallback;
        to.userCallback = this.userCallback;
        to.connectionFactory = this.connectionFactory;
        to.initialSize = this.initialSize;
        to.maxActive = this.maxActive;
        to.minIdle = this.minIdle;
        to.maxIdle = this.maxIdle;
        to.maxWait = this.maxWait;
        to.validationQuery = this.validationQuery;
        to.validationQueryTimeout = this.validationQueryTimeout;
        to.testOnBorrow = this.testOnBorrow;
        to.testOnReturn = this.testOnReturn;
        to.testWhileIdle = this.testWhileIdle;
        to.poolPreparedStatements = this.poolPreparedStatements;
        to.sharePreparedStatements = this.sharePreparedStatements;
        to.maxPoolPreparedStatementPerConnectionSize = this.maxPoolPreparedStatementPerConnectionSize;
        to.logWriter = this.logWriter;
        if (this.filters != null) {
            to.filters = new ArrayList<Filter>(this.filters);
        }
        to.exceptionSorter = this.exceptionSorter;
        to.driver = this.driver;
        to.queryTimeout = this.queryTimeout;
        to.transactionQueryTimeout = this.transactionQueryTimeout;
        to.accessToUnderlyingConnectionAllowed = this.accessToUnderlyingConnectionAllowed;
        to.timeBetweenEvictionRunsMillis = this.timeBetweenEvictionRunsMillis;
        to.numTestsPerEvictionRun = this.numTestsPerEvictionRun;
        to.minEvictableIdleTimeMillis = this.minEvictableIdleTimeMillis;
        to.removeAbandoned = this.removeAbandoned;
        to.removeAbandonedTimeoutMillis = this.removeAbandonedTimeoutMillis;
        to.logAbandoned = this.logAbandoned;
        to.maxOpenPreparedStatements = this.maxOpenPreparedStatements;
        if (this.connectionInitSqls != null) {
            to.connectionInitSqls = new ArrayList<String>(this.connectionInitSqls);
        }
        to.dbType = this.dbType;
        to.timeBetweenConnectErrorMillis = this.timeBetweenConnectErrorMillis;
        to.validConnectionChecker = this.validConnectionChecker;
        to.connectionErrorRetryAttempts = this.connectionErrorRetryAttempts;
        to.breakAfterAcquireFailure = this.breakAfterAcquireFailure;
        to.transactionThresholdMillis = this.transactionThresholdMillis;
        to.dupCloseLogEnable = this.dupCloseLogEnable;
        to.isOracle = this.isOracle;
        to.useOracleImplicitCache = this.useOracleImplicitCache;
    }

    public static class DruidPoolConnectionFactory
    implements ConnectionFactory {
        private final String url;
        private final Properties info;
        private final DruidAbstractDataSource dataSource;

        public DruidPoolConnectionFactory(DruidAbstractDataSource dataSource) throws SQLException {
            String password;
            this.dataSource = dataSource;
            this.url = dataSource.getUrl();
            Properties properties = dataSource.getConnectProperties();
            String user = dataSource.getUserCallback() != null ? dataSource.getUserCallback().getName() : dataSource.getUsername();
            PasswordCallback passwordCallback = dataSource.getPasswordCallback();
            if (passwordCallback != null) {
                Method method;
                try {
                    method = passwordCallback.getClass().getMethod("setUrl", String.class);
                    method.invoke((Object)passwordCallback, this.url);
                }
                catch (NoSuchMethodException ex) {
                }
                catch (IllegalAccessException e) {
                    throw new SQLException("passwordCallback Error", e);
                }
                catch (InvocationTargetException e) {
                    throw new SQLException("passwordCallback Error", e);
                }
                try {
                    method = passwordCallback.getClass().getMethod("setProperties", Properties.class);
                    method.invoke((Object)passwordCallback, properties);
                }
                catch (NoSuchMethodException ex) {
                }
                catch (IllegalAccessException e) {
                    throw new SQLException("passwordCallback Error", e);
                }
                catch (InvocationTargetException e) {
                    throw new SQLException("passwordCallback Error", e);
                }
                char[] chars = passwordCallback.getPassword();
                password = chars != null ? new String(chars) : null;
            } else {
                password = dataSource.getPassword();
            }
            this.info = new Properties(dataSource.getConnectProperties());
            if (properties != null) {
                this.info.putAll((Map<?, ?>)properties);
            }
            if (!this.info.contains("user") && user != null) {
                this.info.put("user", user);
            }
            if (!this.info.contains("password") && password != null) {
                this.info.put("password", password);
            }
        }

        public String getUrl() {
            return this.url;
        }

        public Properties getInfo() {
            return this.info;
        }

        @Override
        public Connection createConnection() throws SQLException {
            Connection conn;
            long startNano = System.nanoTime();
            try {
                if (this.dataSource.getProxyFilters().size() != 0) {
                    conn = new FilterChainImpl(this.dataSource).connection_connect(this.info);
                } else {
                    conn = this.dataSource.getDriver().connect(this.url, this.info);
                    if (conn == null) {
                        throw new SQLException("connect error, url " + this.url);
                    }
                }
                conn.setAutoCommit(this.dataSource.isDefaultAutoCommit());
                if (this.dataSource.getDefaultReadOnly() != null && conn.isReadOnly() != this.dataSource.getDefaultReadOnly().booleanValue()) {
                    conn.setReadOnly(this.dataSource.getDefaultReadOnly());
                }
                if (this.dataSource.getDefaultTransactionIsolation() != null && conn.getTransactionIsolation() != this.dataSource.getDefaultTransactionIsolation().intValue()) {
                    conn.setTransactionIsolation(this.dataSource.getDefaultTransactionIsolation());
                }
                if (this.dataSource.getDefaultCatalog() != null && this.dataSource.getDefaultCatalog().length() != 0) {
                    conn.setCatalog(this.dataSource.getDefaultCatalog());
                }
                this.dataSource.validateConnection(conn);
                this.dataSource.createError = null;
            }
            catch (SQLException ex) {
                ++this.dataSource.createErrorCount;
                this.dataSource.createError = ex;
                this.dataSource.lastCreateError = ex;
                this.dataSource.lastCreateErrorTimeMillis = System.currentTimeMillis();
                throw ex;
            }
            catch (RuntimeException ex) {
                ++this.dataSource.createErrorCount;
                this.dataSource.createError = ex;
                this.dataSource.lastCreateError = ex;
                this.dataSource.lastCreateErrorTimeMillis = System.currentTimeMillis();
                throw ex;
            }
            catch (Error ex) {
                ++this.dataSource.createErrorCount;
                throw ex;
            }
            finally {
                long nano = System.nanoTime() - startNano;
                this.dataSource.createTimespan += nano;
            }
            this.dataSource.incrementCreateCount();
            return conn;
        }
    }
}

