/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.TransactionTimeoutException;
import com.alibaba.druid.VERSION;
import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.mock.MockDriver;
import com.alibaba.druid.pool.ConnectionHolder;
import com.alibaba.druid.pool.DataSourceDisableException;
import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidDataSourceMBean;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.DruidPooledPreparedStatement;
import com.alibaba.druid.pool.GetConnectionTimeoutException;
import com.alibaba.druid.pool.ManagedDataSource;
import com.alibaba.druid.pool.PreparedStatementHolder;
import com.alibaba.druid.pool.PreparedStatementPool;
import com.alibaba.druid.pool.vendor.InformixExceptionSorter;
import com.alibaba.druid.pool.vendor.MSSQLValidConnectionChecker;
import com.alibaba.druid.pool.vendor.MockExceptionSorter;
import com.alibaba.druid.pool.vendor.MySqlExceptionSorter;
import com.alibaba.druid.pool.vendor.MySqlValidConnectionChecker;
import com.alibaba.druid.pool.vendor.OracleExceptionSorter;
import com.alibaba.druid.pool.vendor.OracleValidConnectionChecker;
import com.alibaba.druid.pool.vendor.SybaseExceptionSorter;
import com.alibaba.druid.proxy.DruidDriver;
import com.alibaba.druid.proxy.jdbc.DataSourceProxyConfig;
import com.alibaba.druid.proxy.jdbc.TransactionInfo;
import com.alibaba.druid.stat.DruidDataSourceStatManager;
import com.alibaba.druid.stat.JdbcDataSourceStat;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.IOUtils;
import com.alibaba.druid.util.JdbcUtils;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;

public class DruidDataSource
extends DruidAbstractDataSource
implements DruidDataSourceMBean,
ManagedDataSource,
Referenceable,
Closeable,
Cloneable {
    private static final Log LOG = LogFactory.getLog(DruidDataSource.class);
    private static final long serialVersionUID = 1L;
    private final Condition notEmpty;
    private final Condition empty;
    private long connectCount;
    private long closeCount;
    private long connectErrorCount;
    private long recycleCount;
    private long createConnectionCount;
    private long destroyCount;
    private long removeAbandonedCount;
    private long notEmptyWaitCount;
    private long notEmptySignalCount;
    private long notEmptyWaitNanos;
    private int activePeak;
    private long activePeakTime;
    private int poolingPeak;
    private long poolingPeakTime;
    private ConnectionHolder[] connections;
    private int poolingCount;
    private int activeCount;
    private int notEmptyWaitThreadCount;
    private int notEmptyWaitThreadPeak;
    private CreateConnectionThread createConnectionThread;
    private DestroyConnectionThread destoryConnectionThread;
    private final CountDownLatch initedLatch;
    private boolean enable;
    private boolean resetStatEnable;
    private String initStackTrace;
    private boolean closed;
    private JdbcDataSourceStat dataSourceStat;
    protected String instanceKey;

    public DruidDataSource() {
        this.notEmpty = this.lock.newCondition();
        this.empty = this.lock.newCondition();
        this.connectCount = 0L;
        this.closeCount = 0L;
        this.connectErrorCount = 0L;
        this.recycleCount = 0L;
        this.createConnectionCount = 0L;
        this.destroyCount = 0L;
        this.removeAbandonedCount = 0L;
        this.notEmptyWaitCount = 0L;
        this.notEmptySignalCount = 0L;
        this.notEmptyWaitNanos = 0L;
        this.activePeak = 0;
        this.activePeakTime = 0L;
        this.poolingPeak = 0;
        this.poolingPeakTime = 0L;
        this.poolingCount = 0;
        this.activeCount = 0;
        this.notEmptyWaitThreadCount = 0;
        this.notEmptyWaitThreadPeak = 0;
        this.initedLatch = new CountDownLatch(2);
        this.enable = true;
        this.resetStatEnable = true;
        this.closed = false;
        this.instanceKey = null;
    }

    public String getInitStackTrace() {
        return this.initStackTrace;
    }

    @Override
    public boolean isResetStatEnable() {
        return this.resetStatEnable;
    }

    @Override
    public void setResetStatEnable(boolean resetStatEnable) {
        this.resetStatEnable = resetStatEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        this.lock.lock();
        try {
            this.close();
            this.resetStat();
            this.inited = false;
            this.enable = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStat() {
        if (!this.resetStatEnable) {
            return;
        }
        this.lock.lock();
        try {
            this.connectCount = 0L;
            this.closeCount = 0L;
            this.connectErrorCount = 0L;
            this.recycleCount = 0L;
            this.createConnectionCount = 0L;
            this.destroyCount = 0L;
            this.removeAbandonedCount = 0L;
            this.notEmptyWaitCount = 0L;
            this.notEmptySignalCount = 0L;
            this.notEmptyWaitNanos = 0L;
            this.activePeak = 0;
            this.activePeakTime = 0L;
            this.poolingPeak = 0;
            this.createTimespan = 0L;
            this.lastError = null;
            this.lastErrorTimeMillis = 0L;
            this.lastCreateError = null;
            this.lastCreateErrorTimeMillis = 0L;
        }
        finally {
            this.lock.unlock();
        }
        this.errorCount.set(0L);
        this.commitCount.set(0L);
        this.rollbackCount.set(0L);
        this.startTransactionCount.set(0L);
        this.cachedPreparedStatementHitCount.set(0L);
        this.closedPreparedStatementCount.set(0L);
        this.preparedStatementCount.set(0L);
        this.transactionHistogram.reset();
        this.cachedPreparedStatementDeleteCount.set(0L);
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnable(boolean enable) {
        this.lock.lock();
        try {
            this.enable = enable;
            if (!enable) {
                this.notEmpty.signalAll();
                ++this.notEmptySignalCount;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPoolPreparedStatements(boolean value) {
        this.lock.lock();
        try {
            if (this.poolPreparedStatements && !value) {
                for (int i = 0; i < this.poolingCount; ++i) {
                    ConnectionHolder connection = this.connections[i];
                    for (PreparedStatementHolder holder : connection.getStatementPool().getMap().values()) {
                        this.closePreapredStatement(holder);
                        this.decrementCachedPreparedStatementCount();
                    }
                    connection.getStatementPool().getMap().clear();
                }
            }
            super.setPoolPreparedStatements(value);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isInited() {
        return this.inited;
    }

    public void init() throws SQLException {
        if (this.inited) {
            return;
        }
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new SQLException("interrupt", e);
        }
        try {
            String realDriverClassName;
            if (this.inited) {
                return;
            }
            this.initStackTrace = IOUtils.toString(Thread.currentThread().getStackTrace());
            this.id = DruidDriver.createDataSourceId();
            if (this.maxActive <= 0) {
                throw new IllegalArgumentException("illegal maxActive " + this.maxActive);
            }
            if (this.maxActive < this.minIdle) {
                throw new IllegalArgumentException("illegal maxActive " + this.maxActive);
            }
            if (this.maxIdle <= 0 || this.maxIdle < this.minIdle) {
                throw new IllegalArgumentException("illegal maxPoolSize");
            }
            if (this.getInitialSize() > this.maxActive) {
                throw new IllegalArgumentException("illegal initialSize");
            }
            if (this.driverClass != null) {
                this.driverClass = this.driverClass.trim();
            }
            if (this.jdbcUrl != null) {
                this.jdbcUrl = this.jdbcUrl.trim();
                if (this.jdbcUrl.startsWith("jdbc:wrap-jdbc:")) {
                    DataSourceProxyConfig config = DruidDriver.parseConfig(this.jdbcUrl, null);
                    this.driverClass = config.getRawDriverClassName();
                    this.jdbcUrl = config.getRawUrl();
                    if (this.name == null) {
                        this.name = config.getName();
                    }
                    this.filters.addAll(config.getFilters());
                }
            }
            if (this.driver == null) {
                if (this.driverClass == null || this.driverClass.isEmpty()) {
                    this.driverClass = JdbcUtils.getDriverClassName(this.jdbcUrl);
                }
                this.driver = MockDriver.class.getName().equals(this.driverClass) ? MockDriver.instance : JdbcUtils.createDriver(this.driverClass);
            } else if (this.driverClass == null) {
                this.driverClass = this.driver.getClass().getName();
            }
            if (this.dbType == null || this.dbType.length() == 0) {
                this.dbType = JdbcUtils.getDbType(this.jdbcUrl, this.driverClass.getClass().getName());
            }
            if ("oracle".equals(this.dbType)) {
                this.isOracle = true;
                if (this.driver.getMajorVersion() < 10) {
                    throw new SQLException("not support oracle driver " + this.driver.getMajorVersion() + "." + this.driver.getMinorVersion());
                }
                if (this.driver.getMajorVersion() == 10 && this.isUseOracleImplicitCache()) {
                    this.getConnectProperties().setProperty("oracle.jdbc.FreeMemoryOnEnterImplicitCache", "true");
                }
            }
            if ((realDriverClassName = this.driver.getClass().getName()).equals("com.mysql.jdbc.Driver")) {
                this.validConnectionChecker = new MySqlValidConnectionChecker();
                this.exceptionSorter = new MySqlExceptionSorter();
            } else if (realDriverClassName.equals("oracle.jdbc.driver.OracleDriver")) {
                this.validConnectionChecker = new OracleValidConnectionChecker();
                this.exceptionSorter = new OracleExceptionSorter();
            } else if (realDriverClassName.equals("com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
                this.validConnectionChecker = new MSSQLValidConnectionChecker();
            } else if (realDriverClassName.equals("com.informix.jdbc.IfxDriver")) {
                this.exceptionSorter = new InformixExceptionSorter();
            } else if (realDriverClassName.equals("com.sybase.jdbc2.jdbc.SybDriver")) {
                this.exceptionSorter = new SybaseExceptionSorter();
            } else if (realDriverClassName.equals("com.alibaba.druid.mock.MockDriver")) {
                this.exceptionSorter = new MockExceptionSorter();
            }
            this.dataSourceStat = new JdbcDataSourceStat(this.name, this.jdbcUrl);
            String property = System.getProperty("druid.filters");
            if (property != null && property.length() > 0) {
                this.setFilters(property);
            }
            for (Filter filter : this.filters) {
                filter.init(this);
            }
            this.initConnectionFactory();
            this.connections = new ConnectionHolder[this.maxActive];
            SQLException connectError = null;
            try {
                int size = this.getInitialSize();
                for (int i = 0; i < size; ++i) {
                    Connection conn = this.connectionFactory.createConnection();
                    conn.setAutoCommit(true);
                    this.connections[this.poolingCount++] = new ConnectionHolder(this, conn);
                }
            }
            catch (SQLException ex) {
                LOG.error("init datasource error", ex);
                connectError = ex;
            }
            this.createConnectionThread = new CreateConnectionThread("Druid-ConnectionPool-Create");
            this.createConnectionThread.setDaemon(true);
            this.destoryConnectionThread = new DestroyConnectionThread("Druid-ConnectionPool-Destory");
            this.destoryConnectionThread.setDaemon(true);
            this.createConnectionThread.start();
            this.destoryConnectionThread.start();
            this.initedLatch.await();
            this.createdTime = new Date();
            DruidDataSourceStatManager.add(this);
            if (connectError != null && this.poolingCount == 0) {
                throw connectError;
            }
        }
        catch (InterruptedException e) {
            throw new SQLException(e.getMessage(), e);
        }
        finally {
            this.inited = true;
            this.lock.unlock();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.maxWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(long maxWaitMillis) throws SQLException {
        DruidPooledConnection poolalbeConnection;
        this.init();
        int maxWaitThreadCount = this.getMaxWaitThreadCount();
        if (maxWaitThreadCount > 0 && this.notEmptyWaitThreadCount > maxWaitThreadCount) {
            this.lock.lock();
            try {
                ++this.connectErrorCount;
            }
            finally {
                this.lock.unlock();
            }
            throw new SQLException("maxWaitThreadCount " + maxWaitThreadCount + ", current wait Thread count " + this.lock.getQueueLength());
        }
        while (true) {
            boolean validate;
            long idleMillis;
            poolalbeConnection = this.getConnectionInternal(maxWaitMillis);
            if (this.isTestOnBorrow()) {
                boolean validate2 = this.testConnectionInternal(poolalbeConnection.getConnection());
                if (validate2) break;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("skip not validate connection.");
                }
                Connection realConnection = poolalbeConnection.getConnection();
                this.discardConnection(realConnection);
                continue;
            }
            Connection realConnection = poolalbeConnection.getConnection();
            if (realConnection.isClosed()) {
                this.discardConnection(null);
                continue;
            }
            if (!this.isTestWhileIdle() || (idleMillis = System.currentTimeMillis() - poolalbeConnection.getConnectionHolder().getLastActiveTimeMillis()) < this.getTimeBetweenEvictionRunsMillis() || (validate = this.testConnectionInternal(poolalbeConnection.getConnection()))) break;
            if (LOG.isDebugEnabled()) {
                LOG.debug("skip not validate connection.");
            }
            this.discardConnection(realConnection);
        }
        if (this.isRemoveAbandoned()) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            this.activeConnections.put(poolalbeConnection, new ActiveConnectionTraceInfo(poolalbeConnection, System.currentTimeMillis(), stackTrace));
            poolalbeConnection.setTraceEnable(true);
        }
        if (!this.isDefaultAutoCommit()) {
            poolalbeConnection.setAutoCommit(false);
        }
        return poolalbeConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardConnection(Connection realConnection) throws SQLException {
        JdbcUtils.close(realConnection);
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new SQLException("interrupt", e);
        }
        try {
            --this.activeCount;
        }
        finally {
            this.lock.unlock();
        }
    }

    private DruidPooledConnection getConnectionInternal(long maxWait) throws SQLException {
        DruidPooledConnection poolalbeConnection;
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new SQLException("interrupt", e);
        }
        try {
            if (!this.enable) {
                ++this.connectErrorCount;
                throw new DataSourceDisableException();
            }
            ++this.connectCount;
            ConnectionHolder holder = maxWait > 0L ? this.pollLast(maxWait, TimeUnit.MILLISECONDS) : this.takeLast();
            if (holder == null) {
                throw new SQLException("can not get connection");
            }
            holder.incrementUseCount();
            ++this.activeCount;
            if (this.activeCount > this.activePeak) {
                this.activePeak = this.activeCount;
                this.activePeakTime = System.currentTimeMillis();
            }
            poolalbeConnection = new DruidPooledConnection(holder);
        }
        catch (InterruptedException e) {
            ++this.connectErrorCount;
            throw new SQLException(e.getMessage(), e);
        }
        catch (SQLException e) {
            ++this.connectErrorCount;
            throw e;
        }
        finally {
            this.lock.unlock();
        }
        return poolalbeConnection;
    }

    @Override
    public void handleConnectionException(DruidPooledConnection pooledConnection, Throwable t) throws SQLException {
        ConnectionHolder holder = pooledConnection.getConnectionHolder();
        this.errorCount.incrementAndGet();
        this.lastError = t;
        this.lastErrorTimeMillis = System.currentTimeMillis();
        if (t instanceof SQLException) {
            SQLException sqlEx = (SQLException)t;
            ConnectionEvent event = new ConnectionEvent(pooledConnection, sqlEx);
            for (ConnectionEventListener eventListener : holder.getConnectionEventListeners()) {
                eventListener.connectionErrorOccurred(event);
            }
            if (this.exceptionSorter != null && this.exceptionSorter.isExceptionFatal(sqlEx)) {
                if (pooledConnection.isTraceEnable()) {
                    this.activeConnections.remove(pooledConnection);
                }
                this.discardConnection(holder.getConnection());
                pooledConnection.disable();
            }
            throw sqlEx;
        }
        throw new SQLException("Error", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recycle(DruidPooledConnection pooledConnection) throws SQLException {
        ActiveConnectionTraceInfo oldInfo;
        Connection conn = pooledConnection.getConnection();
        ConnectionHolder holder = pooledConnection.getConnectionHolder();
        assert (holder != null);
        if (pooledConnection.isTraceEnable() && (oldInfo = (ActiveConnectionTraceInfo)this.activeConnections.remove(pooledConnection)) == null) {
            LOG.warn("remove abandonded failed. activeConnections.size " + this.activeConnections.size());
        }
        try {
            boolean validate;
            if (conn == null) {
                this.lock.lockInterruptibly();
                try {
                    --this.activeCount;
                    ++this.closeCount;
                }
                finally {
                    this.lock.unlock();
                }
                return;
            }
            boolean isAutoCommit = holder.isUnderlyingAutoCommit();
            boolean isReadOnly = holder.isUnderlyingReadOnly();
            if (!isAutoCommit && !isReadOnly) {
                pooledConnection.rollback();
            }
            holder.reset();
            if (this.isTestOnReturn() && !(validate = this.testConnectionInternal(conn))) {
                JdbcUtils.close(conn);
                this.lock.lockInterruptibly();
                try {
                    ++this.destroyCount;
                    --this.activeCount;
                    ++this.closeCount;
                }
                finally {
                    this.lock.unlock();
                }
                return;
            }
            boolean neadDestory = false;
            this.lock.lockInterruptibly();
            try {
                if (holder.getModCount() == this.modCount) {
                    --this.activeCount;
                    ++this.closeCount;
                    this.putLast(holder);
                    ++this.recycleCount;
                } else {
                    ++this.destroyCount;
                    --this.activeCount;
                    ++this.closeCount;
                    neadDestory = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (neadDestory) {
                JdbcUtils.close(conn);
            }
        }
        catch (Throwable e) {
            JdbcUtils.close(conn);
            try {
                this.lock.lockInterruptibly();
            }
            catch (InterruptedException interruptEx) {
                throw new SQLException("interrupt", interruptEx);
            }
            try {
                --this.activeCount;
                ++this.closeCount;
            }
            finally {
                this.lock.unlock();
            }
            throw new SQLException("recyle error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStatementCache() throws SQLException {
        this.lock.lock();
        try {
            for (int i = 0; i < this.poolingCount; ++i) {
                ConnectionHolder conn = this.connections[i];
                conn.getStatementPool().clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            if (!this.inited) {
                return;
            }
            if (this.createConnectionThread != null) {
                this.createConnectionThread.interrupt();
            }
            if (this.destoryConnectionThread != null) {
                this.destoryConnectionThread.interrupt();
            }
            for (int i = 0; i < this.poolingCount; ++i) {
                try {
                    JdbcUtils.close(this.connections[i].getConnection());
                    this.connections[i] = null;
                    ++this.destroyCount;
                    continue;
                }
                catch (Exception ex) {
                    LOG.warn("close connection error", ex);
                }
            }
            this.poolingCount = 0;
            DruidDataSourceStatManager.remove(this);
            this.enable = false;
            this.notEmpty.signalAll();
            ++this.notEmptySignalCount;
            this.closed = true;
            for (Filter filter : this.filters) {
                filter.destory();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    void incrementCreateCount() {
        ++this.createConnectionCount;
    }

    void putLast(ConnectionHolder e) throws SQLException {
        if (!this.enable) {
            this.discardConnection(e.getConnection());
            return;
        }
        e.setLastActiveTimeMillis(System.currentTimeMillis());
        this.connections[this.poolingCount++] = e;
        this.notEmpty.signal();
        ++this.notEmptySignalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionHolder takeLast() throws InterruptedException, SQLException {
        try {
            while (this.poolingCount == 0) {
                this.empty.signal();
                ++this.notEmptyWaitThreadCount;
                if (this.notEmptyWaitThreadCount > this.notEmptyWaitThreadPeak) {
                    this.notEmptyWaitThreadPeak = this.notEmptyWaitThreadCount;
                }
                try {
                    this.notEmpty.await();
                }
                finally {
                    --this.notEmptyWaitThreadCount;
                }
                ++this.notEmptyWaitCount;
                if (this.enable) continue;
                ++this.connectErrorCount;
                throw new DataSourceDisableException();
            }
        }
        catch (InterruptedException ie) {
            this.notEmpty.signal();
            ++this.notEmptySignalCount;
            throw ie;
        }
        --this.poolingCount;
        ConnectionHolder last = this.connections[this.poolingCount];
        this.connections[this.poolingCount] = null;
        return last;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ConnectionHolder pollLast(long timeout, TimeUnit unit) throws InterruptedException, SQLException {
        long estimate = unit.toNanos(timeout);
        int i = 0;
        while (this.poolingCount == 0) {
            this.empty.signal();
            if (estimate <= 0L) {
                throw new GetConnectionTimeoutException();
            }
            ++this.notEmptyWaitThreadCount;
            if (this.notEmptyWaitThreadCount > this.notEmptyWaitThreadPeak) {
                this.notEmptyWaitThreadPeak = this.notEmptyWaitThreadCount;
            }
            try {
                long startEstimate = estimate;
                estimate = this.notEmpty.awaitNanos(estimate);
                ++this.notEmptyWaitCount;
                this.notEmptyWaitNanos += startEstimate - estimate;
                if (!this.enable) {
                    ++this.connectErrorCount;
                    throw new DataSourceDisableException();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                ++this.notEmptySignalCount;
                throw ie;
            }
            finally {
                --this.notEmptyWaitThreadCount;
            }
            if (this.poolingCount != 0) break;
            if (estimate > 0L) {
                ++i;
                continue;
            }
            if (this.createError != null) {
                throw new GetConnectionTimeoutException(this.createError);
            }
            throw new GetConnectionTimeoutException("loopWaitCount " + i);
        }
        --this.poolingCount;
        ConnectionHolder last = this.connections[this.poolingCount];
        this.connections[this.poolingCount] = null;
        return last;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("Not supported by DruidDataSource");
    }

    @Override
    public long getCreateCount() {
        return this.createConnectionCount;
    }

    @Override
    public long getDestroyCount() {
        return this.destroyCount;
    }

    @Override
    public long getConnectCount() {
        return this.connectCount;
    }

    @Override
    public long getCloseCount() {
        return this.closeCount;
    }

    @Override
    public long getConnectErrorCount() {
        return this.connectErrorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoolingCount() {
        this.lock.lock();
        try {
            int n = this.poolingCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getPoolingPeak() {
        return this.poolingPeak;
    }

    @Override
    public Date getPoolingPeakTime() {
        if (this.poolingPeakTime <= 0L) {
            return null;
        }
        return new Date(this.poolingPeakTime);
    }

    @Override
    public long getRecycleCount() {
        return this.recycleCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveCount() {
        this.lock.lock();
        try {
            int n = this.activeCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        this.lock.lock();
        try {
            boolean bl = this.inited && this.activeCount == this.maxActive && this.poolingCount == 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getRemoveAbandonedCount() {
        return this.removeAbandonedCount;
    }

    @Override
    public int removeAbandoned() {
        int removeCount = 0;
        Iterator iter = this.activeConnections.entrySet().iterator();
        long currentMillis = System.currentTimeMillis();
        ArrayList<DruidPooledConnection> abondonedList = new ArrayList<DruidPooledConnection>();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ActiveConnectionTraceInfo activeInfo = (ActiveConnectionTraceInfo)entry.getValue();
            long timeMillis = currentMillis - activeInfo.getConnectTime();
            if (timeMillis < this.removeAbandonedTimeoutMillis) continue;
            DruidPooledConnection pooledConnection = (DruidPooledConnection)entry.getKey();
            JdbcUtils.close(pooledConnection);
            ++this.removeAbandonedCount;
            ++removeCount;
            abondonedList.add(pooledConnection);
            if (!this.isLogAbandoned()) continue;
            StringBuilder buf = new StringBuilder();
            buf.append("abandon connection, open stackTrace\n");
            StackTraceElement[] trace = activeInfo.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                buf.append("\tat ");
                buf.append(trace[i].toString());
                buf.append("\n");
            }
            LOG.error(buf.toString());
        }
        for (DruidPooledConnection conn : abondonedList) {
            this.activeConnections.remove(conn);
        }
        return removeCount;
    }

    public DataSourceProxyConfig getConfig() {
        return null;
    }

    @Override
    public Reference getReference() throws NamingException {
        String className = this.getClass().getName();
        String factoryName = className + "Factory";
        Reference ref = new Reference(className, factoryName, null);
        ref.add(new StringRefAddr("instanceKey", this.instanceKey));
        return ref;
    }

    @Override
    public List<String> getFilterClassNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Filter filter : this.filters) {
            names.add(filter.getClass().getName());
        }
        return names;
    }

    @Override
    public int getRawDriverMajorVersion() {
        int version = -1;
        if (this.driver != null) {
            version = this.driver.getMajorVersion();
        }
        return version;
    }

    @Override
    public int getRawDriverMinorVersion() {
        int version = -1;
        if (this.driver != null) {
            version = this.driver.getMinorVersion();
        }
        return version;
    }

    @Override
    public String getProperties() {
        if (this.connectionProperties == null) {
            return null;
        }
        Properties properties = new Properties(this.connectionProperties);
        if (properties.contains("password")) {
            properties.put("password", "******");
        }
        return properties.toString();
    }

    @Override
    public void shrink() {
        this.shrink(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shrink(boolean checkTime) {
        Object connection;
        ArrayList<ConnectionHolder> evictList = new ArrayList<ConnectionHolder>();
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            return;
        }
        try {
            int removeCount;
            int checkCount = this.poolingCount - this.minIdle;
            for (int i = 0; i < checkCount; ++i) {
                connection = this.connections[i];
                if (checkTime) {
                    long idleMillis = System.currentTimeMillis() - ((ConnectionHolder)connection).getLastActiveTimeMillis();
                    if (idleMillis < this.minEvictableIdleTimeMillis) break;
                    evictList.add((ConnectionHolder)connection);
                    continue;
                }
                evictList.add((ConnectionHolder)connection);
            }
            if ((removeCount = evictList.size()) > 0) {
                System.arraycopy(this.connections, removeCount, this.connections, 0, this.poolingCount - removeCount);
                Arrays.fill(this.connections, this.poolingCount - removeCount, this.poolingCount, null);
                this.poolingCount -= removeCount;
            }
        }
        finally {
            this.lock.unlock();
        }
        for (ConnectionHolder item : evictList) {
            connection = item.getConnection();
            JdbcUtils.close((Connection)connection);
            ++this.destroyCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWaitThreadCount() {
        this.lock.lock();
        try {
            int n = this.lock.getWaitQueueLength(this.notEmpty);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getNotEmptyWaitCount() {
        return this.notEmptyWaitCount;
    }

    @Override
    public int getNotEmptyWaitThreadCount() {
        return this.notEmptyWaitThreadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNotEmptyWaitThreadPeak() {
        this.lock.lock();
        try {
            int n = this.notEmptyWaitThreadPeak;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getNotEmptySignalCount() {
        return this.notEmptySignalCount;
    }

    @Override
    public long getNotEmptyWaitMillis() {
        return this.notEmptyWaitNanos / 1000000L;
    }

    @Override
    public long getNotEmptyWaitNanos() {
        return this.notEmptyWaitNanos;
    }

    @Override
    public int getLockQueueLength() {
        return this.lock.getQueueLength();
    }

    @Override
    public int getActivePeak() {
        return this.activePeak;
    }

    @Override
    public Date getActivePeakTime() {
        if (this.activePeakTime <= 0L) {
            return null;
        }
        return new Date(this.activePeakTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dump() {
        this.lock.lock();
        try {
            String string = this.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getErrorCount() {
        return this.errorCount.get();
    }

    public String toString() {
        ConnectionHolder conn;
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("\n\tCreateTime:\"");
        buf.append(IOUtils.toString(this.getCreatedTime()));
        buf.append("\"");
        buf.append(",\n\tActiveCount:");
        buf.append(this.getActiveCount());
        buf.append(",\n\tPoolingCount:");
        buf.append(this.getPoolingCount());
        buf.append(",\n\tCreateCount:");
        buf.append(this.getCreateCount());
        buf.append(",\n\tDestroyCount:");
        buf.append(this.getDestroyCount());
        buf.append(",\n\tCloseCount:");
        buf.append(this.getCloseCount());
        buf.append(",\n\tConnectCount:");
        buf.append(this.getConnectCount());
        buf.append(",\n\tConnections:[");
        for (i = 0; i < this.poolingCount; ++i) {
            conn = this.connections[i];
            if (conn == null) continue;
            if (i != 0) {
                buf.append(",");
            }
            buf.append("\n\t\t");
            buf.append(conn.toString());
        }
        buf.append("\n\t]");
        buf.append("\n}");
        if (this.isPoolPreparedStatements()) {
            buf.append("\n\n[");
            for (i = 0; i < this.poolingCount; ++i) {
                conn = this.connections[i];
                if (conn == null) continue;
                if (i != 0) {
                    buf.append(",");
                }
                buf.append("\n\t{\n\tID:");
                buf.append(System.identityHashCode(conn.getConnection()));
                PreparedStatementPool pool = conn.getStatementPool();
                if (pool != null) {
                    buf.append(", \n\tpoolStatements:[");
                    int entryIndex = 0;
                    try {
                        for (Map.Entry<DruidPooledPreparedStatement.PreparedStatementKey, PreparedStatementHolder> entry : pool.getMap().entrySet()) {
                            if (entryIndex++ != 0) {
                                buf.append(",");
                            }
                            buf.append("\n\t\t{hitCount:");
                            buf.append(entry.getValue().getHitCount());
                            buf.append(",sql:\"");
                            buf.append(entry.getKey().getSql());
                            buf.append("\"");
                            buf.append("\t}");
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        // empty catch block
                    }
                    buf.append("\n\t\t]");
                }
                buf.append("\n\t}");
            }
            buf.append("\n]");
        }
        return buf.toString();
    }

    @Override
    public void logTransaction(TransactionInfo info) {
        long transactionMillis = info.getEndTimeMillis() - info.getStartTimeMillis();
        if (this.transactionThresholdMillis > 0L && transactionMillis > this.transactionThresholdMillis) {
            StringBuilder buf = new StringBuilder();
            buf.append("long time transaction, take ");
            buf.append(transactionMillis);
            buf.append(" ms : ");
            for (String sql : info.getSqlList()) {
                buf.append(sql);
                buf.append(";");
            }
            LOG.error(buf.toString(), new TransactionTimeoutException());
        }
    }

    @Override
    public String getVersion() {
        return VERSION.getVersionNumber();
    }

    @Override
    public JdbcDataSourceStat getDataSourceStat() {
        return this.dataSourceStat;
    }

    public Object clone() throws CloneNotSupportedException {
        return this.cloneDruidDataSource();
    }

    public DruidDataSource cloneDruidDataSource() {
        DruidDataSource x = new DruidDataSource();
        this.cloneTo(x);
        return x;
    }

    static class ActiveConnectionTraceInfo {
        private final DruidPooledConnection connection;
        private final long connectTime;
        private final StackTraceElement[] stackTrace;

        public ActiveConnectionTraceInfo(DruidPooledConnection connection, long connectTime, StackTraceElement[] stackTrace) {
            this.connection = connection;
            this.connectTime = connectTime;
            this.stackTrace = stackTrace;
        }

        public DruidPooledConnection getConnection() {
            return this.connection;
        }

        public long getConnectTime() {
            return this.connectTime;
        }

        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }
    }

    public class DestroyConnectionThread
    extends Thread {
        public DestroyConnectionThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            DruidDataSource.this.initedLatch.countDown();
            try {
                while (true) {
                    if (DruidDataSource.this.timeBetweenEvictionRunsMillis > 0L) {
                        Thread.sleep(DruidDataSource.this.timeBetweenEvictionRunsMillis);
                    } else {
                        Thread.sleep(1000L);
                    }
                    if (!Thread.interrupted()) {
                        DruidDataSource.this.shrink(true);
                        if (!DruidDataSource.this.isRemoveAbandoned()) continue;
                        DruidDataSource.this.removeAbandoned();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
            }
        }
    }

    public class CreateConnectionThread
    extends Thread {
        public CreateConnectionThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DruidDataSource.this.initedLatch.countDown();
            int errorCount = 0;
            while (true) {
                Connection connection;
                block23: {
                    try {
                        DruidDataSource.this.lock.lockInterruptibly();
                    }
                    catch (InterruptedException e2) {
                        break;
                    }
                    try {
                        if (DruidDataSource.this.poolingCount >= DruidDataSource.this.notEmptyWaitThreadCount) {
                            DruidDataSource.this.empty.await();
                        }
                        if (DruidDataSource.this.activeCount + DruidDataSource.this.poolingCount >= DruidDataSource.this.maxActive) {
                            DruidDataSource.this.empty.await();
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        DruidDataSource.this.lastCreateError = e;
                        DruidDataSource.this.lastErrorTimeMillis = System.currentTimeMillis();
                        break;
                    }
                    finally {
                        DruidDataSource.this.lock.unlock();
                        continue;
                    }
                    connection = null;
                    try {
                        connection = DruidDataSource.this.connectionFactory.createConnection();
                    }
                    catch (SQLException e) {
                        LOG.error("create connection error", e);
                        if (++errorCount <= DruidDataSource.this.connectionErrorRetryAttempts || DruidDataSource.this.timeBetweenConnectErrorMillis <= 0L) break block23;
                        if (DruidDataSource.this.breakAfterAcquireFailure) break;
                        try {
                            Thread.sleep(DruidDataSource.this.timeBetweenConnectErrorMillis);
                        }
                        catch (InterruptedException interruptEx) {
                            break;
                        }
                    }
                    catch (RuntimeException e) {
                        LOG.error("create connection error", e);
                        continue;
                    }
                    catch (Error e) {
                        LOG.error("create connection error", e);
                        break;
                    }
                }
                if (connection == null) continue;
                DruidDataSource.this.lock.lock();
                try {
                    ((DruidDataSource)DruidDataSource.this).connections[((DruidDataSource)DruidDataSource.this).poolingCount++] = new ConnectionHolder(DruidDataSource.this, connection);
                    if (DruidDataSource.this.poolingCount > DruidDataSource.this.poolingPeak) {
                        DruidDataSource.this.poolingPeak = DruidDataSource.this.poolingCount;
                        DruidDataSource.this.poolingPeakTime = System.currentTimeMillis();
                    }
                    errorCount = 0;
                    DruidDataSource.this.notEmpty.signal();
                    DruidDataSource.this.notEmptySignalCount++;
                    continue;
                }
                catch (SQLException ex) {
                    LOG.error("create connection holder error", ex);
                }
                finally {
                    DruidDataSource.this.lock.unlock();
                    continue;
                }
                break;
            }
        }
    }
}

