/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.pool.DruidPooledStatement;
import com.alibaba.druid.pool.PoolableWrapper;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public final class DruidPooledResultSet
extends PoolableWrapper
implements ResultSet {
    private final ResultSet rs;
    private final DruidPooledStatement stmt;
    private boolean closed = false;
    protected int cursorIndex = 0;
    protected int fetchRowCount = 0;

    public DruidPooledResultSet(DruidPooledStatement stmt, ResultSet rs) {
        super(rs);
        this.stmt = stmt;
        this.rs = rs;
    }

    protected SQLException checkException(Throwable error) throws SQLException {
        return this.stmt.checkException(error);
    }

    public DruidPooledStatement getPoolableStatement() {
        return this.stmt;
    }

    public ResultSet getRawResultSet() {
        return this.rs;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            boolean moreRows = this.rs.next();
            if (moreRows) {
                ++this.cursorIndex;
                if (this.cursorIndex > this.fetchRowCount) {
                    this.fetchRowCount = this.cursorIndex;
                }
            }
            return moreRows;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.closed = true;
            this.rs.close();
            this.stmt.recordFetchRowCount(this.fetchRowCount);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            return this.rs.wasNull();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            return this.rs.getString(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            return this.rs.getBoolean(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try {
            return this.rs.getByte(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            return this.rs.getShort(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            return this.rs.getInt(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            return this.rs.getLong(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            return this.rs.getFloat(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            return this.rs.getDouble(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            return this.rs.getBigDecimal(columnIndex, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            return this.rs.getBytes(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            return this.rs.getDate(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            return this.rs.getTime(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            return this.rs.getTimestamp(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try {
            return this.rs.getAsciiStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        try {
            return this.rs.getUnicodeStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try {
            return this.rs.getBinaryStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        try {
            return this.rs.getString(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        try {
            return this.rs.getBoolean(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        try {
            return this.rs.getByte(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        try {
            return this.rs.getShort(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        try {
            return this.rs.getInt(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        try {
            return this.rs.getLong(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        try {
            return this.rs.getFloat(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        try {
            return this.rs.getDouble(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        try {
            return this.rs.getBigDecimal(columnLabel, scale);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        try {
            return this.rs.getBytes(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        try {
            return this.rs.getDate(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        try {
            return this.rs.getTime(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        try {
            return this.rs.getTimestamp(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        try {
            return this.rs.getAsciiStream(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        try {
            return this.rs.getUnicodeStream(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        try {
            return this.rs.getBinaryStream(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.rs.getWarnings();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.rs.clearWarnings();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            return this.rs.getCursorName();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.rs.getMetaData();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            return this.rs.getObject(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        try {
            return this.rs.getObject(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        try {
            return this.rs.findColumn(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            return this.rs.getCharacterStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        try {
            return this.rs.getCharacterStream(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            return this.rs.getBigDecimal(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        try {
            return this.rs.getBigDecimal(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            return this.rs.isBeforeFirst();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            return this.rs.isAfterLast();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            return this.rs.isFirst();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            return this.rs.isLast();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            this.rs.beforeFirst();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            this.rs.afterLast();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            return this.rs.first();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            return this.rs.last();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getRow() throws SQLException {
        try {
            return this.rs.getRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        try {
            return this.rs.absolute(row);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        try {
            return this.rs.relative(rows);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            boolean moreRows = this.rs.previous();
            if (moreRows) {
                --this.cursorIndex;
            }
            return moreRows;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.rs.setFetchDirection(direction);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.rs.getFetchDirection();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.rs.setFetchSize(rows);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.rs.getFetchSize();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            return this.rs.getType();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            return this.rs.getConcurrency();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            return this.rs.rowUpdated();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            return this.rs.rowInserted();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            return this.rs.rowDeleted();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        try {
            this.rs.updateNull(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            this.rs.updateBoolean(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            this.rs.updateByte(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        try {
            this.rs.updateShort(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        try {
            this.rs.updateInt(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        try {
            this.rs.updateLong(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        try {
            this.rs.updateFloat(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            this.rs.updateDouble(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            this.rs.updateBigDecimal(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        try {
            this.rs.updateString(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            this.rs.updateBytes(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            this.rs.updateDate(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            this.rs.updateTime(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            this.rs.updateTimestamp(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            this.rs.updateAsciiStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            this.rs.updateBinaryStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        try {
            this.rs.updateCharacterStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        try {
            this.rs.updateObject(columnIndex, x, scaleOrLength);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        try {
            this.rs.updateObject(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        try {
            this.rs.updateNull(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        try {
            this.rs.updateBoolean(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        try {
            this.rs.updateByte(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        try {
            this.rs.updateShort(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        try {
            this.rs.updateInt(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        try {
            this.rs.updateLong(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        try {
            this.rs.updateFloat(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        try {
            this.rs.updateDouble(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        try {
            this.rs.updateBigDecimal(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        try {
            this.rs.updateString(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        try {
            this.rs.updateBytes(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        try {
            this.rs.updateDate(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        try {
            this.rs.updateTime(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        try {
            this.rs.updateTimestamp(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        try {
            this.rs.updateAsciiStream(columnLabel, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        try {
            this.rs.updateBinaryStream(columnLabel, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        try {
            this.rs.updateCharacterStream(columnLabel, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        try {
            this.rs.updateObject(columnLabel, x, scaleOrLength);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        try {
            this.rs.updateObject(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            this.rs.insertRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            this.rs.updateRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            this.rs.deleteRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            this.rs.refreshRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            this.rs.cancelRowUpdates();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            this.rs.moveToInsertRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            this.rs.moveToCurrentRow();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Statement getStatement() {
        return this.stmt;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        try {
            return this.rs.getObject(columnIndex, map);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        try {
            return this.rs.getRef(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        try {
            return this.rs.getBlob(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        try {
            return this.rs.getClob(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        try {
            return this.rs.getArray(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        try {
            return this.rs.getObject(columnLabel, map);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        try {
            return this.rs.getRef(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        try {
            return this.rs.getBlob(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        try {
            return this.rs.getClob(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        try {
            return this.rs.getArray(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.rs.getDate(columnIndex, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        try {
            return this.rs.getDate(columnLabel, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.rs.getTime(columnIndex, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        try {
            return this.rs.getTime(columnLabel, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try {
            return this.rs.getTimestamp(columnIndex, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        try {
            return this.rs.getTimestamp(columnLabel, cal);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            return this.rs.getURL(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        try {
            return this.rs.getURL(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        try {
            this.rs.updateRef(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        try {
            this.rs.updateRef(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        try {
            this.rs.updateBlob(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        try {
            this.rs.updateBlob(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        try {
            this.rs.updateClob(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        try {
            this.rs.updateClob(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        try {
            this.rs.updateArray(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        try {
            this.rs.updateArray(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        try {
            return this.rs.getRowId(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        try {
            return this.rs.getRowId(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        try {
            this.rs.updateRowId(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        try {
            this.rs.updateRowId(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.rs.getHoldability();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        try {
            this.rs.updateNString(columnIndex, nString);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        try {
            this.rs.updateNString(columnLabel, nString);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        try {
            this.rs.updateNClob(columnIndex, nClob);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        try {
            this.rs.updateNClob(columnLabel, nClob);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        try {
            return this.rs.getNClob(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        try {
            return this.rs.getNClob(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        try {
            return this.rs.getSQLXML(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        try {
            return this.rs.getSQLXML(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        try {
            this.rs.updateSQLXML(columnIndex, xmlObject);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        try {
            this.rs.updateSQLXML(columnLabel, xmlObject);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        try {
            return this.rs.getNString(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        try {
            return this.rs.getNString(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        try {
            return this.rs.getNCharacterStream(columnIndex);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        try {
            return this.rs.getNCharacterStream(columnLabel);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            this.rs.updateNCharacterStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this.rs.updateNCharacterStream(columnLabel, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            this.rs.updateAsciiStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            this.rs.updateBinaryStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            this.rs.updateCharacterStream(columnIndex, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            this.rs.updateAsciiStream(columnLabel, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            this.rs.updateBinaryStream(columnLabel, x, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this.rs.updateCharacterStream(columnLabel, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        try {
            this.rs.updateBlob(columnIndex, inputStream, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        try {
            this.rs.updateBlob(columnLabel, inputStream, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        try {
            this.rs.updateClob(columnIndex, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this.rs.updateClob(columnLabel, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        try {
            this.rs.updateNClob(columnIndex, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this.rs.updateNClob(columnLabel, reader, length);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            this.rs.updateNCharacterStream(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        try {
            this.rs.updateNCharacterStream(columnLabel, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        try {
            this.rs.updateAsciiStream(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        try {
            this.rs.updateBinaryStream(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            this.rs.updateCharacterStream(columnIndex, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        try {
            this.rs.updateAsciiStream(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        try {
            this.rs.updateBinaryStream(columnLabel, x);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        try {
            this.rs.updateCharacterStream(columnLabel, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        try {
            this.rs.updateBlob(columnIndex, inputStream);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        try {
            this.rs.updateBlob(columnLabel, inputStream);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        try {
            this.rs.updateClob(columnIndex, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        try {
            this.rs.updateClob(columnLabel, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        try {
            this.rs.updateNClob(columnIndex, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        try {
            this.rs.updateNClob(columnLabel, reader);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == ResultSet.class) {
            if (this.rs instanceof ResultSetProxy) {
                return this.rs.unwrap(iface);
            }
            return (T)this.rs;
        }
        return super.unwrap(iface);
    }
}

