/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.pool.ConnectionHolder;
import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidPooledPreparedStatement;
import com.alibaba.druid.pool.PreparedStatementHolder;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.OracleUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PreparedStatementPool {
    private static final Log LOG = LogFactory.getLog(PreparedStatementPool.class);
    private final LRUCache map;
    private final DruidAbstractDataSource dataSource;

    public PreparedStatementPool(ConnectionHolder holder) {
        this.dataSource = holder.getDataSource();
        int initCapacity = holder.getDataSource().getMaxPoolPreparedStatementPerConnectionSize();
        if (initCapacity <= 0) {
            initCapacity = 16;
        }
        this.map = new LRUCache(initCapacity);
    }

    public PreparedStatementHolder get(DruidPooledPreparedStatement.PreparedStatementKey key) throws SQLException {
        PreparedStatementHolder holder = (PreparedStatementHolder)this.map.get(key);
        if (holder != null) {
            if (holder.isInUse() && !this.dataSource.isSharePreparedStatements()) {
                return null;
            }
            holder.incrementHitCount();
            this.dataSource.incrementCachedPreparedStatementHitCount();
            if (holder.isEnterOracleImplicitCache()) {
                OracleUtils.exitImplicitCacheToActive(holder.getStatement());
            }
        } else {
            this.dataSource.incrementCachedPreparedStatementMissCount();
        }
        return holder;
    }

    public void put(PreparedStatementHolder holder) throws SQLException {
        PreparedStatement stmt = holder.getStatement();
        if (stmt == null) {
            return;
        }
        if (this.dataSource.isOracle() && this.dataSource.isUseOracleImplicitCache()) {
            OracleUtils.enterImplicitCache(stmt);
            holder.setEnterOracleImplicitCache(true);
        } else {
            holder.setEnterOracleImplicitCache(false);
        }
        DruidPooledPreparedStatement.PreparedStatementKey key = holder.getKey();
        PreparedStatementHolder oldHolder = this.map.put(key, holder);
        if (oldHolder != null && oldHolder != holder) {
            this.dataSource.closePreapredStatement(oldHolder);
        } else if (holder.getHitCount() == 0) {
            this.dataSource.incrementCachedPreparedStatementCount();
        }
    }

    public void clear() throws SQLException {
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.closeStatement((PreparedStatementHolder)entry.getValue());
            iter.remove();
        }
    }

    private void closeStatement(PreparedStatementHolder holder) throws SQLException {
        if (holder.isEnterOracleImplicitCache()) {
            OracleUtils.exitImplicitCacheToClose(holder.getStatement());
        }
        this.dataSource.closePreapredStatement(holder);
        this.dataSource.decrementCachedPreparedStatementCount();
        this.dataSource.incrementCachedPreparedStatementDeleteCount();
    }

    public Map<DruidPooledPreparedStatement.PreparedStatementKey, PreparedStatementHolder> getMap() {
        return this.map;
    }

    public class LRUCache
    extends LinkedHashMap<DruidPooledPreparedStatement.PreparedStatementKey, PreparedStatementHolder> {
        private static final long serialVersionUID = 1L;

        public LRUCache(int maxSize) {
            super(maxSize, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<DruidPooledPreparedStatement.PreparedStatementKey, PreparedStatementHolder> eldest) {
            boolean remove;
            boolean bl = remove = this.size() > PreparedStatementPool.this.dataSource.getMaxPoolPreparedStatementPerConnectionSize();
            if (remove) {
                try {
                    PreparedStatementPool.this.closeStatement(eldest.getValue());
                }
                catch (SQLException e) {
                    LOG.error("closeStatement error", e);
                }
            }
            return remove;
        }
    }

    public static enum MethodType {
        M1,
        M2,
        M3,
        M4,
        M5,
        M6,
        Precall_1,
        Precall_2,
        Precall_3;

    }
}

