/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.pool.DataSourceAdapter;
import com.alibaba.druid.pool.ha.DataSourceHolder;
import com.alibaba.druid.pool.ha.MultiConnectionHolder;
import com.alibaba.druid.pool.ha.MultiDataSourceConnection;
import com.alibaba.druid.pool.ha.MultiDataSourceMBean;
import com.alibaba.druid.pool.ha.MultiDataSourceStatManager;
import com.alibaba.druid.pool.ha.balance.Balancer;
import com.alibaba.druid.pool.ha.balance.WeightBalancer;
import com.alibaba.druid.pool.ha.config.ConfigLoader;
import com.alibaba.druid.pool.ha.valid.DataSourceFailureDetecter;
import com.alibaba.druid.pool.ha.valid.DefaultDataSourceFailureDetecter;
import com.alibaba.druid.proxy.jdbc.DataSourceProxy;
import com.alibaba.druid.stat.JdbcDataSourceStat;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.ObjectName;

public class MultiDataSource
extends DataSourceAdapter
implements MultiDataSourceMBean,
DataSourceProxy {
    private static final Log LOG = LogFactory.getLog(MultiDataSource.class);
    private Properties properties = new Properties();
    private final AtomicLong connectionIdSeed = new AtomicLong();
    private final AtomicLong statementIdSeed = new AtomicLong();
    private final AtomicLong resultSetIdSeed = new AtomicLong();
    private final AtomicLong transactionIdSeed = new AtomicLong();
    private final AtomicLong configLoadCount = new AtomicLong();
    private final AtomicLong failureDetectCount = new AtomicLong();
    private final AtomicLong busySkipCount = new AtomicLong();
    private final AtomicLong retryGetConnectionCount = new AtomicLong();
    protected DataSourceFailureDetecter failureDetector = new DefaultDataSourceFailureDetecter();
    private long failureDetectPeriodMillis = 3000L;
    private long configLoadPeriodMillis = 60000L;
    private int schedulerThreadCount = 3;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> failureDetectFuture;
    private ScheduledFuture<?> configLoadFuture;
    private boolean inited = false;
    protected final Lock lock = new ReentrantLock();
    protected final Condition notFull = this.lock.newCondition();
    protected final Condition notFail = this.lock.newCondition();
    private ConcurrentMap<String, DataSourceHolder> dataSources = new ConcurrentHashMap<String, DataSourceHolder>();
    private ObjectName objectName;
    private List<Filter> filters = new ArrayList<Filter>();
    private boolean enable;
    private String name;
    private ConfigLoader configLoader;
    private int maxPoolSize = 50;
    private long activeCount = 0L;
    private long maxWaitMillis = 0L;
    private Balancer balancer = new WeightBalancer();
    private JdbcDataSourceStat dataSourceStat;
    protected Properties connectionProperties = new Properties();

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public void setMaxWait(long seconds) {
        this.setMaxWaitMillis(1000L * seconds);
    }

    public long getMaxWait() {
        return this.getMaxWaitMillis() / 1000L;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) throws SQLException {
        if (this.isIntited()) {
            throw new SQLException("dataSource inited");
        }
        this.maxPoolSize = maxPoolSize;
    }

    public ConfigLoader getConfigLoader() {
        return this.configLoader;
    }

    public void setConfigLoader(ConfigLoader configLoader) {
        this.configLoader = configLoader;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "HADataSource-" + System.identityHashCode(this);
        }
        return this.name;
    }

    public String getNameInternal() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isIntited() {
        return this.inited;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws SQLException {
        if (this.inited) {
            return;
        }
        this.lock.lock();
        try {
            if (this.inited) {
                return;
            }
            this.dataSourceStat = new JdbcDataSourceStat(this.name, null);
            this.balancer.init(this);
            this.initInternal();
            this.scheduler = Executors.newScheduledThreadPool(this.schedulerThreadCount);
            this.startFailureDetectScheduleTask();
            this.startConfigLoadScheduleTask();
            this.inited = true;
            MultiDataSourceStatManager.add(this);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean startConfigLoadScheduleTask() {
        if (this.configLoadFuture == null) {
            this.configLoadFuture = this.scheduler.scheduleAtFixedRate(new ConfigLoadTask(), this.configLoadPeriodMillis, this.configLoadPeriodMillis, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    @Override
    public boolean stopConfigLoadScheduleTask() {
        if (this.configLoadFuture != null) {
            this.configLoadFuture.cancel(true);
            this.configLoadFuture = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean startFailureDetectScheduleTask() {
        if (this.failureDetectFuture == null) {
            this.failureDetectFuture = this.scheduler.scheduleAtFixedRate(new FailureDetectTask(), this.failureDetectPeriodMillis, this.failureDetectPeriodMillis, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    @Override
    public boolean stopFailureDetectScheduleTask() {
        if (this.failureDetectFuture != null) {
            this.failureDetectFuture.cancel(true);
            this.failureDetectFuture = null;
            return true;
        }
        return false;
    }

    protected void initInternal() throws SQLException {
    }

    public void resetStat() {
    }

    public void close() {
        Object[] items;
        this.scheduler.shutdownNow();
        for (Object item : items = this.getDataSources().values().toArray()) {
            JdbcUtils.close((DataSourceHolder)item);
        }
        MultiDataSourceStatManager.remove(this);
    }

    @Override
    public void failureDetect() {
        int changeCount = 0;
        for (DataSourceHolder dataSourceHolder : this.getDataSources().values()) {
            boolean isFail = !this.failureDetector.isValid(dataSourceHolder.getDataSource());
            if (isFail == dataSourceHolder.isFail()) continue;
            dataSourceHolder.setFail(isFail);
            ++changeCount;
        }
        if (changeCount != 0) {
            this.afterDataSourceChanged(null);
        }
        this.failureDetectCount.incrementAndGet();
    }

    protected ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public void setFailureDetectPeriodMillis(long failureDetectPeriodMillis) {
        this.failureDetectPeriodMillis = failureDetectPeriodMillis;
    }

    public void setConfigLoadPeriodMillis(long configLoadPeriodMillis) {
        this.configLoadPeriodMillis = configLoadPeriodMillis;
    }

    public DataSourceFailureDetecter getFailureDetector() {
        return this.failureDetector;
    }

    public void setFailureDetector(DataSourceFailureDetecter failureDetector) {
        this.failureDetector = failureDetector;
    }

    @Override
    public long createConnectionId() {
        return this.connectionIdSeed.getAndIncrement();
    }

    @Override
    public long createStatementId() {
        return this.statementIdSeed.incrementAndGet();
    }

    public Map<String, DataSourceHolder> getDataSources() {
        return this.dataSources;
    }

    public DataSourceHolder getDataSourceHolder(String name) {
        return (DataSourceHolder)this.dataSources.get(name);
    }

    public void addDataSource(String name, DataSourceHolder dataSourceHolder) {
        this.dataSources.put(name, dataSourceHolder);
        this.afterDataSourceChanged(null);
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public long getActiveCount() {
        return this.activeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notFailSignal() {
        this.lock.lock();
        try {
            this.notFail.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void afterDataSourceChanged(Object event) {
        if (!this.balancer.isInited()) {
            this.balancer.init(this);
        }
        this.balancer.afterDataSourceChanged(null);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.init();
        this.lock.lock();
        try {
            if (this.activeCount >= (long)this.maxPoolSize) {
                this.notFull.await();
            }
            MultiDataSourceConnection conn = new MultiDataSourceConnection(this, this.createConnectionId());
            ++this.activeCount;
            MultiDataSourceConnection multiDataSourceConnection = conn;
            return multiDataSourceConnection;
        }
        catch (InterruptedException e) {
            throw new SQLException("thread interrupted", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterConnectionClosed(MultiDataSourceConnection conn) {
        this.lock.lock();
        try {
            --this.activeCount;
            this.notFull.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public MultiConnectionHolder getRealConnection(MultiDataSourceConnection multiConn, String sql) throws SQLException {
        return this.balancer.getConnection(multiConn, sql);
    }

    public int getEnabledDataSourceCount() {
        int count = 0;
        for (DataSourceHolder item : this.dataSources.values()) {
            if (!item.isEnable()) continue;
            ++count;
        }
        return count;
    }

    public void handleNotAwailableDatasource(DataSourceHolder dataSourceHolder) {
    }

    @Override
    public long getRetryGetConnectionCount() {
        return this.retryGetConnectionCount.get();
    }

    public void incrementRetryGetConnectionCount() {
        this.retryGetConnectionCount.incrementAndGet();
    }

    public Lock getLock() {
        return this.lock;
    }

    public Condition getNotFail() {
        return this.notFail;
    }

    @Override
    public long getBusySkipCount() {
        return this.busySkipCount.get();
    }

    public void incrementBusySkipCount() {
        this.busySkipCount.incrementAndGet();
    }

    @Override
    public String[] getDataSourceNames() {
        return this.dataSources.keySet().toArray(new String[this.dataSources.size()]);
    }

    @Override
    public String getDbType() {
        return null;
    }

    @Override
    public Driver getRawDriver() {
        return null;
    }

    @Override
    public String getUrl() {
        return null;
    }

    @Override
    public String getRawJdbcUrl() {
        return null;
    }

    @Override
    public List<Filter> getProxyFilters() {
        return this.filters;
    }

    @Override
    public long createResultSetId() {
        return this.resultSetIdSeed.incrementAndGet();
    }

    @Override
    public long createTransactionId() {
        return this.transactionIdSeed.incrementAndGet();
    }

    @Override
    public boolean restartDataSource(String name) {
        DataSourceHolder holder = this.getDataSources().get(name);
        if (holder != null) {
            holder.restart();
            return true;
        }
        return false;
    }

    @Override
    public long getConfigLoadCount() {
        return this.configLoadCount.get();
    }

    @Override
    public long getFailureDetectCount() {
        return this.failureDetectCount.get();
    }

    @Override
    public long getFailureDetectPeriodMillis() {
        return this.failureDetectPeriodMillis;
    }

    @Override
    public long getConfigLoadPeriodMillis() {
        return this.configLoadPeriodMillis;
    }

    @Override
    public JdbcDataSourceStat getDataSourceStat() {
        return this.dataSourceStat;
    }

    @Override
    public Properties getConnectProperties() {
        return this.connectionProperties;
    }

    class FailureDetectTask
    implements Runnable {
        FailureDetectTask() {
        }

        @Override
        public void run() {
            try {
                MultiDataSource.this.failureDetect();
            }
            catch (Exception ex) {
                LOG.error("failure detect error", ex);
            }
        }
    }

    class ConfigLoadTask
    implements Runnable {
        ConfigLoadTask() {
        }

        @Override
        public void run() {
            if (MultiDataSource.this.configLoader != null) {
                try {
                    MultiDataSource.this.configLoadCount.incrementAndGet();
                    MultiDataSource.this.configLoader.load();
                }
                catch (Exception e) {
                    LOG.error("config load error", e);
                }
            }
        }
    }
}

