/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.balance;

import com.alibaba.druid.pool.ha.DataSourceChangedEvent;
import com.alibaba.druid.pool.ha.DataSourceHolder;
import com.alibaba.druid.pool.ha.MultiConnectionHolder;
import com.alibaba.druid.pool.ha.MultiDataSource;
import com.alibaba.druid.pool.ha.MultiDataSourceConnection;
import com.alibaba.druid.pool.ha.balance.AbstractBalancer;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinBlancer
extends AbstractBalancer {
    private static final Log LOG = LogFactory.getLog(RoundRobinBlancer.class);
    private final AtomicInteger indexErrorCount = new AtomicInteger();

    @Override
    public void afterDataSourceChanged(DataSourceChangedEvent event) {
    }

    @Override
    public MultiConnectionHolder getConnection(MultiDataSourceConnection conn, String sql) throws SQLException {
        DataSourceHolder dataSource;
        block8: {
            MultiDataSource multiDataSource = conn.getMultiDataSource();
            int size = multiDataSource.getDataSources().size();
            long connectionId = (int)conn.getId();
            if (size == 0) {
                throw new SQLException("can not get connection, no availabe datasources");
            }
            int index = (int)(connectionId % (long)size);
            DataSourceHolder first = null;
            dataSource = null;
            try {
                int itemIndex = 0;
                for (DataSourceHolder item : multiDataSource.getDataSources().values()) {
                    if (!item.isEnable()) continue;
                    if (first == null) {
                        first = item;
                    }
                    if (itemIndex == index) {
                        dataSource = item;
                        break;
                    }
                    ++itemIndex;
                }
                if (dataSource == null) {
                    dataSource = first;
                }
            }
            catch (Exception ex) {
                this.indexErrorCount.incrementAndGet();
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug("getDataSource error, index : " + index, ex);
            }
        }
        if (dataSource == null) {
            throw new SQLException("can not get real connection.");
        }
        MultiConnectionHolder holder = null;
        return holder;
    }

    public long getIndexErrorCount() {
        return this.indexErrorCount.get();
    }
}

