/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SQLAggregateExpr
extends SQLExprImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String methodName;
    protected int option;
    protected final List<SQLExpr> arguments = new ArrayList<SQLExpr>();

    public SQLAggregateExpr(String methodName) {
        this.methodName = methodName;
        this.option = 1;
    }

    public SQLAggregateExpr(String methodName, int option) {
        this.methodName = methodName;
        this.option = option;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public int getOption() {
        return this.option;
    }

    public void setOption(int option) {
        this.option = option;
    }

    public List<SQLExpr> getArguments() {
        return this.arguments;
    }

    @Override
    public void output(StringBuffer buf) {
        buf.append(this.methodName);
        buf.append("(");
        int size = this.arguments.size();
        for (int i = 0; i < size; ++i) {
            this.arguments.get(i).output(buf);
        }
        buf.append(")");
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.arguments);
        }
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arguments == null ? 0 : ((Object)this.arguments).hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + this.option;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLAggregateExpr other = (SQLAggregateExpr)obj;
        if (this.arguments == null ? other.arguments != null : !((Object)this.arguments).equals(other.arguments)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return this.option == other.option;
    }
}

