/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;

public class PGSelectParser
extends SQLSelectParser {
    public PGSelectParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public PGSelectParser(String sql) throws ParserException {
        this(new PGExprParser(sql));
    }

    protected SQLExprParser createExprParser() {
        return new PGExprParser(this.lexer);
    }

    @Override
    public SQLSelectQuery query() throws ParserException {
        SQLExpr expr;
        PGSelectQueryBlock queryBlock = new PGSelectQueryBlock();
        if (this.lexer.token() == Token.SELECT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DISTINCT) {
                queryBlock.setDistionOption(2);
                this.lexer.nextToken();
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    while (true) {
                        SQLExpr expr2 = this.createExprParser().expr();
                        queryBlock.getDistinctOn().add(expr2);
                        if (this.lexer.token() == Token.COMMA) {
                            this.lexer.nextToken();
                            continue;
                        }
                        break;
                    }
                }
            } else if (this.lexer.token() == Token.ALL) {
                queryBlock.setDistionOption(1);
                this.lexer.nextToken();
            }
            this.parseSelectList(queryBlock);
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TEMPORARY) {
                    this.lexer.nextToken();
                    queryBlock.setIntoOption(PGSelectQueryBlock.IntoOption.TEMPORARY);
                } else if (this.lexer.token() == Token.TEMP) {
                    this.lexer.nextToken();
                    queryBlock.setIntoOption(PGSelectQueryBlock.IntoOption.TEMP);
                } else if (this.lexer.token() == Token.UNLOGGED) {
                    this.lexer.nextToken();
                    queryBlock.setIntoOption(PGSelectQueryBlock.IntoOption.UNLOGGED);
                }
                if (this.lexer.token() == Token.TABLE) {
                    this.lexer.nextToken();
                }
                SQLName name = this.createExprParser().name();
                queryBlock.setInto(new SQLExprTableSource(name));
            }
        }
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        if (this.lexer.token() == Token.WINDOW) {
            this.lexer.nextToken();
            PGSelectQueryBlock.WindowClause window = new PGSelectQueryBlock.WindowClause();
            window.setName(this.expr());
            this.accept(Token.AS);
            while (true) {
                expr = this.createExprParser().expr();
                window.getDefinition().add(expr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            queryBlock.setWindow(window);
        }
        queryBlock.setOrderBy(this.createExprParser().parseOrderBy());
        if (this.lexer.token() == Token.LIMIT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.ALL) {
                queryBlock.setLimit(new SQLIdentifierExpr("ALL"));
                this.lexer.nextToken();
            } else {
                SQLExpr limit = this.expr();
                queryBlock.setLimit(limit);
            }
        }
        if (this.lexer.token() == Token.OFFSET) {
            this.lexer.nextToken();
            SQLExpr offset = this.expr();
            queryBlock.setOffset(offset);
            if (this.lexer.token() == Token.ROW || this.lexer.token() == Token.ROWS) {
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.FETCH) {
            this.lexer.nextToken();
            PGSelectQueryBlock.FetchClause fetch = new PGSelectQueryBlock.FetchClause();
            if (this.lexer.token() == Token.FIRST) {
                fetch.setOption(PGSelectQueryBlock.FetchClause.Option.FIRST);
            } else if (this.lexer.token() == Token.NEXT) {
                fetch.setOption(PGSelectQueryBlock.FetchClause.Option.NEXT);
            } else {
                throw new ParserException("expect 'FIRST' or 'NEXT'");
            }
            SQLExpr count = this.expr();
            fetch.setCount(count);
            if (this.lexer.token() != Token.ROW && this.lexer.token() != Token.ROWS) {
                throw new ParserException("expect 'ROW' or 'ROWS'");
            }
            this.lexer.nextToken();
            if (this.lexer.token() != Token.ONLY) {
                throw new ParserException("expect 'ONLY'");
            }
            this.lexer.nextToken();
            queryBlock.setFetch(fetch);
        }
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            PGSelectQueryBlock.ForClause forClause = new PGSelectQueryBlock.ForClause();
            if (this.lexer.token() == Token.UPDATE) {
                forClause.setOption(PGSelectQueryBlock.ForClause.Option.UPDATE);
            } else if (this.lexer.token() == Token.SHARE) {
                forClause.setOption(PGSelectQueryBlock.ForClause.Option.SHARE);
            } else {
                throw new ParserException("expect 'FIRST' or 'NEXT'");
            }
            this.accept(Token.OF);
            while (true) {
                expr = this.createExprParser().expr();
                forClause.getOf().add(expr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.NOWAIT) {
                this.lexer.nextToken();
                forClause.setNoWait(true);
            }
            queryBlock.setForClause(forClause);
        }
        return this.queryRest(queryBlock);
    }
}

