/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLReleaseSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.ArrayList;
import java.util.List;

public class SQLStatementParser
extends SQLParser {
    protected SQLExprParser exprParser;

    public SQLStatementParser(String sql) {
        this(new SQLExprParser(sql));
    }

    public SQLStatementParser(SQLExprParser exprParser) {
        super(exprParser.getLexer());
        this.exprParser = exprParser;
    }

    public SQLExprParser getExprParser() {
        return this.exprParser;
    }

    public List<SQLStatement> parseStatementList() throws ParserException {
        ArrayList<SQLStatement> statementList = new ArrayList<SQLStatement>();
        this.parseStatementList(statementList);
        return statementList;
    }

    public void parseStatementList(List<SQLStatement> statementList) throws ParserException {
        while (true) {
            if (this.lexer.token() == Token.EOF) {
                return;
            }
            if (this.lexer.token() == Token.SEMI) {
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.token() == Token.SELECT) {
                statementList.add(this.parseSelect());
                continue;
            }
            if (this.lexer.token() == Token.UPDATE) {
                statementList.add(this.parseUpdateStatement());
                continue;
            }
            if (this.lexer.token() == Token.CREATE) {
                statementList.add(this.parseCreate());
                continue;
            }
            if (this.lexer.token() == Token.INSERT) {
                SQLStatement insertStatement = this.parseInsert();
                statementList.add(insertStatement);
                continue;
            }
            if (this.lexer.token() == Token.DELETE) {
                statementList.add(this.parseDeleteStatement());
                continue;
            }
            if (this.lexer.token() == Token.SET) {
                statementList.add(this.parseSet());
                continue;
            }
            if (this.lexer.token() == Token.ALTER) {
                statementList.add(this.parseAlter());
                continue;
            }
            if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TABLE || this.identifierEquals("TEMPORARY")) {
                    SQLDropTableStatement stmt = this.parseDropTable(false);
                    statementList.add(stmt);
                    continue;
                }
                if (this.identifierEquals("USER")) {
                    SQLStatement stmt = this.parseDropUser();
                    statementList.add(stmt);
                    continue;
                }
                if (this.lexer.token() == Token.INDEX) {
                    SQLStatement stmt = this.parseDropIndex();
                    statementList.add(stmt);
                    continue;
                }
                if (this.lexer.token() == Token.VIEW) {
                    SQLDropViewStatement stmt = this.parseDropView(false);
                    statementList.add(stmt);
                    continue;
                }
                throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
            }
            if (this.lexer.token() == Token.TRUNCATE) {
                SQLStatement stmt = this.parseTruncate();
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.token() == Token.USE) {
                SQLUseStatement stmt = this.parseUse();
                statementList.add(stmt);
                continue;
            }
            if (this.identifierEquals("CALL")) {
                SQLCallStatement stmt = this.parseCall();
                statementList.add(stmt);
                continue;
            }
            if (this.identifierEquals("RENAME")) {
                SQLStatement stmt = this.parseRename();
                statementList.add(stmt);
                continue;
            }
            if (this.identifierEquals("RELEASE")) {
                SQLStatement stmt = this.parseReleaseSavePoint();
                statementList.add(stmt);
                continue;
            }
            if (this.identifierEquals("SAVEPOINT")) {
                SQLStatement stmt = this.parseSavePoint();
                statementList.add(stmt);
                continue;
            }
            if (this.identifierEquals("ROLLBACK")) {
                SQLRollbackStatement stmt = this.parseRollback();
                statementList.add(stmt);
                continue;
            }
            if (this.identifierEquals("COMMIT")) {
                SQLStatement stmt = this.parseCommit();
                statementList.add(stmt);
                continue;
            }
            if (this.identifierEquals("SHOW")) {
                SQLStatement stmt = this.parseShow();
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.token() == Token.LPAREN) {
                char mark_ch = this.lexer.current();
                int mark_bp = this.lexer.bp();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.SELECT) {
                    this.lexer.reset(mark_bp, mark_ch, Token.LPAREN);
                    SQLSelectStatement stmt = this.parseSelect();
                    statementList.add(stmt);
                    continue;
                }
            }
            if (!this.parseStatementListDialect(statementList)) break;
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    public SQLRollbackStatement parseRollback() {
        this.lexer.nextToken();
        if (this.identifierEquals("WORK")) {
            this.lexer.nextToken();
        }
        SQLRollbackStatement stmt = new SQLRollbackStatement();
        if (this.identifierEquals("TO")) {
            this.lexer.nextToken();
            if (this.identifierEquals("SAVEPOINT")) {
                this.lexer.nextToken();
            }
            stmt.setTo(this.exprParser.name());
        }
        return stmt;
    }

    public SQLStatement parseCommit() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    public SQLStatement parseShow() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    public SQLUseStatement parseUse() {
        this.accept(Token.USE);
        SQLUseStatement stmt = new SQLUseStatement();
        stmt.setDatabase(this.exprParser.name());
        return stmt;
    }

    public SQLStatement parseSavePoint() {
        this.acceptIdentifier("SAVEPOINT");
        SQLSavePointStatement stmt = new SQLSavePointStatement();
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    public SQLStatement parseReleaseSavePoint() {
        this.acceptIdentifier("RELEASE");
        this.acceptIdentifier("SAVEPOINT");
        SQLReleaseSavePointStatement stmt = new SQLReleaseSavePointStatement();
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    public SQLStatement parseAlter() {
        this.accept(Token.ALTER);
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    public SQLStatement parseRename() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    protected SQLDropTableStatement parseDropTable(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        this.accept(Token.TABLE);
        SQLDropTableStatement stmt = new SQLDropTableStatement();
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.getTableSources().add(new SQLExprTableSource(name));
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    protected SQLDropViewStatement parseDropView(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        this.accept(Token.VIEW);
        SQLDropViewStatement stmt = new SQLDropViewStatement();
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.getTableSources().add(new SQLExprTableSource(name));
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    public SQLStatement parseTruncate() {
        this.accept(Token.TRUNCATE);
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
        }
        SQLTruncateStatement stmt = new SQLTruncateStatement();
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addTableSource(name);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    public SQLStatement parseInsert() {
        SQLInsertStatement insertStatement = new SQLInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.accept(Token.INSERT);
        }
        this.parseInsert0(insertStatement);
        return insertStatement;
    }

    protected void parseInsert0(SQLInsertInto insertStatement) {
        this.parseInsert0(insertStatement, true);
    }

    protected void parseInsert0_hinits(SQLInsertInto insertStatement) {
    }

    protected void parseInsert0(SQLInsertInto insertStatement, boolean acceptSubQuery) {
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            SQLName tableName = this.exprParser.name();
            insertStatement.setTableName(tableName);
            if (this.lexer.token() == Token.LITERAL_ALIAS) {
                insertStatement.setAlias(this.as());
            }
            this.parseInsert0_hinits(insertStatement);
            if (this.lexer.token() == Token.IDENTIFIER) {
                insertStatement.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(insertStatement.getColumns());
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
            this.exprParser.exprList(values.getValues());
            insertStatement.setValues(values);
            this.accept(Token.RPAREN);
        } else if (acceptSubQuery && (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.LPAREN)) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            insertStatement.setQuery(queryExpr.getSubQuery());
        }
    }

    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        return false;
    }

    public SQLStatement parseDropUser() throws ParserException {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLStatement parseDropIndex() throws ParserException {
        this.accept(Token.INDEX);
        SQLDropIndexStatement stmt = new SQLDropIndexStatement();
        stmt.setIndexName(this.exprParser.name());
        this.accept(Token.ON);
        stmt.setTableName(this.exprParser.name());
        return stmt;
    }

    public SQLCallStatement parseCall() throws ParserException {
        this.acceptIdentifier("CALL");
        SQLCallStatement stmt = new SQLCallStatement();
        stmt.setProcedureName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getParameters());
            this.accept(Token.RPAREN);
        }
        return stmt;
    }

    public SQLStatement parseSet() throws ParserException {
        this.accept(Token.SET);
        SQLSetStatement stmt = new SQLSetStatement();
        this.parseAssignItems(stmt.getItems());
        return stmt;
    }

    public void parseAssignItems(List<SQLAssignItem> items) {
        while (true) {
            SQLAssignItem item = this.exprParser.parseAssignItem();
            items.add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    public SQLStatement parseCreate() throws ParserException {
        char mark_ch = this.lexer.current();
        int mark_bp = this.lexer.bp();
        this.accept(Token.CREATE);
        Token token = this.lexer.token();
        if (token == Token.TABLE || this.identifierEquals("GLOBAL")) {
            SQLCreateTableParser createTableParser = this.getSQLCreateTableParser();
            return createTableParser.parseCrateTable(false);
        }
        if (token == Token.INDEX || token == Token.UNIQUE) {
            return this.parseCreateIndex(false);
        }
        if (this.identifierEquals("SEQUENCE")) {
            return this.parseCreateSequence(false);
        }
        if (token == Token.OR) {
            this.lexer.nextToken();
            this.acceptIdentifier("REPLACE");
            if (this.lexer.token() == Token.PROCEDURE) {
                this.lexer.reset(mark_bp, mark_ch, Token.CREATE);
                return this.parseCreateProcedure();
            }
            throw new ParserException("TODO " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        if (token == Token.DATABASE) {
            return this.parseCreateDatabase();
        }
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLStatement parseCreateDatabase() {
        if (this.lexer.token() == Token.CREATE) {
            this.lexer.nextToken();
        }
        this.accept(Token.DATABASE);
        SQLCreateDatabaseStatement stmt = new SQLCreateDatabaseStatement();
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    public SQLStatement parseCreateProcedure() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLStatement parseCreateSequence(boolean acceptCreate) {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLStatement parseCreateIndex(boolean acceptCreate) {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token()));
    }

    public SQLCreateTableParser getSQLCreateTableParser() {
        return new SQLCreateTableParser(this.exprParser);
    }

    public SQLSelectStatement parseSelect() throws ParserException {
        return new SQLSelectStatement(this.createSQLSelectParser().select());
    }

    public SQLSelectParser createSQLSelectParser() {
        return new SQLSelectParser(this.exprParser);
    }

    public SQLUpdateStatement parseUpdateStatement() throws ParserException {
        SQLUpdateStatement udpateStatement = this.createUpdateStatement();
        if (this.lexer.token() == Token.UPDATE) {
            this.lexer.nextToken();
            SQLTableSource tableSource = this.exprParser.createSelectParser().parseTableSource();
            udpateStatement.setTableSource(tableSource);
        }
        this.accept(Token.SET);
        while (true) {
            SQLUpdateSetItem item = new SQLUpdateSetItem();
            item.setColumn(this.exprParser.name());
            this.accept(Token.EQ);
            item.setValue(this.exprParser.expr());
            udpateStatement.getItems().add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            udpateStatement.setWhere(this.exprParser.expr());
        }
        return udpateStatement;
    }

    protected SQLUpdateStatement createUpdateStatement() {
        return new SQLUpdateStatement();
    }

    public SQLDeleteStatement parseDeleteStatement() throws ParserException {
        SQLDeleteStatement deleteStatement = new SQLDeleteStatement();
        if (this.lexer.token() == Token.DELETE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
            }
            SQLName tableName = this.exprParser.name();
            deleteStatement.setTableName(tableName);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            deleteStatement.setWhere(where);
        }
        return deleteStatement;
    }

    public SQLCreateTableStatement parseCreateTable() throws ParserException {
        throw new ParserException("TODO");
    }

    public SQLCreateViewStatement parseCreateView() throws ParserException {
        SQLCreateViewStatement createView = new SQLCreateViewStatement();
        this.accept(Token.CREATE);
        this.accept(Token.VIEW);
        createView.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(createView.getColumns());
            this.accept(Token.RPAREN);
        }
        this.accept(Token.AS);
        createView.setSubQuery(new SQLSelectParser(this.exprParser).select());
        return createView;
    }

    public SQLCommentStatement parseComment() {
        this.accept(Token.COMMENT);
        SQLCommentStatement stmt = new SQLCommentStatement();
        this.accept(Token.ON);
        if (this.lexer.token() == Token.TABLE) {
            stmt.setType(SQLCommentStatement.Type.TABLE);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.COLUMN) {
            stmt.setType(SQLCommentStatement.Type.COLUMN);
            this.lexer.nextToken();
        }
        stmt.setOn(this.exprParser.name());
        this.accept(Token.IS);
        stmt.setComment(this.exprParser.expr());
        return stmt;
    }
}

