/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.http;

import com.alibaba.druid.support.http.InfoServlet;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.io.IOException;
import java.net.BindException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.MultiException;

public class HttpServer {
    private static final Log LOG = LogFactory.getLog(HttpServer.class);
    protected final Server webServer;
    protected final Connector listener;
    protected final WebAppContext webAppContext;
    protected final Map<Context, Boolean> defaultContexts = new HashMap<Context, Boolean>();
    protected final List<String> filterNames = new ArrayList<String>();

    public HttpServer() throws IOException {
        this("druid", "0.0.0.0", 19790);
    }

    public HttpServer(String name, String bindAddress, int port) throws IOException {
        this.webServer = new Server();
        this.listener = this.createBaseListener();
        this.listener.setHost(bindAddress);
        this.listener.setPort(port);
        this.webServer.addConnector(this.listener);
        this.webServer.setThreadPool((ThreadPool)new QueuedThreadPool());
        String appDir = this.getWebAppsPath();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.webServer.setHandler((Handler)contexts);
        this.webAppContext = new WebAppContext();
        this.webAppContext.setDisplayName("WepAppsContext");
        this.webAppContext.setContextPath("/");
        this.webAppContext.setWar(appDir + "/" + name);
        this.webServer.addHandler((Handler)this.webAppContext);
        this.addDefaultApps(contexts, appDir);
        this.addDefaultServlets();
    }

    public Connector createBaseListener() throws IOException {
        return HttpServer.createDefaultChannelConnector();
    }

    public static Connector createDefaultChannelConnector() {
        SelectChannelConnector ret = new SelectChannelConnector();
        ret.setLowResourceMaxIdleTime(10000);
        ret.setAcceptQueueSize(128);
        ret.setResolveNames(false);
        ret.setUseDirectBuffers(false);
        return ret;
    }

    protected String getWebAppsPath() throws IOException {
        URL url = this.getClass().getClassLoader().getResource("druid-webapps");
        if (url == null) {
            throw new IOException("webapps not found in CLASSPATH");
        }
        return url.toString();
    }

    public void stop() throws Exception {
        this.listener.close();
        this.webServer.stop();
    }

    public void join() throws InterruptedException {
        this.webServer.join();
    }

    public void start() throws IOException {
        try {
            int port = 0;
            int oriPort = this.listener.getPort();
            try {
                port = this.webServer.getConnectors()[0].getLocalPort();
                LOG.debug("Port returned by webServer.getConnectors()[0].getLocalPort() before open() is " + port + ". Opening the listener on " + oriPort);
                this.listener.open();
                port = this.listener.getLocalPort();
                LOG.debug("listener.getLocalPort() returned " + this.listener.getLocalPort() + " webServer.getConnectors()[0].getLocalPort() returned " + this.webServer.getConnectors()[0].getLocalPort());
                LOG.debug("Jetty bound to port " + port);
                this.webServer.start();
            }
            catch (IOException ex) {
                if (ex instanceof BindException) {
                    throw (BindException)ex;
                }
                LOG.debug("HttpServer.start() threw a non Bind IOException");
                throw ex;
            }
            catch (MultiException ex) {
                LOG.debug("HttpServer.start() threw a MultiException");
                throw ex;
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Problem starting http server", ex);
        }
    }

    protected void addDefaultApps(ContextHandlerCollection parent, String appDir) throws IOException {
        Context staticContext = new Context((HandlerContainer)parent, "/static");
        staticContext.setResourceBase(appDir + "/static");
        staticContext.addServlet(DefaultServlet.class, "/*");
        staticContext.setDisplayName("static");
        this.setContextAttributes(staticContext);
        this.defaultContexts.put(staticContext, true);
    }

    private void setContextAttributes(Context context) {
    }

    protected void addDefaultServlets() {
        this.addServlet("info", "/info", InfoServlet.class);
    }

    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addInternalServlet(name, pathSpec, clazz, false);
        this.addFilterPathMapping(pathSpec, (Context)this.webAppContext);
    }

    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz, boolean requireAuth) {
        ServletHolder holder = new ServletHolder(clazz);
        if (name != null) {
            holder.setName(name);
        }
        this.webAppContext.addServlet(holder, pathSpec);
    }

    protected void addFilterPathMapping(String pathSpec, Context webAppCtx) {
        ServletHandler handler = webAppCtx.getServletHandler();
        for (String name : this.filterNames) {
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setFilterName(name);
            fmap.setDispatches(15);
            handler.addFilterMapping(fmap);
        }
    }
}

