/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.FilterManager;
import com.alibaba.druid.proxy.config.AbstractDruidFilterConfig;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.sql.SQLException;
import java.util.List;

public class DruidLoaderUtils {
    private static final Log LOG = LogFactory.getLog(DruidLoaderUtils.class);

    public static void loadFilter(List<Filter> filterList, List<AbstractDruidFilterConfig> druidFilterConfigList) throws SQLException {
        for (AbstractDruidFilterConfig druidFilterConfig : druidFilterConfigList) {
            Filter jdbcFilter;
            String filterItem = druidFilterConfig.getClazz();
            Class<?> filterClass = DruidLoaderUtils.loadClass(druidFilterConfig.getClazz());
            if (filterClass == null) {
                return;
            }
            try {
                jdbcFilter = (Filter)filterClass.newInstance();
                jdbcFilter.loadConfig(druidFilterConfig);
            }
            catch (InstantiationException e) {
                throw new SQLException("load managed jdbc driver event listener error. " + filterItem, e);
            }
            catch (IllegalAccessException e) {
                throw new SQLException("load managed jdbc driver event listener error. " + filterItem, e);
            }
            filterList.add(jdbcFilter);
        }
    }

    public static void loadFilter(List<Filter> filters, String filterName) throws SQLException {
        Class<?> filterClass;
        if (filterName.length() == 0) {
            return;
        }
        String filterClassNames = FilterManager.getFilter(filterName);
        if (filterClassNames != null) {
            filterClassNames = filterClassNames.trim();
        }
        if (filterClassNames != null) {
            for (String filterClassName : filterClassNames.split(",")) {
                Filter filter;
                Class<?> filterClass2;
                if (DruidLoaderUtils.isExist(filters, filterClassName) || (filterClass2 = DruidLoaderUtils.loadClass(filterClassName)) == null) continue;
                try {
                    filter = (Filter)filterClass2.newInstance();
                }
                catch (InstantiationException e) {
                    throw new SQLException("load managed jdbc driver event listener error. " + filterName, e);
                }
                catch (IllegalAccessException e) {
                    throw new SQLException("load managed jdbc driver event listener error. " + filterName, e);
                }
                filters.add(filter);
            }
        } else if (!DruidLoaderUtils.isExist(filters, filterName) && (filterClass = DruidLoaderUtils.loadClass(filterName)) != null) {
            try {
                Filter filter = (Filter)filterClass.newInstance();
                filters.add(filter);
            }
            catch (InstantiationException e) {
                throw new SQLException("load managed jdbc driver event listener error. " + filterName, e);
            }
            catch (IllegalAccessException e) {
                throw new SQLException("load managed jdbc driver event listener error. " + filterName, e);
            }
        }
    }

    private static boolean isExist(List<Filter> filterConfigList, String filterClassName) {
        for (Filter filter : filterConfigList) {
            if (!filter.getClass().getName().equalsIgnoreCase(filterClassName)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> loadClass(String className) {
        Class<?> clazz = null;
        if (className == null) {
            return null;
        }
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error("load class error", e);
        }
        if (clazz == null) {
            DruidLoaderUtils.loadClass2(className);
        }
        return clazz;
    }

    public static Class<?> loadClass2(String className) {
        if (className == null) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

