/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.selector;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.ha.HighAvailableDataSource;
import com.alibaba.druid.pool.ha.selector.DataSourceSelector;
import com.alibaba.druid.pool.ha.selector.RandomDataSourceRecoverThread;
import com.alibaba.druid.pool.ha.selector.RandomDataSourceValidateThread;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.DataSource;

public class RandomDataSourceSelector
implements DataSourceSelector {
    private static final Log LOG = LogFactory.getLog(RandomDataSourceSelector.class);
    private Random random = new Random();
    private List<DataSource> blacklist = new CopyOnWriteArrayList<DataSource>();
    private HighAvailableDataSource highAvailableDataSource;
    private RandomDataSourceValidateThread validateThread;
    private RandomDataSourceRecoverThread recoverThread;

    public RandomDataSourceSelector(HighAvailableDataSource highAvailableDataSource) {
        this.highAvailableDataSource = highAvailableDataSource;
        if (!highAvailableDataSource.isTestOnBorrow() && !highAvailableDataSource.isTestOnReturn()) {
            this.validateThread = new RandomDataSourceValidateThread(this);
            this.recoverThread = new RandomDataSourceRecoverThread(this);
            new Thread((Runnable)this.validateThread, "RandomDataSourceSelector-validate-thread").start();
            new Thread((Runnable)this.recoverThread, "RandomDataSourceSelector-recover-thread").start();
        } else {
            LOG.info("testOnBorrow or testOnReturn has been set to true, ignore validateThread");
        }
    }

    @Override
    public boolean isSame(String name) {
        return this.getName().equalsIgnoreCase(name);
    }

    @Override
    public String getName() {
        return "random";
    }

    @Override
    public DataSource get() {
        Collection<DataSource> targetDataSourceSet;
        Map<String, DataSource> dataSourceMap = this.getDataSourceMap();
        if (dataSourceMap == null || dataSourceMap.isEmpty()) {
            return null;
        }
        if (this.blacklist == null || this.blacklist.isEmpty() || this.blacklist.size() >= dataSourceMap.size()) {
            targetDataSourceSet = dataSourceMap.values();
        } else {
            targetDataSourceSet = new HashSet<DataSource>(dataSourceMap.values());
            for (DataSource b : this.blacklist) {
                targetDataSourceSet.remove(b);
            }
        }
        DataSource[] dataSources = targetDataSourceSet.toArray(new DataSource[0]);
        if (dataSources != null && dataSources.length > 0) {
            return dataSources[this.random.nextInt(targetDataSourceSet.size())];
        }
        return null;
    }

    @Override
    public void setTarget(String name) {
    }

    public Map<String, DataSource> getDataSourceMap() {
        if (this.highAvailableDataSource != null) {
            return this.highAvailableDataSource.getDataSourceMap();
        }
        return new HashMap<String, DataSource>();
    }

    public List<DataSource> getBlacklist() {
        return this.blacklist;
    }

    public void addBlacklist(DataSource dataSource) {
        if (dataSource != null && !this.blacklist.contains(dataSource)) {
            this.blacklist.add(dataSource);
            if (dataSource instanceof DruidDataSource) {
                ((DruidDataSource)dataSource).setTestOnReturn(true);
            }
        }
    }

    public void removeBlacklist(DataSource dataSource) {
        if (dataSource != null && this.blacklist.contains(dataSource)) {
            this.blacklist.remove(dataSource);
            if (dataSource instanceof DruidDataSource) {
                ((DruidDataSource)dataSource).setTestOnReturn(this.highAvailableDataSource.isTestOnReturn());
            }
        }
    }

    public RandomDataSourceValidateThread getValidateThread() {
        return this.validateThread;
    }

    public RandomDataSourceRecoverThread getRecoverThread() {
        return this.recoverThread;
    }
}

