/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.selector;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.ha.selector.RandomDataSourceSelector;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class RandomDataSourceValidateThread
implements Runnable {
    private static final Log LOG = LogFactory.getLog(RandomDataSourceValidateThread.class);
    private int sleepSeconds = 30;
    private int blacklistThreshold = 3;
    private RandomDataSourceSelector selector;
    private Map<String, Integer> errorCounts = new HashMap<String, Integer>();

    public RandomDataSourceValidateThread(RandomDataSourceSelector selector) {
        this.selector = selector;
    }

    @Override
    public void run() {
        while (true) {
            if (this.selector != null) {
                this.checkAllDataSources();
                this.maintainBlacklist();
            }
            try {
                Thread.sleep(this.sleepSeconds * 1000);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void maintainBlacklist() {
        Map<String, DataSource> dataSourceMap = this.selector.getDataSourceMap();
        for (Map.Entry<String, Integer> e : this.errorCounts.entrySet()) {
            if (e.getValue() <= 0) {
                this.selector.removeBlacklist(dataSourceMap.get(e.getKey()));
                continue;
            }
            if (e.getValue() < this.blacklistThreshold) continue;
            LOG.warn("Adding " + e.getKey() + " to blacklist.");
            this.selector.addBlacklist(dataSourceMap.get(e.getKey()));
        }
    }

    private void checkAllDataSources() {
        Map<String, DataSource> dataSourceMap = this.selector.getDataSourceMap();
        for (Map.Entry<String, DataSource> e : dataSourceMap.entrySet()) {
            if (!(e.getValue() instanceof DruidDataSource)) continue;
            boolean flag = this.check(e.getKey(), (DruidDataSource)e.getValue());
            if (flag) {
                this.errorCounts.put(e.getKey(), 0);
                continue;
            }
            if (!this.errorCounts.containsKey(e.getKey())) {
                this.errorCounts.put(e.getKey(), 0);
            }
            int count = this.errorCounts.get(e.getKey());
            this.errorCounts.put(e.getKey(), count + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean check(String name, DruidDataSource dataSource) {
        boolean result = true;
        Driver driver = dataSource.getRawDriver();
        Properties info = new Properties(dataSource.getConnectProperties());
        String username = dataSource.getUsername();
        String password = dataSource.getPassword();
        String url = dataSource.getUrl();
        Connection conn = null;
        if (info.getProperty("user") == null && username != null) {
            info.setProperty("user", username);
        }
        if (info.getProperty("password") == null && password != null) {
            info.setProperty("password", password);
        }
        try {
            LOG.debug("Validating " + name + " every " + this.sleepSeconds + " seconds.");
            conn = driver.connect(url, info);
            dataSource.validateConnection(conn);
        }
        catch (SQLException e) {
            try {
                LOG.warn("Validation FAILED for " + name + " with url [" + url + "] and username [" + info.getProperty("user") + "]. Exception: " + e.getMessage());
                result = false;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(conn);
                throw throwable;
            }
            JdbcUtils.close(conn);
        }
        JdbcUtils.close(conn);
        return result;
    }

    public void setSleepSeconds(int sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
    }

    public void setBlacklistThreshold(int blacklistThreshold) {
        this.blacklistThreshold = blacklistThreshold;
    }
}

