/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleSQLObject;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLSelect
extends SQLObjectImpl {
    protected SQLWithSubqueryClause withSubQuery;
    protected SQLSelectQuery query;
    protected SQLOrderBy orderBy;
    protected SQLLimit limit;
    protected List<SQLHint> hints;
    protected SQLObject restriction;
    protected boolean forBrowse;
    protected List<String> forXmlOptions = null;
    protected SQLExpr xmlPath;
    protected SQLExpr rowCount;
    protected SQLExpr offset;

    public SQLSelect() {
    }

    public List<SQLHint> getHints() {
        if (this.hints == null) {
            this.hints = new ArrayList<SQLHint>(2);
        }
        return this.hints;
    }

    public int getHintsSize() {
        if (this.hints == null) {
            return 0;
        }
        return this.hints.size();
    }

    public SQLSelect(SQLSelectQuery query) {
        this.setQuery(query);
    }

    public SQLWithSubqueryClause getWithSubQuery() {
        return this.withSubQuery;
    }

    public void setWithSubQuery(SQLWithSubqueryClause withSubQuery) {
        this.withSubQuery = withSubQuery;
    }

    public SQLSelectQuery getQuery() {
        return this.query;
    }

    public void setQuery(SQLSelectQuery query) {
        if (query != null) {
            query.setParent(this);
        }
        this.query = query;
    }

    public SQLSelectQueryBlock getQueryBlock() {
        if (this.query instanceof SQLSelectQueryBlock) {
            return (SQLSelectQueryBlock)this.query;
        }
        return null;
    }

    public SQLOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(SQLOrderBy orderBy) {
        if (orderBy != null) {
            orderBy.setParent(this);
        }
        this.orderBy = orderBy;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.withSubQuery);
            this.acceptChild(visitor, this.query);
            this.acceptChild(visitor, this.restriction);
            this.acceptChild(visitor, this.orderBy);
            this.acceptChild(visitor, this.hints);
            this.acceptChild(visitor, this.offset);
            this.acceptChild(visitor, this.rowCount);
        }
        visitor.endVisit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLSelect sqlSelect = (SQLSelect)o;
        if (this.forBrowse != sqlSelect.forBrowse) {
            return false;
        }
        if (this.withSubQuery != null ? !this.withSubQuery.equals(sqlSelect.withSubQuery) : sqlSelect.withSubQuery != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(sqlSelect.query) : sqlSelect.query != null) {
            return false;
        }
        if (this.orderBy != null ? !this.orderBy.equals(sqlSelect.orderBy) : sqlSelect.orderBy != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(sqlSelect.limit) : sqlSelect.limit != null) {
            return false;
        }
        if (this.hints != null ? !this.hints.equals(sqlSelect.hints) : sqlSelect.hints != null) {
            return false;
        }
        if (this.restriction != null ? !this.restriction.equals(sqlSelect.restriction) : sqlSelect.restriction != null) {
            return false;
        }
        if (this.forXmlOptions != null ? !this.forXmlOptions.equals(sqlSelect.forXmlOptions) : sqlSelect.forXmlOptions != null) {
            return false;
        }
        if (this.xmlPath != null ? !this.xmlPath.equals(sqlSelect.xmlPath) : sqlSelect.xmlPath != null) {
            return false;
        }
        if (this.rowCount != null ? !this.rowCount.equals(sqlSelect.rowCount) : sqlSelect.rowCount != null) {
            return false;
        }
        return this.offset != null ? this.offset.equals(sqlSelect.offset) : sqlSelect.offset == null;
    }

    public int hashCode() {
        int result = this.withSubQuery != null ? this.withSubQuery.hashCode() : 0;
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.hints != null ? this.hints.hashCode() : 0);
        result = 31 * result + (this.restriction != null ? this.restriction.hashCode() : 0);
        result = 31 * result + (this.forBrowse ? 1 : 0);
        result = 31 * result + (this.forXmlOptions != null ? this.forXmlOptions.hashCode() : 0);
        result = 31 * result + (this.xmlPath != null ? this.xmlPath.hashCode() : 0);
        result = 31 * result + (this.rowCount != null ? this.rowCount.hashCode() : 0);
        result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
        return result;
    }

    @Override
    public void output(StringBuffer buf) {
        String dbType = null;
        SQLObject parent = this.getParent();
        if (parent instanceof SQLStatement) {
            dbType = ((SQLStatement)parent).getDbType();
        }
        if (dbType == null && parent instanceof OracleSQLObject) {
            dbType = "oracle";
        }
        if (dbType == null && this.query instanceof SQLSelectQueryBlock) {
            dbType = ((SQLSelectQueryBlock)this.query).dbType;
        }
        SQLASTOutputVisitor visitor = SQLUtils.createOutputVisitor(buf, dbType);
        this.accept(visitor);
    }

    @Override
    public String toString() {
        String dbType;
        SQLObject parent = this.getParent();
        if (parent instanceof SQLStatement && (dbType = ((SQLStatement)parent).getDbType()) != null) {
            return SQLUtils.toSQLString(this, dbType);
        }
        if (parent instanceof OracleSQLObject) {
            return SQLUtils.toSQLString(this, "oracle");
        }
        if (this.query instanceof SQLSelectQueryBlock && (dbType = ((SQLSelectQueryBlock)this.query).dbType) != null) {
            return SQLUtils.toSQLString(this, dbType);
        }
        return super.toString();
    }

    @Override
    public SQLSelect clone() {
        SQLSelect x = new SQLSelect();
        x.withSubQuery = this.withSubQuery;
        if (this.query != null) {
            x.setQuery(this.query.clone());
        }
        if (this.orderBy != null) {
            x.setOrderBy(this.orderBy.clone());
        }
        if (this.restriction != null) {
            x.setRestriction(this.restriction.clone());
        }
        if (this.hints != null) {
            for (SQLHint hint : this.hints) {
                x.hints.add(hint);
            }
        }
        x.forBrowse = this.forBrowse;
        if (this.forXmlOptions != null) {
            x.forXmlOptions = new ArrayList<String>(this.forXmlOptions);
        }
        if (this.xmlPath != null) {
            x.setXmlPath(this.xmlPath.clone());
        }
        if (this.rowCount != null) {
            x.setRowCount(this.rowCount.clone());
        }
        if (this.offset != null) {
            x.setOffset(this.offset.clone());
        }
        return x;
    }

    public boolean isSimple() {
        return !(this.withSubQuery != null || this.hints != null && this.hints.size() != 0 || this.restriction != null || this.forBrowse || this.forXmlOptions != null && this.forXmlOptions.size() != 0 || this.xmlPath != null || this.rowCount != null || this.offset != null);
    }

    public SQLObject getRestriction() {
        return this.restriction;
    }

    public void setRestriction(SQLObject restriction) {
        if (restriction != null) {
            restriction.setParent(this);
        }
        this.restriction = restriction;
    }

    public boolean isForBrowse() {
        return this.forBrowse;
    }

    public void setForBrowse(boolean forBrowse) {
        this.forBrowse = forBrowse;
    }

    public List<String> getForXmlOptions() {
        if (this.forXmlOptions == null) {
            this.forXmlOptions = new ArrayList<String>(4);
        }
        return this.forXmlOptions;
    }

    public int getForXmlOptionsSize() {
        if (this.forXmlOptions == null) {
            return 0;
        }
        return this.forXmlOptions.size();
    }

    public SQLExpr getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(SQLExpr rowCount) {
        if (rowCount != null) {
            rowCount.setParent(this);
        }
        this.rowCount = rowCount;
    }

    public SQLExpr getOffset() {
        return this.offset;
    }

    public void setOffset(SQLExpr offset) {
        if (offset != null) {
            offset.setParent(this);
        }
        this.offset = offset;
    }

    public SQLExpr getXmlPath() {
        return this.xmlPath;
    }

    public void setXmlPath(SQLExpr xmlPath) {
        if (xmlPath != null) {
            xmlPath.setParent(this);
        }
        this.xmlPath = xmlPath;
    }

    public SQLSelectQueryBlock getFirstQueryBlock() {
        if (this.query instanceof SQLSelectQueryBlock) {
            return (SQLSelectQueryBlock)this.query;
        }
        if (this.query instanceof SQLUnionQuery) {
            return ((SQLUnionQuery)this.query).getFirstQueryBlock();
        }
        return null;
    }

    public boolean addWhere(SQLExpr where) {
        if (where == null) {
            return false;
        }
        if (this.query instanceof SQLSelectQueryBlock) {
            ((SQLSelectQueryBlock)this.query).addWhere(where);
            return true;
        }
        if (this.query instanceof SQLUnionQuery) {
            SQLSelectQueryBlock queryBlock = new SQLSelectQueryBlock();
            queryBlock.setFrom(new SQLSelect(this.query), "u");
            queryBlock.addSelectItem(new SQLAllColumnExpr());
            queryBlock.setParent(queryBlock);
            this.query = queryBlock;
            return true;
        }
        return false;
    }

    public SQLLimit getLimit() {
        return this.limit;
    }

    public void setLimit(SQLLimit x) {
        if (x != null) {
            x.setParent(this);
        }
        this.limit = x;
    }
}

