/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsertStatement;
import com.alibaba.druid.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.druid.sql.dialect.hive.visitor.HiveASTVisitor;
import com.alibaba.druid.sql.repository.SchemaResolveVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;

public class HiveSchemaStatVisitor
extends SchemaStatVisitor
implements HiveASTVisitor {
    public HiveSchemaStatVisitor() {
        super("hive");
    }

    @Override
    public boolean visit(HiveCreateTableStatement x) {
        return super.visit(x);
    }

    @Override
    public void endVisit(HiveCreateTableStatement x) {
    }

    @Override
    public boolean visit(HiveInsert x) {
        this.setMode(x, TableStat.Mode.Insert);
        SQLExprTableSource tableSource = x.getTableSource();
        SQLExpr tableName = tableSource.getExpr();
        if (tableName instanceof SQLName) {
            TableStat stat = this.getTableStat((SQLName)tableName);
            stat.incrementInsertCount();
        }
        for (SQLAssignItem partition : x.getPartitions()) {
            partition.accept(this);
        }
        this.accept(x.getQuery());
        return false;
    }

    @Override
    public void endVisit(HiveInsert x) {
    }

    @Override
    public void endVisit(HiveMultiInsertStatement x) {
    }

    @Override
    public boolean visit(HiveMultiInsertStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        return true;
    }

    @Override
    public void endVisit(HiveInsertStatement x) {
    }

    @Override
    public boolean visit(HiveInsertStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.setMode(x, TableStat.Mode.Insert);
        SQLExprTableSource tableSource = x.getTableSource();
        SQLExpr tableName = tableSource.getExpr();
        if (tableName instanceof SQLName) {
            TableStat stat = this.getTableStat((SQLName)tableName);
            stat.incrementInsertCount();
        }
        for (SQLAssignItem partition : x.getPartitions()) {
            partition.accept(this);
        }
        this.accept(x.getQuery());
        return false;
    }
}

