/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.parser;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.druid.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.druid.sql.dialect.hive.parser.HiveCreateTableParser;
import com.alibaba.druid.sql.dialect.hive.parser.HiveExprParser;
import com.alibaba.druid.sql.dialect.hive.parser.HiveSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;

public class HiveStatementParser
extends SQLStatementParser {
    public HiveStatementParser(String sql) {
        super(new HiveExprParser(sql));
    }

    public HiveStatementParser(String sql, SQLParserFeature ... features) {
        super(new HiveExprParser(sql, features));
    }

    public HiveStatementParser(Lexer lexer) {
        super(new HiveExprParser(lexer));
    }

    @Override
    public HiveSelectParser createSQLSelectParser() {
        return new HiveSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLStatement parseMerge() {
        this.accept(Token.MERGE);
        this.accept(Token.INTO);
        SQLReplaceStatement stmt = new SQLReplaceStatement();
        stmt.setDbType("hive");
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.exprParser.exprList(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES || this.lexer.identifierEquals("VALUE")) {
            this.lexer.nextToken();
            this.parseValueClause(stmt.getValuesList(), 0, stmt);
        } else if (this.lexer.token() == Token.SELECT) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr);
        } else if (this.lexer.token() == Token.LPAREN) {
            SQLSelect select = this.createSQLSelectParser().select();
            SQLQueryExpr queryExpr = new SQLQueryExpr(select);
            stmt.setQuery(queryExpr);
        }
        return stmt;
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new HiveCreateTableParser(this.exprParser);
    }

    @Override
    public SQLStatement parseInsert() {
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            HiveMultiInsertStatement stmt = new HiveMultiInsertStatement();
            if (this.lexer.token() == Token.IDENTIFIER) {
                SQLName tableName = this.exprParser.name();
                SQLExprTableSource from = new SQLExprTableSource(tableName);
                stmt.setFrom(from);
                if (this.lexer.token() == Token.IDENTIFIER) {
                    from.setAlias(this.lexer.stringVal());
                    this.lexer.nextToken();
                }
            } else {
                this.accept(Token.LPAREN);
                HiveSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect select = selectParser.select();
                this.accept(Token.RPAREN);
                String alias = this.lexer.stringVal();
                this.accept(Token.IDENTIFIER);
                SQLSubqueryTableSource from = new SQLSubqueryTableSource(select, alias);
                stmt.setFrom(from);
            }
            do {
                HiveInsert insert = this.parseHiveInsert();
                stmt.addItem(insert);
            } while (this.lexer.token() == Token.INSERT);
            return stmt;
        }
        return this.parseHiveInsertStmt();
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.FROM) {
            SQLStatement stmt = this.parseInsert();
            statementList.add(stmt);
            return true;
        }
        return false;
    }
}

