/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.SQLTableDataType;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLDecimalExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterMaterializedViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddClusteringKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAlterColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableArchivePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableChangeOwner;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDeleteByCondition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropSubpartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableKeys;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableExchangePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableMergePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTablePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTablePartitionSetProperties;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRecoverPartitions;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenameColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenamePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableReplaceColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetComment;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetLifecycle;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetLocation;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSetOption;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableSubpartitionAvailablePartitionNum;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableTouch;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableUnarchivePartition;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewRenameStatement;
import com.alibaba.druid.sql.ast.statement.SQLAnalyzeTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLCloseStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLCommitStatement;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateMaterializedViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateRoleStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableGroupStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDescribeStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropCatalogStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropDatabaseStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropEventStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropLogFileGroupStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropMaterializedViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropOutlineStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropResourceGroupStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropResourceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropRoleStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropServerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableGroupStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableSpaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDumpStatement;
import com.alibaba.druid.sql.ast.statement.SQLErrorLoggingClause;
import com.alibaba.druid.sql.ast.statement.SQLExplainStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLFetchStatement;
import com.alibaba.druid.sql.ast.statement.SQLForStatement;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyConstraint;
import com.alibaba.druid.sql.ast.statement.SQLGrantStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLObjectType;
import com.alibaba.druid.sql.ast.statement.SQLOpenStatement;
import com.alibaba.druid.sql.ast.statement.SQLOptimizeStatement;
import com.alibaba.druid.sql.ast.statement.SQLPartitionRef;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLPrivilegeItem;
import com.alibaba.druid.sql.ast.statement.SQLPurgeLogsStatement;
import com.alibaba.druid.sql.ast.statement.SQLPurgeRecyclebinStatement;
import com.alibaba.druid.sql.ast.statement.SQLPurgeTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLPurgeTemporaryOutputStatement;
import com.alibaba.druid.sql.ast.statement.SQLRefreshMaterializedViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLReleaseSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLReturnStatement;
import com.alibaba.druid.sql.ast.statement.SQLRevokeStatement;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSavePointStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowColumnsStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowDatabasesStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowMaterializedViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTableGroupsStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowVariantsStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.druid.sql.ast.statement.SQLWhoamiStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsertStatement;
import com.alibaba.druid.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveCreateFunctionStatement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveMsckRepairStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.FullTextType;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateExternalCatalogStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExplainPlanCacheStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHintStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlManageInstanceGroupStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdatePlanCacheStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MysqlDropFullTextStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.SQLAlterResourceGroupStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.SQLCreateResourceGroupStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.SQLListResourceGroupStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAlterTableSetChangeLogs;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsAlterTableSetFileFormat;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.parser.InsertColumnsCache;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLInsertValueHandler;
import com.alibaba.druid.sql.parser.SQLParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.MySqlUtils;
import com.alibaba.druid.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;

public class SQLStatementParser
extends SQLParser {
    protected SchemaRepository repository;
    protected SQLExprParser exprParser;
    protected boolean parseCompleteValues = true;
    protected int parseValuesSize = 3;
    protected SQLSelectListCache selectListCache;
    protected InsertColumnsCache insertColumnsCache;
    protected Timestamp now;
    protected Date currentDate;

    public SQLStatementParser(String sql) {
        this(sql, null);
    }

    public SQLStatementParser(String sql, DbType dbType) {
        this(new SQLExprParser(sql, dbType, new SQLParserFeature[0]));
    }

    public SQLStatementParser(SQLExprParser exprParser) {
        super(exprParser.getLexer(), exprParser.getDbType());
        this.exprParser = exprParser;
        this.dbType = exprParser.dbType;
    }

    protected SQLStatementParser(Lexer lexer, DbType dbType) {
        super(lexer, dbType);
    }

    public boolean isKeepComments() {
        return this.lexer.isKeepComments();
    }

    public void setKeepComments(boolean keepComments) {
        this.lexer.setKeepComments(keepComments);
    }

    public SQLExprParser getExprParser() {
        return this.exprParser;
    }

    public SchemaRepository getRepository() {
        return this.repository;
    }

    public void setRepository(SchemaRepository repository) {
        this.repository = repository;
    }

    public List<SQLStatement> parseStatementList() {
        ArrayList<SQLStatement> statementList = new ArrayList<SQLStatement>();
        this.parseStatementList(statementList, -1, null);
        return statementList;
    }

    public List<SQLStatement> parseStatementList(SQLObject parent) {
        ArrayList<SQLStatement> statementList = new ArrayList<SQLStatement>();
        this.parseStatementList(statementList, -1, parent);
        return statementList;
    }

    public void parseStatementList(List<SQLStatement> statementList) {
        this.parseStatementList(statementList, -1, null);
    }

    public void parseStatementList(List<SQLStatement> statementList, int max) {
        this.parseStatementList(statementList, max, null);
    }

    public void parseStatementList(List<SQLStatement> statementList, int max, SQLObject parent) {
        if ("select @@session.tx_read_only".equals(this.lexer.text) && this.lexer.token == Token.SELECT) {
            SQLSelect select = new SQLSelect();
            MySqlSelectQueryBlock queryBlock = new MySqlSelectQueryBlock();
            queryBlock.addSelectItem(new SQLPropertyExpr(new SQLVariantRefExpr("@@session"), "tx_read_only"));
            select.setQuery(queryBlock);
            SQLSelectStatement stmt = new SQLSelectStatement(select);
            statementList.add(stmt);
            this.lexer.reset(29, '\u001a', Token.EOF);
            return;
        }
        boolean semi = false;
        int i = 0;
        while (max == -1 || statementList.size() < max) {
            while (this.lexer.token == Token.MULTI_LINE_COMMENT || this.lexer.token == Token.LINE_COMMENT) {
                this.lexer.nextToken();
            }
            switch (this.lexer.token) {
                case EOF: 
                case END: 
                case UNTIL: 
                case ELSE: 
                case WHEN: {
                    if (this.lexer.isKeepComments() && this.lexer.hasComment() && statementList.size() > 0) {
                        SQLStatement stmt = statementList.get(statementList.size() - 1);
                        stmt.addAfterComment(this.lexer.readAndResetComments());
                    }
                    return;
                }
                case SEMI: {
                    int line0 = this.lexer.getLine();
                    char ch = this.lexer.ch;
                    this.lexer.nextToken();
                    int line1 = this.lexer.getLine();
                    if (statementList.size() > 0) {
                        SQLStatement lastStmt = statementList.get(statementList.size() - 1);
                        lastStmt.setAfterSemi(true);
                        if (this.lexer.isKeepComments()) {
                            if (ch == '\n' && this.lexer.getComments() != null && !this.lexer.getComments().isEmpty() && !(lastStmt instanceof SQLSetStatement)) {
                                this.lexer.getComments().add(0, new String("\n"));
                            }
                            if (line1 - line0 <= 1) {
                                lastStmt.addAfterComment(this.lexer.readAndResetComments());
                            }
                        }
                    }
                    semi = true;
                    break;
                }
                case WITH: {
                    SQLStatement stmt = this.parseWith();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case SELECT: {
                    MySqlHintStatement hintStatement = null;
                    if (i == 1 && statementList.size() > 0 && statementList.get(statementList.size() - i) instanceof MySqlHintStatement) {
                        hintStatement = (MySqlHintStatement)statementList.get(statementList.size() - i);
                    } else if (i > 0 && this.dbType != DbType.odps && !semi) {
                        throw new ParserException("syntax error. " + this.lexer.info());
                    }
                    SQLStatement stmt = this.parseSelect();
                    stmt.setParent(parent);
                    if (hintStatement != null && stmt instanceof SQLStatementImpl) {
                        SQLStatementImpl stmtImpl = (SQLStatementImpl)stmt;
                        List<SQLCommentHint> hints = stmtImpl.getHeadHintsDirect();
                        if (hints == null) {
                            stmtImpl.setHeadHints(hintStatement.getHints());
                        } else {
                            hints.addAll(hintStatement.getHints());
                        }
                        statementList.set(statementList.size() - 1, stmt);
                    } else {
                        statementList.add(stmt);
                    }
                    semi = false;
                    break;
                }
                case UPDATE: {
                    Lexer.SavePoint savePoint = this.lexer.mark();
                    this.lexer.nextToken();
                    if (this.dbType == DbType.mysql && this.lexer.identifierEquals("PLANCACHE")) {
                        this.lexer.nextToken();
                        if (this.lexer.token == Token.SELECT) {
                            MySqlUpdatePlanCacheStatement stmt = new MySqlUpdatePlanCacheStatement();
                            SQLSelect fromSelect = this.createSQLSelectParser().select();
                            this.accept(Token.TO);
                            SQLSelect toSelect = this.createSQLSelectParser().select();
                            stmt.setFormSelect(fromSelect);
                            stmt.setToSelect(toSelect);
                            statementList.add(stmt);
                            break;
                        }
                    }
                    this.lexer.reset(savePoint);
                    SQLUpdateStatement stmt = this.parseUpdateStatement();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case CREATE: {
                    SQLStatement stmt = this.parseCreate();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case INSERT: {
                    SQLStatement stmt = this.parseInsert();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case DELETE: {
                    SQLDeleteStatement stmt = this.parseDeleteStatement();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case EXPLAIN: {
                    SQLStatementImpl stmt;
                    this.lexer.computeRowAndColumn();
                    int sourceLine = this.lexer.posLine;
                    int sourceColumn = this.lexer.posColumn;
                    Lexer.SavePoint savePoint = this.lexer.mark();
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals("PLANCACHE")) {
                        this.lexer.nextToken();
                        stmt = new MySqlExplainPlanCacheStatement();
                        stmt.setSourceLine(sourceLine);
                        stmt.setSourceLine(sourceColumn);
                        statementList.add(stmt);
                        break;
                    }
                    this.lexer.reset(savePoint);
                    stmt = this.parseExplain();
                    stmt.setSourceLine(sourceLine);
                    stmt.setSourceLine(sourceColumn);
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case SET: {
                    SQLStatement stmt = this.parseSet();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case ALTER: {
                    SQLStatement stmt = this.parseAlter();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case TRUNCATE: {
                    SQLStatement stmt = this.parseTruncate();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case USE: {
                    SQLUseStatement stmt = this.parseUse();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case GRANT: {
                    SQLGrantStatement stmt = this.parseGrant();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case REVOKE: {
                    SQLRevokeStatement stmt = this.parseRevoke();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case SHOW: {
                    SQLStatement stmt = this.parseShow();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case MERGE: {
                    SQLStatement stmt = this.parseMerge();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case REPEAT: {
                    SQLStatement stmt = this.parseRepeat();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case DECLARE: {
                    SQLStatement stmt = this.parseDeclare();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case WHILE: {
                    SQLStatement stmt = this.parseWhile();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case IF: {
                    SQLStatement stmt = this.parseIf();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case CASE: {
                    SQLStatement stmt = this.parseCase();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case OPEN: {
                    SQLOpenStatement stmt = this.parseOpen();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case FETCH: {
                    SQLFetchStatement stmt = this.parseFetch();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case DROP: {
                    SQLStatement stmt = this.parseDrop();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case COMMENT: {
                    SQLCommentStatement stmt = this.parseComment();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case KILL: {
                    SQLStatement stmt = this.parseKill();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case CLOSE: {
                    SQLStatement stmt = this.parseClose();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case RETURN: {
                    SQLStatement stmt = this.parseReturn();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case UPSERT: {
                    SQLStatement stmt = this.parseUpsert();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                case LEAVE: {
                    SQLStatement stmt = this.parseLeave();
                    stmt.setParent(parent);
                    statementList.add(stmt);
                    break;
                }
                default: {
                    if (this.lexer.token == Token.LBRACE || this.lexer.identifierEquals("CALL")) {
                        SQLCallStatement stmt = this.parseCall();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.identifierEquals("UPSERT")) {
                        SQLStatement stmt = this.parseUpsert();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.identifierEquals("LIST")) {
                        Lexer.SavePoint mark = this.lexer.mark();
                        SQLStatement stmt = this.parseList();
                        if (stmt != null) {
                            statementList.add(stmt);
                            break;
                        }
                        this.lexer.reset(mark);
                    }
                    if (this.lexer.identifierEquals("RENAME")) {
                        SQLStatement stmt = this.parseRename();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.identifierEquals("RELEASE")) {
                        SQLStatement stmt = this.parseReleaseSavePoint();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.identifierEquals("SAVEPOINT")) {
                        SQLStatement stmt = this.parseSavePoint();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.identifierEquals("REFRESH")) {
                        SQLStatement stmt = this.parseRefresh();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.identifierEquals("SETPROJECT")) {
                        SQLStatement stmt = this.parseSet();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.COPY)) {
                        SQLStatement stmt = this.parseCopy();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.token == Token.DESC || this.lexer.identifierEquals(FnvHash.Constants.DESCRIBE)) {
                        SQLStatement stmt = this.parseDescribe();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.identifierEquals("ROLLBACK")) {
                        SQLStatement stmt = this.parseRollback();
                        statementList.add(stmt);
                        if (!(parent instanceof SQLBlockStatement) || DbType.mysql != this.dbType) break;
                        return;
                    }
                    if (this.lexer.identifierEquals("DUMP")) {
                        SQLStatement stmt = this.parseDump();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.COMMIT)) {
                        SQLStatement stmt = this.parseCommit();
                        statementList.add(stmt);
                        if (!(parent instanceof SQLBlockStatement) || DbType.mysql != this.dbType) break;
                        return;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.RETURN)) {
                        SQLStatement stmt = this.parseReturn();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.PURGE)) {
                        SQLStatement stmt = this.parsePurge();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.FLASHBACK)) {
                        SQLStatement stmt = this.parseFlashback();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.WHO)) {
                        SQLStatement stmt = this.parseWhoami();
                        statementList.add(stmt);
                        break;
                    }
                    if (this.lexer.token == Token.FOR) {
                        SQLStatement stmt = this.parseFor();
                        statementList.add(stmt);
                        stmt.setParent(parent);
                        break;
                    }
                    if (this.lexer.token == Token.LPAREN) {
                        Lexer.SavePoint savePoint = this.lexer.markOut();
                        int parenCount = 0;
                        do {
                            this.lexer.nextToken();
                            ++parenCount;
                        } while (this.lexer.token == Token.LPAREN);
                        if (this.lexer.token == Token.RPAREN && parenCount == 1 && this.dbType == DbType.odps) {
                            this.lexer.nextToken();
                            break;
                        }
                        if (this.lexer.token == Token.SELECT) {
                            this.lexer.reset(savePoint);
                            SQLStatement stmt = this.parseSelect();
                            statementList.add(stmt);
                            break;
                        }
                        throw new ParserException("TODO " + this.lexer.info());
                    }
                    if (this.lexer.token == Token.VALUES) {
                        SQLValuesTableSource values = this.createSQLSelectParser().parseValues();
                        SQLSelectStatement stmt = new SQLSelectStatement();
                        stmt.setSelect(new SQLSelect(values));
                        statementList.add(stmt);
                        stmt.setParent(parent);
                        break;
                    }
                    if (this.lexer.identifierEquals("OPTIMIZE")) {
                        SQLStatement stmt = this.parseOptimize();
                        statementList.add(stmt);
                        stmt.setParent(parent);
                        break;
                    }
                    int size = statementList.size();
                    if (this.parseStatementListDialect(statementList)) {
                        if (parent == null) break;
                        for (int j = size; j < statementList.size(); ++j) {
                            SQLStatement dialectStmt = statementList.get(j);
                            dialectStmt.setParent(parent);
                        }
                        break;
                    }
                    throw new ParserException("not supported." + this.lexer.info());
                }
            }
            ++i;
        }
        return;
    }

    public SQLStatement parseOptimize() {
        this.acceptIdentifier("OPTIMIZE");
        this.accept(Token.TABLE);
        SQLOptimizeStatement stmt = new SQLOptimizeStatement();
        ArrayList<SQLName> names = new ArrayList<SQLName>();
        this.exprParser.names(names, stmt);
        for (SQLName name : names) {
            stmt.addTableSource(new SQLExprTableSource(name));
        }
        if (this.lexer.token == Token.ON) {
            this.lexer.nextToken();
            this.acceptIdentifier("CLUSTER");
            SQLName cluster = this.exprParser.name();
            stmt.setCluster(cluster);
        }
        if (this.lexer.identifierEquals("FINAL")) {
            this.lexer.nextToken();
            stmt.setFinal(true);
        }
        if (this.lexer.identifierEquals("DEDUPLICATE")) {
            this.lexer.nextToken();
            stmt.setDeduplicate(true);
            if (this.lexer.token == Token.BY) {
                this.lexer.nextToken();
                stmt.setDeduplicateBy(this.exprParser.expr());
            }
        }
        return stmt;
    }

    public SQLStatement parseCopy() {
        throw new ParserException("TODO : " + this.lexer.info());
    }

    public SQLStatement parseFor() {
        this.accept(Token.FOR);
        SQLForStatement stmt = new SQLForStatement();
        stmt.setDbType(this.dbType);
        stmt.setIndex(this.exprParser.name());
        this.accept(Token.IN);
        stmt.setRange(this.exprParser.expr());
        this.accept(Token.LOOP);
        this.parseStatementList(stmt.getStatements(), -1, stmt);
        this.accept(Token.END);
        this.accept(Token.LOOP);
        this.accept(Token.SEMI);
        stmt.setAfterSemi(true);
        return stmt;
    }

    public SQLStatement parseFlashback() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseDump() {
        SQLDumpStatement stmt = new SQLDumpStatement();
        this.acceptIdentifier("DUMP");
        this.acceptIdentifier("DATA");
        if (this.lexer.identifierEquals(FnvHash.Constants.OVERWRITE)) {
            this.lexer.nextToken();
            stmt.setOverwrite(true);
        }
        if (this.lexer.token == Token.INTO) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.LITERAL_CHARS) {
                stmt.setInto(new SQLCharExpr(this.lexer.stringVal));
                this.lexer.nextToken();
            } else {
                stmt.setInto(this.exprParser.expr());
            }
        }
        SQLSelect select = this.createSQLSelectParser().select();
        stmt.setSelect(select);
        return stmt;
    }

    public SQLStatement parseDrop() {
        SQLStatement stmt;
        List<String> beforeComments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            beforeComments = this.lexer.readAndResetComments();
        }
        Lexer.SavePoint mark = this.lexer.mark();
        this.lexer.nextToken();
        List<SQLCommentHint> hints = null;
        if (this.lexer.token == Token.HINT) {
            hints = this.exprParser.parseHints();
        }
        boolean temporary = false;
        if (this.lexer.token == Token.TEMPORARY || this.lexer.identifierEquals(FnvHash.Constants.TEMPORARY)) {
            this.lexer.nextToken();
            temporary = true;
        }
        boolean physical = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.PHYSICAL)) {
            this.lexer.nextToken();
            physical = true;
        }
        switch (this.lexer.token) {
            case USER: {
                stmt = this.parseDropUser();
                break;
            }
            case INDEX: {
                stmt = this.parseDropIndex();
                break;
            }
            case VIEW: {
                stmt = this.parseDropView(false);
                break;
            }
            case TRIGGER: {
                stmt = this.parseDropTrigger(false);
                break;
            }
            case DATABASE: {
                stmt = this.parseDropDatabaseOrSchema(false);
                if (!physical) break;
                ((SQLDropDatabaseStatement)stmt).setPhysical(physical);
                break;
            }
            case SCHEMA: {
                if (this.dbType == DbType.postgresql) {
                    stmt = this.parseDropSchema();
                    break;
                }
                stmt = this.parseDropDatabaseOrSchema(false);
                if (!physical) break;
                ((SQLDropDatabaseStatement)stmt).setPhysical(physical);
                break;
            }
            case FUNCTION: {
                SQLDropFunctionStatement dropFunc = this.parseDropFunction(false);
                if (temporary) {
                    dropFunc.setTemporary(true);
                }
                stmt = dropFunc;
                break;
            }
            case TABLESPACE: {
                stmt = this.parseDropTablespace(false);
                break;
            }
            case PROCEDURE: {
                stmt = this.parseDropProcedure(false);
                break;
            }
            case SEQUENCE: {
                stmt = this.parseDropSequence(false);
                break;
            }
            case TABLE: {
                SQLDropTableStatement dropTable = this.parseDropTable(false);
                if (temporary) {
                    dropTable.setTemporary(true);
                }
                if (hints != null) {
                    dropTable.setHints(hints);
                }
                stmt = dropTable;
                break;
            }
            default: {
                if (this.lexer.token == Token.TABLE || this.lexer.identifierEquals("TEMPORARY") || this.lexer.identifierEquals(FnvHash.Constants.PARTITIONED)) {
                    SQLDropTableStatement dropTable = this.parseDropTable(false);
                    if (hints != null) {
                        dropTable.setHints(hints);
                    }
                    stmt = dropTable;
                    break;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.TABLES)) {
                    stmt = this.parseDropTable(false);
                    break;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.EVENT)) {
                    stmt = this.parseDropEvent();
                    break;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.RESOURCE)) {
                    stmt = this.parseDropResource();
                    break;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.LOGFILE)) {
                    stmt = this.parseDropLogFileGroup();
                    break;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.SERVER)) {
                    stmt = this.parseDropServer();
                    break;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.TABLEGROUP)) {
                    stmt = this.parseDropTableGroup();
                    break;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.ROLE)) {
                    this.lexer.reset(mark);
                    stmt = this.parseDropRole();
                    break;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.OUTLINE)) {
                    this.lexer.reset(mark);
                    stmt = this.parseDropOutline();
                    break;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.TABLE) {
                        this.lexer.reset(mark);
                        stmt = this.parseDropTable(true);
                        break;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.CATALOG)) {
                        this.lexer.reset(mark);
                        stmt = this.parseDropCatalog();
                        break;
                    }
                    throw new ParserException("TODO " + this.lexer.info());
                }
                if (this.lexer.token() == Token.FULLTEXT) {
                    this.lexer.nextToken();
                    FullTextType type = this.parseFullTextType();
                    SQLName name = this.exprParser.name();
                    MysqlDropFullTextStatement x = new MysqlDropFullTextStatement();
                    x.setName(name);
                    x.setType(type);
                    stmt = x;
                    break;
                }
                if (this.lexer.identifierEquals("INSTANCE_GROUP")) {
                    this.lexer.nextToken();
                    MySqlManageInstanceGroupStatement x = new MySqlManageInstanceGroupStatement();
                    x.setOperation(new SQLIdentifierExpr("DROP"));
                    while (true) {
                        x.getGroupNames().add(this.exprParser.expr());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    stmt = x;
                    break;
                }
                if (this.lexer.identifierEquals("MATERIALIZED")) {
                    stmt = this.parseDropMaterializedView();
                    break;
                }
                throw new ParserException("TODO " + this.lexer.info());
            }
        }
        if (beforeComments != null) {
            stmt.addBeforeComment(beforeComments);
        }
        return stmt;
    }

    protected FullTextType parseFullTextType() {
        FullTextType textType;
        if (this.lexer.identifierEquals(FnvHash.Constants.CHARFILTER)) {
            textType = FullTextType.CHARFILTER;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.TOKENIZER)) {
            textType = FullTextType.TOKENIZER;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.TOKENFILTER)) {
            textType = FullTextType.TOKENFILTER;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.ANALYZER)) {
            textType = FullTextType.ANALYZER;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.DICTIONARY)) {
            textType = FullTextType.DICTIONARY;
        } else {
            throw new ParserException("type of full text must be [CHARFILTER/TOKENIZER/TOKENFILTER/ANALYZER/DICTIONARY] .");
        }
        this.lexer.nextToken();
        return textType;
    }

    protected SQLStatement parseWhoami() {
        this.lexer.nextToken();
        this.acceptIdentifier("AM");
        this.acceptIdentifier("I");
        return new SQLWhoamiStatement();
    }

    protected SQLStatement parseDropOutline() {
        this.accept(Token.DROP);
        SQLDropOutlineStatement stmt = new SQLDropOutlineStatement();
        stmt.setDbType(this.dbType);
        this.acceptIdentifier("OUTLINE");
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    public SQLStatement parseRefresh() {
        if (this.lexer.identifierEquals("REFRESH")) {
            this.lexer.nextToken();
        }
        SQLRefreshMaterializedViewStatement stmt = new SQLRefreshMaterializedViewStatement();
        stmt.setDbType(this.dbType);
        this.acceptIdentifier("MATERIALIZED");
        this.accept(Token.VIEW);
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    public SQLStatement parseShowMaterializedView() {
        if (this.lexer.token() == Token.SHOW) {
            this.lexer.nextToken();
        }
        SQLShowMaterializedViewStatement stmt = new SQLShowMaterializedViewStatement();
        stmt.setDbType(this.dbType);
        this.acceptIdentifier("MATERIALIZED");
        this.acceptIdentifier("VIEWS");
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            stmt.setLike(this.exprParser.charExpr());
        }
        return stmt;
    }

    public SQLStatement parseDropMaterializedView() {
        if (this.lexer.token() == Token.DROP) {
            this.lexer.nextToken();
        }
        SQLDropMaterializedViewStatement stmt = new SQLDropMaterializedViewStatement();
        stmt.setDbType(this.dbType);
        this.acceptIdentifier("MATERIALIZED");
        this.accept(Token.VIEW);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    protected SQLStatement parseDropCatalog() {
        this.accept(Token.DROP);
        SQLDropCatalogStatement stmt = new SQLDropCatalogStatement(this.dbType);
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            stmt.setExternal(true);
            this.lexer.nextToken();
        }
        this.acceptIdentifier("CATALOG");
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    protected SQLStatement parseDropRole() {
        this.accept(Token.DROP);
        this.acceptIdentifier("ROLE");
        SQLDropRoleStatement stmt = new SQLDropRoleStatement();
        stmt.setDbType(this.dbType);
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    protected SQLStatement parseDropTableGroup() {
        if (this.lexer.token == Token.DROP) {
            this.lexer.nextToken();
        }
        this.acceptIdentifier("TABLEGROUP");
        SQLDropTableGroupStatement stmt = new SQLDropTableGroupStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    protected SQLStatement parseDropServer() {
        if (this.lexer.token == Token.DROP) {
            this.lexer.nextToken();
        }
        this.acceptIdentifier("SERVER");
        SQLDropServerStatement stmt = new SQLDropServerStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    protected SQLStatement parseDropLogFileGroup() {
        if (this.lexer.token == Token.DROP) {
            this.lexer.nextToken();
        }
        this.acceptIdentifier("LOGFILE");
        this.accept(Token.GROUP);
        SQLDropLogFileGroupStatement stmt = new SQLDropLogFileGroupStatement();
        stmt.setDbType(this.dbType);
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE)) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr engine = this.exprParser.primary();
            stmt.setEngine(engine);
        }
        return stmt;
    }

    protected SQLStatement parseDropEvent() {
        if (this.lexer.token == Token.DROP) {
            this.lexer.nextToken();
        }
        this.acceptIdentifier("EVENT");
        SQLDropEventStatement stmt = new SQLDropEventStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    protected SQLStatement parseDropResource() {
        if (this.lexer.token == Token.DROP) {
            this.lexer.nextToken();
        }
        this.acceptIdentifier("RESOURCE");
        if (this.lexer.token == Token.GROUP) {
            this.lexer.nextToken();
            SQLDropResourceGroupStatement stmt = new SQLDropResourceGroupStatement();
            stmt.setDbType(this.dbType);
            if (this.lexer.token == Token.IF) {
                this.lexer.nextToken();
                this.accept(Token.EXISTS);
                stmt.setIfExists(true);
            }
            SQLName name = this.exprParser.name();
            stmt.setName(name);
            return stmt;
        }
        SQLDropResourceStatement stmt = new SQLDropResourceStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    protected SQLStatement parseAlterFunction() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    public SQLStatement parseKill() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseCase() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseIf() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseWhile() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseDeclare() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseRepeat() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parseLeave() {
        throw new ParserException("not supported. " + this.lexer.info());
    }

    public SQLStatement parsePurge() {
        this.acceptIdentifier("PURGE");
        if (this.lexer.token == Token.TABLE) {
            this.lexer.nextToken();
            SQLName tableName = this.exprParser.name();
            SQLPurgeTableStatement stmt = new SQLPurgeTableStatement();
            stmt.setTable(tableName);
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RECYCLEBIN)) {
            this.lexer.nextToken();
            SQLPurgeRecyclebinStatement stmt = new SQLPurgeRecyclebinStatement();
            return stmt;
        }
        if (this.lexer.token == Token.ALL) {
            this.lexer.nextToken();
            SQLPurgeTableStatement stmt = new SQLPurgeTableStatement();
            stmt.setAll(true);
            if (this.lexer.token == Token.LITERAL_INT) {
                stmt.setCount(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
            }
            return stmt;
        }
        if (this.lexer.identifierEquals("TEMPORARY")) {
            this.lexer.nextToken();
            this.acceptIdentifier("OUTPUT");
            SQLPurgeTemporaryOutputStatement stmt = new SQLPurgeTemporaryOutputStatement();
            stmt.setName(this.exprParser.name());
            return stmt;
        }
        SQLPurgeLogsStatement stmt = new SQLPurgeLogsStatement();
        if (this.lexer.token == Token.BINARY) {
            this.lexer.nextToken();
            stmt.setBinary(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.MASTER)) {
            this.lexer.nextToken();
            stmt.setMaster(true);
        }
        if (this.lexer.token == Token.ALL) {
            this.lexer.nextToken();
            stmt.setAll(true);
            return stmt;
        }
        this.acceptIdentifier("LOGS");
        if (this.lexer.token == Token.TO) {
            this.lexer.nextToken();
            SQLExpr to = this.exprParser.expr();
            stmt.setTo(to);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.BEFORE)) {
            this.lexer.nextToken();
            SQLExpr before = this.exprParser.expr();
            stmt.setBefore(before);
        }
        return stmt;
    }

    public SQLStatement parseReturn() {
        if (this.lexer.token == Token.RETURN || this.lexer.identifierEquals("RETURN")) {
            this.lexer.nextToken();
        }
        SQLReturnStatement stmt = new SQLReturnStatement();
        if (this.lexer.token != Token.SEMI) {
            SQLExpr expr = this.exprParser.expr();
            stmt.setExpr(expr);
        }
        if (this.lexer.token == Token.SEMI) {
            this.accept(Token.SEMI);
            stmt.setAfterSemi(true);
        }
        return stmt;
    }

    public SQLStatement parseUpsert() {
        SQLInsertStatement insertStatement = new SQLInsertStatement();
        if (this.lexer.token == Token.UPSERT || this.lexer.identifierEquals("UPSERT")) {
            this.lexer.nextToken();
            insertStatement.setUpsert(true);
        }
        this.parseInsert0(insertStatement);
        return insertStatement;
    }

    public SQLStatement parseRollback() {
        this.lexer.nextToken();
        if (this.lexer.identifierEquals("WORK")) {
            this.lexer.nextToken();
        }
        SQLRollbackStatement stmt = new SQLRollbackStatement(this.getDbType());
        if (this.lexer.token == Token.TO) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("SAVEPOINT") || this.lexer.token == Token.SAVEPOINT) {
                this.lexer.nextToken();
            }
            stmt.setTo(this.exprParser.name());
        }
        return stmt;
    }

    public SQLStatement parseCommit() {
        this.acceptIdentifier("COMMIT");
        return new SQLCommitStatement();
    }

    public SQLStatement parseShow() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    public SQLUseStatement parseUse() {
        this.accept(Token.USE);
        SQLUseStatement stmt = new SQLUseStatement(this.getDbType());
        stmt.setDatabase(this.exprParser.name());
        return stmt;
    }

    protected SQLExpr parseUser() {
        SQLExpr user = this.exprParser.expr();
        return user;
    }

    public SQLGrantStatement parseGrant() {
        this.accept(Token.GRANT);
        SQLGrantStatement stmt = new SQLGrantStatement(this.getDbType());
        this.parsePrivileages(stmt.getPrivileges(), stmt);
        if (this.lexer.token == Token.ON) {
            SQLExpr expr;
            this.lexer.nextToken();
            switch (this.lexer.token) {
                case PROCEDURE: {
                    this.lexer.nextToken();
                    stmt.setResourceType(SQLObjectType.PROCEDURE);
                    break;
                }
                case FUNCTION: {
                    this.lexer.nextToken();
                    stmt.setResourceType(SQLObjectType.FUNCTION);
                    break;
                }
                case TABLE: {
                    this.lexer.nextToken();
                    stmt.setResourceType(SQLObjectType.TABLE);
                    break;
                }
                case USER: {
                    this.lexer.nextToken();
                    stmt.setResourceType(SQLObjectType.USER);
                    break;
                }
                case DATABASE: {
                    this.lexer.nextToken();
                    stmt.setResourceType(SQLObjectType.DATABASE);
                    break;
                }
                case IDENTIFIER: {
                    if (!this.lexer.identifierEquals("SYSTEM")) break;
                    this.lexer.nextToken();
                    stmt.setResourceType(SQLObjectType.SYSTEM);
                    break;
                }
            }
            if (stmt.getResourceType() != null && this.lexer.token == Token.COLONCOLON) {
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.DOT) {
                expr = new SQLAllColumnExpr();
                this.lexer.nextToken();
            } else {
                expr = this.exprParser.expr();
            }
            if (stmt.getResourceType() == SQLObjectType.TABLE || stmt.getResourceType() == null) {
                stmt.setResource(new SQLExprTableSource(expr));
            } else {
                stmt.setResource(expr);
            }
        }
        if (this.lexer.token == Token.TO) {
            this.lexer.nextToken();
            while (true) {
                SQLExpr user = this.parseUser();
                stmt.getUsers().add(user);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token == Token.WITH) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.GRANT) {
                this.lexer.nextToken();
                this.acceptIdentifier("OPTION");
                stmt.setWithGrantOption(true);
            }
            while (true) {
                if (this.lexer.identifierEquals("MAX_QUERIES_PER_HOUR")) {
                    this.lexer.nextToken();
                    stmt.setMaxQueriesPerHour(this.exprParser.primary());
                    continue;
                }
                if (this.lexer.identifierEquals("MAX_UPDATES_PER_HOUR")) {
                    this.lexer.nextToken();
                    stmt.setMaxUpdatesPerHour(this.exprParser.primary());
                    continue;
                }
                if (this.lexer.identifierEquals("MAX_CONNECTIONS_PER_HOUR")) {
                    this.lexer.nextToken();
                    stmt.setMaxConnectionsPerHour(this.exprParser.primary());
                    continue;
                }
                if (!this.lexer.identifierEquals("MAX_USER_CONNECTIONS")) break;
                this.lexer.nextToken();
                stmt.setMaxUserConnections(this.exprParser.primary());
            }
        }
        if (this.lexer.identifierEquals("ADMIN")) {
            this.lexer.nextToken();
            this.acceptIdentifier("OPTION");
            stmt.setAdminOption(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.IDENTIFIED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.identifierEquals("PASSWORD")) {
                this.lexer.nextToken();
                String password = this.lexer.stringVal();
                this.accept(Token.LITERAL_CHARS);
                stmt.setIdentifiedByPassword(password);
            } else {
                stmt.setIdentifiedBy(this.exprParser.expr());
            }
        }
        if (this.lexer.token == Token.WITH) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.GRANT) {
                this.lexer.nextToken();
                this.acceptIdentifier("OPTION");
                stmt.setWithGrantOption(true);
            }
        }
        return stmt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parsePrivileages(List<SQLPrivilegeItem> privileges, SQLObject parent) {
        while (true) {
            String privilege = null;
            if (this.lexer.token == Token.ALL) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("PRIVILEGES")) {
                    privilege = "ALL PRIVILEGES";
                    this.lexer.nextToken();
                } else {
                    privilege = "ALL";
                }
            } else if (this.lexer.token == Token.SELECT) {
                privilege = "SELECT";
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.UPDATE) {
                privilege = "UPDATE";
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.DELETE) {
                privilege = "DELETE";
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.INSERT) {
                privilege = "INSERT";
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.INDEX) {
                this.lexer.nextToken();
                privilege = "INDEX";
            } else if (this.lexer.token == Token.TRIGGER) {
                this.lexer.nextToken();
                privilege = "TRIGGER";
            } else if (this.lexer.token == Token.REFERENCES) {
                privilege = "REFERENCES";
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.DESC) {
                privilege = "DESCRIBE";
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.CREATE) {
                this.lexer.nextToken();
                if (this.lexer.token == Token.TABLE) {
                    privilege = "CREATE TABLE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.SESSION) {
                    privilege = "CREATE SESSION";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.TABLESPACE) {
                    privilege = "CREATE TABLESPACE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.USER) {
                    privilege = "CREATE USER";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.VIEW) {
                    privilege = "CREATE VIEW";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.PROCEDURE) {
                    privilege = "CREATE PROCEDURE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.SEQUENCE) {
                    privilege = "CREATE SEQUENCE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.ANY) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.TABLE) {
                        this.lexer.nextToken();
                        privilege = "CREATE ANY TABLE";
                    } else {
                        if (!this.lexer.identifierEquals("MATERIALIZED")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token) + " " + this.lexer.stringVal());
                        this.lexer.nextToken();
                        this.accept(Token.VIEW);
                        privilege = "CREATE ANY MATERIALIZED VIEW";
                    }
                } else if (this.lexer.identifierEquals("SYNONYM")) {
                    privilege = "CREATE SYNONYM";
                    this.lexer.nextToken();
                } else if (this.lexer.identifierEquals("ROUTINE")) {
                    privilege = "CREATE ROUTINE";
                    this.lexer.nextToken();
                } else if (this.lexer.identifierEquals("TEMPORARY")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("TABLES");
                    privilege = "CREATE TEMPORARY TABLES";
                } else if (this.lexer.token == Token.ON) {
                    privilege = "CREATE";
                } else {
                    if (this.lexer.token != Token.COMMA) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token) + " " + this.lexer.stringVal());
                    privilege = "CREATE";
                }
            } else if (this.lexer.token == Token.ALTER) {
                this.lexer.nextToken();
                if (this.lexer.token == Token.TABLE) {
                    privilege = "ALTER TABLE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.SESSION) {
                    privilege = "ALTER SESSION";
                    this.lexer.nextToken();
                } else if (this.lexer.identifierEquals(FnvHash.Constants.ROUTINE)) {
                    privilege = "ALTER ROUTINE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.ANY) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.TABLE) {
                        this.lexer.nextToken();
                        privilege = "ALTER ANY TABLE";
                    } else {
                        if (!this.lexer.identifierEquals("MATERIALIZED")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token) + " " + this.lexer.stringVal());
                        this.lexer.nextToken();
                        this.accept(Token.VIEW);
                        privilege = "ALTER ANY MATERIALIZED VIEW";
                    }
                } else {
                    if (this.lexer.token != Token.ON && this.lexer.token != Token.COMMA) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token) + " " + this.lexer.stringVal());
                    privilege = "ALTER";
                }
            } else if (this.lexer.token == Token.DROP) {
                this.lexer.nextToken();
                if (this.lexer.token == Token.DROP) {
                    privilege = "DROP TABLE";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.SESSION) {
                    privilege = "DROP SESSION";
                    this.lexer.nextToken();
                } else if (this.lexer.token == Token.ANY) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.TABLE) {
                        this.lexer.nextToken();
                        privilege = "DROP ANY TABLE";
                    } else {
                        if (!this.lexer.identifierEquals("MATERIALIZED")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token) + " " + this.lexer.stringVal());
                        this.lexer.nextToken();
                        this.accept(Token.VIEW);
                        privilege = "DROP ANY MATERIALIZED VIEW";
                    }
                } else {
                    privilege = "DROP";
                }
            } else if (this.lexer.identifierEquals("USAGE")) {
                privilege = "USAGE";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("EXECUTE")) {
                privilege = "EXECUTE";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("PROXY")) {
                privilege = "PROXY";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("QUERY")) {
                this.lexer.nextToken();
                this.acceptIdentifier("REWRITE");
                privilege = "QUERY REWRITE";
            } else if (this.lexer.identifierEquals("GLOBAL")) {
                this.lexer.nextToken();
                this.acceptIdentifier("QUERY");
                this.acceptIdentifier("REWRITE");
                privilege = "GLOBAL QUERY REWRITE";
            } else if (this.lexer.identifierEquals("INHERIT")) {
                this.lexer.nextToken();
                this.acceptIdentifier("PRIVILEGES");
                privilege = "INHERIT PRIVILEGES";
            } else if (this.lexer.identifierEquals("EVENT")) {
                this.lexer.nextToken();
                privilege = "EVENT";
            } else if (this.lexer.identifierEquals("FILE")) {
                this.lexer.nextToken();
                privilege = "FILE";
            } else if (this.lexer.identifierEquals("DESCRIBE")) {
                this.lexer.nextToken();
                privilege = "DESCRIBE";
            } else if (this.lexer.token == Token.GRANT) {
                this.lexer.nextToken();
                this.acceptIdentifier("OPTION");
                if (this.lexer.token == Token.FOR) {
                    privilege = "GRANT OPTION FOR";
                    this.lexer.nextToken();
                } else {
                    privilege = "GRANT OPTION";
                }
            } else if (this.lexer.token == Token.LOCK) {
                this.lexer.nextToken();
                this.acceptIdentifier("TABLES");
                privilege = "LOCK TABLES";
            } else if (this.lexer.identifierEquals("PROCESS")) {
                this.lexer.nextToken();
                privilege = "PROCESS";
            } else if (this.lexer.identifierEquals("RELOAD")) {
                this.lexer.nextToken();
                privilege = "RELOAD";
            } else if (this.lexer.identifierEquals("CONNECT")) {
                privilege = "CONNECT";
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("RESOURCE")) {
                this.lexer.nextToken();
                privilege = "RESOURCE";
            } else if (this.lexer.token == Token.CONNECT) {
                this.lexer.nextToken();
                privilege = "CONNECT";
            } else if (this.lexer.identifierEquals("REPLICATION")) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("SLAVE")) {
                    this.lexer.nextToken();
                    privilege = "REPLICATION SLAVE";
                } else {
                    this.acceptIdentifier("CLIENT");
                    privilege = "REPLICATION CLIENT";
                }
            } else if (this.lexer.token == Token.SHOW) {
                this.lexer.nextToken();
                if (this.lexer.token == Token.VIEW) {
                    this.lexer.nextToken();
                    privilege = "SHOW VIEW";
                } else if (this.lexer.identifierEquals("DATABASES")) {
                    this.acceptIdentifier("DATABASES");
                    privilege = "SHOW DATABASES";
                } else {
                    privilege = "SHOW";
                }
            } else if (this.lexer.identifierEquals("SHUTDOWN")) {
                this.lexer.nextToken();
                privilege = "SHUTDOWN";
            } else if (this.lexer.identifierEquals("SUPER")) {
                this.lexer.nextToken();
                privilege = "SUPER";
            } else if (this.lexer.identifierEquals("CONTROL")) {
                this.lexer.nextToken();
                privilege = "CONTROL";
            } else if (this.lexer.identifierEquals("IMPERSONATE")) {
                this.lexer.nextToken();
                privilege = "IMPERSONATE";
            } else if (this.lexer.identifierEquals("LOAD")) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("DATA")) {
                    this.lexer.nextToken();
                    privilege = "LOAD DATA";
                }
            } else if (this.lexer.identifierEquals("DUMP")) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("DATA")) {
                    this.lexer.nextToken();
                    privilege = "DUMP DATA";
                }
            }
            if (privilege != null) {
                SQLIdentifierExpr expr = new SQLIdentifierExpr(privilege);
                SQLPrivilegeItem privilegeItem = new SQLPrivilegeItem();
                privilegeItem.setAction(expr);
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    while (true) {
                        privilegeItem.getColumns().add(this.exprParser.name());
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                }
                expr.setParent(parent);
                privileges.add(privilegeItem);
            }
            if (this.lexer.token != Token.COMMA) return;
            this.lexer.nextToken();
        }
    }

    public SQLRevokeStatement parseRevoke() {
        this.accept(Token.REVOKE);
        SQLRevokeStatement stmt = new SQLRevokeStatement(this.dbType);
        if (this.lexer.token == Token.GRANT) {
            this.lexer.nextToken();
            this.acceptIdentifier("OPTION");
            stmt.setGrantOption(true);
            if (this.lexer.token == Token.FOR) {
                this.lexer.nextToken();
            }
        }
        this.parsePrivileages(stmt.getPrivileges(), stmt);
        if (this.lexer.token == Token.ON) {
            this.lexer.nextToken();
            switch (this.lexer.token) {
                case PROCEDURE: {
                    this.lexer.nextToken();
                    stmt.setResourceType(SQLObjectType.PROCEDURE);
                    break;
                }
                case FUNCTION: {
                    this.lexer.nextToken();
                    stmt.setResourceType(SQLObjectType.FUNCTION);
                    break;
                }
                case TABLE: {
                    this.lexer.nextToken();
                    stmt.setResourceType(SQLObjectType.TABLE);
                    break;
                }
                case USER: {
                    this.lexer.nextToken();
                    stmt.setResourceType(SQLObjectType.USER);
                    break;
                }
                case IDENTIFIER: {
                    if (this.lexer.identifierEquals("SYSTEM")) {
                        this.lexer.nextToken();
                        stmt.setResourceType(SQLObjectType.SYSTEM);
                        break;
                    }
                    if (!this.lexer.identifierEquals("PROJECT")) break;
                    this.lexer.nextToken();
                    stmt.setResourceType(SQLObjectType.PROJECT);
                    break;
                }
            }
            SQLExpr expr = this.exprParser.expr();
            if (stmt.getResourceType() == SQLObjectType.TABLE || stmt.getResourceType() == null) {
                stmt.setResource(new SQLExprTableSource(expr));
            } else {
                stmt.setResource(expr);
            }
        }
        if (this.lexer.token == Token.FROM) {
            this.lexer.nextToken();
            while (true) {
                if (this.lexer.token() == Token.USER && this.dbType == DbType.odps) {
                    this.lexer.nextToken();
                }
                SQLExpr user = this.parseUser();
                stmt.getUsers().add(user);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        return stmt;
    }

    public SQLStatement parseSavePoint() {
        this.acceptIdentifier("SAVEPOINT");
        SQLSavePointStatement stmt = new SQLSavePointStatement(this.getDbType());
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    public SQLStatement parseReleaseSavePoint() {
        this.acceptIdentifier("RELEASE");
        this.acceptIdentifier("SAVEPOINT");
        SQLReleaseSavePointStatement stmt = new SQLReleaseSavePointStatement(this.getDbType());
        stmt.setName(this.exprParser.name());
        return stmt;
    }

    public SQLStatement parseAlter() {
        Lexer.SavePoint mark = this.lexer.mark();
        this.accept(Token.ALTER);
        if (this.lexer.token == Token.TABLE) {
            this.lexer.nextToken();
            SQLAlterTableStatement stmt = new SQLAlterTableStatement(this.getDbType());
            if (this.lexer.token == Token.IF) {
                this.lexer.nextToken();
                this.accept(Token.EXISTS);
                stmt.setIfExists(true);
            }
            stmt.setName(this.exprParser.name());
            while (true) {
                SQLObjectImpl item;
                if (this.lexer.token == Token.DROP) {
                    this.parseAlterDrop(stmt);
                    continue;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.ADD)) {
                    this.alterTableAdd(stmt);
                    continue;
                }
                if (this.lexer.token == Token.DISABLE) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.CONSTRAINT) {
                        this.lexer.nextToken();
                        SQLAlterTableDisableConstraint item2 = new SQLAlterTableDisableConstraint();
                        item2.setConstraintName(this.exprParser.name());
                        stmt.addItem(item2);
                        continue;
                    }
                    if (this.lexer.identifierEquals("LIFECYCLE")) {
                        this.lexer.nextToken();
                        SQLAlterTableDisableLifecycle item3 = new SQLAlterTableDisableLifecycle();
                        stmt.addItem(item3);
                        continue;
                    }
                    this.acceptIdentifier("KEYS");
                    SQLAlterTableDisableKeys item4 = new SQLAlterTableDisableKeys();
                    stmt.addItem(item4);
                    continue;
                }
                if (this.lexer.token == Token.ENABLE) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.CONSTRAINT) {
                        this.lexer.nextToken();
                        SQLAlterTableEnableConstraint item5 = new SQLAlterTableEnableConstraint();
                        item5.setConstraintName(this.exprParser.name());
                        stmt.addItem(item5);
                        continue;
                    }
                    if (this.lexer.identifierEquals("LIFECYCLE")) {
                        this.lexer.nextToken();
                        SQLAlterTableEnableLifecycle item6 = new SQLAlterTableEnableLifecycle();
                        stmt.addItem(item6);
                        continue;
                    }
                    this.acceptIdentifier("KEYS");
                    SQLAlterTableEnableKeys item7 = new SQLAlterTableEnableKeys();
                    stmt.addItem(item7);
                    continue;
                }
                if (this.lexer.token == Token.ALTER) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.COLUMN) {
                        SQLAlterTableAlterColumn alterColumn = this.parseAlterColumn();
                        stmt.addItem(alterColumn);
                        if (this.dbType != DbType.postgresql || this.lexer.token != Token.COMMA) continue;
                        this.lexer.nextToken();
                        continue;
                    }
                    if (this.lexer.token == Token.LITERAL_ALIAS) {
                        SQLAlterTableAlterColumn alterColumn = this.parseAlterColumn();
                        stmt.addItem(alterColumn);
                        continue;
                    }
                    throw new ParserException("TODO " + this.lexer.info());
                }
                if (this.lexer.token == Token.DELETE) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.WHERE) {
                        this.lexer.nextToken();
                        SQLAlterTableDeleteByCondition alterColumn = new SQLAlterTableDeleteByCondition();
                        alterColumn.setWhere(this.exprParser.expr());
                        stmt.addItem(alterColumn);
                        continue;
                    }
                    throw new ParserException("TODO " + this.lexer.info());
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.CHANGE)) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.COLUMN) {
                        this.lexer.nextToken();
                    }
                    SQLName columnName = this.exprParser.name();
                    if (this.lexer.identifierEquals("RENAME")) {
                        this.lexer.nextToken();
                        this.accept(Token.TO);
                        SQLName toName = this.exprParser.name();
                        SQLAlterTableRenameColumn renameColumn = new SQLAlterTableRenameColumn();
                        renameColumn.setColumn(columnName);
                        renameColumn.setTo(toName);
                        stmt.addItem(renameColumn);
                        continue;
                    }
                    if (this.lexer.token == Token.COMMENT) {
                        SQLExpr comment;
                        this.lexer.nextToken();
                        if (this.lexer.token == Token.LITERAL_ALIAS) {
                            String alias = this.lexer.stringVal();
                            if (alias.length() > 2 && alias.charAt(0) == '\"' && alias.charAt(alias.length() - 1) == '\"') {
                                alias = alias.substring(1, alias.length() - 1);
                            }
                            comment = new SQLCharExpr(alias);
                            this.lexer.nextToken();
                        } else {
                            comment = this.exprParser.primary();
                        }
                        SQLColumnDefinition column = new SQLColumnDefinition();
                        column.setDbType(this.dbType);
                        column.setName(columnName);
                        column.setComment(comment);
                        SQLAlterTableAlterColumn changeColumn = new SQLAlterTableAlterColumn();
                        changeColumn.setColumn(column);
                        stmt.addItem(changeColumn);
                        continue;
                    }
                    if (this.lexer.token == Token.NULL) {
                        this.lexer.nextToken();
                        stmt.addItem(new SQLAlterTableAddConstraint(new SQLNullConstraint()));
                        continue;
                    }
                    SQLColumnDefinition column = this.exprParser.parseColumn();
                    SQLAlterTableAlterColumn alterColumn = new SQLAlterTableAlterColumn();
                    alterColumn.setColumn(column);
                    alterColumn.setOriginColumn(columnName);
                    if (this.lexer.identifierEquals(FnvHash.Constants.AFTER)) {
                        this.lexer.nextToken();
                        alterColumn.setAfter(this.exprParser.name());
                    } else if (this.lexer.identifierEquals(FnvHash.Constants.FIRST)) {
                        this.lexer.nextToken();
                        alterColumn.setFirst(true);
                    }
                    stmt.addItem(alterColumn);
                    continue;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.EXCHANGE)) {
                    this.lexer.nextToken();
                    this.accept(Token.PARTITION);
                    SQLAlterTableExchangePartition item8 = new SQLAlterTableExchangePartition();
                    this.accept(Token.LPAREN);
                    while (true) {
                        SQLExpr partition = this.exprParser.name();
                        if (this.lexer.token == Token.EQ) {
                            this.lexer.nextToken();
                            SQLExpr value = this.exprParser.primary();
                            partition = new SQLAssignItem(partition, value);
                        }
                        item8.addPartition(partition);
                        if (this.lexer.token != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    this.accept(Token.WITH);
                    this.accept(Token.TABLE);
                    SQLName table = this.exprParser.name();
                    item8.setTable(table);
                    if (this.lexer.token == Token.WITH) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("VALIDATION");
                        item8.setValidation(true);
                    } else if (this.lexer.identifierEquals(FnvHash.Constants.WITHOUT)) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("VALIDATION");
                        item8.setValidation(false);
                    }
                    stmt.addItem(item8);
                    continue;
                }
                if (this.lexer.token == Token.WITH) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("NOCHECK");
                    this.acceptIdentifier("ADD");
                    SQLConstraint check = this.exprParser.parseConstaint();
                    SQLAlterTableAddConstraint addCheck = new SQLAlterTableAddConstraint();
                    addCheck.setWithNoCheck(true);
                    addCheck.setConstraint(check);
                    stmt.addItem(addCheck);
                    continue;
                }
                if (this.lexer.identifierEquals("RENAME")) {
                    stmt.addItem(this.parseAlterTableRename());
                    continue;
                }
                if (this.lexer.token == Token.SET) {
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.COMMENT) {
                        this.lexer.nextToken();
                        SQLAlterTableSetComment setComment = new SQLAlterTableSetComment();
                        setComment.setComment(this.exprParser.primary());
                        stmt.addItem(setComment);
                        continue;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
                        this.lexer.nextToken();
                        SQLAlterTableSetLifecycle setLifecycle = new SQLAlterTableSetLifecycle();
                        setLifecycle.setLifecycle(this.exprParser.primary());
                        stmt.addItem(setLifecycle);
                        continue;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
                        this.lexer.nextToken();
                        SQLAlterTableSetLocation setLocation = new SQLAlterTableSetLocation();
                        setLocation.setLocation(this.exprParser.primary());
                        stmt.addItem(setLocation);
                        continue;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.TBLPROPERTIES)) {
                        this.lexer.nextToken();
                        SQLAlterTableSetOption setOption = new SQLAlterTableSetOption();
                        this.accept(Token.LPAREN);
                        while (true) {
                            item = this.exprParser.parseAssignItem();
                            setOption.addOption((SQLAssignItem)item);
                            if (this.lexer.token != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        this.accept(Token.RPAREN);
                        stmt.addItem(setOption);
                        continue;
                    }
                    if (this.lexer.identifierEquals("CHANGELOGS") && this.dbType == DbType.odps) {
                        this.lexer.nextToken();
                        OdpsAlterTableSetChangeLogs item9 = new OdpsAlterTableSetChangeLogs();
                        item9.setValue(this.exprParser.primary());
                        stmt.addItem(item9);
                        continue;
                    }
                    if (this.lexer.identifierEquals("FILEFORMAT") && this.dbType == DbType.odps) {
                        this.lexer.nextToken();
                        OdpsAlterTableSetFileFormat item10 = new OdpsAlterTableSetFileFormat();
                        item10.setValue(this.exprParser.primary());
                        stmt.addItem(item10);
                        continue;
                    }
                    throw new ParserException("TODO " + this.lexer.info());
                }
                if (this.lexer.token == Token.PARTITION) {
                    this.lexer.nextToken();
                    SQLAlterTableRenamePartition renamePartition = new SQLAlterTableRenamePartition();
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(renamePartition.getPartition(), renamePartition);
                    this.accept(Token.RPAREN);
                    if (this.lexer.token == Token.ENABLE) {
                        this.lexer.nextToken();
                        if (this.lexer.identifierEquals("LIFECYCLE")) {
                            this.lexer.nextToken();
                        }
                        SQLAlterTableEnableLifecycle enableLifeCycle = new SQLAlterTableEnableLifecycle();
                        for (SQLAssignItem condition : renamePartition.getPartition()) {
                            enableLifeCycle.getPartition().add(condition);
                            condition.setParent(enableLifeCycle);
                        }
                        stmt.addItem(enableLifeCycle);
                        continue;
                    }
                    if (this.lexer.token == Token.DISABLE) {
                        this.lexer.nextToken();
                        if (this.lexer.identifierEquals("LIFECYCLE")) {
                            this.lexer.nextToken();
                        }
                        SQLAlterTableDisableLifecycle disableLifeCycle = new SQLAlterTableDisableLifecycle();
                        for (SQLAssignItem condition : renamePartition.getPartition()) {
                            disableLifeCycle.getPartition().add(condition);
                            condition.setParent(disableLifeCycle);
                        }
                        stmt.addItem(disableLifeCycle);
                        continue;
                    }
                    if (DbType.odps == this.dbType) {
                        SQLObjectImpl alterTablePartition;
                        if (this.lexer.identifierEquals("MERGE")) {
                            alterTablePartition = new SQLAlterTablePartition();
                            for (SQLAssignItem condition : renamePartition.getPartition()) {
                                ((SQLAlterTablePartition)alterTablePartition).getPartition().add(condition);
                                condition.setParent(alterTablePartition);
                            }
                            stmt.addItem((SQLAlterTableItem)((Object)alterTablePartition));
                            continue;
                        }
                        if (this.lexer.token == Token.SET) {
                            alterTablePartition = new SQLAlterTablePartitionSetProperties();
                            for (SQLAssignItem condition : renamePartition.getPartition()) {
                                ((SQLAlterTablePartitionSetProperties)alterTablePartition).getPartition().add(condition);
                                condition.setParent(alterTablePartition);
                            }
                            this.lexer.nextToken();
                            this.acceptIdentifier("PARTITIONPROPERTIES");
                            this.accept(Token.LPAREN);
                            this.parseAssignItems(((SQLAlterTablePartitionSetProperties)alterTablePartition).getPartitionProperties(), alterTablePartition);
                            this.accept(Token.RPAREN);
                            stmt.addItem((SQLAlterTableItem)((Object)alterTablePartition));
                            continue;
                        }
                        if (this.lexer.identifierEquals(FnvHash.Constants.ADD)) {
                            this.alterTableAdd(stmt);
                            continue;
                        }
                    }
                    this.acceptIdentifier("RENAME");
                    this.accept(Token.TO);
                    this.accept(Token.PARTITION);
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(renamePartition.getTo(), renamePartition);
                    this.accept(Token.RPAREN);
                    stmt.addItem(renamePartition);
                    continue;
                }
                if (this.lexer.identifierEquals("TOUCH")) {
                    this.lexer.nextToken();
                    SQLAlterTableTouch item11 = new SQLAlterTableTouch();
                    if (this.lexer.token == Token.PARTITION) {
                        this.lexer.nextToken();
                        this.accept(Token.LPAREN);
                        this.parseAssignItems(item11.getPartition(), item11);
                        this.accept(Token.RPAREN);
                    }
                    stmt.addItem(item11);
                    continue;
                }
                if (this.lexer.identifierEquals("CHANGEOWNER")) {
                    this.lexer.nextToken();
                    this.accept(Token.TO);
                    SQLName name = this.exprParser.name();
                    SQLAlterTableChangeOwner changeOwner = new SQLAlterTableChangeOwner();
                    changeOwner.setOwner(name);
                    stmt.addItem(changeOwner);
                    continue;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.ARCHIVE)) {
                    this.lexer.nextToken();
                    this.accept(Token.PARTITION);
                    SQLAlterTableArchivePartition item12 = new SQLAlterTableArchivePartition();
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(item12.getPartitions(), item12, false);
                    this.accept(Token.RPAREN);
                    stmt.addItem(item12);
                    continue;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.UNARCHIVE)) {
                    this.lexer.nextToken();
                    this.accept(Token.PARTITION);
                    SQLAlterTableUnarchivePartition item13 = new SQLAlterTableUnarchivePartition();
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(item13.getPartitions(), item13, false);
                    this.accept(Token.RPAREN);
                    stmt.addItem(item13);
                    continue;
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.SUBPARTITION_AVAILABLE_PARTITION_NUM)) {
                    this.lexer.nextToken();
                    this.accept(Token.EQ);
                    SQLIntegerExpr num = this.exprParser.integerExpr();
                    item = new SQLAlterTableSubpartitionAvailablePartitionNum();
                    ((SQLAlterTableSubpartitionAvailablePartitionNum)item).setNumber(num);
                    stmt.addItem((SQLAlterTableItem)((Object)item));
                    continue;
                }
                if (DbType.odps == this.dbType && this.lexer.identifierEquals("MERGE")) {
                    this.lexer.nextToken();
                    boolean ifExists = false;
                    if (this.lexer.token == Token.IF) {
                        this.lexer.nextToken();
                        this.accept(Token.EXISTS);
                        ifExists = true;
                    }
                    if (this.lexer.token == Token.PARTITION) {
                        item = new SQLAlterTableMergePartition();
                        while (true) {
                            ((SQLAlterTableMergePartition)item).addPartition(this.getExprParser().parsePartitionSpec());
                            if (this.lexer.token != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        this.accept(Token.OVERWRITE);
                        ((SQLAlterTableMergePartition)item).setOverwritePartition(this.getExprParser().parsePartitionSpec());
                        if (ifExists) {
                            ((SQLAlterTableMergePartition)item).setIfExists(true);
                        }
                        if (this.lexer.identifierEquals(FnvHash.Constants.PURGE)) {
                            this.lexer.nextToken();
                            ((SQLAlterTableMergePartition)item).setPurge(true);
                        }
                        stmt.addItem((SQLAlterTableItem)((Object)item));
                        continue;
                    }
                    this.acceptIdentifier("SMALLFILES");
                    stmt.setMergeSmallFiles(true);
                    continue;
                }
                if (DbType.odps == this.dbType && (this.lexer.identifierEquals(FnvHash.Constants.RANGE) || this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED))) {
                    if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
                        this.lexer.nextToken();
                        this.acceptIdentifier("CLUSTERED");
                        stmt.setRange(true);
                    } else {
                        this.lexer.nextToken();
                    }
                    this.accept(Token.BY);
                    this.accept(Token.LPAREN);
                    while (true) {
                        SQLSelectOrderByItem item14 = this.exprParser.parseSelectOrderByItem();
                        stmt.addClusteredByItem(item14);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    continue;
                }
                if (DbType.odps == this.dbType && this.lexer.identifierEquals(FnvHash.Constants.SORTED)) {
                    this.lexer.nextToken();
                    this.accept(Token.BY);
                    this.accept(Token.LPAREN);
                    while (true) {
                        SQLSelectOrderByItem item15 = this.exprParser.parseSelectOrderByItem();
                        stmt.addSortedByItem(item15);
                        if (this.lexer.token() != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    this.accept(Token.RPAREN);
                    continue;
                }
                if ((stmt.getClusteredBy().size() > 0 || stmt.getSortedBy().size() > 0) && this.lexer.token == Token.INTO) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.LITERAL_INT) {
                        throw new ParserException("into buckets must be integer. " + this.lexer.info());
                    }
                    int num = this.lexer.integerValue().intValue();
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals(FnvHash.Constants.BUCKETS)) {
                        stmt.setBuckets(num);
                        this.lexer.nextToken();
                        continue;
                    }
                    this.acceptIdentifier("SHARDS");
                    stmt.setShards(num);
                    continue;
                }
                if (this.lexer.token == Token.REPLACE) {
                    SQLAlterTableReplaceColumn item16 = this.parseAlterTableReplaceColumn();
                    stmt.addItem(item16);
                    continue;
                }
                if (DbType.hive == this.dbType && this.lexer.identifierEquals(FnvHash.Constants.RECOVER)) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("PARTITIONS");
                    stmt.addItem(new SQLAlterTableRecoverPartitions());
                    continue;
                }
                if (this.dbType != DbType.odps || this.lexer.token != Token.NOT) break;
                this.lexer.nextToken();
                this.acceptIdentifier("CLUSTERED");
                stmt.setNotClustered(true);
            }
            return stmt;
        }
        if (this.lexer.token == Token.VIEW) {
            this.lexer.nextToken();
            SQLName viewName = this.exprParser.name();
            SQLAlterViewRenameStatement stmt = new SQLAlterViewRenameStatement();
            stmt.setName(viewName);
            if (this.lexer.identifierEquals("RENAME")) {
                this.lexer.nextToken();
                this.accept(Token.TO);
                stmt.setTo(this.exprParser.name());
            }
            if (this.lexer.identifierEquals("CHANGEOWNER")) {
                this.lexer.nextToken();
                this.accept(Token.TO);
                stmt.setChangeOwnerTo(this.exprParser.name());
            }
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.MATERIALIZED)) {
            return this.parseAlterMaterialized();
        }
        if (this.lexer.token == Token.INDEX) {
            this.lexer.reset(mark);
            return this.parseAlterIndex();
        }
        if (this.lexer.token == Token.DATABASE) {
            this.lexer.reset(mark);
            return this.parseAlterDatabase();
        }
        if (this.lexer.token == Token.SCHEMA) {
            this.lexer.reset(mark);
            return this.parseAlterSchema();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RESOURCE)) {
            this.lexer.reset(mark);
            return this.parseAlterResourceGroup();
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    private void alterTableAdd(SQLAlterTableStatement stmt) {
        this.lexer.nextToken();
        boolean ifNotExists = false;
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            ifNotExists = true;
        }
        if (this.lexer.token == Token.PRIMARY) {
            SQLPrimaryKey primaryKey = this.exprParser.parsePrimaryKey();
            SQLAlterTableAddConstraint item = new SQLAlterTableAddConstraint(primaryKey);
            stmt.addItem(item);
        } else if (this.lexer.token == Token.UNIQUE) {
            SQLUnique unique = this.exprParser.parseUnique();
            SQLAlterTableAddConstraint item = new SQLAlterTableAddConstraint(unique);
            stmt.addItem(item);
        } else if (this.lexer.token == Token.IDENTIFIER) {
            SQLAlterTableAddColumn item = this.parseAlterTableAddColumn();
            stmt.addItem(item);
        } else if (this.lexer.token == Token.LPAREN) {
            if (this.dbType == DbType.h2) {
                this.lexer.nextToken();
                SQLAlterTableAddColumn item = this.parseAlterTableAddColumn();
                stmt.addItem(item);
                this.accept(Token.RPAREN);
            }
        } else if (this.lexer.token == Token.COLUMN) {
            this.lexer.nextToken();
            SQLAlterTableAddColumn item = this.parseAlterTableAddColumn();
            stmt.addItem(item);
        } else if (this.lexer.token == Token.CHECK) {
            SQLCheck check = this.exprParser.parseCheck();
            SQLAlterTableAddConstraint item = new SQLAlterTableAddConstraint(check);
            stmt.addItem(item);
        } else if (this.lexer.token == Token.CONSTRAINT) {
            SQLConstraint constraint = this.exprParser.parseConstaint();
            SQLAlterTableAddConstraint item = new SQLAlterTableAddConstraint(constraint);
            stmt.addItem(item);
        } else if (this.lexer.token == Token.FOREIGN) {
            SQLForeignKeyConstraint constraint = this.exprParser.parseForeignKey();
            SQLAlterTableAddConstraint item = new SQLAlterTableAddConstraint(constraint);
            stmt.addItem(item);
        } else if (this.lexer.token == Token.PARTITION) {
            while (true) {
                this.lexer.nextToken();
                SQLAlterTableAddPartition addPartition = new SQLAlterTableAddPartition();
                addPartition.setIfNotExists(ifNotExists);
                this.accept(Token.LPAREN);
                this.parseAssignItems(addPartition.getPartitions(), addPartition, false);
                this.accept(Token.RPAREN);
                if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
                    this.lexer.nextToken();
                    SQLExpr location = this.exprParser.primary();
                    addPartition.setLocation(location);
                }
                stmt.addItem(addPartition);
                if (this.lexer.token == Token.PARTITION) continue;
                if (this.lexer.token == Token.COMMA) {
                    this.lexer.nextToken();
                    if (this.lexer.identifierEquals("ADD") || this.lexer.token == Token.PARTITION) {
                        continue;
                    }
                }
                break;
            }
        } else if (this.lexer.token == Token.DEFAULT) {
            SQLConstraint constraint = this.exprParser.parseConstaint();
            SQLAlterTableAddConstraint item = new SQLAlterTableAddConstraint(constraint);
            stmt.addItem(item);
        } else {
            throw new ParserException("TODO " + this.lexer.info());
        }
    }

    protected SQLStatement parseAlterDatabase() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    protected SQLStatement parseAlterSchema() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    protected SQLAlterTableItem parseAlterTableRename() {
        this.acceptIdentifier("RENAME");
        if (this.lexer.token == Token.COLUMN) {
            this.lexer.nextToken();
            SQLAlterTableRenameColumn renameColumn = new SQLAlterTableRenameColumn();
            renameColumn.setColumn(this.exprParser.name());
            this.accept(Token.TO);
            renameColumn.setTo(this.exprParser.name());
            return renameColumn;
        }
        if (this.lexer.token == Token.TO) {
            this.lexer.nextToken();
            SQLAlterTableRename item = new SQLAlterTableRename();
            item.setTo(this.exprParser.name());
            return item;
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    protected SQLAlterTableAlterColumn parseAlterColumn() {
        this.lexer.nextToken();
        SQLColumnDefinition column = this.exprParser.parseColumn();
        SQLAlterTableAlterColumn alterColumn = new SQLAlterTableAlterColumn();
        alterColumn.setColumn(column);
        return alterColumn;
    }

    public void parseAlterDrop(SQLAlterTableStatement stmt) {
        this.lexer.nextToken();
        boolean ifExists = false;
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            ifExists = true;
        }
        if (this.lexer.token == Token.CONSTRAINT) {
            this.lexer.nextToken();
            SQLAlterTableDropConstraint item = new SQLAlterTableDropConstraint();
            item.setConstraintName(this.exprParser.name());
            if (this.lexer.token == Token.RESTRICT) {
                this.lexer.nextToken();
                item.setRestrict(true);
            } else if (this.lexer.token == Token.CASCADE) {
                this.lexer.nextToken();
                item.setCascade(true);
            }
            stmt.addItem(item);
        } else if (this.lexer.token == Token.COLUMN || this.lexer.identifierEquals(FnvHash.Constants.COLUMNS)) {
            this.lexer.nextToken();
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            if (this.dbType == DbType.postgresql) {
                item.getColumns().add(this.exprParser.name());
            } else {
                boolean paren = false;
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    paren = true;
                }
                this.exprParser.names(item.getColumns());
                if (paren) {
                    this.accept(Token.RPAREN);
                }
            }
            if (this.lexer.token == Token.CASCADE) {
                item.setCascade(true);
                this.lexer.nextToken();
            }
            stmt.addItem(item);
            if (this.dbType == DbType.postgresql && this.lexer.token == Token.COMMA) {
                this.lexer.nextToken();
            }
        } else if (this.lexer.token == Token.LITERAL_ALIAS) {
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            this.exprParser.names(item.getColumns());
            if (this.lexer.token == Token.CASCADE) {
                item.setCascade(true);
                this.lexer.nextToken();
            }
            stmt.addItem(item);
        } else if (this.lexer.token == Token.PARTITION) {
            SQLAlterTableDropPartition dropPartition = this.parseAlterTableDropPartition(ifExists);
            stmt.addItem(dropPartition);
            while (this.lexer.token == Token.COMMA) {
                this.lexer.nextToken();
                Lexer.SavePoint mark = this.lexer.mark();
                if (this.lexer.token == Token.PARTITION) {
                    SQLAlterTableDropPartition dropPartition2 = this.parseAlterTableDropPartition(ifExists);
                    stmt.addItem(dropPartition2);
                    continue;
                }
                this.lexer.reset(mark);
            }
        } else if (this.lexer.token == Token.INDEX) {
            this.lexer.nextToken();
            SQLName indexName = this.exprParser.name();
            SQLAlterTableDropIndex item = new SQLAlterTableDropIndex();
            item.setIndexName(indexName);
            stmt.addItem(item);
        } else if (this.lexer.token == Token.PRIMARY) {
            this.lexer.nextToken();
            this.accept(Token.KEY);
            SQLAlterTableDropPrimaryKey item = new SQLAlterTableDropPrimaryKey();
            stmt.addItem(item);
        } else {
            throw new ParserException("TODO " + this.lexer.info());
        }
    }

    protected SQLAlterTableDropPartition parseAlterTableDropPartition(boolean ifExists) {
        this.lexer.nextToken();
        SQLAlterTableDropPartition dropPartition = new SQLAlterTableDropPartition();
        dropPartition.setIfExists(ifExists);
        if (this.lexer.token == Token.LPAREN) {
            this.accept(Token.LPAREN);
            this.exprParser.exprList(dropPartition.getPartitions(), dropPartition);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals("PURGE")) {
                this.lexer.nextToken();
                dropPartition.setPurge(true);
            }
        } else {
            while (true) {
                SQLExpr partition = this.exprParser.expr();
                dropPartition.addPartition(partition);
                if (this.lexer.token != Token.COMMA) break;
                this.lexer.nextToken();
            }
            dropPartition.getAttributes().put("SIMPLE", true);
        }
        return dropPartition;
    }

    protected SQLAlterTableDropSubpartition parseAlterTableDropSubpartition() {
        this.lexer.nextToken();
        SQLAlterTableDropSubpartition item = new SQLAlterTableDropSubpartition();
        if (this.lexer.token() == Token.LITERAL_INT) {
            while (true) {
                item.getPartitionIds().add(this.exprParser.integerExpr());
                String pidStr = this.lexer.stringVal();
                this.accept(Token.VARIANT);
                String s = pidStr.replaceAll(":", "");
                if (StringUtils.isEmpty(s)) {
                    item.getSubpartitionIds().add(this.exprParser.integerExpr());
                } else {
                    item.getSubpartitionIds().add(new SQLIntegerExpr(Integer.valueOf(s)));
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        return item;
    }

    public SQLStatement parseRename() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    public SQLStatement parseList() {
        if (this.lexer.identifierEquals(FnvHash.Constants.LIST)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.RESOURCE)) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals(FnvHash.Constants.GROUP) || this.lexer.token == Token.GROUP) {
                    this.lexer.nextToken();
                    return new SQLListResourceGroupStatement();
                }
            }
        }
        return null;
    }

    protected SQLDropTableStatement parseDropTable(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropTableStatement stmt = new SQLDropTableStatement(this.getDbType());
        if (this.lexer.identifierEquals(FnvHash.Constants.TEMPORARY)) {
            this.lexer.nextToken();
            stmt.setTemporary(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONED)) {
            this.lexer.nextToken();
            stmt.setDropPartition(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.nextToken();
            stmt.setExternal(true);
        }
        if (this.lexer.token == Token.TABLE) {
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals(FnvHash.Constants.TABLES) && this.dbType == DbType.mysql) {
            this.lexer.nextToken();
        } else {
            throw new ParserException("expected token: TABLE.");
        }
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addPartition(new SQLExprTableSource(name));
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        while (true) {
            if (this.lexer.identifierEquals("RESTRICT")) {
                this.lexer.nextToken();
                stmt.setRestrict(true);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.CASCADE)) {
                this.lexer.nextToken();
                stmt.setCascade(true);
                if (!this.lexer.identifierEquals("CONSTRAINTS")) continue;
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.token != Token.PURGE && !this.lexer.identifierEquals("PURGE")) break;
            this.lexer.nextToken();
            stmt.setPurge(true);
        }
        if (stmt.isDropPartition() && this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    protected SQLDropSequenceStatement parseDropSequence(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        this.lexer.nextToken();
        SQLName name = this.exprParser.name();
        SQLDropSequenceStatement stmt = new SQLDropSequenceStatement(this.getDbType());
        stmt.setName(name);
        return stmt;
    }

    protected SQLDropTriggerStatement parseDropTrigger(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        this.lexer.nextToken();
        SQLDropTriggerStatement stmt = new SQLDropTriggerStatement(this.getDbType());
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    protected SQLDropViewStatement parseDropView(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropViewStatement stmt = new SQLDropViewStatement(this.getDbType());
        this.accept(Token.VIEW);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addPartition(new SQLExprTableSource(name));
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals("RESTRICT")) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        } else if (this.lexer.identifierEquals("CASCADE")) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("CONSTRAINTS")) {
                this.lexer.nextToken();
            }
            stmt.setCascade(true);
        }
        return stmt;
    }

    protected SQLDropStatement parseDropSchema() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    protected SQLDropStatement parseDropDatabaseOrSchema(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropDatabaseStatement stmt = new SQLDropDatabaseStatement(this.getDbType());
        if (this.lexer.token == Token.SCHEMA) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.DATABASE);
        }
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setDatabase(name);
        if (this.lexer.identifierEquals(FnvHash.Constants.RESTRICT)) {
            this.lexer.nextToken();
            stmt.setRestrict(true);
        } else if (this.lexer.token == Token.CASCADE || this.lexer.identifierEquals(FnvHash.Constants.CASCADE)) {
            this.lexer.nextToken();
            stmt.setCascade(true);
        } else {
            stmt.setCascade(false);
        }
        return stmt;
    }

    protected SQLDropFunctionStatement parseDropFunction(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropFunctionStatement stmt = new SQLDropFunctionStatement(this.getDbType());
        this.accept(Token.FUNCTION);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    protected SQLDropTableSpaceStatement parseDropTablespace(boolean acceptDrop) {
        SQLDropTableSpaceStatement stmt = new SQLDropTableSpaceStatement(this.getDbType());
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            stmt.addBeforeComment(this.lexer.readAndResetComments());
        }
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        this.accept(Token.TABLESPACE);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE)) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr engine = this.exprParser.primary();
            stmt.setEngine(engine);
        }
        return stmt;
    }

    protected SQLDropProcedureStatement parseDropProcedure(boolean acceptDrop) {
        if (acceptDrop) {
            this.accept(Token.DROP);
        }
        SQLDropProcedureStatement stmt = new SQLDropProcedureStatement(this.getDbType());
        this.accept(Token.PROCEDURE);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        return stmt;
    }

    public SQLStatement parseTruncate() {
        this.accept(Token.TRUNCATE);
        if (this.lexer.token == Token.TABLE) {
            this.lexer.nextToken();
        }
        SQLTruncateStatement stmt = new SQLTruncateStatement(this.getDbType());
        if (this.lexer.token == Token.ONLY) {
            this.lexer.nextToken();
            stmt.setOnly(true);
        }
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            SQLName name = this.exprParser.name();
            stmt.addTableSource(name);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.PARTITION) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.LPAREN) {
                this.accept(Token.LPAREN);
                while (true) {
                    SQLAssignItem item = this.exprParser.parseAssignItem();
                    item.setParent(stmt);
                    stmt.getPartitions().add(item);
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            } else if (this.lexer.token == Token.ALL) {
                this.lexer.nextToken();
                stmt.setPartitionAll(true);
            } else {
                while (true) {
                    stmt.getPartitionsForADB().add(this.exprParser.integerExpr());
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
        }
        while (true) {
            if (this.lexer.token == Token.PURGE) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("SNAPSHOT")) {
                    this.lexer.nextToken();
                    this.acceptIdentifier("LOG");
                    stmt.setPurgeSnapshotLog(true);
                    continue;
                }
                throw new ParserException("TODO : " + (Object)((Object)this.lexer.token) + " " + this.lexer.stringVal());
            }
            if (this.lexer.token == Token.RESTART) {
                this.lexer.nextToken();
                this.accept(Token.IDENTITY);
                stmt.setRestartIdentity(Boolean.TRUE);
                continue;
            }
            if (this.lexer.token == Token.SHARE) {
                this.lexer.nextToken();
                this.accept(Token.IDENTITY);
                stmt.setRestartIdentity(Boolean.FALSE);
                continue;
            }
            if (this.lexer.token == Token.CASCADE) {
                this.lexer.nextToken();
                stmt.setCascade(Boolean.TRUE);
                continue;
            }
            if (this.lexer.token == Token.RESTRICT) {
                this.lexer.nextToken();
                stmt.setCascade(Boolean.FALSE);
                continue;
            }
            if (this.lexer.token == Token.DROP) {
                this.lexer.nextToken();
                this.acceptIdentifier("STORAGE");
                stmt.setDropStorage(true);
                continue;
            }
            if (this.lexer.identifierEquals("REUSE")) {
                this.lexer.nextToken();
                this.acceptIdentifier("STORAGE");
                stmt.setReuseStorage(true);
                continue;
            }
            if (this.lexer.identifierEquals("IGNORE")) {
                this.lexer.nextToken();
                this.accept(Token.DELETE);
                this.acceptIdentifier("TRIGGERS");
                stmt.setIgnoreDeleteTriggers(true);
                continue;
            }
            if (this.lexer.identifierEquals("RESTRICT")) {
                this.lexer.nextToken();
                this.accept(Token.WHEN);
                this.accept(Token.DELETE);
                this.acceptIdentifier("TRIGGERS");
                stmt.setRestrictWhenDeleteTriggers(true);
                continue;
            }
            if (this.lexer.token == Token.CONTINUE) {
                this.lexer.nextToken();
                this.accept(Token.IDENTITY);
                continue;
            }
            if (!this.lexer.identifierEquals("IMMEDIATE")) break;
            this.lexer.nextToken();
            stmt.setImmediate(true);
        }
        return stmt;
    }

    public SQLStatement parseInsert() {
        SQLInsertStatement stmt = new SQLInsertStatement();
        if (this.lexer.token == Token.INSERT) {
            this.accept(Token.INSERT);
        }
        this.parseInsert0(stmt);
        return stmt;
    }

    protected void parseInsert0(SQLInsertInto insertStatement) {
        this.parseInsert0(insertStatement, true);
    }

    protected void parseInsert0_hinits(SQLInsertInto insertStatement) {
    }

    protected void parseInsert0(SQLInsertInto insertStatement, boolean acceptSubQuery) {
        if (this.lexer.token == Token.INTO) {
            this.lexer.nextToken();
            SQLName tableName = this.exprParser.name();
            insertStatement.setTableName(tableName);
            if (this.lexer.token == Token.LITERAL_ALIAS) {
                insertStatement.setAlias(this.tableAlias());
            }
            this.parseInsert0_hinits(insertStatement);
            if (this.lexer.token == Token.IDENTIFIER) {
                insertStatement.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            this.parseInsertColumns(insertStatement);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                SQLInsertStatement.ValuesClause values;
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    values = new SQLInsertStatement.ValuesClause();
                    this.exprParser.exprList(values.getValues(), values);
                    insertStatement.addValueCause(values);
                    this.accept(Token.RPAREN);
                } else {
                    values = new SQLInsertStatement.ValuesClause();
                    SQLExpr value = this.exprParser.expr();
                    values.addValue(value);
                    insertStatement.addValueCause(values);
                }
                if (this.lexer.token == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (acceptSubQuery && (this.lexer.token == Token.SELECT || this.lexer.token == Token.LPAREN)) {
            SQLSelect select = this.createSQLSelectParser().select();
            insertStatement.setQuery(select);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.VALUE)) {
            throw new ParserException("'values' expected, but 'value'. " + this.lexer.info());
        }
    }

    protected void parseInsertColumns(SQLInsertInto insert) {
        this.exprParser.exprList(insert.getColumns(), insert);
    }

    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        return false;
    }

    public SQLDropUserStatement parseDropUser() {
        this.accept(Token.USER);
        SQLDropUserStatement stmt = new SQLDropUserStatement(this.getDbType());
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        while (true) {
            if (this.lexer.token == Token.IF) {
                this.lexer.nextToken();
                this.accept(Token.EXISTS);
            }
            SQLExpr expr = this.exprParser.expr();
            stmt.addUser(expr);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return stmt;
    }

    public SQLStatement parseDropIndex() {
        this.accept(Token.INDEX);
        SQLDropIndexStatement stmt = new SQLDropIndexStatement(this.getDbType());
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.EXISTS);
            stmt.setIfExists(true);
        }
        stmt.setIndexName(this.exprParser.name());
        if (this.lexer.token == Token.ON) {
            this.lexer.nextToken();
            stmt.setTableName(this.exprParser.name());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ALGORITHM)) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr algorithm = this.exprParser.primary();
            stmt.setAlgorithm(algorithm);
        }
        if (this.lexer.token == Token.LOCK) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.EQ) {
                this.lexer.nextToken();
            }
            SQLExpr option = this.exprParser.primary();
            stmt.setLockOption(option);
        }
        return stmt;
    }

    public SQLCallStatement parseCall() {
        boolean brace = false;
        if (this.lexer.token == Token.LBRACE) {
            this.lexer.nextToken();
            brace = true;
        }
        SQLCallStatement stmt = new SQLCallStatement(this.getDbType());
        if (this.lexer.token == Token.QUES) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            stmt.setOutParameter(new SQLVariantRefExpr("?"));
        }
        this.acceptIdentifier("CALL");
        stmt.setProcedureName(this.exprParser.name());
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getParameters(), stmt);
            this.accept(Token.RPAREN);
        }
        if (brace) {
            this.accept(Token.RBRACE);
            stmt.setBrace(true);
        }
        return stmt;
    }

    public SQLStatement parseSet() {
        this.accept(Token.SET);
        SQLSetStatement stmt = new SQLSetStatement(this.getDbType());
        this.parseAssignItems(stmt.getItems(), stmt);
        return stmt;
    }

    public void parseAssignItems(List<? super SQLAssignItem> items, SQLObject parent) {
        this.parseAssignItems(items, parent, true);
    }

    public void parseAssignItems(List<? super SQLAssignItem> items, SQLObject parent, boolean variant) {
        while (true) {
            SQLAssignItem item = this.exprParser.parseAssignItem(variant, parent);
            item.setParent(parent);
            items.add(item);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    public SQLPartitionRef parsePartitionRef() {
        this.accept(Token.PARTITION);
        SQLPartitionRef partitionRef = new SQLPartitionRef();
        this.accept(Token.LPAREN);
        while (true) {
            SQLIdentifierExpr name = (SQLIdentifierExpr)this.exprParser.name();
            if (this.lexer.token == Token.EQ) {
                this.lexer.nextToken();
                SQLExpr value = this.exprParser.expr();
                partitionRef.addItem(name, value);
            } else {
                partitionRef.addItem(new SQLPartitionRef.Item(name));
            }
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return partitionRef;
    }

    public SQLStatement parseCreatePackage() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    public SQLStatement parseCreate() {
        Lexer.SavePoint mark = this.lexer.mark();
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        this.accept(Token.CREATE);
        boolean global = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.GLOBAL)) {
            this.lexer.nextToken();
            global = true;
        }
        boolean temporary = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.TEMPORARY) || this.lexer.token == Token.TEMPORARY) {
            this.lexer.nextToken();
            temporary = true;
        }
        boolean nonclustered = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.NONCLUSTERED)) {
            this.lexer.nextToken();
            nonclustered = true;
        }
        Token token = this.lexer.token;
        switch (this.lexer.token) {
            case TABLE: {
                this.lexer.reset(mark);
                SQLCreateTableParser createTableParser = this.getSQLCreateTableParser();
                SQLCreateTableStatement stmt = createTableParser.parseCreateTable();
                if (temporary) {
                    if (global) {
                        stmt.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
                    } else {
                        stmt.setType(SQLCreateTableStatement.Type.TEMPORARY);
                    }
                }
                if (comments != null) {
                    stmt.addBeforeComment(comments);
                }
                return stmt;
            }
            case INDEX: 
            case UNIQUE: {
                SQLCreateIndexStatement createIndex = this.parseCreateIndex(false);
                if (nonclustered) {
                    createIndex.setType("NONCLUSTERED");
                }
                return createIndex;
            }
            case SEQUENCE: {
                return this.parseCreateSequence(false);
            }
            case DATABASE: {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("LINK")) {
                    this.lexer.reset(mark);
                    return this.parseCreateDbLink();
                }
                this.lexer.reset(mark);
                SQLStatement stmt = this.parseCreateDatabase();
                if (comments != null) {
                    stmt.addBeforeComment(comments);
                    comments = null;
                }
                return stmt;
            }
            case SCHEMA: {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("LINK")) {
                    this.lexer.reset(mark);
                    return this.parseCreateDbLink();
                }
                this.lexer.reset(mark);
                SQLStatement stmt = this.parseCreateSchema();
                if (comments != null) {
                    stmt.addBeforeComment(comments);
                    comments = null;
                }
                return stmt;
            }
            case USER: {
                this.lexer.reset(mark);
                return this.parseCreateUser();
            }
            case FUNCTION: {
                SQLCreateFunctionStatement createFunct;
                this.lexer.reset(mark);
                SQLCreateFunctionStatement stmt = createFunct = this.parseCreateFunction();
                return stmt;
            }
        }
        if (token == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.PROCEDURE) {
                this.lexer.reset(mark);
                return this.parseCreateProcedure();
            }
            if (this.lexer.token == Token.VIEW) {
                this.lexer.reset(mark);
                return this.parseCreateView();
            }
            if (this.lexer.token == Token.TRIGGER) {
                this.lexer.reset(mark);
                return this.parseCreateTrigger();
            }
            if (this.lexer.token == Token.FUNCTION || this.lexer.identifierEquals(FnvHash.Constants.SQL)) {
                this.lexer.reset(mark);
                return this.parseCreateFunction();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.PACKAGE)) {
                this.lexer.reset(mark);
                return this.parseCreatePackage();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TYPE)) {
                this.lexer.reset(mark);
                return this.parseCreateType();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.PUBLIC)) {
                this.lexer.reset(mark);
                return this.parseCreateSynonym();
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.SYNONYM)) {
                this.lexer.reset(mark);
                return this.parseCreateSynonym();
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PUBLIC)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("SYNONYM")) {
                this.lexer.reset(mark);
                return this.parseCreateSynonym();
            }
            this.lexer.reset(mark);
            return this.parseCreateDbLink();
        }
        if (this.lexer.identifierEquals("SHARE")) {
            this.lexer.reset(mark);
            return this.parseCreateDbLink();
        }
        if (this.lexer.identifierEquals("SYNONYM")) {
            this.lexer.reset(mark);
            return this.parseCreateSynonym();
        }
        if (token == Token.VIEW) {
            return this.parseCreateView();
        }
        if (token == Token.TRIGGER) {
            this.lexer.reset(mark);
            return this.parseCreateTrigger();
        }
        if (token == Token.PROCEDURE) {
            SQLCreateProcedureStatement stmt = this.parseCreateProcedure();
            stmt.setCreate(true);
            return stmt;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.BITMAP)) {
            this.lexer.reset(mark);
            return this.parseCreateIndex(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.MATERIALIZED)) {
            this.lexer.reset(mark);
            return this.parseCreateMaterializedView();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TYPE)) {
            this.lexer.reset(mark);
            return this.parseCreateType();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.reset(mark);
            SQLCreateTableStatement createTable = this.parseCreateTable();
            if (comments != null) {
                createTable.addBeforeComment(comments);
                comments = null;
            }
            return createTable;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TABLEGROUP)) {
            this.lexer.reset(mark);
            return this.parseCreateTableGroup();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SQL) && this.dbType == DbType.odps) {
            this.lexer.reset(mark);
            return this.parseCreateFunction();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DIMENSION)) {
            this.lexer.reset(mark);
            return this.parseCreateTable();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ROLE)) {
            this.lexer.reset(mark);
            return this.parseCreateRole();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RESOURCE)) {
            this.lexer.reset(mark);
            return this.parseCreateResourceGroup();
        }
        if (this.lexer.token() == Token.FOREIGN) {
            this.lexer.reset(mark);
            return this.parseCreateTable();
        }
        throw new ParserException("TODO " + this.lexer.info());
    }

    public SQLStatement parseCreateRole() {
        this.accept(Token.CREATE);
        this.acceptIdentifier("ROLE");
        SQLName name = this.exprParser.name();
        SQLCreateRoleStatement stmt = new SQLCreateRoleStatement(this.dbType);
        stmt.setName(name);
        return stmt;
    }

    public SQLStatement parseCreateType() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateTableGroup() {
        this.accept(Token.CREATE);
        this.acceptIdentifier("TABLEGROUP");
        SQLCreateTableGroupStatement stmt = new SQLCreateTableGroupStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.IF)) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        if (this.lexer.token == Token.PARTITION || this.lexer.identifierEquals("PARTITION")) {
            this.lexer.nextToken();
            this.acceptIdentifier("NUM");
            SQLExpr num = this.exprParser.expr();
            stmt.setPartitionNum(num);
        }
        return stmt;
    }

    public SQLStatement parseCreateUser() {
        this.accept(Token.CREATE);
        this.accept(Token.USER);
        SQLCreateUserStatement stmt = new SQLCreateUserStatement();
        stmt.setUser(this.exprParser.name());
        this.acceptIdentifier("IDENTIFIED");
        this.accept(Token.BY);
        stmt.setPassword(this.exprParser.primary());
        return stmt;
    }

    public SQLCreateFunctionStatement parseCreateFunction() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateMaterializedView() {
        this.accept(Token.CREATE);
        this.acceptIdentifier("MATERIALIZED");
        this.accept(Token.VIEW);
        SQLCreateMaterializedViewStatement stmt = new SQLCreateMaterializedViewStatement();
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.dbType == DbType.mysql) {
            stmt.setDbType(DbType.mysql);
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                while (true) {
                    MySqlTableIndex idx;
                    Token token = this.lexer.token;
                    if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED)) {
                        this.lexer.nextToken();
                        if (this.lexer.token() == Token.KEY) {
                            MySqlKey clsKey = new MySqlKey();
                            this.exprParser.parseIndex(clsKey.getIndexDefinition());
                            clsKey.setIndexType("CLUSTERED");
                            clsKey.setParent(stmt);
                            stmt.getTableElementList().add(clsKey);
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                        } else if (this.lexer.token() == Token.INDEX) {
                            idx = new MySqlTableIndex();
                            this.exprParser.parseIndex(idx.getIndexDefinition());
                            idx.setIndexType("CLUSTERED");
                            idx.setParent(stmt);
                            stmt.getTableElementList().add(idx);
                            if (this.lexer.token() == Token.RPAREN) break;
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                        }
                    }
                    if (token == Token.IDENTIFIER) {
                        SQLColumnDefinition column = this.exprParser.parseColumn(stmt);
                        stmt.getTableElementList().add(column);
                    } else if (token == Token.PRIMARY || token == Token.UNIQUE || token == Token.CHECK || token == Token.CONSTRAINT || token == Token.FOREIGN) {
                        SQLConstraint constraint = this.exprParser.parseConstaint();
                        constraint.setParent(stmt);
                        stmt.getTableElementList().add((SQLTableElement)((Object)constraint));
                    } else if (this.lexer.token() == Token.INDEX) {
                        idx = new MySqlTableIndex();
                        this.exprParser.parseIndex(idx.getIndexDefinition());
                        idx.setParent(stmt);
                        stmt.getTableElementList().add(idx);
                    } else if (this.lexer.token() == Token.KEY) {
                        Lexer.SavePoint savePoint = this.lexer.mark();
                        this.lexer.nextToken();
                        boolean isColumn = false;
                        if (this.lexer.identifierEquals(FnvHash.Constants.VARCHAR)) {
                            isColumn = true;
                        }
                        this.lexer.reset(savePoint);
                        if (isColumn) {
                            stmt.getTableElementList().add(this.exprParser.parseColumn());
                            continue;
                        }
                        SQLName name = null;
                        if (this.lexer.token() == Token.IDENTIFIER) {
                            name = this.exprParser.name();
                        }
                        MySqlKey key = new MySqlKey();
                        this.exprParser.parseIndex(key.getIndexDefinition());
                        if (name != null) {
                            key.setName(name);
                        }
                        key.setParent(stmt);
                        stmt.getTableElementList().add(key);
                        continue;
                    }
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            while (true) {
                if (this.lexer.identifierEquals(FnvHash.Constants.DISTRIBUTED)) {
                    this.lexer.nextToken();
                    this.accept(Token.BY);
                    if (this.lexer.identifierEquals(FnvHash.Constants.HASH)) {
                        this.lexer.nextToken();
                        this.accept(Token.LPAREN);
                        while (true) {
                            SQLName name = this.exprParser.name();
                            stmt.getDistributedBy().add(name);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        this.accept(Token.RPAREN);
                        stmt.setDistributedByType(new SQLIdentifierExpr("HASH"));
                        continue;
                    }
                    if (!this.lexer.identifierEquals(FnvHash.Constants.BROADCAST)) continue;
                    this.lexer.nextToken();
                    stmt.setDistributedByType(new SQLIdentifierExpr("BROADCAST"));
                    continue;
                }
                if (this.lexer.identifierEquals("INDEX_ALL")) {
                    this.lexer.nextToken();
                    this.accept(Token.EQ);
                    if (this.lexer.token() != Token.LITERAL_CHARS) continue;
                    if ("Y".equalsIgnoreCase(this.lexer.stringVal())) {
                        this.lexer.nextToken();
                        stmt.addOption("INDEX_ALL", new SQLCharExpr("Y"));
                        continue;
                    }
                    if ("N".equalsIgnoreCase(this.lexer.stringVal())) {
                        this.lexer.nextToken();
                        stmt.addOption("INDEX_ALL", new SQLCharExpr("N"));
                        continue;
                    }
                    throw new ParserException("INDEX_ALL accept parameter ['Y' or 'N'] only.");
                }
                if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE)) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.EQ) {
                        this.lexer.nextToken();
                    }
                    SQLExpr expr = this.exprParser.expr();
                    stmt.addOption("ENGINE", expr);
                    continue;
                }
                if (this.lexer.token == Token.PARTITION) {
                    SQLPartitionBy partitionBy = this.exprParser.parsePartitionBy();
                    stmt.setPartitionBy(partitionBy);
                    continue;
                }
                if (this.lexer.token() == Token.COMMENT) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.EQ) {
                        this.lexer.nextToken();
                    }
                    stmt.setComment(this.exprParser.expr());
                    continue;
                }
                break;
            }
        } else if (this.dbType == DbType.odps) {
            if (this.lexer.identifierEquals(FnvHash.Constants.LIFECYCLE)) {
                this.lexer.nextToken();
                stmt.setLifyCycle(this.exprParser.primary());
            }
            if (this.lexer.token == Token.PARTITIONED) {
                this.lexer.nextToken();
                this.accept(Token.ON);
                this.accept(Token.LPAREN);
                this.exprParser.names(stmt.getPartitionedOn(), stmt);
                this.accept(Token.RPAREN);
            }
        } else if (this.lexer.token == Token.PARTITION) {
            SQLPartitionBy partitionBy = this.exprParser.parsePartitionBy();
            stmt.setPartitionBy(partitionBy);
        }
        while (true) {
            if (this.exprParser instanceof OracleExprParser) {
                ((OracleExprParser)this.exprParser).parseSegmentAttributes(stmt);
            }
            if (this.lexer.identifierEquals("REFRESH")) {
                this.lexer.nextToken();
                boolean refresh = false;
                while (true) {
                    if (this.lexer.identifierEquals("FAST")) {
                        this.lexer.nextToken();
                        stmt.setRefreshFast(true);
                        refresh = true;
                        continue;
                    }
                    if (this.lexer.identifierEquals("COMPLETE")) {
                        this.lexer.nextToken();
                        stmt.setRefreshComplete(true);
                        refresh = true;
                        continue;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
                        this.lexer.nextToken();
                        stmt.setRefreshForce(true);
                        refresh = true;
                        continue;
                    }
                    if (this.lexer.token == Token.ON) {
                        this.lexer.nextToken();
                        if (this.lexer.token == Token.COMMIT || this.lexer.identifierEquals(FnvHash.Constants.COMMIT)) {
                            this.lexer.nextToken();
                            stmt.setRefreshOnCommit(true);
                            refresh = true;
                            continue;
                        }
                        if (this.lexer.identifierEquals(FnvHash.Constants.OVERWRITE)) {
                            this.lexer.nextToken();
                            stmt.setRefreshOnOverWrite(true);
                            refresh = true;
                            continue;
                        }
                        this.acceptIdentifier("DEMAND");
                        stmt.setRefreshOnDemand(true);
                        refresh = true;
                        continue;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.START)) {
                        this.lexer.nextToken();
                        this.accept(Token.WITH);
                        SQLExpr startWith = this.exprParser.expr();
                        stmt.setStartWith(startWith);
                        stmt.setRefreshStartWith(true);
                        refresh = true;
                        continue;
                    }
                    if (!this.lexer.identifierEquals(FnvHash.Constants.NEXT)) break;
                    this.lexer.nextToken();
                    SQLExpr next = this.exprParser.expr();
                    stmt.setNext(next);
                    stmt.setRefreshNext(true);
                    refresh = true;
                }
                if (refresh) continue;
                throw new ParserException("refresh clause is empty. " + this.lexer.info());
            }
            if (this.lexer.identifierEquals("BUILD")) {
                this.lexer.nextToken();
                if (this.lexer.identifierEquals("IMMEDIATE") || this.lexer.token == Token.IMMEDIATE) {
                    this.lexer.nextToken();
                    stmt.setBuildImmediate(true);
                    continue;
                }
                this.accept(Token.DEFERRED);
                stmt.setBuildDeferred(true);
                continue;
            }
            if (this.lexer.identifierEquals("PARALLEL")) {
                this.lexer.nextToken();
                stmt.setParallel(true);
                if (this.lexer.token != Token.LITERAL_INT) continue;
                stmt.setParallelValue(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.NOCACHE) || this.lexer.token == Token.NOCACHE) {
                this.lexer.nextToken();
                stmt.setCache(false);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.NOPARALLEL)) {
                this.lexer.nextToken();
                stmt.setParallel(false);
                continue;
            }
            if (this.lexer.token != Token.WITH) break;
            this.lexer.nextToken();
            this.acceptIdentifier("ROWID");
            stmt.setWithRowId(true);
        }
        Boolean enableQueryRewrite = null;
        if (this.lexer.token == Token.ENABLE) {
            this.lexer.nextToken();
            enableQueryRewrite = true;
        }
        if (this.lexer.token == Token.DISABLE) {
            this.lexer.nextToken();
            enableQueryRewrite = false;
        }
        if (enableQueryRewrite != null) {
            this.acceptIdentifier("QUERY");
            this.acceptIdentifier("REWRITE");
            stmt.setEnableQueryRewrite(enableQueryRewrite);
        }
        this.accept(Token.AS);
        SQLSelect select = this.createSQLSelectParser().select();
        stmt.setQuery(select);
        return stmt;
    }

    public SQLStatement parseCreateDbLink() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateSynonym() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateExternalCatalog() {
        MySqlCreateExternalCatalogStatement stmt = new MySqlCreateExternalCatalogStatement();
        if (this.lexer.token == Token.CREATE) {
            this.lexer.nextToken();
        }
        this.acceptIdentifier("EXTERNAL");
        this.acceptIdentifier("CATALOG");
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        this.acceptIdentifier("PROPERTIES");
        this.accept(Token.LPAREN);
        do {
            SQLName key = this.exprParser.name();
            this.accept(Token.EQ);
            SQLName value = this.exprParser.name();
            stmt.getProperties().put(key, value);
        } while (this.lexer.token != Token.RPAREN);
        this.accept(Token.RPAREN);
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            SQLName comment = this.exprParser.name();
            stmt.setComment(comment);
        }
        return stmt;
    }

    public SQLStatement parseCreateTrigger() {
        List<SQLStatement> body;
        SQLCreateTriggerStatement stmt = new SQLCreateTriggerStatement(this.getDbType());
        if (this.lexer.token == Token.CREATE) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.OR) {
                this.lexer.nextToken();
                this.accept(Token.REPLACE);
                stmt.setOrReplace(true);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DEFINER)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLName definer = ((MySqlExprParser)this.exprParser).userName();
            stmt.setDefiner(definer);
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                this.accept(Token.RPAREN);
            }
        }
        this.accept(Token.TRIGGER);
        stmt.setName(this.exprParser.name());
        if (this.lexer.identifierEquals(FnvHash.Constants.BEFORE)) {
            stmt.setTriggerType(SQLCreateTriggerStatement.TriggerType.BEFORE);
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals(FnvHash.Constants.AFTER)) {
            stmt.setTriggerType(SQLCreateTriggerStatement.TriggerType.AFTER);
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals(FnvHash.Constants.INSTEAD)) {
            this.lexer.nextToken();
            this.accept(Token.OF);
            stmt.setTriggerType(SQLCreateTriggerStatement.TriggerType.INSTEAD_OF);
        }
        while (true) {
            if (this.lexer.token == Token.INSERT) {
                this.lexer.nextToken();
                stmt.setInsert(true);
            } else if (this.lexer.token == Token.UPDATE) {
                this.lexer.nextToken();
                stmt.setUpdate(true);
                if (this.lexer.token == Token.OF) {
                    this.lexer.nextToken();
                    this.exprParser.names(stmt.getUpdateOfColumns(), stmt);
                }
            } else if (this.lexer.token == Token.DELETE) {
                this.lexer.nextToken();
                stmt.setDelete(true);
            }
            if (this.lexer.token != Token.COMMA && this.lexer.token != Token.OR) break;
            this.lexer.nextToken();
        }
        this.accept(Token.ON);
        stmt.setOn(this.exprParser.name());
        if (this.lexer.token == Token.FOR) {
            this.lexer.nextToken();
            this.acceptIdentifier("EACH");
            this.accept(Token.ROW);
            stmt.setForEachRow(true);
        }
        if (this.lexer.token == Token.WHEN) {
            this.lexer.nextToken();
            SQLExpr condition = this.exprParser.expr();
            stmt.setWhen(condition);
        }
        if ((body = this.parseStatementList()) == null || body.isEmpty()) {
            throw new ParserException("syntax error");
        }
        stmt.setBody(body.get(0));
        return stmt;
    }

    public SQLStatement parseBlock() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    public SQLStatement parseCreateSchema() {
        throw new ParserException("TODO " + this.lexer.info());
    }

    public SQLStatement parseCreateDatabase() {
        SQLExpr comment;
        SQLCreateDatabaseStatement stmt = new SQLCreateDatabaseStatement(this.dbType);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            stmt.addBeforeComment(this.lexer.readAndResetComments());
        }
        if (this.lexer.token == Token.CREATE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.SCHEMA && this.dbType == DbType.hive) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.DATABASE);
        }
        if (this.lexer.token == Token.IF || this.lexer.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token == Token.COMMENT) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.EQ) {
                this.lexer.nextToken();
            }
            comment = this.exprParser.expr();
            stmt.setComment(comment);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
            this.lexer.nextToken();
            SQLExpr location = this.exprParser.expr();
            stmt.setLocation(location);
        }
        if (this.lexer.token == Token.WITH) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.DBPROPERTIES)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                while (true) {
                    SQLAssignItem assignItem = this.exprParser.parseAssignItem();
                    assignItem.setParent(stmt);
                    stmt.getDbProperties().add(assignItem);
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            } else {
                throw new ParserException("TODO " + this.lexer.info());
            }
        }
        if (this.lexer.token == Token.COMMENT) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.EQ) {
                this.lexer.nextToken();
            }
            comment = this.exprParser.expr();
            stmt.setComment(comment);
        }
        return stmt;
    }

    public SQLCreateProcedureStatement parseCreateProcedure() {
        throw new ParserException("TODO " + (Object)((Object)this.lexer.token));
    }

    public SQLStatement parseCreateSequence(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        SQLCreateSequenceStatement stmt = new SQLCreateSequenceStatement();
        if (this.lexer.token == Token.GROUP) {
            this.lexer.nextToken();
            stmt.setGroup(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.SIMPLE)) {
            this.lexer.nextToken();
            stmt.setSimple(true);
            if (this.lexer.token == Token.WITH) {
                this.lexer.nextToken();
                this.accept(Token.CACHE);
                stmt.setWithCache(true);
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.TIME)) {
            this.lexer.nextToken();
            stmt.setTime(true);
        }
        this.accept(Token.SEQUENCE);
        stmt.setDbType(this.dbType);
        stmt.setName(this.exprParser.name());
        while (true) {
            if (this.lexer.token() == Token.START || this.lexer.identifierEquals(FnvHash.Constants.START)) {
                this.lexer.nextToken();
                this.accept(Token.WITH);
                stmt.setStartWith(this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.INCREMENT)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setIncrementBy(this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.CACHE || this.lexer.identifierEquals(FnvHash.Constants.CACHE)) {
                this.lexer.nextToken();
                stmt.setCache(Boolean.TRUE);
                if (this.lexer.token() != Token.LITERAL_INT) continue;
                stmt.setCacheValue(this.exprParser.primary());
                continue;
            }
            if (this.lexer.token == Token.WITH) {
                this.lexer.nextToken();
                this.accept(Token.CACHE);
                stmt.setCache(true);
                continue;
            }
            if (this.lexer.token() == Token.NOCACHE || this.lexer.identifierEquals(FnvHash.Constants.NOCACHE)) {
                this.lexer.nextToken();
                stmt.setCache(Boolean.FALSE);
                continue;
            }
            if (this.lexer.token() == Token.ORDER) {
                this.lexer.nextToken();
                stmt.setOrder(Boolean.TRUE);
                continue;
            }
            if (this.lexer.identifierEquals("NOORDER")) {
                this.lexer.nextToken();
                stmt.setOrder(Boolean.FALSE);
                continue;
            }
            if (this.lexer.identifierEquals("CYCLE")) {
                this.lexer.nextToken();
                stmt.setCycle(Boolean.TRUE);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.NOCYCLE)) {
                this.lexer.nextToken();
                stmt.setCycle(Boolean.FALSE);
                continue;
            }
            if (this.lexer.identifierEquals("MINVALUE")) {
                this.lexer.nextToken();
                stmt.setMinValue(this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("MAXVALUE")) {
                this.lexer.nextToken();
                stmt.setMaxValue(this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("NOMAXVALUE")) {
                this.lexer.nextToken();
                stmt.setNoMaxValue(true);
                continue;
            }
            if (!this.lexer.identifierEquals("NOMINVALUE")) break;
            this.lexer.nextToken();
            stmt.setNoMinValue(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.UNIT)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.COUNT)) {
                this.lexer.nextToken();
                SQLExpr unitCount = this.exprParser.primary();
                stmt.setUnitCount(unitCount);
            }
            if (this.lexer.token == Token.INDEX) {
                this.lexer.nextToken();
                SQLExpr unitIndex = this.exprParser.primary();
                stmt.setUnitIndex(unitIndex);
            }
            if (this.lexer.hashLCase() == FnvHash.Constants.STEP) {
                this.lexer.nextToken();
                SQLExpr step = this.exprParser.primary();
                stmt.setStep(step);
            }
        }
        return stmt;
    }

    public SQLCreateIndexStatement parseCreateIndex(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        SQLCreateIndexStatement stmt = new SQLCreateIndexStatement(this.getDbType());
        if (this.lexer.token == Token.UNIQUE) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("CLUSTERED")) {
                this.lexer.nextToken();
                stmt.setType("UNIQUE CLUSTERED");
            } else if (this.lexer.identifierEquals("NONCLUSTERED")) {
                stmt.setType("UNIQUE NONCLUSTERED");
                this.lexer.nextToken();
            } else {
                stmt.setType("UNIQUE");
            }
        } else if (this.lexer.token() == Token.FULLTEXT) {
            stmt.setType("FULLTEXT");
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals("NONCLUSTERED")) {
            stmt.setType("NONCLUSTERED");
            this.lexer.nextToken();
        }
        this.accept(Token.INDEX);
        stmt.setName(this.exprParser.name());
        this.accept(Token.ON);
        stmt.setTable(this.exprParser.name());
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            item.setParent(stmt);
            stmt.addItem(item);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return stmt;
    }

    public SQLCreateTableParser getSQLCreateTableParser() {
        return new SQLCreateTableParser(this.exprParser);
    }

    public SQLStatement parseSelect() {
        SQLSelectParser selectParser = this.createSQLSelectParser();
        SQLSelect select = selectParser.select();
        return new SQLSelectStatement(select, this.getDbType());
    }

    public SQLSelectParser createSQLSelectParser() {
        return new SQLSelectParser(this.exprParser, this.selectListCache);
    }

    public SQLSelectParser createSQLSelectParser(SQLExprParser exprParser) {
        return new SQLSelectParser(exprParser);
    }

    public SQLUpdateStatement parseUpdateStatement() {
        SQLUpdateStatement udpateStatement = this.createUpdateStatement();
        if (this.lexer.token == Token.UPDATE) {
            this.lexer.nextToken();
            SQLTableSource tableSource = this.exprParser.createSelectParser().parseTableSource();
            udpateStatement.setTableSource(tableSource);
        }
        if (this.dbType == DbType.odps && this.lexer.token == Token.PARTITION) {
            this.lexer.nextToken();
            udpateStatement.setPartitions(new ArrayList<SQLAssignItem>());
            this.exprParser.parseAssignItem(udpateStatement.getPartitions(), (SQLObject)udpateStatement);
        }
        this.parseUpdateSet(udpateStatement);
        if (this.lexer.token == Token.WHERE) {
            this.lexer.nextToken();
            udpateStatement.setWhere(this.exprParser.expr());
        }
        return udpateStatement;
    }

    protected void parseUpdateSet(SQLUpdateStatement update) {
        this.accept(Token.SET);
        if (this.lexer.token == Token.COMMA && this.dbType == DbType.odps) {
            this.lexer.nextToken();
        }
        while (true) {
            SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
            update.addItem(item);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    protected SQLUpdateStatement createUpdateStatement() {
        return new SQLUpdateStatement(this.getDbType());
    }

    public SQLDeleteStatement parseDeleteStatement() {
        SQLDeleteStatement deleteStatement = new SQLDeleteStatement(this.getDbType());
        if (this.lexer.token == Token.DELETE) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.FROM) {
                this.lexer.nextToken();
            }
            if (this.lexer.token == Token.COMMENT) {
                this.lexer.nextToken();
            }
            SQLName tableName = this.exprParser.name();
            deleteStatement.setTableName(tableName);
            if (this.lexer.token == Token.FROM) {
                this.lexer.nextToken();
                SQLTableSource tableSource = this.createSQLSelectParser().parseTableSource();
                deleteStatement.setFrom(tableSource);
            }
        }
        if (this.lexer.token == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            deleteStatement.setWhere(where);
        }
        return deleteStatement;
    }

    public SQLCreateTableStatement parseCreateTable() {
        SQLCreateTableParser parser = new SQLCreateTableParser(this.exprParser);
        return parser.parseCreateTable();
    }

    public SQLCreateViewStatement parseCreateView() {
        SQLCreateViewStatement createView = new SQLCreateViewStatement(this.getDbType());
        if (this.lexer.token == Token.CREATE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            createView.setOrReplace(true);
        }
        if (this.lexer.identifierEquals("ALGORITHM")) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            String algorithm = this.lexer.stringVal();
            createView.setAlgorithm(algorithm);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DEFINER)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLName definer = ((MySqlExprParser)this.exprParser).userName();
            createView.setDefiner(definer);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SQL)) {
            this.lexer.nextToken();
            this.acceptIdentifier("SECURITY");
            String sqlSecurity = this.lexer.stringVal();
            createView.setSqlSecurity(sqlSecurity);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
            this.lexer.nextToken();
            createView.setForce(true);
        }
        this.accept(Token.VIEW);
        if (this.lexer.token == Token.IF || this.lexer.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createView.setIfNotExists(true);
        }
        createView.setName(this.exprParser.name());
        if (this.dbType == DbType.clickhouse) {
            SQLName to;
            if (this.lexer.token == Token.ON) {
                this.lexer.nextToken();
                this.acceptIdentifier("CLUSTER");
                createView.setOnCluster(true);
            }
            if (this.lexer.token == Token.LITERAL_CHARS) {
                to = this.exprParser.name();
                createView.setTo(to);
            } else if (this.lexer.token == Token.TO) {
                this.lexer.nextToken();
                to = this.exprParser.name();
                createView.setTo(to);
            }
        }
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                if (this.lexer.token == Token.CONSTRAINT) {
                    SQLTableConstraint constraint = (SQLTableConstraint)this.exprParser.parseConstaint();
                    createView.addColumn(constraint);
                } else {
                    if (this.lexer.token == Token.RPAREN) break;
                    SQLColumnDefinition column = new SQLColumnDefinition();
                    column.setDbType(this.dbType);
                    SQLName expr = this.exprParser.name();
                    column.setName(expr);
                    if (this.dbType == DbType.odps && expr.getSimpleName().startsWith("@")) {
                        column.setDataType(this.exprParser.parseDataType());
                    }
                    this.exprParser.parseColumnRest(column);
                    if (this.lexer.token == Token.COMMENT) {
                        SQLExpr comment;
                        this.lexer.nextToken();
                        if (this.lexer.token == Token.LITERAL_ALIAS) {
                            String alias = this.lexer.stringVal();
                            if (alias.length() > 2 && alias.charAt(0) == '\"' && alias.charAt(alias.length() - 1) == '\"') {
                                alias = alias.substring(1, alias.length() - 1);
                            }
                            comment = new SQLCharExpr(alias);
                            this.lexer.nextToken();
                        } else {
                            comment = this.exprParser.primary();
                        }
                        column.setComment(comment);
                    }
                    column.setParent(createView);
                    createView.addColumn(column);
                }
                if (this.lexer.token != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals("RETURNS")) {
            this.lexer.nextToken();
            SQLVariantRefExpr varRef = (SQLVariantRefExpr)this.exprParser.expr();
            createView.setReturns(varRef);
            createView.setReturnsDataType((SQLTableDataType)this.exprParser.parseDataType());
        }
        if (this.lexer.token == Token.COMMENT) {
            this.lexer.nextToken();
            SQLCharExpr comment = (SQLCharExpr)this.exprParser.primary();
            createView.setComment(comment);
        }
        this.accept(Token.AS);
        if (this.lexer.identifierEquals(FnvHash.Constants.BEGIN)) {
            SQLBlockStatement block = (SQLBlockStatement)this.parseBlock();
            createView.setScript(block);
            return createView;
        }
        SQLSelectParser selectParser = this.createSQLSelectParser();
        createView.setSubQuery(selectParser.select());
        if (this.lexer.token == Token.WITH) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("CASCADED")) {
                createView.setWithCascaded(true);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("LOCAL")) {
                createView.setWithLocal(true);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("READ")) {
                this.lexer.nextToken();
                this.accept(Token.ONLY);
                createView.setWithReadOnly(true);
            }
            if (this.lexer.token == Token.CHECK) {
                this.lexer.nextToken();
                this.acceptIdentifier("OPTION");
                createView.setWithCheckOption(true);
            }
        }
        return createView;
    }

    public SQLCommentStatement parseComment() {
        this.accept(Token.COMMENT);
        SQLCommentStatement stmt = new SQLCommentStatement();
        this.accept(Token.ON);
        if (this.lexer.token == Token.TABLE) {
            stmt.setType(SQLCommentStatement.Type.TABLE);
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.COLUMN) {
            stmt.setType(SQLCommentStatement.Type.COLUMN);
            this.lexer.nextToken();
        }
        stmt.setOn(this.exprParser.name());
        this.accept(Token.IS);
        stmt.setComment(this.exprParser.expr());
        return stmt;
    }

    protected SQLAlterTableAddColumn parseAlterTableAddColumn() {
        boolean odps = DbType.odps == this.dbType || DbType.hive == this.dbType;
        boolean columns = false;
        if (odps) {
            if (this.lexer.identifierEquals("COLUMNS")) {
                this.lexer.nextToken();
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    columns = true;
                }
            } else if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                columns = true;
            }
        }
        SQLAlterTableAddColumn item = new SQLAlterTableAddColumn();
        do {
            SQLColumnDefinition columnDef = this.exprParser.parseColumn();
            item.addColumn(columnDef);
            if (this.lexer.token == Token.WITH) {
                Lexer.SavePoint mark = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token == Token.DEFAULT) {
                    this.lexer.nextToken();
                    SQLExpr defaultExpr = this.exprParser.expr();
                    columnDef.setDefaultExpr(defaultExpr);
                } else {
                    this.lexer.reset(mark);
                }
            }
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        } while (!this.lexer.identifierEquals("ADD"));
        if (odps && columns) {
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RESTRICT)) {
            this.lexer.nextToken();
            item.setRestrict(true);
        } else if (this.lexer.token() == Token.CASCADE || this.lexer.identifierEquals(FnvHash.Constants.CASCADE)) {
            this.lexer.nextToken();
            item.setCascade(true);
        } else {
            item.setCascade(false);
        }
        return item;
    }

    protected SQLAlterTableReplaceColumn parseAlterTableReplaceColumn() {
        this.accept(Token.REPLACE);
        this.acceptIdentifier("COLUMNS");
        SQLAlterTableReplaceColumn item = new SQLAlterTableReplaceColumn();
        this.accept(Token.LPAREN);
        do {
            SQLColumnDefinition columnDef = this.exprParser.parseColumn();
            item.addColumn(columnDef);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        } while (!this.lexer.identifierEquals(FnvHash.Constants.ADD));
        this.accept(Token.RPAREN);
        return item;
    }

    public SQLStatement parseStatement() {
        if (this.lexer.token == Token.SELECT) {
            return this.parseSelect();
        }
        if (this.lexer.token == Token.INSERT) {
            return this.parseInsert();
        }
        if (this.lexer.token == Token.UPDATE) {
            return this.parseUpdateStatement();
        }
        if (this.lexer.token == Token.DELETE) {
            return this.parseDeleteStatement();
        }
        ArrayList<SQLStatement> list = new ArrayList<SQLStatement>(1);
        this.parseStatementList(list, 1, null);
        return (SQLStatement)list.get(0);
    }

    public SQLStatement parseStatement(boolean tryBest) {
        ArrayList<SQLStatement> list = new ArrayList<SQLStatement>();
        this.parseStatementList(list, 1, null);
        if (tryBest && this.lexer.token != Token.EOF) {
            throw new ParserException("sql syntax error, no terminated. " + this.lexer.info());
        }
        return (SQLStatement)list.get(0);
    }

    public SQLExplainStatement parseExplain() {
        this.accept(Token.EXPLAIN);
        if (this.lexer.identifierEquals("PLAN")) {
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.FOR) {
            this.lexer.nextToken();
        }
        SQLExplainStatement explain = new SQLExplainStatement(this.dbType);
        if (this.lexer.token == Token.ANALYZE || this.lexer.identifierEquals(FnvHash.Constants.ANALYZE)) {
            this.lexer.nextToken();
            explain.setType("ANALYZE");
        }
        if (this.lexer.token == Token.HINT) {
            explain.setHints(this.exprParser.parseHints());
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTENDED)) {
            this.lexer.nextToken();
            explain.setExtended(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DEPENDENCY)) {
            this.lexer.nextToken();
            explain.setDependency(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.AUTHORIZATION)) {
            this.lexer.nextToken();
            explain.setAuthorization(true);
        }
        if (DbType.mysql == this.dbType && (this.lexer.identifierEquals("FORMAT") || this.lexer.identifierEquals("PARTITIONS"))) {
            explain.setType(this.lexer.stringVal);
            this.lexer.nextToken();
        }
        if ((DbType.mysql == this.dbType || DbType.ads == this.dbType || DbType.presto == this.dbType || DbType.trino == this.dbType) && this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("FORMAT")) {
                this.lexer.nextToken();
                String type = "FORMAT " + this.lexer.stringVal;
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("TYPE")) {
                this.lexer.nextToken();
                String type = "TYPE " + this.lexer.stringVal;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        explain.setStatement(this.parseStatement());
        return explain;
    }

    protected SQLAlterTableAddClusteringKey parseAlterTableAddClusteringKey() {
        this.lexer.nextToken();
        SQLAlterTableAddClusteringKey item = new SQLAlterTableAddClusteringKey();
        this.accept(Token.KEY);
        item.setName(this.exprParser.name());
        this.accept(Token.LPAREN);
        while (true) {
            item.getColumns().add(this.exprParser.name());
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return item;
    }

    public SQLOpenStatement parseOpen() {
        SQLName cursorName;
        SQLOpenStatement stmt = new SQLOpenStatement();
        this.accept(Token.OPEN);
        if (this.lexer.token == Token.QUES) {
            this.lexer.nextToken();
            cursorName = new SQLIdentifierExpr("?");
        } else {
            cursorName = this.exprParser.name();
        }
        stmt.setCursorName(cursorName);
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.names(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token == Token.FOR) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.SELECT) {
                SQLSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect select = selectParser.select();
                SQLQueryExpr queryExpr = new SQLQueryExpr(select);
                stmt.setFor(queryExpr);
            } else if (this.lexer.token == Token.LITERAL_CHARS) {
                String chars = this.lexer.stringVal;
                SQLExprParser exprParser = SQLParserUtils.createExprParser(chars, this.dbType, new SQLParserFeature[0]);
                SQLSelectParser selectParser = this.createSQLSelectParser(exprParser);
                SQLSelect select = selectParser.select();
                SQLQueryExpr queryExpr = new SQLQueryExpr(select);
                stmt.setFor(queryExpr);
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.QUES) {
                this.lexer.nextToken();
                stmt.setFor(new SQLVariantRefExpr("?"));
            } else {
                throw new ParserException("TODO " + this.lexer.info());
            }
        }
        if (this.lexer.token == Token.USING) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getUsing(), stmt);
        }
        this.accept(Token.SEMI);
        stmt.setAfterSemi(true);
        return stmt;
    }

    public SQLFetchStatement parseFetch() {
        this.accept(Token.FETCH);
        SQLFetchStatement stmt = new SQLFetchStatement();
        stmt.setCursorName(this.exprParser.name());
        if (this.lexer.identifierEquals("BULK")) {
            this.lexer.nextToken();
            this.acceptIdentifier("COLLECT");
            stmt.setBulkCollect(true);
        }
        this.accept(Token.INTO);
        while (true) {
            stmt.getInto().add(this.exprParser.name());
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.LIMIT) {
            SQLLimit limit = this.exprParser.parseLimit();
            stmt.setLimit(limit);
        }
        return stmt;
    }

    public SQLStatement parseClose() {
        SQLCloseStatement stmt = new SQLCloseStatement();
        this.accept(Token.CLOSE);
        stmt.setCursorName(this.exprParser.name());
        this.accept(Token.SEMI);
        stmt.setAfterSemi(true);
        return stmt;
    }

    public boolean isParseCompleteValues() {
        return this.parseCompleteValues;
    }

    public void setParseCompleteValues(boolean parseCompleteValues) {
        this.parseCompleteValues = parseCompleteValues;
    }

    public int getParseValuesSize() {
        return this.parseValuesSize;
    }

    public void setParseValuesSize(int parseValuesSize) {
        this.parseValuesSize = parseValuesSize;
    }

    public SQLStatement parseMerge() {
        if (this.lexer.identifierEquals(FnvHash.Constants.MERGE)) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.MERGE);
        }
        SQLMergeStatement stmt = new SQLMergeStatement();
        stmt.setDbType(this.dbType);
        this.parseHints(stmt.getHints());
        this.accept(Token.INTO);
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelect select = this.createSQLSelectParser().select();
            SQLSubqueryTableSource tableSource = new SQLSubqueryTableSource(select);
            stmt.setInto(tableSource);
            this.accept(Token.RPAREN);
        } else {
            stmt.setInto(this.exprParser.name());
        }
        stmt.getInto().setAlias(this.tableAlias());
        if (this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.USING);
        }
        SQLTableSource using = this.createSQLSelectParser().parseTableSource();
        stmt.setUsing(using);
        this.accept(Token.ON);
        stmt.setOn(this.exprParser.expr());
        do {
            boolean insertFlag = false;
            if (this.lexer.token == Token.WHEN) {
                this.lexer.nextToken();
                if (this.lexer.token == Token.MATCHED || this.lexer.identifierEquals(FnvHash.Constants.MATCHED)) {
                    SQLMergeStatement.MergeUpdateClause updateClause = new SQLMergeStatement.MergeUpdateClause();
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.AND) {
                        this.lexer.nextToken();
                        SQLExpr where = this.exprParser.expr();
                        updateClause.setWhere(where);
                    }
                    this.accept(Token.THEN);
                    if (this.lexer.token == Token.DELETE) {
                        this.lexer.nextToken();
                        updateClause.setDelete(true);
                        stmt.setUpdateClause(updateClause);
                        break;
                    }
                    this.accept(Token.UPDATE);
                    this.accept(Token.SET);
                    while (true) {
                        SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
                        updateClause.addItem(item);
                        item.setParent(updateClause);
                        if (this.lexer.token != Token.COMMA) break;
                        this.lexer.nextToken();
                    }
                    if (this.lexer.token == Token.WHERE) {
                        this.lexer.nextToken();
                        updateClause.setWhere(this.exprParser.expr());
                    }
                    SQLExpr deleteWhere = null;
                    if (this.lexer.token == Token.WHEN) {
                        Lexer.SavePoint savePoint = this.lexer.mark();
                        this.lexer.nextToken();
                        if (this.lexer.token == Token.MATCHED) {
                            this.lexer.nextToken();
                            if (this.lexer.token == Token.AND) {
                                this.lexer.nextToken();
                                deleteWhere = this.exprParser.expr();
                            }
                            if (this.lexer.token == Token.THEN) {
                                this.lexer.nextToken();
                                if (this.lexer.token == Token.DELETE) {
                                    this.lexer.nextToken();
                                    updateClause.setDeleteWhere(deleteWhere);
                                } else {
                                    deleteWhere = null;
                                }
                            } else {
                                deleteWhere = null;
                            }
                            if (deleteWhere == null) {
                                this.lexer.reset(savePoint);
                            }
                        }
                    }
                    if (this.lexer.token == Token.DELETE) {
                        this.lexer.nextToken();
                        this.accept(Token.WHERE);
                        updateClause.setDeleteWhere(this.exprParser.expr());
                    }
                    stmt.setUpdateClause(updateClause);
                } else if (this.lexer.token == Token.NOT) {
                    this.lexer.nextToken();
                    insertFlag = true;
                }
            }
            if (!insertFlag) {
                if (this.lexer.token == Token.WHEN) {
                    this.lexer.nextToken();
                }
                if (this.lexer.token == Token.NOT) {
                    this.lexer.nextToken();
                    insertFlag = true;
                }
            }
            if (!insertFlag) continue;
            SQLMergeStatement.MergeInsertClause insertClause = new SQLMergeStatement.MergeInsertClause();
            if (this.lexer.identifierEquals(FnvHash.Constants.MATCHED)) {
                this.lexer.nextToken();
            } else {
                this.accept(Token.MATCHED);
            }
            if (this.lexer.token == Token.AND) {
                this.lexer.nextToken();
                insertClause.setWhere(this.exprParser.expr());
            }
            this.accept(Token.THEN);
            this.accept(Token.INSERT);
            if (this.lexer.token == Token.LPAREN) {
                this.accept(Token.LPAREN);
                this.exprParser.exprList(insertClause.getColumns(), insertClause);
                this.accept(Token.RPAREN);
            }
            this.accept(Token.VALUES);
            this.accept(Token.LPAREN);
            this.exprParser.exprList(insertClause.getValues(), insertClause);
            this.accept(Token.RPAREN);
            if (this.lexer.token == Token.WHERE) {
                this.lexer.nextToken();
                insertClause.setWhere(this.exprParser.expr());
            }
            stmt.setInsertClause(insertClause);
        } while (this.lexer.token == Token.WHEN);
        SQLErrorLoggingClause errorClause = this.parseErrorLoggingClause();
        stmt.setErrorLoggingClause(errorClause);
        return stmt;
    }

    protected SQLErrorLoggingClause parseErrorLoggingClause() {
        if (this.lexer.identifierEquals("LOG")) {
            SQLErrorLoggingClause errorClause = new SQLErrorLoggingClause();
            this.lexer.nextToken();
            this.accept(Token.ERRORS);
            if (this.lexer.token == Token.INTO) {
                this.lexer.nextToken();
                errorClause.setInto(this.exprParser.name());
            }
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                errorClause.setSimpleExpression(this.exprParser.expr());
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token == Token.REJECT) {
                this.lexer.nextToken();
                this.accept(Token.LIMIT);
                errorClause.setLimit(this.exprParser.expr());
            }
            return errorClause;
        }
        return null;
    }

    public void parseHints(List<SQLHint> hints) {
        this.getExprParser().parseHints(hints);
    }

    public SQLStatement parseDescribe() {
        SQLName column;
        if (this.lexer.token != Token.DESC && !this.lexer.identifierEquals("DESCRIBE")) {
            throw new ParserException("expect DESC, actual " + (Object)((Object)this.lexer.token));
        }
        this.lexer.nextToken();
        SQLDescribeStatement stmt = new SQLDescribeStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token == Token.DATABASE) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.DATABASE);
        } else if (this.lexer.token == Token.SCHEMA) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.SCHEMA);
        } else if (this.lexer.identifierEquals("ROLE")) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.ROLE);
        } else if (this.lexer.identifierEquals("PACKAGE")) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.PACKAGE);
        } else if (this.lexer.identifierEquals("INSTANCE")) {
            this.lexer.nextToken();
            stmt.setObjectType(SQLObjectType.INSTANCE);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTENDED)) {
            this.lexer.nextToken();
            stmt.setExtended(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.FORMATTED)) {
            this.lexer.nextToken();
            stmt.setFormatted(true);
        }
        stmt.setObject(this.exprParser.name());
        if (this.lexer.token == Token.IDENTIFIER) {
            column = this.exprParser.name();
            stmt.setColumn(column);
        }
        if (this.lexer.token == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                stmt.getPartition().add(this.exprParser.expr());
                if (this.lexer.token == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                if (this.lexer.token == Token.RPAREN) break;
            }
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.IDENTIFIER && stmt.getColumn() == null) {
            column = this.exprParser.name();
            stmt.setColumn(column);
        }
        return stmt;
    }

    public SQLWithSubqueryClause parseWithQuery() {
        SQLWithSubqueryClause withQueryClause = new SQLWithSubqueryClause();
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            withQueryClause.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.WITH);
        if (this.lexer.token == Token.RECURSIVE || this.lexer.identifierEquals("RECURSIVE")) {
            this.lexer.nextToken();
            withQueryClause.setRecursive(true);
        }
        while (true) {
            SQLWithSubqueryClause.Entry entry = new SQLWithSubqueryClause.Entry();
            entry.setParent(withQueryClause);
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                entry.addBeforeComment(this.lexer.readAndResetComments());
            }
            String alias = this.lexer.stringVal();
            this.lexer.nextToken();
            entry.setAlias(alias);
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                while (this.lexer.token != Token.RPAREN) {
                    SQLName name = this.exprParser.name();
                    if (this.dbType == DbType.odps && (this.lexer.identifierEquals(FnvHash.Constants.STRING) || this.lexer.identifierEquals(FnvHash.Constants.INT) || this.lexer.identifierEquals(FnvHash.Constants.BIGINT))) {
                        this.lexer.nextToken();
                    }
                    name.setParent(entry);
                    entry.getColumns().add(name);
                    if (this.lexer.token != Token.COMMA) continue;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            this.accept(Token.AS);
            this.accept(Token.LPAREN);
            switch (this.lexer.token) {
                case WITH: 
                case SELECT: 
                case VALUES: 
                case LPAREN: 
                case FROM: {
                    entry.setSubQuery(this.createSQLSelectParser().select());
                    break;
                }
                case INSERT: {
                    entry.setReturningStatement(this.parseInsert());
                    break;
                }
                case UPDATE: {
                    entry.setReturningStatement(this.parseUpdateStatement());
                    break;
                }
                case DELETE: {
                    entry.setReturningStatement(this.parseDeleteStatement());
                    break;
                }
            }
            this.accept(Token.RPAREN);
            withQueryClause.addEntry(entry);
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return withQueryClause;
    }

    public SQLStatement parseWith() {
        SQLWithSubqueryClause with = this.parseWithQuery();
        if (this.lexer.token == Token.SELECT || this.lexer.token == Token.LPAREN) {
            SQLSelectParser selectParser = this.createSQLSelectParser();
            SQLSelect select = selectParser.select();
            select.setWithSubQuery(with);
            return new SQLSelectStatement(select, this.dbType);
        }
        if (this.lexer.token == Token.INSERT) {
            SQLInsertStatement insert = (SQLInsertStatement)this.parseInsert();
            insert.setWith(with);
            return insert;
        }
        if (this.lexer.token == Token.FROM) {
            HiveMultiInsertStatement insert = (HiveMultiInsertStatement)this.parseInsert();
            insert.setWith(with);
            return insert;
        }
        if (this.lexer.token == Token.UPDATE) {
            SQLUpdateStatement update = this.parseUpdateStatement();
            update.setWith(with);
            return update;
        }
        throw new ParserException("TODO. " + this.lexer.info());
    }

    protected void parseValueClause(List<SQLInsertStatement.ValuesClause> valueClauseList, int columnSize, SQLObject parent) {
        this.parseValueClause(valueClauseList, null, 0, parent);
    }

    protected void parseValueClauseNative(List<SQLInsertStatement.ValuesClause> valueClauseList, List<SQLColumnDefinition> columnDefinitionList, int columnSize, SQLObject parent) {
        TimeZone timeZone = this.lexer.getTimeZone();
        int i = 0;
        while (true) {
            SQLInsertStatement.ValuesClause values;
            int startPos = this.lexer.pos - 1;
            if (this.lexer.token != Token.LPAREN) {
                throw new ParserException("syntax error, expect ')', " + this.lexer.info());
            }
            if (this.lexer.ch == '\'') {
                this.lexer.bufPos = 0;
                if (this.dbType == DbType.mysql) {
                    this.lexer.scanString2();
                } else {
                    this.lexer.scanString();
                }
            } else if (this.lexer.ch == '0') {
                this.lexer.bufPos = 0;
                if (this.lexer.charAt(this.lexer.pos + 1) == 'x') {
                    this.lexer.scanChar();
                    this.lexer.scanChar();
                    this.lexer.scanHexaDecimal();
                } else {
                    this.lexer.scanNumber();
                }
            } else if (this.lexer.ch > '0' && this.lexer.ch <= '9') {
                this.lexer.bufPos = 0;
                this.lexer.scanNumber();
            } else if (this.lexer.ch == '-' && this.lexer.charAt(this.lexer.pos + 1) != '-') {
                this.lexer.scanNumber();
            } else {
                this.lexer.nextTokenValue();
            }
            if (this.lexer.token() != Token.RPAREN) {
                ArrayList<Object> valueExprList = columnSize > 0 ? new ArrayList(columnSize) : new ArrayList<Object>();
                values = new SQLInsertStatement.ValuesClause(valueExprList, parent);
                int funcExecCount = 0;
                int j = 0;
                while (true) {
                    SQLExpr expr = null;
                    Object value = null;
                    SQLColumnDefinition columnDefinition = null;
                    if (columnDefinitionList != null && j < columnDefinitionList.size()) {
                        columnDefinition = columnDefinitionList.get(j);
                    }
                    SQLDataType dataType = null;
                    if (columnDefinition != null) {
                        dataType = columnDefinition.getDataType();
                    }
                    switch (this.lexer.token) {
                        case LITERAL_INT: {
                            Number integerValue = this.lexer.integerValue();
                            if (this.lexer.ch == ',') {
                                this.lexer.ch = this.lexer.charAt(++this.lexer.pos);
                                this.lexer.token = Token.COMMA;
                            } else {
                                this.lexer.nextTokenCommaValue();
                            }
                            if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                                expr = new SQLIntegerExpr(integerValue, values);
                                expr = this.exprParser.exprRest(expr);
                                expr.setParent(values);
                                break;
                            }
                            value = integerValue;
                            break;
                        }
                        case LITERAL_CHARS: {
                            String strVal = this.lexer.stringVal();
                            if (this.lexer.ch == ',') {
                                this.lexer.ch = this.lexer.charAt(++this.lexer.pos);
                                this.lexer.token = Token.COMMA;
                            } else {
                                this.lexer.nextTokenCommaValue();
                            }
                            if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                                expr = new SQLCharExpr(strVal, values);
                                expr = this.exprParser.exprRest(expr);
                                expr.setParent(values);
                                break;
                            }
                            value = strVal;
                            break;
                        }
                        case LITERAL_NCHARS: {
                            String strVal = this.lexer.stringVal();
                            if (this.lexer.ch == ',') {
                                this.lexer.ch = this.lexer.charAt(++this.lexer.pos);
                                this.lexer.token = Token.COMMA;
                            } else {
                                this.lexer.nextTokenCommaValue();
                            }
                            if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                                expr = new SQLNCharExpr(strVal, values);
                                expr = this.exprParser.exprRest(expr);
                                expr.setParent(values);
                                break;
                            }
                            value = strVal;
                            break;
                        }
                        case LITERAL_FLOAT: {
                            BigDecimal number = this.lexer.decimalValue();
                            if (dataType != null && dataType.nameHashCode64() == FnvHash.Constants.DECIMAL) {
                                SQLExpr arg0;
                                int precision = 0;
                                int scale = 0;
                                List<SQLExpr> arguments = dataType.getArguments();
                                if (arguments.size() > 0 && (arg0 = arguments.get(0)) instanceof SQLIntegerExpr) {
                                    precision = ((SQLIntegerExpr)arg0).getNumber().intValue();
                                }
                                if (arguments.size() > 1 && (arg0 = arguments.get(1)) instanceof SQLIntegerExpr) {
                                    scale = ((SQLIntegerExpr)arg0).getNumber().intValue();
                                }
                                if (number instanceof BigDecimal) {
                                    number = MySqlUtils.decimal(number, precision, scale);
                                }
                            }
                            if (this.lexer.ch == ',') {
                                this.lexer.ch = this.lexer.charAt(++this.lexer.pos);
                                this.lexer.token = Token.COMMA;
                            } else {
                                this.lexer.nextTokenCommaValue();
                            }
                            if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                                expr = new SQLDecimalExpr(number);
                                expr = this.exprParser.exprRest(expr);
                                expr.setParent(values);
                                break;
                            }
                            value = number;
                            break;
                        }
                        case NULL: {
                            this.lexer.nextTokenCommaValue();
                            if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                                expr = new SQLNullExpr(parent);
                                expr = this.exprParser.exprRest(expr);
                                expr.setParent(values);
                                break;
                            }
                            value = null;
                            break;
                        }
                        case IDENTIFIER: {
                            long hash = this.lexer.hashLCase();
                            if (hash == FnvHash.Constants.DATE) {
                                this.lexer.nextTokenValue();
                                String strVal = this.lexer.stringVal();
                                value = Date.valueOf(strVal);
                                this.lexer.nextTokenComma();
                                break;
                            }
                            if (hash == FnvHash.Constants.TIMESTAMP && timeZone != null) {
                                this.lexer.nextTokenValue();
                                String strVal = this.lexer.stringVal();
                                value = new Timestamp(MySqlUtils.parseDate(strVal, timeZone).getTime());
                                this.lexer.nextTokenComma();
                                break;
                            }
                            if (hash == FnvHash.Constants.CURDATE || hash == FnvHash.Constants.CUR_DATE || hash == FnvHash.Constants.CURRENT_DATE) {
                                this.lexer.nextTokenValue();
                                if (this.lexer.token == Token.LPAREN) {
                                    this.lexer.nextToken();
                                    this.accept(Token.RPAREN);
                                }
                                if (this.now == null) {
                                    this.now = new Timestamp(System.currentTimeMillis());
                                }
                                if (this.currentDate == null) {
                                    this.currentDate = new Date(this.now.getTime());
                                }
                                value = this.currentDate;
                                ++funcExecCount;
                                break;
                            }
                            if ((hash == FnvHash.Constants.SYSDATE || hash == FnvHash.Constants.NOW || hash == FnvHash.Constants.CURRENT_TIMESTAMP) && timeZone != null) {
                                this.lexer.nextTokenValue();
                                if (this.lexer.token == Token.LPAREN) {
                                    this.lexer.nextToken();
                                    this.accept(Token.RPAREN);
                                }
                                if (this.now == null) {
                                    this.now = new Timestamp(System.currentTimeMillis());
                                }
                                value = this.now;
                                ++funcExecCount;
                                break;
                            }
                            if (hash == FnvHash.Constants.UUID) {
                                this.lexer.nextTokenLParen();
                                this.accept(Token.LPAREN);
                                this.accept(Token.RPAREN);
                                value = UUID.randomUUID().toString();
                                ++funcExecCount;
                                break;
                            }
                            value = null;
                            Lexer.SavePoint mark = this.lexer.mark();
                            expr = this.exprParser.expr();
                            if (expr instanceof SQLName) {
                                this.lexer.reset(mark);
                                this.lexer.info();
                                throw new ParserException("insert value error, token " + this.lexer.stringVal() + ", line " + this.lexer.posLine + ", column " + this.lexer.posColumn, this.lexer.posLine, this.lexer.posColumn);
                            }
                            expr.setParent(values);
                            break;
                        }
                        default: {
                            value = null;
                            expr = this.exprParser.expr();
                            expr.setParent(values);
                        }
                    }
                    if (expr != null) {
                        expr.setParent(values);
                        value = expr;
                    }
                    if (this.lexer.token == Token.COMMA) {
                        valueExprList.add(value);
                        if (this.lexer.ch == '\'') {
                            this.lexer.bufPos = 0;
                            if (this.dbType == DbType.mysql) {
                                this.lexer.scanString2();
                            } else {
                                this.lexer.scanString();
                            }
                        } else if (this.lexer.ch == '0') {
                            this.lexer.bufPos = 0;
                            if (this.lexer.charAt(this.lexer.pos + 1) == 'x') {
                                this.lexer.scanChar();
                                this.lexer.scanChar();
                                this.lexer.scanHexaDecimal();
                            } else {
                                this.lexer.scanNumber();
                            }
                        } else if (this.lexer.ch > '0' && this.lexer.ch <= '9') {
                            this.lexer.bufPos = 0;
                            this.lexer.scanNumber();
                        } else if (this.lexer.ch == '-' && this.lexer.charAt(this.lexer.pos + 1) != '-') {
                            this.lexer.bufPos = 0;
                            this.lexer.scanNumber();
                        } else {
                            this.lexer.nextTokenValue();
                        }
                    } else {
                        if (this.lexer.token == Token.RPAREN) {
                            valueExprList.add(value);
                            break;
                        }
                        expr = this.exprParser.primaryRest(expr);
                        if (this.lexer.token != Token.COMMA && this.lexer.token() != Token.RPAREN) {
                            expr = this.exprParser.exprRest(expr);
                        }
                        expr.setParent(values);
                        valueExprList.add(expr);
                        if (this.lexer.token != Token.COMMA) break;
                        this.lexer.nextTokenValue();
                    }
                    ++j;
                }
                if (funcExecCount == 0 && this.lexer.isEnabled(SQLParserFeature.KeepInsertValueClauseOriginalString)) {
                    int endPos = this.lexer.pos();
                    String orginalString = this.lexer.subString(startPos, endPos - startPos);
                    values.setOriginalString(orginalString);
                }
            } else {
                values = new SQLInsertStatement.ValuesClause(new ArrayList<SQLExpr>(0));
            }
            valueClauseList.add(values);
            if (this.lexer.token != Token.RPAREN) {
                throw new ParserException("syntax error. " + this.lexer.info());
            }
            if (!this.parseCompleteValues && valueClauseList.size() >= this.parseValuesSize) {
                this.lexer.skipToEOF();
                break;
            }
            this.lexer.nextTokenComma();
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextTokenLParen();
            if (values != null) {
                columnSize = values.getValues().size();
            }
            ++i;
        }
    }

    public void parseValueClause(SQLInsertValueHandler valueHandler) throws SQLException {
        while (true) {
            if (this.lexer.token != Token.LPAREN) {
                throw new ParserException("syntax error, expect ')', " + this.lexer.info());
            }
            if (this.lexer.ch == '\'') {
                this.lexer.bufPos = 0;
                if (this.dbType == DbType.mysql) {
                    this.lexer.scanString2();
                } else {
                    this.lexer.scanString();
                }
            } else if (this.lexer.ch == '0') {
                this.lexer.bufPos = 0;
                if (this.lexer.charAt(this.lexer.pos + 1) == 'x') {
                    this.lexer.scanChar();
                    this.lexer.scanChar();
                    this.lexer.scanHexaDecimal();
                } else {
                    this.lexer.scanNumber();
                }
            } else if (this.lexer.ch > '0' && this.lexer.ch <= '9') {
                this.lexer.bufPos = 0;
                this.lexer.scanNumber();
            } else if (this.lexer.ch == '-' && this.lexer.charAt(this.lexer.pos + 1) != '-') {
                this.lexer.scanNumber();
            } else {
                this.lexer.nextTokenValue();
            }
            if (this.lexer.token() != Token.RPAREN) {
                Object row = valueHandler.newRow();
                int j = 0;
                while (true) {
                    switch (this.lexer.token) {
                        case LITERAL_INT: {
                            Number number = this.lexer.integerValue();
                            if (this.lexer.ch == ',') {
                                this.lexer.ch = this.lexer.charAt(++this.lexer.pos);
                                this.lexer.token = Token.COMMA;
                            } else {
                                this.lexer.nextTokenCommaValue();
                            }
                            if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                                throw new ParserException("insert value error, " + this.lexer.info());
                            }
                            valueHandler.processInteger(row, j, number);
                            break;
                        }
                        case LITERAL_CHARS: 
                        case LITERAL_NCHARS: {
                            String strVal = this.lexer.stringVal();
                            if (this.lexer.ch == ',') {
                                this.lexer.ch = this.lexer.charAt(++this.lexer.pos);
                                this.lexer.token = Token.COMMA;
                            } else {
                                this.lexer.nextTokenCommaValue();
                            }
                            if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                                throw new ParserException("insert value error, " + this.lexer.info());
                            }
                            valueHandler.processString(row, j, strVal);
                            break;
                        }
                        case LITERAL_FLOAT: {
                            BigDecimal number = this.lexer.decimalValue();
                            if (this.lexer.ch == ',') {
                                this.lexer.ch = this.lexer.charAt(++this.lexer.pos);
                                this.lexer.token = Token.COMMA;
                            } else {
                                this.lexer.nextTokenCommaValue();
                            }
                            if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                                throw new ParserException("insert value error, " + this.lexer.info());
                            }
                            valueHandler.processDecimal(row, j, number);
                            break;
                        }
                        case NULL: {
                            this.lexer.nextTokenCommaValue();
                            if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                                throw new ParserException("insert value error, " + this.lexer.info());
                            }
                            valueHandler.processNull(row, j);
                            break;
                        }
                        case TRUE: {
                            valueHandler.processBoolean(row, j, true);
                            this.lexer.nextTokenComma();
                            break;
                        }
                        case FALSE: {
                            valueHandler.processBoolean(row, j, false);
                            this.lexer.nextTokenComma();
                            break;
                        }
                        case IDENTIFIER: {
                            String funcName;
                            String strVal;
                            long hash = this.lexer.hashLCase();
                            if (hash == FnvHash.Constants.DATE) {
                                this.lexer.nextTokenValue();
                                strVal = this.lexer.stringVal();
                                valueHandler.processDate(row, j, strVal);
                                this.lexer.nextTokenComma();
                                break;
                            }
                            if (hash == FnvHash.Constants.TIMESTAMP) {
                                this.lexer.nextTokenValue();
                                strVal = this.lexer.stringVal();
                                valueHandler.processTimestamp(row, j, strVal);
                                this.lexer.nextTokenComma();
                                break;
                            }
                            if (hash == FnvHash.Constants.TIME) {
                                this.lexer.nextTokenValue();
                                strVal = this.lexer.stringVal();
                                valueHandler.processTime(row, j, strVal);
                                this.lexer.nextTokenComma();
                                break;
                            }
                            if (hash == FnvHash.Constants.DECIMAL) {
                                this.lexer.nextTokenValue();
                                strVal = this.lexer.stringVal();
                                BigDecimal decimal = new BigDecimal(strVal);
                                valueHandler.processDecimal(row, j, decimal);
                                this.lexer.nextTokenComma();
                                break;
                            }
                            if (hash == FnvHash.Constants.CURDATE || hash == FnvHash.Constants.CUR_DATE || hash == FnvHash.Constants.CURRENT_DATE || hash == FnvHash.Constants.SYSDATE) {
                                this.lexer.nextTokenLParen();
                                if (this.lexer.token == Token.LPAREN) {
                                    this.lexer.nextToken();
                                    this.accept(Token.RPAREN);
                                }
                                if (this.currentDate == null) {
                                    this.currentDate = new Date(this.now.getTime());
                                }
                                valueHandler.processDate(row, j, this.currentDate);
                                break;
                            }
                            if (hash == FnvHash.Constants.NOW || hash == FnvHash.Constants.CURRENT_TIMESTAMP) {
                                this.lexer.nextTokenLParen();
                                if (this.lexer.token == Token.LPAREN) {
                                    this.lexer.nextToken();
                                    this.accept(Token.RPAREN);
                                }
                                if (this.now == null) {
                                    this.now = new Timestamp(System.currentTimeMillis());
                                }
                                valueHandler.processTimestamp(row, j, this.now);
                                break;
                            }
                            if (hash == FnvHash.Constants.UUID) {
                                funcName = this.lexer.stringVal();
                                this.lexer.nextTokenLParen();
                                if (this.lexer.token != Token.LPAREN) {
                                    throw new ParserException("insert value error, " + this.lexer.info());
                                }
                                this.lexer.nextToken();
                                this.accept(Token.RPAREN);
                                if (this.now == null) {
                                    this.now = new Timestamp(System.currentTimeMillis());
                                }
                                valueHandler.processFunction(row, j, funcName, hash, new Object[0]);
                                break;
                            }
                            if (hash == FnvHash.Constants.STR_TO_DATE || hash == FnvHash.Constants.DATE_PARSE) {
                                funcName = this.lexer.stringVal();
                                this.lexer.nextTokenLParen();
                                if (this.lexer.token != Token.LPAREN) {
                                    throw new ParserException("insert value error, " + this.lexer.info());
                                }
                                this.lexer.nextTokenValue();
                                String strVal2 = this.lexer.stringVal();
                                this.lexer.nextTokenComma();
                                this.accept(Token.COMMA);
                                String format = this.lexer.stringVal();
                                this.lexer.nextTokenValue();
                                this.accept(Token.RPAREN);
                                valueHandler.processFunction(row, j, funcName, hash, strVal2, format);
                                break;
                            }
                            if (FnvHash.Constants.CLOTHES_FEATURE_EXTRACT_V1 == hash || FnvHash.Constants.CLOTHES_ATTRIBUTE_EXTRACT_V1 == hash || FnvHash.Constants.GENERIC_FEATURE_EXTRACT_V1 == hash || FnvHash.Constants.TEXT_FEATURE_EXTRACT_V1 == hash || FnvHash.Constants.FACE_FEATURE_EXTRACT_V1 == hash) {
                                funcName = this.lexer.stringVal();
                                this.lexer.nextTokenLParen();
                                if (Token.LPAREN != this.lexer.token) {
                                    throw new ParserException("insert value error, " + this.lexer.info());
                                }
                                this.lexer.nextTokenValue();
                                String urlVal = this.lexer.stringVal();
                                this.lexer.nextToken();
                                this.accept(Token.RPAREN);
                                valueHandler.processFunction(row, j, funcName, hash, urlVal);
                                break;
                            }
                            throw new ParserException("insert value error, " + this.lexer.info());
                        }
                        default: {
                            throw new ParserException("insert value error, " + this.lexer.info());
                        }
                    }
                    if (this.lexer.token == Token.COMMA) {
                        if (this.lexer.ch == '\'') {
                            this.lexer.bufPos = 0;
                            if (this.dbType == DbType.mysql) {
                                this.lexer.scanString2();
                            } else {
                                this.lexer.scanString();
                            }
                        } else if (this.lexer.ch == '0') {
                            this.lexer.bufPos = 0;
                            if (this.lexer.charAt(this.lexer.pos + 1) == 'x') {
                                this.lexer.scanChar();
                                this.lexer.scanChar();
                                this.lexer.scanHexaDecimal();
                            } else {
                                this.lexer.scanNumber();
                            }
                        } else if (this.lexer.ch > '0' && this.lexer.ch <= '9') {
                            this.lexer.bufPos = 0;
                            this.lexer.scanNumber();
                        } else if (this.lexer.ch == '-' && this.lexer.charAt(this.lexer.pos + 1) != '-') {
                            this.lexer.bufPos = 0;
                            this.lexer.scanNumber();
                        } else {
                            this.lexer.nextTokenValue();
                        }
                    } else {
                        if (this.lexer.token == Token.RPAREN) break;
                        throw new ParserException("insert value error, " + this.lexer.info());
                    }
                    ++j;
                }
                valueHandler.processRow(row);
            }
            if (this.lexer.token != Token.RPAREN) {
                throw new ParserException("syntax error. " + this.lexer.info());
            }
            this.lexer.nextTokenComma();
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextTokenLParen();
        }
        valueHandler.processComplete();
    }

    protected void parseValueClause(List<SQLInsertStatement.ValuesClause> valueClauseList, List<SQLColumnDefinition> columnDefinitionList, int columnSize, SQLObject parent) {
        boolean optimizedForParameterized = this.lexer.isEnabled(SQLParserFeature.OptimizedForForParameterizedSkipValue);
        int i = 0;
        while (true) {
            SQLInsertStatement.ValuesClause values;
            int startPos = this.lexer.pos - 1;
            if (this.lexer.token == Token.ROW) {
                this.lexer.nextToken();
            }
            if (this.lexer.token != Token.LPAREN) {
                throw new ParserException("syntax error, expect ')', " + this.lexer.info());
            }
            if (this.lexer.ch == '\'') {
                this.lexer.bufPos = 0;
                if (this.dbType == DbType.mysql) {
                    this.lexer.scanString2();
                } else {
                    this.lexer.scanString();
                }
            } else if (this.lexer.ch == '0') {
                this.lexer.bufPos = 0;
                if (this.lexer.charAt(this.lexer.pos + 1) == 'x') {
                    this.lexer.scanChar();
                    this.lexer.scanChar();
                    this.lexer.scanHexaDecimal();
                } else {
                    this.lexer.scanNumber();
                }
            } else if (this.lexer.ch > '0' && this.lexer.ch <= '9') {
                this.lexer.bufPos = 0;
                this.lexer.scanNumber();
            } else if (this.lexer.ch == '-' && this.lexer.charAt(this.lexer.pos + 1) != '-') {
                this.lexer.bufPos = 0;
                this.lexer.scanNumber();
            } else {
                this.lexer.nextTokenValue();
            }
            if (this.lexer.token() != Token.RPAREN) {
                ArrayList<SQLExpr> valueExprList = columnSize > 0 ? new ArrayList(columnSize) : new ArrayList<SQLExpr>();
                values = new SQLInsertStatement.ValuesClause(valueExprList, parent);
                int j = 0;
                while (true) {
                    SQLExpr expr;
                    SQLColumnDefinition columnDefinition = null;
                    if (columnDefinitionList != null && j < columnDefinitionList.size()) {
                        columnDefinition = columnDefinitionList.get(j);
                    }
                    SQLDataType dataType = null;
                    if (columnDefinition != null) {
                        dataType = columnDefinition.getDataType();
                    }
                    if (this.lexer.token == Token.LITERAL_INT) {
                        if (optimizedForParameterized) {
                            expr = new SQLVariantRefExpr("?", values);
                            values.incrementReplaceCount();
                        } else {
                            expr = new SQLIntegerExpr(this.lexer.integerValue(), values);
                        }
                        if (this.lexer.ch == ',') {
                            this.lexer.ch = this.lexer.charAt(++this.lexer.pos);
                            this.lexer.token = Token.COMMA;
                        } else {
                            this.lexer.nextTokenCommaValue();
                        }
                        if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                            expr = this.exprParser.exprRest(expr);
                            expr.setParent(values);
                        }
                    } else if (this.lexer.token == Token.LITERAL_CHARS) {
                        if (optimizedForParameterized) {
                            expr = new SQLVariantRefExpr("?", values);
                            values.incrementReplaceCount();
                        } else {
                            expr = new SQLCharExpr(this.lexer.stringVal(), values);
                        }
                        if (this.lexer.ch == ',') {
                            this.lexer.ch = this.lexer.charAt(++this.lexer.pos);
                            this.lexer.token = Token.COMMA;
                        } else {
                            this.lexer.nextTokenCommaValue();
                        }
                        if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                            expr = this.exprParser.exprRest(expr);
                            expr.setParent(values);
                        }
                    } else if (this.lexer.token == Token.LITERAL_NCHARS) {
                        if (optimizedForParameterized) {
                            expr = new SQLVariantRefExpr("?", values);
                            values.incrementReplaceCount();
                        } else {
                            expr = new SQLNCharExpr(this.lexer.stringVal(), values);
                        }
                        if (this.lexer.ch == ',') {
                            this.lexer.ch = this.lexer.charAt(++this.lexer.pos);
                            this.lexer.token = Token.COMMA;
                        } else {
                            this.lexer.nextTokenCommaValue();
                        }
                        if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                            expr = this.exprParser.exprRest(expr);
                            expr.setParent(values);
                        }
                    } else if (this.lexer.token == Token.LITERAL_FLOAT) {
                        if (optimizedForParameterized) {
                            expr = new SQLVariantRefExpr("?", values);
                            values.incrementReplaceCount();
                        } else {
                            SQLNumberExpr numberExpr = this.lexer.numberExpr(parent);
                            if (dataType != null && dataType.nameHashCode64() == FnvHash.Constants.DECIMAL) {
                                SQLExpr arg0;
                                Number number = numberExpr.getNumber();
                                int precision = 0;
                                int scale = 0;
                                List<SQLExpr> arguments = dataType.getArguments();
                                if (arguments.size() > 0 && (arg0 = arguments.get(0)) instanceof SQLIntegerExpr) {
                                    precision = ((SQLIntegerExpr)arg0).getNumber().intValue();
                                }
                                if (arguments.size() > 1 && (arg0 = arguments.get(1)) instanceof SQLIntegerExpr) {
                                    scale = ((SQLIntegerExpr)arg0).getNumber().intValue();
                                }
                                if (number instanceof BigDecimal) {
                                    number = MySqlUtils.decimal((BigDecimal)number, precision, scale);
                                    numberExpr.setNumber(number);
                                }
                            }
                            expr = numberExpr;
                        }
                        if (this.lexer.ch == ',') {
                            this.lexer.ch = this.lexer.charAt(++this.lexer.pos);
                            this.lexer.token = Token.COMMA;
                        } else {
                            this.lexer.nextTokenCommaValue();
                        }
                        if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                            expr = this.exprParser.exprRest(expr);
                            expr.setParent(values);
                        }
                    } else if (this.lexer.token == Token.NULL) {
                        if (optimizedForParameterized) {
                            expr = new SQLVariantRefExpr("?", parent);
                            values.incrementReplaceCount();
                        } else {
                            expr = new SQLNullExpr(parent);
                        }
                        this.lexer.nextTokenCommaValue();
                        if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                            expr = this.exprParser.exprRest(expr);
                            expr.setParent(values);
                        }
                    } else {
                        expr = this.exprParser.expr();
                        expr.setParent(values);
                    }
                    if (this.lexer.token == Token.COMMA) {
                        valueExprList.add(expr);
                        if (this.lexer.ch == '\'') {
                            this.lexer.bufPos = 0;
                            if (this.dbType == DbType.mysql) {
                                this.lexer.scanString2();
                            } else {
                                this.lexer.scanString();
                            }
                        } else if (this.lexer.ch == '0') {
                            this.lexer.bufPos = 0;
                            if (this.lexer.charAt(this.lexer.pos + 1) == 'x') {
                                this.lexer.scanChar();
                                this.lexer.scanChar();
                                this.lexer.scanHexaDecimal();
                            } else {
                                this.lexer.scanNumber();
                            }
                        } else if (this.lexer.ch > '0' && this.lexer.ch <= '9') {
                            this.lexer.bufPos = 0;
                            this.lexer.scanNumber();
                        } else if (this.lexer.ch == '-' && this.lexer.charAt(this.lexer.pos + 1) != '-') {
                            this.lexer.bufPos = 0;
                            this.lexer.scanNumber();
                        } else {
                            this.lexer.nextTokenValue();
                        }
                    } else {
                        if (this.lexer.token == Token.RPAREN) {
                            valueExprList.add(expr);
                            break;
                        }
                        expr = this.exprParser.primaryRest(expr);
                        if (this.lexer.token != Token.COMMA && this.lexer.token() != Token.RPAREN) {
                            expr = this.exprParser.exprRest(expr);
                        }
                        expr.setParent(values);
                        valueExprList.add(expr);
                        if (this.lexer.token != Token.COMMA) break;
                        this.lexer.nextTokenValue();
                    }
                    ++j;
                }
                if (this.lexer.isEnabled(SQLParserFeature.KeepInsertValueClauseOriginalString)) {
                    int endPos = this.lexer.pos();
                    String orginalString = this.lexer.subString(startPos, endPos - startPos);
                    values.setOriginalString(orginalString);
                }
            } else {
                values = new SQLInsertStatement.ValuesClause(new ArrayList<SQLExpr>(0));
            }
            valueClauseList.add(values);
            if (this.lexer.token != Token.RPAREN) {
                throw new ParserException("syntax error. " + this.lexer.info());
            }
            if (!this.parseCompleteValues && valueClauseList.size() >= this.parseValuesSize) {
                this.lexer.skipToEOF();
                break;
            }
            this.lexer.nextTokenComma();
            if (this.lexer.token != Token.COMMA) break;
            this.lexer.nextTokenLParen();
            if (values != null) {
                columnSize = values.getValues().size();
            }
            ++i;
        }
    }

    public SQLSelectListCache getSelectListCache() {
        return this.selectListCache;
    }

    public void setSelectListCache(SQLSelectListCache selectListCache) {
        this.selectListCache = selectListCache;
    }

    protected HiveInsertStatement parseHiveInsertStmt() {
        HiveInsertStatement insert = new HiveInsertStatement();
        insert.setDbType(this.dbType);
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            insert.addInsertBeforeComment(this.lexer.readAndResetComments());
        }
        SQLSelectParser selectParser = this.createSQLSelectParser();
        this.accept(Token.INSERT);
        if (this.lexer.token == Token.INTO) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.OVERWRITE);
            insert.setOverwrite(true);
        }
        if (this.lexer.token == Token.TABLE) {
            this.lexer.nextToken();
        }
        insert.setTableSource(this.exprParser.name());
        boolean columnsParsed = false;
        if (this.lexer.token == Token.LPAREN) {
            Lexer.SavePoint mark = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token == Token.SELECT) {
                this.lexer.reset(mark);
            } else {
                this.parseInsertColumns(insert);
                columnsParsed = true;
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.token == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLAssignItem ptExpr = new SQLAssignItem();
                ptExpr.setTarget(this.exprParser.name());
                if (this.lexer.token == Token.EQ || this.lexer.token == Token.EQEQ) {
                    this.lexer.nextTokenValue();
                    SQLExpr ptValue = this.exprParser.expr();
                    ptExpr.setValue(ptValue);
                }
                insert.addPartition(ptExpr);
                if (this.lexer.token != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (!columnsParsed && this.lexer.token == Token.LPAREN) {
            boolean select;
            Lexer.SavePoint m1 = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token == Token.LPAREN) {
                Lexer.SavePoint m2 = this.lexer.mark();
                this.lexer.nextToken();
                select = this.lexer.token == Token.SELECT;
                this.lexer.reset(m2);
            } else {
                boolean bl = select = this.lexer.token == Token.SELECT;
            }
            if (!select) {
                this.parseInsertColumns(insert);
                this.accept(Token.RPAREN);
            } else {
                this.lexer.reset(m1);
            }
        }
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            insert.setIfNotExists(true);
        }
        if (this.lexer.token == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
                    this.exprParser.exprList(values.getValues(), values);
                    insert.addValueCause(values);
                    this.accept(Token.RPAREN);
                }
                if (this.lexer.token == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else {
            SQLSelect query = selectParser.select();
            insert.setQuery(query);
        }
        return insert;
    }

    protected HiveInsert parseHiveInsert() {
        HiveInsert insert = new HiveInsert();
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            insert.addBeforeComment(this.lexer.readAndResetComments());
        }
        SQLSelectParser selectParser = this.createSQLSelectParser();
        this.accept(Token.INSERT);
        if (this.lexer.token == Token.INTO) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.OVERWRITE);
            insert.setOverwrite(true);
        }
        if (this.lexer.token == Token.TABLE) {
            this.lexer.nextToken();
        }
        insert.setTableSource(this.exprParser.name());
        if (this.lexer.token == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLAssignItem ptExpr = new SQLAssignItem();
                ptExpr.setTarget(this.exprParser.name());
                if (this.lexer.token == Token.EQ) {
                    this.lexer.nextToken();
                    SQLExpr ptValue = this.exprParser.expr();
                    ptExpr.setValue(ptValue);
                }
                insert.addPartition(ptExpr);
                if (this.lexer.token != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(insert.getColumns(), insert);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
                    this.exprParser.exprList(values.getValues(), values);
                    insert.addValueCause(values);
                    this.accept(Token.RPAREN);
                }
                if (this.lexer.token == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else {
            SQLSelect query = selectParser.select();
            insert.setQuery(query);
        }
        return insert;
    }

    protected SQLShowDatabasesStatement parseShowDatabases(boolean isPhysical) {
        SQLShowDatabasesStatement stmt = new SQLShowDatabasesStatement();
        stmt.setPhysical(isPhysical);
        if (this.lexer.token == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTRA)) {
            this.lexer.nextToken();
            stmt.setExtra(true);
        }
        return stmt;
    }

    protected SQLShowTableGroupsStatement parseShowTableGroups() {
        SQLShowTableGroupsStatement stmt = new SQLShowTableGroupsStatement();
        if (this.lexer.token == Token.IN) {
            this.lexer.nextToken();
            SQLName db = this.exprParser.name();
            stmt.setDatabase(db);
        }
        return stmt;
    }

    protected SQLShowTablesStatement parseShowTables() {
        SQLShowTablesStatement stmt = new SQLShowTablesStatement();
        if (this.lexer.identifierEquals(FnvHash.Constants.SHOW)) {
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TABLES)) {
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTENDED)) {
            this.lexer.nextToken();
            stmt.setExtended(true);
        }
        if (this.lexer.token == Token.FROM || this.lexer.token == Token.IN) {
            this.lexer.nextToken();
            SQLName database = this.exprParser.name();
            if (this.lexer.token == Token.SUB && database instanceof SQLIdentifierExpr) {
                this.lexer.mark();
                this.lexer.nextToken();
                String strVal = this.lexer.stringVal();
                this.lexer.nextToken();
                if (database instanceof SQLIdentifierExpr) {
                    SQLIdentifierExpr ident = (SQLIdentifierExpr)database;
                    database = new SQLIdentifierExpr(ident.getName() + "-" + strVal);
                }
            }
            stmt.setDatabase(database);
        }
        if (this.lexer.token == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    protected SQLShowColumnsStatement parseShowColumns() {
        SQLName table;
        SQLShowColumnsStatement stmt = new SQLShowColumnsStatement();
        if (this.lexer.token == Token.FROM) {
            this.lexer.nextToken();
            table = this.exprParser.name();
            stmt.setTable(table);
            if (this.lexer.token == Token.FROM || this.lexer.token == Token.IN) {
                this.lexer.nextToken();
                SQLName database = this.exprParser.name();
                stmt.setDatabase(database);
            }
        } else if (this.lexer.token == Token.IN) {
            this.lexer.nextToken();
            table = this.exprParser.name();
            stmt.setTable(table);
        }
        if (this.lexer.token == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    protected SQLStatement parseAlterIndex() {
        SQLAlterIndexStatement stmt;
        block10: {
            this.accept(Token.ALTER);
            this.lexer.nextToken();
            stmt = new SQLAlterIndexStatement();
            stmt.setName(this.exprParser.name());
            if (this.lexer.identifierEquals("RENAME")) {
                this.lexer.nextToken();
                this.accept(Token.TO);
                stmt.setRenameTo(this.exprParser.name());
            }
            if (this.lexer.token == Token.ON) {
                this.lexer.nextToken();
                if (this.lexer.token == Token.TABLE) {
                    this.lexer.nextToken();
                }
                SQLName table = this.exprParser.name();
                stmt.setTable(table);
            }
            if (this.lexer.token == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                this.parseAssignItems(stmt.getPartitions(), stmt);
                this.accept(Token.RPAREN);
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.DBPARTITION)) {
                SQLPartitionBy partitionClause = this.getSQLCreateTableParser().parsePartitionBy();
                stmt.setDbPartitionBy(partitionClause);
            }
            if (this.lexer.token == Token.ENABLE) {
                this.lexer.nextToken();
                stmt.setEnable(true);
            }
            if (this.lexer.token == Token.DISABLE) {
                this.lexer.nextToken();
                stmt.setEnable(false);
            }
            if (this.lexer.hashLCase == FnvHash.Constants.UNUSABLE) {
                this.lexer.nextToken();
                stmt.setUnusable(true);
            }
            while (true) {
                if (this.lexer.identifierEquals("rebuild")) {
                    this.lexer.nextToken();
                    SQLAlterIndexStatement.Rebuild rebuild = new SQLAlterIndexStatement.Rebuild();
                    stmt.setRebuild(rebuild);
                    continue;
                }
                if (!this.lexer.identifierEquals("MONITORING")) break;
                this.lexer.nextToken();
                this.acceptIdentifier("USAGE");
                stmt.setMonitoringUsage(Boolean.TRUE);
            }
            if (!this.lexer.identifierEquals("PARALLEL")) break block10;
            this.lexer.nextToken();
            stmt.setParallel(this.exprParser.expr());
        }
        return stmt;
    }

    protected SQLStatement parseAnalyze() {
        this.lexer.nextToken();
        this.accept(Token.TABLE);
        SQLAnalyzeTableStatement stmt = new SQLAnalyzeTableStatement();
        SQLName table = this.exprParser.name();
        stmt.setTable(table);
        if (this.lexer.token() == Token.PARTITION) {
            stmt.setPartition(this.parsePartitionRef());
        }
        this.accept(Token.COMPUTE);
        this.acceptIdentifier("STATISTICS");
        stmt.setComputeStatistics(true);
        if (this.lexer.token == Token.FOR) {
            this.lexer.nextToken();
            this.acceptIdentifier("COLUMNS");
            stmt.setForColums(true);
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.names(stmt.getColumns(), stmt);
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CACHE)) {
            this.lexer.nextToken();
            this.acceptIdentifier("METADATA");
            stmt.setCacheMetadata(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.NOSCAN)) {
            this.lexer.nextToken();
            stmt.setNoscan(true);
        }
        return stmt;
    }

    public SQLAlterSequenceStatement parseAlterSequence() {
        this.accept(Token.ALTER);
        this.accept(Token.SEQUENCE);
        SQLAlterSequenceStatement stmt = new SQLAlterSequenceStatement();
        stmt.setDbType(this.dbType);
        stmt.setName(this.exprParser.name());
        if (this.lexer.identifierEquals(FnvHash.Constants.CHANGE)) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            if (this.lexer.identifierEquals(FnvHash.Constants.SIMPLE)) {
                stmt.setChangeToSimple(true);
                this.lexer.nextToken();
                if (this.lexer.hashLCase() == FnvHash.Constants.WITH) {
                    this.lexer.nextToken();
                    this.accept(Token.CACHE);
                    stmt.setWithCache(true);
                }
            } else if (this.lexer.token == Token.GROUP) {
                stmt.setChangeToGroup(true);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.TIME)) {
                stmt.setChangeToTime(true);
                this.lexer.nextToken();
            } else {
                throw new ParserException("TODO " + this.lexer.info());
            }
        }
        while (true) {
            if (this.lexer.token() == Token.START || this.lexer.identifierEquals(FnvHash.Constants.START)) {
                this.lexer.nextToken();
                this.accept(Token.WITH);
                stmt.setStartWith(this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("INCREMENT")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setIncrementBy(this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.CACHE) {
                this.lexer.nextToken();
                stmt.setCache(Boolean.TRUE);
                if (this.lexer.token() != Token.LITERAL_INT && this.lexer.token() != Token.QUES) continue;
                stmt.setCacheValue(this.exprParser.primary());
                continue;
            }
            if (this.lexer.token() == Token.NOCACHE) {
                this.lexer.nextToken();
                stmt.setCache(Boolean.FALSE);
                continue;
            }
            if (this.lexer.token() == Token.ORDER) {
                this.lexer.nextToken();
                stmt.setOrder(Boolean.TRUE);
                continue;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.RESTART)) {
                this.lexer.nextToken();
                stmt.setRestart(true);
                if (this.lexer.token == Token.WITH || this.lexer.token == Token.EQ) {
                    this.lexer.nextToken();
                    stmt.setRestartWith(this.exprParser.primary());
                    continue;
                }
                if (this.lexer.token != Token.LITERAL_INT) continue;
                stmt.setRestartWith(this.exprParser.primary());
                continue;
            }
            if (this.lexer.identifierEquals("NOORDER")) {
                this.lexer.nextToken();
                stmt.setOrder(Boolean.FALSE);
                continue;
            }
            if (this.lexer.identifierEquals("CYCLE")) {
                this.lexer.nextToken();
                stmt.setCycle(Boolean.TRUE);
                continue;
            }
            if (this.lexer.identifierEquals("NOCYCLE")) {
                this.lexer.nextToken();
                stmt.setCycle(Boolean.FALSE);
                continue;
            }
            if (this.lexer.identifierEquals("MINVALUE")) {
                this.lexer.nextToken();
                stmt.setMinValue(this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("MAXVALUE")) {
                this.lexer.nextToken();
                stmt.setMaxValue(this.exprParser.expr());
                continue;
            }
            if (this.lexer.identifierEquals("NOMAXVALUE")) {
                this.lexer.nextToken();
                stmt.setNoMaxValue(true);
                continue;
            }
            if (!this.lexer.identifierEquals("NOMINVALUE")) break;
            this.lexer.nextToken();
            stmt.setNoMinValue(true);
        }
        return stmt;
    }

    protected SQLStatement parseMsck() {
        this.lexer.nextToken();
        if (this.lexer.identifierEquals("REPAIR")) {
            this.lexer.nextToken();
        }
        HiveMsckRepairStatement stmt = new HiveMsckRepairStatement();
        if (this.lexer.token() == Token.DATABASE || this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
            SQLName name = this.exprParser.name();
            stmt.setDatabase(name);
        }
        if (this.lexer.token() == Token.TABLE) {
            this.lexer.nextToken();
            SQLExpr tableExpr = this.exprParser.expr();
            stmt.setTable(tableExpr);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.ADD)) {
            this.lexer.nextToken();
            this.acceptIdentifier("PARTITIONS");
            stmt.setAddPartitions(true);
        }
        return stmt;
    }

    protected SQLStatement parseCreateResourceGroup() {
        this.accept(Token.CREATE);
        this.acceptIdentifier("RESOURCE");
        this.accept(Token.GROUP);
        SQLCreateResourceGroupStatement stmt = new SQLCreateResourceGroupStatement();
        stmt.setName(this.exprParser.name());
        while (this.lexer.token() != Token.SEMI && this.lexer.token() != Token.EOF) {
            if (this.lexer.token() == Token.ENABLE) {
                this.lexer.nextToken();
                stmt.setEnable(true);
            } else if (this.lexer.token() == Token.DISABLE) {
                this.lexer.nextToken();
                stmt.setEnable(false);
            }
            Lexer.SavePoint m = this.lexer.mark();
            String name = this.lexer.stringVal();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
                SQLExpr value = this.exprParser.expr();
                if (this.lexer.token() == Token.COMMA) {
                    SQLListExpr list = new SQLListExpr();
                    list.addItem(value);
                    while (this.lexer.token() == Token.COMMA) {
                        this.lexer.nextToken();
                        list.addItem(this.exprParser.expr());
                    }
                    stmt.addProperty(name, list);
                    continue;
                }
                stmt.addProperty(name, value);
                continue;
            }
            this.lexer.reset(m);
            break;
        }
        return stmt;
    }

    protected SQLStatement parseAlterResourceGroup() {
        this.accept(Token.ALTER);
        this.acceptIdentifier("RESOURCE");
        this.accept(Token.GROUP);
        SQLAlterResourceGroupStatement stmt = new SQLAlterResourceGroupStatement();
        stmt.setName(this.exprParser.name());
        while (this.lexer.token() != Token.SEMI && this.lexer.token() != Token.EOF) {
            if (this.lexer.token() == Token.ENABLE) {
                this.lexer.nextToken();
                stmt.setEnable(true);
            } else if (this.lexer.token() == Token.DISABLE) {
                this.lexer.nextToken();
                stmt.setEnable(false);
            }
            Lexer.SavePoint m = this.lexer.mark();
            String name = this.lexer.stringVal();
            this.lexer.nextToken();
            if (this.lexer.token() == Token.EQ) {
                this.lexer.nextToken();
                SQLExpr value = this.exprParser.expr();
                if (this.lexer.token() == Token.COMMA) {
                    SQLListExpr list = new SQLListExpr();
                    list.addItem(value);
                    while (this.lexer.token() == Token.COMMA) {
                        this.lexer.nextToken();
                        list.addItem(this.exprParser.expr());
                    }
                    stmt.addProperty(name, list);
                    continue;
                }
                stmt.addProperty(name, value);
                continue;
            }
            this.lexer.reset(m);
            break;
        }
        return stmt;
    }

    public SQLStatement parseAlterMaterialized() {
        SQLAlterMaterializedViewStatement stmt = new SQLAlterMaterializedViewStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token == Token.ALTER) {
            this.lexer.nextToken();
        }
        this.acceptIdentifier("MATERIALIZED");
        this.accept(Token.VIEW);
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.EOF) {
            throw new ParserException("syntax error. " + this.lexer.info());
        }
        while (true) {
            if (this.lexer.identifierEquals("REFRESH")) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EOF) {
                    throw new ParserException("syntax error. " + this.lexer.info());
                }
                boolean refresh = false;
                while (true) {
                    if (this.lexer.identifierEquals("FAST")) {
                        this.lexer.nextToken();
                        stmt.setRefreshFast(true);
                        refresh = true;
                        continue;
                    }
                    if (this.lexer.identifierEquals("COMPLETE")) {
                        this.lexer.nextToken();
                        stmt.setRefreshComplete(true);
                        refresh = true;
                        continue;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.FORCE)) {
                        this.lexer.nextToken();
                        stmt.setRefreshForce(true);
                        refresh = true;
                        continue;
                    }
                    if (this.lexer.token == Token.ON) {
                        this.lexer.nextToken();
                        if (this.lexer.token == Token.COMMIT || this.lexer.identifierEquals(FnvHash.Constants.COMMIT)) {
                            this.lexer.nextToken();
                            stmt.setRefreshOnCommit(true);
                        } else if (this.lexer.identifierEquals(FnvHash.Constants.OVERWRITE)) {
                            this.lexer.nextToken();
                            stmt.setRefreshOnOverWrite(true);
                        } else {
                            this.acceptIdentifier("DEMAND");
                            stmt.setRefreshOnDemand(true);
                        }
                        refresh = true;
                        continue;
                    }
                    if (this.lexer.identifierEquals(FnvHash.Constants.START)) {
                        this.lexer.nextToken();
                        this.accept(Token.WITH);
                        SQLExpr startWith = this.exprParser.expr();
                        stmt.setStartWith(startWith);
                        stmt.setRefreshStartWith(true);
                        refresh = true;
                        continue;
                    }
                    if (!this.lexer.identifierEquals(FnvHash.Constants.NEXT)) break;
                    this.lexer.nextToken();
                    SQLExpr next = this.exprParser.expr();
                    stmt.setNext(next);
                    stmt.setRefreshNext(true);
                    refresh = true;
                }
                if (refresh) continue;
                throw new ParserException("refresh clause is empty. " + this.lexer.info());
            }
            if (!this.lexer.identifierEquals("REBUILD")) break;
            this.lexer.nextToken();
            stmt.setRebuild(true);
        }
        Boolean enableQueryRewrite = null;
        if (this.lexer.token == Token.ENABLE) {
            this.lexer.nextToken();
            enableQueryRewrite = true;
        }
        if (this.lexer.token == Token.DISABLE) {
            this.lexer.nextToken();
            enableQueryRewrite = false;
        }
        if (enableQueryRewrite != null) {
            this.acceptIdentifier("QUERY");
            this.acceptIdentifier("REWRITE");
            stmt.setEnableQueryRewrite(enableQueryRewrite);
        }
        if (this.lexer.token == Token.PARTITION) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.exprParser.exprList(stmt.getPartitions(), stmt);
            this.accept(Token.RPAREN);
        }
        return stmt;
    }

    public SQLCreateFunctionStatement parseHiveCreateFunction() {
        SQLExpr location;
        SQLDataType returnDataType;
        HiveCreateFunctionStatement stmt = new HiveCreateFunctionStatement();
        stmt.setDbType(this.dbType);
        if (this.lexer.token == Token.CREATE) {
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            stmt.setOrReplace(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.TEMPORARY)) {
            this.lexer.nextToken();
            stmt.setTemporary(true);
        }
        boolean sql = false;
        if (this.lexer.identifierEquals(FnvHash.Constants.SQL)) {
            this.lexer.nextToken();
            sql = true;
        }
        this.accept(Token.FUNCTION);
        if (this.lexer.token == Token.IF) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExists(true);
        }
        SQLName name = this.exprParser.name();
        stmt.setName(name);
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            while (this.lexer.token != Token.RPAREN) {
                SQLParameter param = new SQLParameter();
                param.setName(this.exprParser.name());
                param.setDataType(this.exprParser.parseDataType());
                if (this.lexer.token == Token.COMMA) {
                    this.lexer.nextToken();
                }
                stmt.getParameters().add(param);
                param.setParent(stmt);
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.RETURNS)) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.VARIANT) {
                this.lexer.nextToken();
            }
            returnDataType = this.exprParser.parseDataType();
            stmt.setReturnDataType(returnDataType);
        }
        if (this.lexer.token == Token.IDENTIFIER && this.lexer.stringVal().toUpperCase().startsWith("RETURNS@")) {
            this.lexer.nextToken();
            returnDataType = this.exprParser.parseDataType();
            stmt.setReturnDataType(returnDataType);
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.setToken(Token.IDENTIFIER);
            this.lexer.nextToken();
            if (this.lexer.token != Token.BEGIN && !this.lexer.identifierEquals(FnvHash.Constants.BEGIN)) {
                SQLExpr className = this.exprParser.expr();
                stmt.setClassName(className);
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.LOCATION)) {
            this.lexer.nextToken();
            location = this.exprParser.primary();
            stmt.setLocation(location);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SYMBOL)) {
            this.lexer.nextToken();
            this.accept(Token.EQ);
            SQLExpr symbol = this.exprParser.primary();
            stmt.setSymbol(symbol);
        }
        if (this.lexer.token() == Token.USING || this.lexer.hashLCase() == FnvHash.Constants.USING) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.JAR)) {
                this.lexer.nextToken();
                stmt.setResourceType(HiveCreateFunctionStatement.ResourceType.JAR);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.ARCHIVE)) {
                this.lexer.nextToken();
                stmt.setResourceType(HiveCreateFunctionStatement.ResourceType.ARCHIVE);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.FILE)) {
                this.lexer.nextToken();
                stmt.setResourceType(HiveCreateFunctionStatement.ResourceType.FILE);
            } else if (this.lexer.token == Token.CODE) {
                stmt.setCode(this.lexer.stringVal());
                this.lexer.nextToken();
                stmt.setResourceType(HiveCreateFunctionStatement.ResourceType.CODE);
                return stmt;
            }
            location = this.exprParser.primary();
            stmt.setLocation(location);
        }
        return stmt;
    }

    protected SQLShowCreateTableStatement parseShowCreateTable() {
        this.lexer.nextToken();
        this.accept(Token.TABLE);
        SQLShowCreateTableStatement stmt = new SQLShowCreateTableStatement();
        stmt.setDbType(this.dbType);
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.MAPPING)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLName name = this.exprParser.name();
                stmt.setLikeMapping(name);
                this.accept(Token.RPAREN);
            }
        }
        return stmt;
    }

    public SQLShowVariantsStatement parseShowVariants() {
        SQLShowVariantsStatement stmt = new SQLShowVariantsStatement();
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr like = this.exprParser.expr();
            stmt.setLike(like);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            SQLExpr where = this.exprParser.expr();
            stmt.setWhere(where);
        }
        return stmt;
    }

    public SQLStatement parseClone() {
        throw new ParserException("TODO " + this.lexer.info());
    }
}

