/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.opds.udf;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.druid.sql.dialect.odps.visitor.OdpsASTVisitorAdapter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.odps.udf.UDF;
import java.util.List;

public class SqlCodeStat
extends UDF {
    public String evaluate(String sql) {
        return this.evaluate(sql, null, false);
    }

    public String evaluate(String sql, String dbTypeName) {
        return this.evaluate(sql, dbTypeName, false);
    }

    public String evaluate(String sql, String dbTypeName, boolean throwError) {
        DbType dbType = dbTypeName == null ? null : DbType.valueOf(dbTypeName);
        try {
            List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, DbType.odps);
            CodeStatVisitor v = new CodeStatVisitor();
            for (SQLStatement stmt : stmtList) {
                stmt.accept(v);
            }
            return v.toString();
        }
        catch (Exception ex) {
            if (throwError) {
                throw new IllegalArgumentException("error sql : \n" + sql, ex);
            }
            return null;
        }
    }

    private static class CodeStatVisitor
    extends OdpsASTVisitorAdapter {
        SqlStat stat = new SqlStat();

        private CodeStatVisitor() {
        }

        @Override
        public void preVisit(SQLObject x) {
            if (x instanceof SQLStatement) {
                ++this.stat.statementCount;
            }
            if (x instanceof SQLInsertStatement) {
                ++this.stat.insert;
            } else if (x instanceof SQLDropStatement) {
                ++this.stat.drop;
            } else if (x instanceof SQLCreateStatement) {
                ++this.stat.create;
            } else if (x instanceof SQLDeleteStatement) {
                ++this.stat.delete;
            } else if (x instanceof SQLUpdateStatement) {
                ++this.stat.update;
            }
        }

        @Override
        public boolean visit(SQLUnionQuery x) {
            ++this.stat.union;
            return true;
        }

        @Override
        public boolean visit(OdpsSelectQueryBlock x) {
            return this.visit((SQLSelectQueryBlock)x);
        }

        @Override
        public boolean visit(SQLSelectQueryBlock x) {
            ++this.stat.select;
            return true;
        }

        @Override
        public boolean visit(SQLSelectGroupByClause x) {
            ++this.stat.groupByCount;
            if (x.getHaving() != null) {
                ++this.stat.having;
            }
            return true;
        }

        @Override
        public boolean visit(SQLLimit x) {
            ++this.stat.limit;
            return false;
        }

        @Override
        public boolean visit(SQLWithSubqueryClause.Entry x) {
            ++this.stat.cte;
            return true;
        }

        @Override
        public boolean visit(SQLOrderBy x) {
            ++this.stat.orderByCount;
            return true;
        }

        @Override
        public boolean visit(SQLExprTableSource x) {
            ++this.stat.fromCount;
            return true;
        }

        @Override
        public boolean visit(SQLSubqueryTableSource x) {
            ++this.stat.fromCount;
            return true;
        }

        @Override
        public boolean visit(SQLJoinTableSource x) {
            ++this.stat.joinCount;
            return true;
        }

        @Override
        public boolean visit(SQLMethodInvokeExpr x) {
            ++this.stat.functionCallCount;
            return true;
        }

        @Override
        public boolean visit(SQLAggregateExpr x) {
            ++this.stat.aggregateCount;
            return true;
        }

        @Override
        public boolean visit(SQLCastExpr x) {
            ++this.stat.functionCallCount;
            return true;
        }

        @Override
        public boolean visit(SQLInListExpr x) {
            ++this.stat.conditionCount;
            return true;
        }

        @Override
        public boolean visit(SQLBinaryOpExpr x) {
            if (x.getOperator() != null && x.getOperator().isRelational()) {
                ++this.stat.conditionCount;
                SQLExpr left = x.getLeft();
                SQLExpr right = x.getRight();
                if (left instanceof SQLName && right instanceof SQLName) {
                    ++this.stat.joinConditionCount;
                } else if ((left instanceof SQLName || right instanceof SQLName) && (left instanceof SQLLiteralExpr || right instanceof SQLLiteralExpr)) {
                    ++this.stat.valueConditionCount;
                } else {
                    ++this.stat.otherConditionCount;
                }
            }
            return true;
        }

        @Override
        public boolean visit(SQLCaseExpr x) {
            SQLExpr value = x.getValueExpr();
            if (value != null) {
                this.stat.conditionCount += x.getItems().size();
            }
            if (x.getElseExpr() != null) {
                ++this.stat.conditionCount;
            }
            return true;
        }

        @Override
        public boolean visit(SQLExistsExpr x) {
            ++this.stat.conditionCount;
            return true;
        }

        public String toString() {
            return JSON.toJSONString((Object)this.stat, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.NotWriteDefaultValue});
        }
    }

    public static class SqlStat {
        @JSONField(ordinal=0)
        public int statementCount;
        @JSONField(ordinal=1)
        public int cte;
        @JSONField(ordinal=2)
        public int union;
        @JSONField(ordinal=3)
        public int select;
        @JSONField(ordinal=4)
        public int groupByCount;
        @JSONField(ordinal=5)
        public int orderByCount;
        @JSONField(ordinal=6)
        public int fromCount;
        @JSONField(ordinal=7)
        public int joinCount;
        @JSONField(ordinal=50)
        public int insert;
        @JSONField(ordinal=51)
        public int update;
        @JSONField(ordinal=52)
        public int delete;
        @JSONField(ordinal=53)
        public int create;
        @JSONField(ordinal=54)
        public int drop;
        @JSONField(ordinal=100)
        public int conditionCount;
        @JSONField(ordinal=101)
        public int joinConditionCount;
        @JSONField(ordinal=102)
        public int valueConditionCount;
        @JSONField(ordinal=103)
        public int otherConditionCount;
        @JSONField(ordinal=104)
        public int limit;
        @JSONField(ordinal=200)
        public int aggregateCount;
        @JSONField(ordinal=201)
        public int functionCallCount;
        @JSONField(ordinal=202)
        public int having;
    }
}

