/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.dubbo.config.ConsumerConfig;
import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.AbstractAnnotationConfigBeanBuilder;
import com.alibaba.dubbo.config.spring.util.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class ReferenceBeanBuilder
extends AbstractAnnotationConfigBeanBuilder<Reference, ReferenceBean> {
    private ReferenceBeanBuilder(Reference annotation, ClassLoader classLoader, ApplicationContext applicationContext) {
        super(annotation, classLoader, applicationContext);
    }

    private void configureInterface(Reference reference, ReferenceBean referenceBean) {
        Class interfaceClass = reference.interfaceClass();
        if (Void.TYPE.equals(interfaceClass)) {
            interfaceClass = null;
            String interfaceClassName = reference.interfaceName();
            if (StringUtils.hasText((String)interfaceClassName) && ClassUtils.isPresent((String)interfaceClassName, (ClassLoader)this.classLoader)) {
                interfaceClass = ClassUtils.resolveClassName((String)interfaceClassName, (ClassLoader)this.classLoader);
            }
        }
        if (interfaceClass == null) {
            interfaceClass = this.interfaceClass;
        }
        Assert.isTrue((boolean)interfaceClass.isInterface(), (String)"The class of field or method that was annotated @Reference is not an interface!");
        referenceBean.setInterface(interfaceClass);
    }

    private void configureConsumerConfig(Reference reference, ReferenceBean<?> referenceBean) {
        String consumerBeanName = reference.consumer();
        ConsumerConfig consumerConfig = BeanFactoryUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, consumerBeanName, ConsumerConfig.class);
        referenceBean.setConsumer(consumerConfig);
    }

    @Override
    protected ReferenceBean doBuild() {
        return new ReferenceBean((Reference)this.annotation);
    }

    @Override
    protected void preConfigureBean(Reference annotation, ReferenceBean bean) {
        Assert.notNull((Object)this.interfaceClass, (String)"The interface class must set first!");
    }

    @Override
    protected String resolveModuleConfigBeanName(Reference annotation) {
        return annotation.module();
    }

    @Override
    protected String resolveApplicationConfigBeanName(Reference annotation) {
        return annotation.application();
    }

    @Override
    protected String[] resolveRegistryConfigBeanNames(Reference annotation) {
        return annotation.registry();
    }

    @Override
    protected String resolveMonitorConfigBeanName(Reference annotation) {
        return annotation.monitor();
    }

    @Override
    protected void postConfigureBean(Reference annotation, ReferenceBean bean) throws Exception {
        bean.setApplicationContext(this.applicationContext);
        this.configureInterface(annotation, bean);
        this.configureConsumerConfig(annotation, bean);
        bean.afterPropertiesSet();
    }

    public static ReferenceBeanBuilder create(Reference annotation, ClassLoader classLoader, ApplicationContext applicationContext) {
        return new ReferenceBeanBuilder(annotation, classLoader, applicationContext);
    }
}

