/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.cache;

import com.alibaba.excel.cache.ReadCache;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.util.FileUtils;
import com.alibaba.excel.util.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.PersistentCacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ehcache
implements ReadCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ehcache.class);
    private static final int BATCH_COUNT = 1000;
    private static final int CHECK_INTERVAL = 500;
    private static final int MAX_CACHE_ACTIVATE = 10;
    private static final String CACHE = "cache";
    private static final String DATA_SEPARATOR = "@";
    private static final String KEY_VALUE_SEPARATOR = "!";
    private static final String SPECIAL_SEPARATOR = "&";
    private static final String ESCAPED_DATA_SEPARATOR = "&d;";
    private static final String ESCAPED_KEY_VALUE_SEPARATOR = "&kv;";
    private static final String ESCAPED_SPECIAL_SEPARATOR = "&s;";
    private static final int DEBUG_WRITE_SIZE = 1000000;
    private static final int DEBUG_CACHE_MISS_SIZE = 1000;
    private int index = 0;
    private StringBuilder data = new StringBuilder();
    private CacheManager cacheManager;
    private Cache<Integer, String> cache;
    private Map<Integer, Map<Integer, String>> cacheMap = new HashMap<Integer, Map<Integer, String>>();
    private int getCount = 0;
    private LinkedList<Integer> countList = new LinkedList();
    private Set<Integer> lastCheckIntervalUsedSet = new HashSet<Integer>();
    private int cacheMiss = 0;

    @Override
    public void init(AnalysisContext analysisContext) {
        File readTempFile = analysisContext.readWorkbookHolder().getTempFile();
        if (readTempFile == null) {
            readTempFile = FileUtils.createCacheTmpFile();
            analysisContext.readWorkbookHolder().setTempFile(readTempFile);
        }
        File cacheFile = new File(readTempFile.getPath(), UUID.randomUUID().toString());
        PersistentCacheManager persistentCacheManager = (PersistentCacheManager)CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((File)cacheFile)).withCache(CACHE, (Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(Integer.class, String.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().disk(10L, MemoryUnit.GB))).build(true);
        this.cacheManager = persistentCacheManager;
        this.cache = persistentCacheManager.getCache(CACHE, Integer.class, String.class);
    }

    @Override
    public void put(String value) {
        this.data.append(this.index).append(KEY_VALUE_SEPARATOR).append(this.escape(value)).append(DATA_SEPARATOR);
        if ((this.index + 1) % 1000 == 0) {
            this.cache.put((Object)(this.index / 1000), (Object)this.data.toString());
            this.data = new StringBuilder();
        }
        ++this.index;
        if (LOGGER.isDebugEnabled() && this.index % 1000000 == 0) {
            LOGGER.debug("Already put :{}", (Object)this.index);
        }
    }

    private String escape(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        str = str.replaceAll(SPECIAL_SEPARATOR, ESCAPED_SPECIAL_SEPARATOR);
        str = str.replaceAll(DATA_SEPARATOR, ESCAPED_DATA_SEPARATOR);
        str = str.replaceAll(KEY_VALUE_SEPARATOR, ESCAPED_KEY_VALUE_SEPARATOR);
        return str;
    }

    private String unescape(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        str = str.replaceAll(ESCAPED_KEY_VALUE_SEPARATOR, KEY_VALUE_SEPARATOR);
        str = str.replaceAll(ESCAPED_DATA_SEPARATOR, DATA_SEPARATOR);
        str = str.replaceAll(ESCAPED_SPECIAL_SEPARATOR, SPECIAL_SEPARATOR);
        return str;
    }

    @Override
    public String get(Integer key) {
        String[] dataStrings;
        if (key == null || key < 0) {
            return null;
        }
        ++this.getCount;
        int route = key / 1000;
        if (this.cacheMap.containsKey(route)) {
            this.lastCheckIntervalUsedSet.add(route);
            String value = this.cacheMap.get(route).get(key);
            this.checkClear();
            return value;
        }
        HashMap<Integer, String> tempCacheMap = new HashMap<Integer, String>(1333);
        String batchData = (String)this.cache.get((Object)route);
        for (String dataString : dataStrings = batchData.split(DATA_SEPARATOR)) {
            String[] keyValue = dataString.split(KEY_VALUE_SEPARATOR);
            tempCacheMap.put(Integer.valueOf(keyValue[0]), this.unescape(keyValue[1]));
        }
        this.countList.add(route);
        this.cacheMap.put(route, tempCacheMap);
        if (LOGGER.isDebugEnabled() && this.cacheMiss++ % 1000 == 0) {
            LOGGER.debug("Cache misses count:{}", (Object)this.cacheMiss);
        }
        this.lastCheckIntervalUsedSet.add(route);
        String value = (String)tempCacheMap.get(key);
        this.checkClear();
        return value;
    }

    private void checkClear() {
        if (this.countList.size() > 10) {
            Integer route = this.countList.getFirst();
            this.countList.removeFirst();
            this.cacheMap.remove(route);
        }
        if (this.getCount++ % 500 != 0) {
            return;
        }
        Iterator<Map.Entry<Integer, Map<Integer, String>>> iterator = this.cacheMap.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Map.Entry<Integer, Map<Integer, String>> entry = iterator.next();
            if (this.lastCheckIntervalUsedSet.contains(entry.getKey())) continue;
            iterator.remove();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cache remove because {} times unused.", (Object)500);
            }
            Iterator countIterator = this.countList.iterator();
            while (countIterator.hasNext()) {
                Integer route = (Integer)countIterator.next();
                if (!route.equals(entry.getKey())) continue;
                countIterator.remove();
                continue block0;
            }
        }
        this.lastCheckIntervalUsedSet.clear();
    }

    @Override
    public void putFinished() {
        if (StringUtils.isEmpty(this.data.toString())) {
            return;
        }
        this.cache.put((Object)(this.index / 1000), (Object)this.data.toString());
    }

    @Override
    public void destroy() {
        this.cacheManager.close();
    }
}

