/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtils {
    public static final String DATE_FORMAT_14 = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT_17 = "yyyyMMdd HH:mm:ss";
    public static final String DATE_FORMAT_19 = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_19_FORWARD_SLASH = "yyyy/MM/dd HH:mm:ss";
    private static final String MINUS = "-";

    private DateUtils() {
    }

    public static Date parseDate(String dateString, String dateFormat) throws ParseException {
        if (StringUtils.isEmpty(dateFormat)) {
            dateFormat = DateUtils.switchDateFormat(dateString);
        }
        return new SimpleDateFormat(dateFormat).parse(dateString);
    }

    public static Date parseDate(String dateString) throws ParseException {
        return DateUtils.parseDate(dateString, DateUtils.switchDateFormat(dateString));
    }

    private static String switchDateFormat(String dateString) {
        int length = dateString.length();
        switch (length) {
            case 19: {
                if (dateString.contains(MINUS)) {
                    return DATE_FORMAT_19;
                }
                return DATE_FORMAT_19_FORWARD_SLASH;
            }
            case 17: {
                return DATE_FORMAT_17;
            }
            case 14: {
                return DATE_FORMAT_14;
            }
        }
        throw new ExcelDataConvertException("can not find date format for\uff1a" + dateString);
    }

    public static String format(Date date) {
        return DateUtils.format(date, null);
    }

    public static String format(Date date, String dateFormat) {
        if (date == null) {
            return "";
        }
        if (StringUtils.isEmpty(dateFormat)) {
            dateFormat = DATE_FORMAT_19;
        }
        return new SimpleDateFormat(dateFormat).format(date);
    }
}

