/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.property;

import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.converters.DefaultConverterLoader;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.metadata.CellRange;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.property.ColumnWidthProperty;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.metadata.property.ExcelHeadProperty;
import com.alibaba.excel.metadata.property.RowHeightProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ExcelWriteHeadProperty
extends ExcelHeadProperty {
    private RowHeightProperty headRowHeightProperty;
    private RowHeightProperty contentRowHeightProperty;

    public ExcelWriteHeadProperty(Class headClazz, List<List<String>> head, Boolean convertAllFiled) {
        super(headClazz, head, convertAllFiled);
        if (this.getHeadKind() != HeadKindEnum.CLASS) {
            return;
        }
        this.headRowHeightProperty = RowHeightProperty.build(headClazz.getAnnotation(HeadRowHeight.class));
        this.contentRowHeightProperty = RowHeightProperty.build(headClazz.getAnnotation(ContentRowHeight.class));
        ColumnWidth parentColumnWidth = headClazz.getAnnotation(ColumnWidth.class);
        for (Map.Entry<Integer, ExcelContentProperty> entry : this.getContentPropertyMap().entrySet()) {
            NumberFormat numberFormat;
            Integer index = entry.getKey();
            ExcelContentProperty excelContentPropertyData = entry.getValue();
            Field field = excelContentPropertyData.getField();
            Head headData = this.getHeadMap().get(index);
            ColumnWidth columnWidth = field.getAnnotation(ColumnWidth.class);
            if (columnWidth == null) {
                columnWidth = parentColumnWidth;
            }
            headData.setColumnWidthProperty(ColumnWidthProperty.build(columnWidth));
            if (excelContentPropertyData.getConverter() != null || (numberFormat = field.getAnnotation(NumberFormat.class)) == null) continue;
            excelContentPropertyData.setConverter(DefaultConverterLoader.loadAllConverter().get(ConverterKeyBuild.buildKey(field.getType(), CellDataTypeEnum.STRING)));
        }
    }

    public RowHeightProperty getHeadRowHeightProperty() {
        return this.headRowHeightProperty;
    }

    public void setHeadRowHeightProperty(RowHeightProperty headRowHeightProperty) {
        this.headRowHeightProperty = headRowHeightProperty;
    }

    public RowHeightProperty getContentRowHeightProperty() {
        return this.contentRowHeightProperty;
    }

    public void setContentRowHeightProperty(RowHeightProperty contentRowHeightProperty) {
        this.contentRowHeightProperty = contentRowHeightProperty;
    }

    public List<CellRange> headCellRangeList() {
        ArrayList<CellRange> cellRangeList = new ArrayList<CellRange>();
        HashSet<String> alreadyRangeSet = new HashSet<String>();
        ArrayList<Head> headList = new ArrayList<Head>(this.getHeadMap().values());
        for (int i = 0; i < headList.size(); ++i) {
            Head head = (Head)headList.get(i);
            List<String> headNameList = head.getHeadNameList();
            for (int j = 0; j < headNameList.size(); ++j) {
                if (alreadyRangeSet.contains(i + "-" + j)) continue;
                alreadyRangeSet.add(i + "-" + j);
                String headName = headNameList.get(j);
                int lastCol = i;
                int lastRow = j;
                int k = i + 1;
                while (k < headList.size() && ((Head)headList.get(k)).getHeadNameList().get(j).equals(headName)) {
                    alreadyRangeSet.add(k + "-" + j);
                    lastCol = k++;
                }
                HashSet<String> tempAlreadyRangeSet = new HashSet<String>();
                int k2 = j + 1;
                block3: while (k2 < headNameList.size()) {
                    for (int l = i; l <= lastCol; ++l) {
                        if (!((Head)headList.get(l)).getHeadNameList().get(k2).equals(headName)) break block3;
                        tempAlreadyRangeSet.add(l + "-" + k2);
                    }
                    lastRow = k2++;
                    alreadyRangeSet.addAll(tempAlreadyRangeSet);
                }
                if (j == lastRow && i == lastCol) continue;
                cellRangeList.add(new CellRange(j, lastRow, i, lastCol));
            }
        }
        return cellRangeList;
    }
}

