/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.builder;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.write.builder.AbstractExcelWriterParameterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterTableBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import java.util.List;

public class ExcelWriterSheetBuilder
extends AbstractExcelWriterParameterBuilder<ExcelWriterSheetBuilder, WriteSheet> {
    private ExcelWriter excelWriter;
    private WriteSheet writeSheet = new WriteSheet();

    public ExcelWriterSheetBuilder() {
    }

    public ExcelWriterSheetBuilder(ExcelWriter excelWriter) {
        this.excelWriter = excelWriter;
    }

    public ExcelWriterSheetBuilder sheetNo(Integer sheetNo) {
        this.writeSheet.setSheetNo(sheetNo);
        return this;
    }

    public ExcelWriterSheetBuilder sheetName(String sheetName) {
        this.writeSheet.setSheetName(sheetName);
        return this;
    }

    public WriteSheet build() {
        return this.writeSheet;
    }

    public void doWrite(List data) {
        if (this.excelWriter == null) {
            throw new ExcelGenerateException("Must use 'EasyExcelFactory.write().sheet()' to call this method");
        }
        this.excelWriter.write(data, this.build());
        this.excelWriter.finish();
    }

    public void doFill(Object data) {
        this.doFill(data, null);
    }

    public void doFill(Object data, FillConfig fillConfig) {
        if (this.excelWriter == null) {
            throw new ExcelGenerateException("Must use 'EasyExcelFactory.write().sheet()' to call this method");
        }
        this.excelWriter.fill(data, fillConfig, this.build());
        this.excelWriter.finish();
    }

    public ExcelWriterTableBuilder table() {
        return this.table(null);
    }

    public ExcelWriterTableBuilder table(Integer tableNo) {
        ExcelWriterTableBuilder excelWriterTableBuilder = new ExcelWriterTableBuilder(this.excelWriter, this.build());
        if (tableNo != null) {
            excelWriterTableBuilder.tableNo(tableNo);
        }
        return excelWriterTableBuilder;
    }

    @Override
    protected WriteSheet parameter() {
        return this.writeSheet;
    }
}

