/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.property;

import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentFontStyle;
import com.alibaba.excel.annotation.write.style.ContentLoopMerge;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.alibaba.excel.annotation.write.style.HeadStyle;
import com.alibaba.excel.annotation.write.style.OnceAbsoluteMerge;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.converters.DefaultConverterLoader;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.metadata.CellRange;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.Holder;
import com.alibaba.excel.metadata.property.ColumnWidthProperty;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.metadata.property.ExcelHeadProperty;
import com.alibaba.excel.metadata.property.FontProperty;
import com.alibaba.excel.metadata.property.LoopMergeProperty;
import com.alibaba.excel.metadata.property.OnceAbsoluteMergeProperty;
import com.alibaba.excel.metadata.property.RowHeightProperty;
import com.alibaba.excel.metadata.property.StyleProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ExcelWriteHeadProperty
extends ExcelHeadProperty {
    private RowHeightProperty headRowHeightProperty;
    private RowHeightProperty contentRowHeightProperty;
    private OnceAbsoluteMergeProperty onceAbsoluteMergeProperty;

    public ExcelWriteHeadProperty(Holder holder, Class headClazz, List<List<String>> head, Boolean convertAllFiled) {
        super(holder, headClazz, head, convertAllFiled);
        if (this.getHeadKind() != HeadKindEnum.CLASS) {
            return;
        }
        this.headRowHeightProperty = RowHeightProperty.build(headClazz.getAnnotation(HeadRowHeight.class));
        this.contentRowHeightProperty = RowHeightProperty.build(headClazz.getAnnotation(ContentRowHeight.class));
        this.onceAbsoluteMergeProperty = OnceAbsoluteMergeProperty.build(headClazz.getAnnotation(OnceAbsoluteMerge.class));
        ColumnWidth parentColumnWidth = headClazz.getAnnotation(ColumnWidth.class);
        HeadStyle parentHeadStyle = headClazz.getAnnotation(HeadStyle.class);
        HeadFontStyle parentHeadFontStyle = headClazz.getAnnotation(HeadFontStyle.class);
        ContentStyle parentContentStyle = headClazz.getAnnotation(ContentStyle.class);
        ContentFontStyle parentContentFontStyle = headClazz.getAnnotation(ContentFontStyle.class);
        for (Map.Entry<Integer, ExcelContentProperty> entry : this.getContentPropertyMap().entrySet()) {
            NumberFormat numberFormat;
            Integer index = entry.getKey();
            ExcelContentProperty excelContentPropertyData = entry.getValue();
            Field field = excelContentPropertyData.getField();
            Head headData = this.getHeadMap().get(index);
            ColumnWidth columnWidth = field.getAnnotation(ColumnWidth.class);
            if (columnWidth == null) {
                columnWidth = parentColumnWidth;
            }
            headData.setColumnWidthProperty(ColumnWidthProperty.build(columnWidth));
            HeadStyle headStyle = field.getAnnotation(HeadStyle.class);
            if (headStyle == null) {
                headStyle = parentHeadStyle;
            }
            headData.setHeadStyleProperty(StyleProperty.build(headStyle));
            HeadFontStyle headFontStyle = field.getAnnotation(HeadFontStyle.class);
            if (headFontStyle == null) {
                headFontStyle = parentHeadFontStyle;
            }
            headData.setHeadFontProperty(FontProperty.build(headFontStyle));
            ContentStyle contentStyle = field.getAnnotation(ContentStyle.class);
            if (contentStyle == null) {
                contentStyle = parentContentStyle;
            }
            headData.setContentStyleProperty(StyleProperty.build(contentStyle));
            ContentFontStyle contentFontStyle = field.getAnnotation(ContentFontStyle.class);
            if (contentFontStyle == null) {
                contentFontStyle = parentContentFontStyle;
            }
            headData.setContentFontProperty(FontProperty.build(contentFontStyle));
            headData.setLoopMergeProperty(LoopMergeProperty.build(field.getAnnotation(ContentLoopMerge.class)));
            if (excelContentPropertyData.getConverter() != null || (numberFormat = field.getAnnotation(NumberFormat.class)) == null) continue;
            excelContentPropertyData.setConverter(DefaultConverterLoader.loadAllConverter().get(ConverterKeyBuild.buildKey(field.getType(), CellDataTypeEnum.STRING)));
        }
    }

    public RowHeightProperty getHeadRowHeightProperty() {
        return this.headRowHeightProperty;
    }

    public void setHeadRowHeightProperty(RowHeightProperty headRowHeightProperty) {
        this.headRowHeightProperty = headRowHeightProperty;
    }

    public RowHeightProperty getContentRowHeightProperty() {
        return this.contentRowHeightProperty;
    }

    public void setContentRowHeightProperty(RowHeightProperty contentRowHeightProperty) {
        this.contentRowHeightProperty = contentRowHeightProperty;
    }

    public OnceAbsoluteMergeProperty getOnceAbsoluteMergeProperty() {
        return this.onceAbsoluteMergeProperty;
    }

    public void setOnceAbsoluteMergeProperty(OnceAbsoluteMergeProperty onceAbsoluteMergeProperty) {
        this.onceAbsoluteMergeProperty = onceAbsoluteMergeProperty;
    }

    public List<CellRange> headCellRangeList() {
        ArrayList<CellRange> cellRangeList = new ArrayList<CellRange>();
        HashSet<String> alreadyRangeSet = new HashSet<String>();
        ArrayList<Head> headList = new ArrayList<Head>(this.getHeadMap().values());
        for (int i = 0; i < headList.size(); ++i) {
            Head head = (Head)headList.get(i);
            List<String> headNameList = head.getHeadNameList();
            for (int j = 0; j < headNameList.size(); ++j) {
                if (alreadyRangeSet.contains(i + "-" + j)) continue;
                alreadyRangeSet.add(i + "-" + j);
                String headName = headNameList.get(j);
                int lastCol = i;
                int lastRow = j;
                int k = i + 1;
                while (k < headList.size() && ((Head)headList.get(k)).getHeadNameList().get(j).equals(headName)) {
                    alreadyRangeSet.add(k + "-" + j);
                    lastCol = k++;
                }
                HashSet<String> tempAlreadyRangeSet = new HashSet<String>();
                int k2 = j + 1;
                block3: while (k2 < headNameList.size()) {
                    for (int l = i; l <= lastCol; ++l) {
                        if (!((Head)headList.get(l)).getHeadNameList().get(k2).equals(headName)) break block3;
                        tempAlreadyRangeSet.add(l + "-" + k2);
                    }
                    lastRow = k2++;
                    alreadyRangeSet.addAll(tempAlreadyRangeSet);
                }
                if (j == lastRow && i == lastCol) continue;
                cellRangeList.add(new CellRange(j, lastRow, i, lastCol));
            }
        }
        return cellRangeList;
    }
}

