/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata.data;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.CellData;
import com.alibaba.excel.metadata.data.CommentData;
import com.alibaba.excel.metadata.data.HyperlinkData;
import com.alibaba.excel.metadata.data.ImageData;
import com.alibaba.excel.metadata.data.RichTextStringData;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.metadata.fill.AnalysisCell;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;

public class WriteCellData<T>
extends CellData<T> {
    private LocalDateTime dateValue;
    private RichTextStringData richTextStringDataValue;
    private List<ImageData> imageDataList;
    private CommentData commentData;
    private HyperlinkData hyperlinkData;
    private WriteCellStyle writeCellStyle;
    private CellStyle originCellStyle;
    private AnalysisCell analysisCell;

    public WriteCellData(String stringValue) {
        this(CellDataTypeEnum.STRING, stringValue);
    }

    public WriteCellData(CellDataTypeEnum type) {
        this.setType(type);
    }

    public WriteCellData(CellDataTypeEnum type, String stringValue) {
        if (type != CellDataTypeEnum.STRING && type != CellDataTypeEnum.ERROR) {
            throw new IllegalArgumentException("Only support CellDataTypeEnum.STRING and  CellDataTypeEnum.ERROR");
        }
        if (stringValue == null) {
            throw new IllegalArgumentException("StringValue can not be null");
        }
        this.setType(type);
        this.setStringValue(stringValue);
    }

    public WriteCellData(BigDecimal numberValue) {
        if (numberValue == null) {
            throw new IllegalArgumentException("DoubleValue can not be null");
        }
        this.setType(CellDataTypeEnum.NUMBER);
        this.setNumberValue(numberValue);
    }

    public WriteCellData(Boolean booleanValue) {
        if (booleanValue == null) {
            throw new IllegalArgumentException("BooleanValue can not be null");
        }
        this.setType(CellDataTypeEnum.BOOLEAN);
        this.setBooleanValue(booleanValue);
    }

    public WriteCellData(Date dateValue) {
        if (dateValue == null) {
            throw new IllegalArgumentException("DateValue can not be null");
        }
        this.setType(CellDataTypeEnum.DATE);
        this.dateValue = LocalDateTime.ofInstant(dateValue.toInstant(), ZoneId.systemDefault());
    }

    public WriteCellData(LocalDateTime dateValue) {
        if (dateValue == null) {
            throw new IllegalArgumentException("DateValue can not be null");
        }
        this.setType(CellDataTypeEnum.DATE);
        this.dateValue = dateValue;
    }

    public WriteCellData(byte[] image) {
        if (image == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        this.setType(CellDataTypeEnum.EMPTY);
        this.imageDataList = ListUtils.newArrayList();
        ImageData imageData = new ImageData();
        imageData.setImage(image);
        this.imageDataList.add(imageData);
    }

    public WriteCellStyle getOrCreateStyle() {
        if (this.writeCellStyle == null) {
            this.writeCellStyle = new WriteCellStyle();
        }
        return this.writeCellStyle;
    }

    public LocalDateTime getDateValue() {
        return this.dateValue;
    }

    public RichTextStringData getRichTextStringDataValue() {
        return this.richTextStringDataValue;
    }

    public List<ImageData> getImageDataList() {
        return this.imageDataList;
    }

    public CommentData getCommentData() {
        return this.commentData;
    }

    public HyperlinkData getHyperlinkData() {
        return this.hyperlinkData;
    }

    public WriteCellStyle getWriteCellStyle() {
        return this.writeCellStyle;
    }

    public CellStyle getOriginCellStyle() {
        return this.originCellStyle;
    }

    public AnalysisCell getAnalysisCell() {
        return this.analysisCell;
    }

    public void setDateValue(LocalDateTime dateValue) {
        this.dateValue = dateValue;
    }

    public void setRichTextStringDataValue(RichTextStringData richTextStringDataValue) {
        this.richTextStringDataValue = richTextStringDataValue;
    }

    public void setImageDataList(List<ImageData> imageDataList) {
        this.imageDataList = imageDataList;
    }

    public void setCommentData(CommentData commentData) {
        this.commentData = commentData;
    }

    public void setHyperlinkData(HyperlinkData hyperlinkData) {
        this.hyperlinkData = hyperlinkData;
    }

    public void setWriteCellStyle(WriteCellStyle writeCellStyle) {
        this.writeCellStyle = writeCellStyle;
    }

    public void setOriginCellStyle(CellStyle originCellStyle) {
        this.originCellStyle = originCellStyle;
    }

    public void setAnalysisCell(AnalysisCell analysisCell) {
        this.analysisCell = analysisCell;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WriteCellData)) {
            return false;
        }
        WriteCellData other = (WriteCellData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalDateTime this$dateValue = this.getDateValue();
        LocalDateTime other$dateValue = other.getDateValue();
        if (this$dateValue == null ? other$dateValue != null : !((Object)this$dateValue).equals(other$dateValue)) {
            return false;
        }
        RichTextStringData this$richTextStringDataValue = this.getRichTextStringDataValue();
        RichTextStringData other$richTextStringDataValue = other.getRichTextStringDataValue();
        if (this$richTextStringDataValue == null ? other$richTextStringDataValue != null : !((Object)this$richTextStringDataValue).equals(other$richTextStringDataValue)) {
            return false;
        }
        List<ImageData> this$imageDataList = this.getImageDataList();
        List<ImageData> other$imageDataList = other.getImageDataList();
        if (this$imageDataList == null ? other$imageDataList != null : !((Object)this$imageDataList).equals(other$imageDataList)) {
            return false;
        }
        CommentData this$commentData = this.getCommentData();
        CommentData other$commentData = other.getCommentData();
        if (this$commentData == null ? other$commentData != null : !((Object)this$commentData).equals(other$commentData)) {
            return false;
        }
        HyperlinkData this$hyperlinkData = this.getHyperlinkData();
        HyperlinkData other$hyperlinkData = other.getHyperlinkData();
        if (this$hyperlinkData == null ? other$hyperlinkData != null : !((Object)this$hyperlinkData).equals(other$hyperlinkData)) {
            return false;
        }
        WriteCellStyle this$writeCellStyle = this.getWriteCellStyle();
        WriteCellStyle other$writeCellStyle = other.getWriteCellStyle();
        if (this$writeCellStyle == null ? other$writeCellStyle != null : !((Object)this$writeCellStyle).equals(other$writeCellStyle)) {
            return false;
        }
        CellStyle this$originCellStyle = this.getOriginCellStyle();
        CellStyle other$originCellStyle = other.getOriginCellStyle();
        if (this$originCellStyle == null ? other$originCellStyle != null : !this$originCellStyle.equals(other$originCellStyle)) {
            return false;
        }
        AnalysisCell this$analysisCell = this.getAnalysisCell();
        AnalysisCell other$analysisCell = other.getAnalysisCell();
        return !(this$analysisCell == null ? other$analysisCell != null : !((Object)this$analysisCell).equals(other$analysisCell));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WriteCellData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LocalDateTime $dateValue = this.getDateValue();
        result = result * 59 + ($dateValue == null ? 43 : ((Object)$dateValue).hashCode());
        RichTextStringData $richTextStringDataValue = this.getRichTextStringDataValue();
        result = result * 59 + ($richTextStringDataValue == null ? 43 : ((Object)$richTextStringDataValue).hashCode());
        List<ImageData> $imageDataList = this.getImageDataList();
        result = result * 59 + ($imageDataList == null ? 43 : ((Object)$imageDataList).hashCode());
        CommentData $commentData = this.getCommentData();
        result = result * 59 + ($commentData == null ? 43 : ((Object)$commentData).hashCode());
        HyperlinkData $hyperlinkData = this.getHyperlinkData();
        result = result * 59 + ($hyperlinkData == null ? 43 : ((Object)$hyperlinkData).hashCode());
        WriteCellStyle $writeCellStyle = this.getWriteCellStyle();
        result = result * 59 + ($writeCellStyle == null ? 43 : ((Object)$writeCellStyle).hashCode());
        CellStyle $originCellStyle = this.getOriginCellStyle();
        result = result * 59 + ($originCellStyle == null ? 43 : $originCellStyle.hashCode());
        AnalysisCell $analysisCell = this.getAnalysisCell();
        result = result * 59 + ($analysisCell == null ? 43 : ((Object)$analysisCell).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WriteCellData(super=" + super.toString() + ", dateValue=" + this.getDateValue() + ", richTextStringDataValue=" + this.getRichTextStringDataValue() + ", imageDataList=" + this.getImageDataList() + ", commentData=" + this.getCommentData() + ", hyperlinkData=" + this.getHyperlinkData() + ", writeCellStyle=" + this.getWriteCellStyle() + ", originCellStyle=" + this.getOriginCellStyle() + ", analysisCell=" + this.getAnalysisCell() + ")";
    }

    public WriteCellData() {
    }
}

