/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata.format;

import com.alibaba.excel.metadata.format.ExcelGeneralNumberFormat;
import com.alibaba.excel.util.DateUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.format.CellFormat;
import org.apache.poi.ss.format.CellFormatResult;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;
import org.apache.poi.ss.usermodel.FractionFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataFormatter.class);
    private static final String defaultFractionWholePartFormat = "#";
    private static final String defaultFractionFractionPartFormat = "#/##";
    private static final Pattern numPattern = Pattern.compile("[0#]+");
    private static final Pattern daysAsText = Pattern.compile("([d]{3,})", 2);
    private static final Pattern amPmPattern = Pattern.compile("(([AP])[M/P]*)|(([\u4e0a\u4e0b])[\u5348/\u4e0b]*)", 2);
    private static final Pattern rangeConditionalPattern = Pattern.compile(".*\\[\\s*(>|>=|<|<=|=)\\s*[0-9]*\\.*[0-9].*");
    private static final Pattern localePatternGroup = Pattern.compile("(\\[\\$[^-\\]]*-[0-9A-Z]+])");
    private static final Pattern colorPattern = Pattern.compile("(\\[BLACK])|(\\[BLUE])|(\\[CYAN])|(\\[GREEN])|(\\[MAGENTA])|(\\[RED])|(\\[WHITE])|(\\[YELLOW])|(\\[COLOR\\s*\\d])|(\\[COLOR\\s*[0-5]\\d])|(\\[DBNum(1|2|3)])|(\\[\\$-\\d{0,3}])", 2);
    private static final Pattern fractionPattern = Pattern.compile("(?:([#\\d]+)\\s+)?(#+)\\s*/\\s*([#\\d]+)");
    private static final Pattern fractionStripper = Pattern.compile("(\"[^\"]*\")|([^ ?#\\d/]+)");
    private static final Pattern alternateGrouping = Pattern.compile("([#0]([^.#0])[#0]{3})");
    private static final String invalidDateTimeString;
    private DecimalFormatSymbols decimalSymbols;
    private DateFormatSymbols dateSymbols;
    private Format defaultNumFormat;
    private final Map<String, Format> formats = new HashMap<String, Format>();
    private Locale locale;
    private Boolean use1904windowing;
    private Boolean useScientificFormat;

    public DataFormatter(Boolean use1904windowing, Locale locale, Boolean useScientificFormat) {
        this.use1904windowing = use1904windowing == null ? Boolean.FALSE : use1904windowing;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.useScientificFormat = use1904windowing == null ? Boolean.FALSE : useScientificFormat;
        this.dateSymbols = DateFormatSymbols.getInstance(this.locale);
        this.decimalSymbols = DecimalFormatSymbols.getInstance(this.locale);
    }

    private Format getFormat(Double data, Short dataFormat, String dataFormatString) {
        Format format;
        String formatStr = dataFormatString;
        if (formatStr.contains(";") && (formatStr.indexOf(59) != formatStr.lastIndexOf(59) || rangeConditionalPattern.matcher(formatStr).matches())) {
            try {
                CellFormat cfmt = CellFormat.getInstance((Locale)this.locale, (String)formatStr);
                Comparable<Double> cellValueO = data;
                if (DateUtil.isADateFormat((int)dataFormat.shortValue(), (String)formatStr) && data != 0.0) {
                    cellValueO = DateUtil.getJavaDate((double)data, (boolean)this.use1904windowing);
                }
                return new CellFormatResultWrapper(cfmt.apply((Object)cellValueO));
            }
            catch (Exception e) {
                LOGGER.warn("Formatting failed for format {}, falling back", (Object)formatStr, (Object)e);
            }
        }
        if ((format = this.formats.get(formatStr)) != null) {
            return format;
        }
        if ("General".equalsIgnoreCase(formatStr) || "@".equals(formatStr)) {
            format = this.getDefaultFormat();
            this.addFormat(formatStr, format);
            return format;
        }
        format = this.createFormat(dataFormat, formatStr);
        this.addFormat(formatStr, format);
        return format;
    }

    private Format createFormat(Short dataFormat, String dataFormatString) {
        String nFormatStr;
        String colour;
        int at;
        String formatStr = dataFormatString;
        Format format = this.checkSpecialConverter(formatStr);
        if (format != null) {
            return format;
        }
        Matcher colourM = colorPattern.matcher(formatStr);
        while (colourM.find() && (at = formatStr.indexOf(colour = colourM.group())) != -1 && !(nFormatStr = formatStr.substring(0, at) + formatStr.substring(at + colour.length())).equals(formatStr)) {
            formatStr = nFormatStr;
            colourM = colorPattern.matcher(formatStr);
        }
        Matcher m = localePatternGroup.matcher(formatStr);
        while (m.find()) {
            String match = m.group();
            String symbol = match.substring(match.indexOf(36) + 1, match.indexOf(45));
            if (symbol.indexOf(36) > -1) {
                symbol = symbol.substring(0, symbol.indexOf(36)) + '\\' + symbol.substring(symbol.indexOf(36));
            }
            formatStr = m.replaceAll(symbol);
            m = localePatternGroup.matcher(formatStr);
        }
        if (formatStr == null || formatStr.trim().length() == 0) {
            return this.getDefaultFormat();
        }
        if ("General".equalsIgnoreCase(formatStr) || "@".equals(formatStr)) {
            return this.getDefaultFormat();
        }
        if (DateUtils.isADateFormat(dataFormat, formatStr)) {
            return this.createDateFormat(formatStr);
        }
        if (formatStr.contains("#/") || formatStr.contains("?/")) {
            String[] chunks;
            for (String chunk1 : chunks = formatStr.split(";")) {
                String chunk = chunk1.replaceAll("\\?", defaultFractionWholePartFormat);
                Matcher matcher = fractionStripper.matcher(chunk);
                chunk = matcher.replaceAll(" ");
                Matcher fractionMatcher = fractionPattern.matcher(chunk = chunk.replaceAll(" +", " "));
                if (!fractionMatcher.find()) continue;
                String wholePart = fractionMatcher.group(1) == null ? "" : defaultFractionWholePartFormat;
                return new FractionFormat(wholePart, fractionMatcher.group(3));
            }
            return new FractionFormat(defaultFractionWholePartFormat, defaultFractionFractionPartFormat);
        }
        if (numPattern.matcher(formatStr).find()) {
            return this.createNumberFormat(formatStr);
        }
        return this.getDefaultFormat();
    }

    private Format checkSpecialConverter(String dataFormatString) {
        if ("00000\\-0000".equals(dataFormatString) || "00000-0000".equals(dataFormatString)) {
            return new ZipPlusFourFormat();
        }
        if ("[<=9999999]###\\-####;\\(###\\)\\ ###\\-####".equals(dataFormatString) || "[<=9999999]###-####;(###) ###-####".equals(dataFormatString) || "###\\-####;\\(###\\)\\ ###\\-####".equals(dataFormatString) || "###-####;(###) ###-####".equals(dataFormatString)) {
            return new PhoneFormat();
        }
        if ("000\\-00\\-0000".equals(dataFormatString) || "000-00-0000".equals(dataFormatString)) {
            return new SSNFormat();
        }
        return null;
    }

    private Format createDateFormat(String pFormatStr) {
        String formatStr = pFormatStr;
        formatStr = formatStr.replaceAll("\\\\-", "-");
        formatStr = formatStr.replaceAll("\\\\,", ",");
        formatStr = formatStr.replaceAll("\\\\\\.", ".");
        formatStr = formatStr.replaceAll("\\\\ ", " ");
        formatStr = formatStr.replaceAll("\\\\/", "/");
        formatStr = formatStr.replaceAll(";@", "");
        formatStr = formatStr.replaceAll("\"/\"", "/");
        formatStr = formatStr.replace("\"\"", "'");
        formatStr = formatStr.replaceAll("\\\\T", "'T'");
        formatStr = formatStr.replace("\"", "");
        boolean hasAmPm = false;
        Matcher amPmMatcher = amPmPattern.matcher(formatStr);
        while (amPmMatcher.find()) {
            formatStr = amPmMatcher.replaceAll("@");
            hasAmPm = true;
            amPmMatcher = amPmPattern.matcher(formatStr);
        }
        Matcher dateMatcher = daysAsText.matcher(formatStr = formatStr.replaceAll("@", "a"));
        if (dateMatcher.find()) {
            String match = dateMatcher.group(0).toUpperCase(Locale.ROOT).replaceAll("D", "E");
            formatStr = dateMatcher.replaceAll(match);
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = formatStr.toCharArray();
        boolean mIsMonth = true;
        ArrayList<Integer> ms = new ArrayList<Integer>();
        boolean isElapsed = false;
        block3: for (int j = 0; j < chars.length; ++j) {
            char c = chars[j];
            if (c == '\'') {
                sb.append(c);
                ++j;
                while (j < chars.length) {
                    c = chars[j];
                    sb.append(c);
                    if (c == '\'') continue block3;
                    ++j;
                }
                continue;
            }
            if (c == '[' && !isElapsed) {
                isElapsed = true;
                mIsMonth = false;
                sb.append(c);
                continue;
            }
            if (c == ']' && isElapsed) {
                isElapsed = false;
                sb.append(c);
                continue;
            }
            if (isElapsed) {
                if (c == 'h' || c == 'H') {
                    sb.append('H');
                    continue;
                }
                if (c == 'm' || c == 'M') {
                    sb.append('m');
                    continue;
                }
                if (c == 's' || c == 'S') {
                    sb.append('s');
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == 'h' || c == 'H') {
                mIsMonth = false;
                if (hasAmPm) {
                    sb.append('h');
                    continue;
                }
                sb.append('H');
                continue;
            }
            if (c == 'm' || c == 'M') {
                if (mIsMonth) {
                    sb.append('M');
                    ms.add(sb.length() - 1);
                    continue;
                }
                sb.append('m');
                continue;
            }
            if (c == 's' || c == 'S') {
                sb.append('s');
                Iterator iterator = ms.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    if (sb.charAt(index) != 'M') continue;
                    sb.replace(index, index + 1, "m");
                }
                mIsMonth = true;
                ms.clear();
                continue;
            }
            if (Character.isLetter(c)) {
                mIsMonth = true;
                ms.clear();
                if (c == 'y' || c == 'Y') {
                    sb.append('y');
                    continue;
                }
                if (c == 'd' || c == 'D') {
                    sb.append('d');
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                ms.clear();
            }
            sb.append(c);
        }
        formatStr = sb.toString();
        try {
            return new ExcelStyleDateFormatter(formatStr, this.dateSymbols);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.debug("Formatting failed for format {}, falling back", (Object)formatStr, (Object)iae);
            return this.getDefaultFormat();
        }
    }

    private String cleanFormatForNumber(String formatStr) {
        char c;
        int i;
        StringBuilder sb = new StringBuilder(formatStr);
        for (i = 0; i < sb.length(); ++i) {
            c = sb.charAt(i);
            if (c != '_' && c != '*' || i > 0 && sb.charAt(i - 1) == '\\') continue;
            if (i < sb.length() - 1) {
                sb.deleteCharAt(i + 1);
            }
            sb.deleteCharAt(i);
            --i;
        }
        for (i = 0; i < sb.length(); ++i) {
            c = sb.charAt(i);
            if (c == '\\' || c == '\"') {
                sb.deleteCharAt(i);
                --i;
                continue;
            }
            if (c != '+' || i <= 0 || sb.charAt(i - 1) != 'E') continue;
            sb.deleteCharAt(i);
            --i;
        }
        return sb.toString();
    }

    private Format createNumberFormat(String formatStr) {
        char grouping;
        String format = this.cleanFormatForNumber(formatStr);
        DecimalFormatSymbols symbols = this.decimalSymbols;
        Matcher agm = alternateGrouping.matcher(format);
        if (agm.find() && (grouping = agm.group(2).charAt(0)) != ',') {
            symbols = DecimalFormatSymbols.getInstance(this.locale);
            symbols.setGroupingSeparator(grouping);
            String oldPart = agm.group(1);
            String newPart = oldPart.replace(grouping, ',');
            format = format.replace(oldPart, newPart);
        }
        try {
            return new InternalDecimalFormatWithScale(format, symbols);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error("Formatting failed for format {}, falling back", (Object)formatStr, (Object)iae);
            return this.getDefaultFormat();
        }
    }

    private Format getDefaultFormat() {
        if (this.defaultNumFormat != null) {
            return this.defaultNumFormat;
        }
        this.defaultNumFormat = new ExcelGeneralNumberFormat(this.locale, this.useScientificFormat);
        return this.defaultNumFormat;
    }

    private String performDateFormatting(Date d, Format dateFormat) {
        Format df = dateFormat != null ? dateFormat : this.getDefaultFormat();
        return df.format(d);
    }

    private String getFormattedDateString(Double data, Short dataFormat, String dataFormatString) {
        Format dateFormat = this.getFormat(data, dataFormat, dataFormatString);
        if (dateFormat instanceof ExcelStyleDateFormatter) {
            ((ExcelStyleDateFormatter)dateFormat).setDateToBeFormatted(data.doubleValue());
        }
        return this.performDateFormatting(DateUtil.getJavaDate((double)data, (boolean)this.use1904windowing), dateFormat);
    }

    private String getFormattedNumberString(BigDecimal data, Short dataFormat, String dataFormatString) {
        Format numberFormat = this.getFormat(data.doubleValue(), dataFormat, dataFormatString);
        String formatted = numberFormat.format(data);
        return formatted.replaceFirst("E(\\d)", "E+$1");
    }

    public String format(BigDecimal data, Short dataFormat, String dataFormatString) {
        if (DateUtils.isADateFormat(dataFormat, dataFormatString)) {
            return this.getFormattedDateString(data.doubleValue(), dataFormat, dataFormatString);
        }
        return this.getFormattedNumberString(data, dataFormat, dataFormatString);
    }

    public void setDefaultNumberFormat(Format format) {
        for (Map.Entry<String, Format> entry : this.formats.entrySet()) {
            if (entry.getValue() != this.defaultNumFormat) continue;
            entry.setValue(format);
        }
        this.defaultNumFormat = format;
    }

    public void addFormat(String excelFormatStr, Format format) {
        this.formats.put(excelFormatStr, format);
    }

    private static DecimalFormat createIntegerOnlyFormat(String fmt) {
        DecimalFormatSymbols dsf = DecimalFormatSymbols.getInstance(Locale.ROOT);
        DecimalFormat result = new DecimalFormat(fmt, dsf);
        result.setParseIntegerOnly(true);
        return result;
    }

    public static void setExcelStyleRoundingMode(DecimalFormat format) {
        DataFormatter.setExcelStyleRoundingMode(format, RoundingMode.HALF_UP);
    }

    public static void setExcelStyleRoundingMode(DecimalFormat format, RoundingMode roundingMode) {
        format.setRoundingMode(roundingMode);
    }

    static /* synthetic */ DecimalFormat access$400(String x0) {
        return DataFormatter.createIntegerOnlyFormat(x0);
    }

    static {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 255; ++i) {
            buf.append('#');
        }
        invalidDateTimeString = buf.toString();
    }

    private final class CellFormatResultWrapper
    extends Format {
        private final CellFormatResult result;

        private CellFormatResultWrapper(CellFormatResult result) {
            this.result = result;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(this.result.text.trim());
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }

    private static final class PhoneFormat
    extends Format {
        private static final DecimalFormat df = DataFormatter.access$400("##########");

        private PhoneFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuilder sb = new StringBuilder();
            int len = result.length();
            if (len <= 4) {
                return result;
            }
            String seg3 = result.substring(len - 4, len);
            String seg2 = result.substring(Math.max(0, len - 7), len - 4);
            String seg1 = result.substring(Math.max(0, len - 10), Math.max(0, len - 7));
            if (seg1.trim().length() > 0) {
                sb.append('(').append(seg1).append(") ");
            }
            if (seg2.trim().length() > 0) {
                sb.append(seg2).append('-');
            }
            sb.append(seg3);
            return sb.toString();
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(PhoneFormat.format((Number)obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class ZipPlusFourFormat
    extends Format {
        private static final DecimalFormat df = DataFormatter.access$400("000000000");

        private ZipPlusFourFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            return result.substring(0, 5) + '-' + result.substring(5, 9);
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(ZipPlusFourFormat.format((Number)obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class SSNFormat
    extends Format {
        private static final DecimalFormat df = DataFormatter.access$400("000000000");

        private SSNFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            return result.substring(0, 3) + '-' + result.substring(3, 5) + '-' + result.substring(5, 9);
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(SSNFormat.format((Number)obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static class InternalDecimalFormatWithScale
    extends Format {
        private static final Pattern endsWithCommas = Pattern.compile("(,+)$");
        private BigDecimal divider;
        private static final BigDecimal ONE_THOUSAND = new BigDecimal(1000);
        private final DecimalFormat df;

        private static String trimTrailingCommas(String s) {
            return s.replaceAll(",+$", "");
        }

        public InternalDecimalFormatWithScale(String pattern, DecimalFormatSymbols symbols) {
            this.df = new DecimalFormat(InternalDecimalFormatWithScale.trimTrailingCommas(pattern), symbols);
            DataFormatter.setExcelStyleRoundingMode(this.df);
            Matcher endsWithCommasMatcher = endsWithCommas.matcher(pattern);
            if (endsWithCommasMatcher.find()) {
                String commas = endsWithCommasMatcher.group(1);
                BigDecimal temp = BigDecimal.ONE;
                for (int i = 0; i < commas.length(); ++i) {
                    temp = temp.multiply(ONE_THOUSAND);
                }
                this.divider = temp;
            } else {
                this.divider = null;
            }
        }

        private Object scaleInput(Object obj) {
            if (this.divider != null) {
                if (obj instanceof BigDecimal) {
                    obj = ((BigDecimal)obj).divide(this.divider, RoundingMode.HALF_UP);
                } else if (obj instanceof Double) {
                    obj = (Double)obj / this.divider.doubleValue();
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            return obj;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            obj = this.scaleInput(obj);
            return this.df.format(obj, toAppendTo, pos);
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException();
        }
    }
}

