/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.style;

import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.style.AbstractCellStyleStrategy;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class HorizontalCellStyleStrategy
extends AbstractCellStyleStrategy {
    private WriteCellStyle headWriteCellStyle;
    private List<WriteCellStyle> contentWriteCellStyleList;

    public HorizontalCellStyleStrategy() {
    }

    public HorizontalCellStyleStrategy(WriteCellStyle headWriteCellStyle, List<WriteCellStyle> contentWriteCellStyleList) {
        this.headWriteCellStyle = headWriteCellStyle;
        this.contentWriteCellStyleList = contentWriteCellStyleList;
    }

    public HorizontalCellStyleStrategy(WriteCellStyle headWriteCellStyle, WriteCellStyle contentWriteCellStyle) {
        this.headWriteCellStyle = headWriteCellStyle;
        if (contentWriteCellStyle != null) {
            this.contentWriteCellStyleList = ListUtils.newArrayList(contentWriteCellStyle);
        }
    }

    @Override
    protected void setHeadCellStyle(CellWriteHandlerContext context) {
        if (this.stopProcessing(context) || this.headWriteCellStyle == null) {
            return;
        }
        WriteCellData<?> cellData = context.getFirstCellData();
        WriteCellStyle.merge(this.headWriteCellStyle, cellData.getOrCreateStyle());
    }

    @Override
    protected void setContentCellStyle(CellWriteHandlerContext context) {
        if (this.stopProcessing(context) || CollectionUtils.isEmpty(this.contentWriteCellStyleList)) {
            return;
        }
        WriteCellData<?> cellData = context.getFirstCellData();
        if (context.getRelativeRowIndex() == null || context.getRelativeRowIndex() <= 0) {
            WriteCellStyle.merge(this.contentWriteCellStyleList.get(0), cellData.getOrCreateStyle());
        } else {
            WriteCellStyle.merge(this.contentWriteCellStyleList.get(context.getRelativeRowIndex() % this.contentWriteCellStyleList.size()), cellData.getOrCreateStyle());
        }
    }

    protected boolean stopProcessing(CellWriteHandlerContext context) {
        return context.getFirstCellData() == null;
    }

    public WriteCellStyle getHeadWriteCellStyle() {
        return this.headWriteCellStyle;
    }

    public List<WriteCellStyle> getContentWriteCellStyleList() {
        return this.contentWriteCellStyleList;
    }

    public void setHeadWriteCellStyle(WriteCellStyle headWriteCellStyle) {
        this.headWriteCellStyle = headWriteCellStyle;
    }

    public void setContentWriteCellStyleList(List<WriteCellStyle> contentWriteCellStyleList) {
        this.contentWriteCellStyleList = contentWriteCellStyleList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HorizontalCellStyleStrategy)) {
            return false;
        }
        HorizontalCellStyleStrategy other = (HorizontalCellStyleStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WriteCellStyle this$headWriteCellStyle = this.getHeadWriteCellStyle();
        WriteCellStyle other$headWriteCellStyle = other.getHeadWriteCellStyle();
        if (this$headWriteCellStyle == null ? other$headWriteCellStyle != null : !((Object)this$headWriteCellStyle).equals(other$headWriteCellStyle)) {
            return false;
        }
        List<WriteCellStyle> this$contentWriteCellStyleList = this.getContentWriteCellStyleList();
        List<WriteCellStyle> other$contentWriteCellStyleList = other.getContentWriteCellStyleList();
        return !(this$contentWriteCellStyleList == null ? other$contentWriteCellStyleList != null : !((Object)this$contentWriteCellStyleList).equals(other$contentWriteCellStyleList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HorizontalCellStyleStrategy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        WriteCellStyle $headWriteCellStyle = this.getHeadWriteCellStyle();
        result = result * 59 + ($headWriteCellStyle == null ? 43 : ((Object)$headWriteCellStyle).hashCode());
        List<WriteCellStyle> $contentWriteCellStyleList = this.getContentWriteCellStyleList();
        result = result * 59 + ($contentWriteCellStyleList == null ? 43 : ((Object)$contentWriteCellStyleList).hashCode());
        return result;
    }

    public String toString() {
        return "HorizontalCellStyleStrategy(super=" + super.toString() + ", headWriteCellStyle=" + this.getHeadWriteCellStyle() + ", contentWriteCellStyleList=" + this.getContentWriteCellStyleList() + ")";
    }
}

