/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel;

import com.alibaba.excel.analysis.ExcelAnalyser;
import com.alibaba.excel.analysis.ExcelAnalyserImpl;
import com.alibaba.excel.analysis.ExcelReadExecutor;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.ReadWorkbook;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelReader.class);
    private ExcelAnalyser excelAnalyser;

    public ExcelReader(ReadWorkbook readWorkbook) {
        this.excelAnalyser = new ExcelAnalyserImpl(readWorkbook);
    }

    @Deprecated
    public void read() {
        this.readAll();
    }

    public void readAll() {
        this.excelAnalyser.analysis(null, Boolean.TRUE);
    }

    public ExcelReader read(ReadSheet ... readSheet) {
        return this.read(Arrays.asList(readSheet));
    }

    public ExcelReader read(List<ReadSheet> readSheetList) {
        this.excelAnalyser.analysis(readSheetList, Boolean.FALSE);
        return this;
    }

    public AnalysisContext analysisContext() {
        return this.excelAnalyser.analysisContext();
    }

    public ExcelReadExecutor excelExecutor() {
        return this.excelAnalyser.excelExecutor();
    }

    @Deprecated
    public AnalysisContext getAnalysisContext() {
        return this.analysisContext();
    }

    public void finish() {
        if (this.excelAnalyser != null) {
            this.excelAnalyser.finish();
        }
    }

    protected void finalize() {
        try {
            this.finish();
        }
        catch (Throwable e) {
            LOGGER.warn("Destroy object failed", e);
        }
    }
}

