/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.asm.ClassWriter;
import com.alibaba.fastjson.asm.FieldVisitor;
import com.alibaba.fastjson.asm.Label;
import com.alibaba.fastjson.asm.MethodVisitor;
import com.alibaba.fastjson.asm.Opcodes;
import com.alibaba.fastjson.serializer.FilterUtils;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.ASMClassLoader;
import com.alibaba.fastjson.util.ASMUtils;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMSerializerFactory
implements Opcodes {
    private ASMClassLoader classLoader = new ASMClassLoader();
    private final AtomicLong seed = new AtomicLong();

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz) throws Exception {
        return this.createJavaBeanSerializer(clazz, null);
    }

    public String getGenClassName(Class<?> clazz) {
        return "Serializer_" + this.seed.incrementAndGet();
    }

    public boolean isExternalClass(Class<?> clazz) {
        return this.classLoader.isExternalClass(clazz);
    }

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz, Map<String, String> aliasMap) throws Exception {
        if (clazz.isPrimitive()) {
            throw new JSONException("unsupportd class " + clazz.getName());
        }
        List<FieldInfo> getters = TypeUtils.computeGetters(clazz, aliasMap, false);
        String className = this.getGenClassName(clazz);
        ClassWriter cw = new ClassWriter();
        cw.visit(49, 33, className, "java/lang/Object", new String[]{"com/alibaba/fastjson/serializer/ObjectSerializer"});
        FieldVisitor fw = cw.visitField(2, "nature", ASMUtils.getDesc(JavaBeanSerializer.class));
        fw.visitEnd();
        for (FieldInfo fieldInfo : getters) {
            FieldVisitor fw2 = cw.visitField(1, fieldInfo.getName() + "_asm_fieldPrefix", "Ljava/lang/reflect/Type;");
            fw2.visitEnd();
            FieldVisitor fw3 = cw.visitField(1, fieldInfo.getName() + "_asm_fieldType", "Ljava/lang/reflect/Type;");
            fw3.visitEnd();
        }
        MethodVisitor mw = cw.visitMethod(1, "<init>", "()V", null, null);
        mw.visitVarInsn(25, 0);
        mw.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        for (FieldInfo fieldInfo : getters) {
            mw.visitVarInsn(25, 0);
            mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.getDesc(fieldInfo.getDeclaringClass())));
            if (fieldInfo.getMethod() != null) {
                mw.visitLdcInsn(fieldInfo.getMethod().getName());
                mw.visitMethodInsn(184, ASMUtils.getType(ASMUtils.class), "getMethodType", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/reflect/Type;");
            } else {
                mw.visitLdcInsn(fieldInfo.getField().getName());
                mw.visitMethodInsn(184, ASMUtils.getType(ASMUtils.class), "getFieldType", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/reflect/Type;");
            }
            mw.visitFieldInsn(181, className, fieldInfo.getName() + "_asm_fieldType", "Ljava/lang/reflect/Type;");
        }
        mw.visitInsn(177);
        mw.visitMaxs(4, 4);
        mw.visitEnd();
        Context context = new Context(className);
        mw = cw.visitMethod(1, "write", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;)V", null, new String[]{"java/io/IOException"});
        mw.visitVarInsn(25, context.serializer());
        mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "getWriter", "()" + ASMUtils.getDesc(SerializeWriter.class));
        mw.visitVarInsn(58, context.var("out"));
        JSONType jsonType = clazz.getAnnotation(JSONType.class);
        if (jsonType == null || jsonType.alphabetic()) {
            Label _else = new Label();
            mw.visitVarInsn(25, context.var("out"));
            mw.visitFieldInsn(178, ASMUtils.getType(SerializerFeature.class), "SortField", "L" + ASMUtils.getType(SerializerFeature.class) + ";");
            mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "isEnabled", "(L" + ASMUtils.getType(SerializerFeature.class) + ";)Z");
            mw.visitJumpInsn(153, _else);
            mw.visitVarInsn(25, 0);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, 2);
            mw.visitVarInsn(25, 3);
            mw.visitVarInsn(25, context.paramFieldType());
            mw.visitMethodInsn(182, className, "write1", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;)V");
            mw.visitInsn(177);
            mw.visitLabel(_else);
        }
        mw.visitVarInsn(25, context.obj());
        mw.visitTypeInsn(192, ASMUtils.getType(clazz));
        mw.visitVarInsn(58, context.var("entity"));
        this.generateWriteMethod(clazz, mw, getters, context);
        mw.visitInsn(177);
        mw.visitMaxs(5, context.getVariantCount() + 1);
        mw.visitEnd();
        List<FieldInfo> list = TypeUtils.computeGetters(clazz, aliasMap, true);
        Context context2 = new Context(className);
        mw = cw.visitMethod(1, "write1", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;)V", null, new String[]{"java/io/IOException"});
        mw.visitVarInsn(25, context2.serializer());
        mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "getWriter", "()" + ASMUtils.getDesc(SerializeWriter.class));
        mw.visitVarInsn(58, context2.var("out"));
        mw.visitVarInsn(25, context2.obj());
        mw.visitTypeInsn(192, ASMUtils.getType(clazz));
        mw.visitVarInsn(58, context2.var("entity"));
        this.generateWriteMethod(clazz, mw, list, context2);
        mw.visitInsn(177);
        mw.visitMaxs(5, context2.getVariantCount() + 1);
        mw.visitEnd();
        byte[] code = cw.toByteArray();
        Class<?> exampleClass = this.classLoader.defineClassPublic(className, code, 0, code.length);
        Object instance = exampleClass.newInstance();
        return (ObjectSerializer)instance;
    }

    private void generateWriteMethod(Class<?> clazz, MethodVisitor mw, List<FieldInfo> getters, Context context) throws Exception {
        Label end = new Label();
        int size = getters.size();
        Label endFormat_ = new Label();
        Label notNull_ = new Label();
        mw.visitVarInsn(25, context.var("out"));
        mw.visitFieldInsn(178, ASMUtils.getType(SerializerFeature.class), "PrettyFormat", "L" + ASMUtils.getType(SerializerFeature.class) + ";");
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "isEnabled", "(L" + ASMUtils.getType(SerializerFeature.class) + ";)Z");
        mw.visitJumpInsn(153, endFormat_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.getClassName(), "nature", ASMUtils.getDesc(JavaBeanSerializer.class));
        mw.visitJumpInsn(199, notNull_);
        this.initNature(clazz, mw, context);
        mw.visitLabel(notNull_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.getClassName(), "nature", ASMUtils.getDesc(JavaBeanSerializer.class));
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitVarInsn(25, 4);
        mw.visitMethodInsn(182, ASMUtils.getType(JavaBeanSerializer.class), "write", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;)V");
        mw.visitInsn(177);
        mw.visitLabel(endFormat_);
        Label endRef_ = new Label();
        notNull_ = new Label();
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.obj());
        mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "containsReference", "(Ljava/lang/Object;)Z");
        mw.visitJumpInsn(153, endRef_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.getClassName(), "nature", ASMUtils.getDesc(JavaBeanSerializer.class));
        mw.visitJumpInsn(199, notNull_);
        this.initNature(clazz, mw, context);
        mw.visitLabel(notNull_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, context.getClassName(), "nature", ASMUtils.getDesc(JavaBeanSerializer.class));
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitMethodInsn(182, ASMUtils.getType(JavaBeanSerializer.class), "writeReference", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;)V");
        mw.visitInsn(177);
        mw.visitLabel(endRef_);
        mw.visitVarInsn(25, context.serializer());
        mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "getContext", "()Lcom/alibaba/fastjson/serializer/SerialContext;");
        mw.visitVarInsn(58, context.var("parent"));
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.var("parent"));
        mw.visitVarInsn(25, context.obj());
        mw.visitVarInsn(25, context.paramFieldName());
        mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "setContext", "(Lcom/alibaba/fastjson/serializer/SerialContext;Ljava/lang/Object;Ljava/lang/Object;)V");
        Label end_ = new Label();
        Label else_ = new Label();
        Label writeClass_ = new Label();
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.paramFieldType());
        mw.visitVarInsn(25, context.obj());
        mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "isWriteClassName", "(Ljava/lang/reflect/Type;Ljava/lang/Object;)Z");
        mw.visitJumpInsn(153, else_);
        mw.visitVarInsn(25, context.paramFieldType());
        mw.visitVarInsn(25, context.obj());
        mw.visitMethodInsn(182, ASMUtils.getType(Object.class), "getClass", "()Ljava/lang/Class;");
        mw.visitJumpInsn(165, else_);
        mw.visitLabel(writeClass_);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitLdcInsn("{\"" + JSON.DEFAULT_TYPE_KEY + "\":\"" + clazz.getName() + "\"");
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "write", "(Ljava/lang/String;)V");
        mw.visitVarInsn(16, 44);
        mw.visitJumpInsn(167, end_);
        mw.visitLabel(else_);
        mw.visitVarInsn(16, 123);
        mw.visitLabel(end_);
        mw.visitVarInsn(54, context.var("seperator"));
        for (int i = 0; i < size; ++i) {
            FieldInfo property = getters.get(i);
            Class<?> propertyClass = property.getFieldClass();
            mw.visitLdcInsn(property.getName());
            mw.visitVarInsn(58, context.fieldName());
            if (propertyClass == Byte.TYPE) {
                this._byte(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Short.TYPE) {
                this._short(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Integer.TYPE) {
                this._int(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Long.TYPE) {
                this._long(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Float.TYPE) {
                this._float(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Double.TYPE) {
                this._double(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Boolean.TYPE) {
                this._boolean(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == Character.TYPE) {
                this._char(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == String.class) {
                this._string(clazz, mw, property, context);
                continue;
            }
            if (propertyClass == BigDecimal.class) {
                this._decimal(clazz, mw, property, context);
                continue;
            }
            if (List.class.isAssignableFrom(propertyClass)) {
                this._list(clazz, mw, property, context);
                continue;
            }
            if (propertyClass.isEnum()) {
                this._enum(clazz, mw, property, context);
                continue;
            }
            this._object(clazz, mw, property, context);
        }
        Label _if = new Label();
        Label _else = new Label();
        Label _end_if = new Label();
        mw.visitLabel(_if);
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitIntInsn(16, 123);
        mw.visitJumpInsn(160, _else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitLdcInsn("{}");
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "write", "(Ljava/lang/String;)V");
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(16, 125);
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "write", "(C)V");
        mw.visitLabel(_end_if);
        mw.visitLabel(end);
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.var("parent"));
        mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "setContext", "(Lcom/alibaba/fastjson/serializer/SerialContext;)V");
    }

    private void initNature(Class<?> clazz, MethodVisitor mw, Context context) {
        mw.visitVarInsn(25, 0);
        mw.visitTypeInsn(187, ASMUtils.getType(JavaBeanSerializer.class));
        mw.visitInsn(89);
        mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.getDesc(clazz)));
        mw.visitMethodInsn(183, ASMUtils.getType(JavaBeanSerializer.class), "<init>", "(" + ASMUtils.getDesc(Class.class) + ")V");
        mw.visitFieldInsn(181, context.getClassName(), "nature", ASMUtils.getDesc(JavaBeanSerializer.class));
    }

    private void _object(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(58, context.var("object"));
        this._filters(mw, property, context, _end);
        this._writeObject(mw, property, context, _end);
        mw.visitLabel(_end);
    }

    private void _enum(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        boolean writeEnumUsingToString = false;
        JSONField annotation = property.getAnnotation(JSONField.class);
        if (annotation != null) {
            for (SerializerFeature feature : annotation.serialzeFeatures()) {
                if (feature != SerializerFeature.WriteEnumUsingToString) continue;
                writeEnumUsingToString = true;
            }
        }
        Label _not_null = new Label();
        Label _end_if = new Label();
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitTypeInsn(192, ASMUtils.getType(Enum.class));
        mw.visitVarInsn(58, context.var("enum"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("enum"));
        mw.visitJumpInsn(199, _not_null);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_not_null);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(25, context.var("enum"));
        if (writeEnumUsingToString) {
            mw.visitMethodInsn(182, ASMUtils.getType(Object.class), "toString", "()Ljava/lang/String;");
            mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;Ljava/lang/String;)V");
        } else {
            mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;L" + ASMUtils.getType(Enum.class) + ";)V");
        }
        this._seperator(mw, context);
        mw.visitLabel(_end_if);
        mw.visitLabel(_end);
    }

    private void _long(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(55, context.var("long", 2));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(22, context.var("long", 2));
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;J)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _float(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(56, context.var("float"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(23, context.var("float"));
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;F)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _double(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(57, context.var("double", 2));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(24, context.var("double", 2));
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;D)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _char(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(54, context.var("char"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(21, context.var("char"));
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;C)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _boolean(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(54, context.var("boolean"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(21, context.var("boolean"));
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;Z)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _get(MethodVisitor mw, Context context, FieldInfo property) {
        Method method = property.getMethod();
        if (method != null) {
            mw.visitVarInsn(25, context.var("entity"));
            mw.visitMethodInsn(182, ASMUtils.getType(method.getDeclaringClass()), method.getName(), ASMUtils.getDesc(method));
        } else {
            mw.visitVarInsn(25, context.var("entity"));
            mw.visitFieldInsn(180, ASMUtils.getType(property.getDeclaringClass()), property.getName(), ASMUtils.getDesc(property.getFieldClass()));
        }
    }

    private void _byte(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(54, context.var("byte"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(21, context.var("byte"));
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;I)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _short(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(54, context.var("short"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(21, context.var("short"));
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;I)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _int(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(54, context.var("int"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(21, context.var("int"));
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;I)V");
        this._seperator(mw, context);
        mw.visitLabel(_end);
    }

    private void _decimal(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(58, context.var("decimal"));
        this._filters(mw, property, context, _end);
        Label _if = new Label();
        Label _else = new Label();
        Label _end_if = new Label();
        mw.visitLabel(_if);
        mw.visitVarInsn(25, context.var("decimal"));
        mw.visitJumpInsn(199, _else);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(25, context.var("decimal"));
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;Ljava/math/BigDecimal;)V");
        this._seperator(mw, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_end_if);
        mw.visitLabel(_end);
    }

    private void _string(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Label _end = new Label();
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitVarInsn(58, context.var("string"));
        this._filters(mw, property, context, _end);
        Label _else = new Label();
        Label _end_if = new Label();
        mw.visitVarInsn(25, context.var("string"));
        mw.visitJumpInsn(199, _else);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitVarInsn(25, context.var("string"));
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;Ljava/lang/String;)V");
        this._seperator(mw, context);
        mw.visitLabel(_end_if);
        mw.visitLabel(_end);
    }

    private void _list(Class<?> clazz, MethodVisitor mw, FieldInfo property, Context context) {
        Type propertyType = property.getFieldType();
        Object elementType = propertyType instanceof Class ? Object.class : ((ParameterizedType)propertyType).getActualTypeArguments()[0];
        Class elementClass = null;
        if (elementType instanceof Class) {
            elementClass = (Class)elementType;
        }
        Label _end = new Label();
        Label _if = new Label();
        Label _else = new Label();
        Label _end_if = new Label();
        mw.visitLabel(_if);
        this._nameApply(mw, property, context, _end);
        this._get(mw, context, property);
        mw.visitTypeInsn(192, ASMUtils.getType(List.class));
        mw.visitVarInsn(58, context.var("list"));
        this._filters(mw, property, context, _end);
        mw.visitVarInsn(25, context.var("list"));
        mw.visitJumpInsn(199, _else);
        this._if_write_null(mw, property, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "write", "(C)V");
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldName", "(Ljava/lang/String;)V");
        mw.visitVarInsn(25, context.var("list"));
        mw.visitMethodInsn(185, ASMUtils.getType(List.class), "size", "()I");
        mw.visitVarInsn(54, context.var("int"));
        Label _if_3 = new Label();
        Label _else_3 = new Label();
        Label _end_if_3 = new Label();
        mw.visitLabel(_if_3);
        mw.visitVarInsn(21, context.var("int"));
        mw.visitInsn(3);
        mw.visitJumpInsn(160, _else_3);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitLdcInsn("[]");
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "write", "(Ljava/lang/String;)V");
        mw.visitJumpInsn(167, _end_if_3);
        mw.visitLabel(_else_3);
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.var("list"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "setContext", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(16, 91);
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "write", "(C)V");
        mw.visitInsn(1);
        mw.visitTypeInsn(192, ASMUtils.getType(ObjectSerializer.class));
        mw.visitVarInsn(58, context.var("list_ser"));
        Label _for = new Label();
        Label _end_for = new Label();
        mw.visitInsn(3);
        mw.visitVarInsn(54, context.var("i"));
        mw.visitLabel(_for);
        mw.visitVarInsn(21, context.var("i"));
        mw.visitVarInsn(21, context.var("int"));
        mw.visitInsn(4);
        mw.visitInsn(100);
        mw.visitJumpInsn(162, _end_for);
        if (elementType == String.class) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(185, ASMUtils.getType(List.class), "get", "(I)Ljava/lang/Object;");
            mw.visitTypeInsn(192, ASMUtils.getType(String.class));
            mw.visitVarInsn(16, 44);
            mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeString", "(Ljava/lang/String;C)V");
        } else {
            mw.visitVarInsn(25, context.serializer());
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(185, ASMUtils.getType(List.class), "get", "(I)Ljava/lang/Object;");
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(184, ASMUtils.getType(Integer.class), "valueOf", "(I)Ljava/lang/Integer;");
            if (elementClass != null && Modifier.isPublic(elementClass.getModifiers())) {
                mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.getDesc((Class)elementType)));
                mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;)V");
            } else {
                mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            }
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(16, 44);
            mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "write", "(C)V");
        }
        mw.visitIincInsn(context.var("i"), 1);
        mw.visitJumpInsn(167, _for);
        mw.visitLabel(_end_for);
        if (elementType == String.class) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(21, context.var("int"));
            mw.visitInsn(4);
            mw.visitInsn(100);
            mw.visitMethodInsn(185, ASMUtils.getType(List.class), "get", "(I)Ljava/lang/Object;");
            mw.visitTypeInsn(192, ASMUtils.getType(String.class));
            mw.visitVarInsn(16, 93);
            mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeString", "(Ljava/lang/String;C)V");
        } else {
            mw.visitVarInsn(25, context.serializer());
            mw.visitVarInsn(25, context.var("list"));
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(185, ASMUtils.getType(List.class), "get", "(I)Ljava/lang/Object;");
            mw.visitVarInsn(21, context.var("i"));
            mw.visitMethodInsn(184, ASMUtils.getType(Integer.class), "valueOf", "(I)Ljava/lang/Integer;");
            if (elementClass != null && Modifier.isPublic(elementClass.getModifiers())) {
                mw.visitLdcInsn(com.alibaba.fastjson.asm.Type.getType(ASMUtils.getDesc((Class)elementType)));
                mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;)V");
            } else {
                mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            }
            mw.visitVarInsn(25, context.var("out"));
            mw.visitVarInsn(16, 93);
            mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "write", "(C)V");
        }
        mw.visitVarInsn(25, context.serializer());
        mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "popContext", "()V");
        mw.visitLabel(_end_if_3);
        this._seperator(mw, context);
        mw.visitLabel(_end_if);
        mw.visitLabel(_end);
    }

    private void _filters(MethodVisitor mw, FieldInfo property, Context context, Label _end) {
        if (property.getField() != null && Modifier.isTransient(property.getField().getModifiers())) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitFieldInsn(178, ASMUtils.getType(SerializerFeature.class), "SkipTransientField", "L" + ASMUtils.getType(SerializerFeature.class) + ";");
            mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "isEnabled", "(L" + ASMUtils.getType(SerializerFeature.class) + ";)Z");
            mw.visitJumpInsn(154, _end);
        }
        this._apply(mw, property, context);
        mw.visitJumpInsn(153, _end);
        this._processKey(mw, property, context);
        Label _else_processKey = new Label();
        this._processValue(mw, property, context);
        mw.visitVarInsn(25, context.original());
        mw.visitVarInsn(25, context.processValue());
        mw.visitJumpInsn(165, _else_processKey);
        this._writeObject(mw, property, context, _end);
        mw.visitJumpInsn(167, _end);
        mw.visitLabel(_else_processKey);
    }

    private void _nameApply(MethodVisitor mw, FieldInfo property, Context context, Label _end) {
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.obj());
        mw.visitVarInsn(25, context.fieldName());
        mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "applyName", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;)Z");
        mw.visitJumpInsn(153, _end);
    }

    private void _writeObject(MethodVisitor mw, FieldInfo fieldInfo, Context context, Label _end) {
        String format = null;
        JSONField annotation = fieldInfo.getAnnotation(JSONField.class);
        if (annotation != null && (format = annotation.format()).trim().length() == 0) {
            format = null;
        }
        Label _not_null = new Label();
        mw.visitVarInsn(25, context.processValue());
        mw.visitJumpInsn(199, _not_null);
        this._if_write_null(mw, fieldInfo, context);
        mw.visitJumpInsn(167, _end);
        mw.visitLabel(_not_null);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "write", "(C)V");
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(25, context.fieldName());
        mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldName", "(Ljava/lang/String;)V");
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.processValue());
        if (format != null) {
            mw.visitLdcInsn(format);
            mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "writeWithFormat", "(Ljava/lang/Object;Ljava/lang/String;)V");
        } else {
            mw.visitVarInsn(25, context.fieldName());
            if (fieldInfo.getFieldType() instanceof Class && ((Class)fieldInfo.getFieldType()).isPrimitive()) {
                mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            } else {
                mw.visitVarInsn(25, 0);
                mw.visitFieldInsn(180, context.getClassName(), fieldInfo.getName() + "_asm_fieldType", "Ljava/lang/reflect/Type;");
                mw.visitMethodInsn(182, ASMUtils.getType(JSONSerializer.class), "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;)V");
            }
        }
        this._seperator(mw, context);
    }

    private void _apply(MethodVisitor mw, FieldInfo property, Context context) {
        Class<?> propertyClass = property.getFieldClass();
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.obj());
        mw.visitVarInsn(25, context.fieldName());
        if (propertyClass == Byte.TYPE) {
            mw.visitVarInsn(21, context.var("byte"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;B)Z");
        } else if (propertyClass == Short.TYPE) {
            mw.visitVarInsn(21, context.var("short"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;S)Z");
        } else if (propertyClass == Integer.TYPE) {
            mw.visitVarInsn(21, context.var("int"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;I)Z");
        } else if (propertyClass == Character.TYPE) {
            mw.visitVarInsn(21, context.var("char"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;C)Z");
        } else if (propertyClass == Long.TYPE) {
            mw.visitVarInsn(22, context.var("long", 2));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;J)Z");
        } else if (propertyClass == Float.TYPE) {
            mw.visitVarInsn(23, context.var("float"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;F)Z");
        } else if (propertyClass == Double.TYPE) {
            mw.visitVarInsn(24, context.var("double", 2));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;D)Z");
        } else if (propertyClass == Boolean.TYPE) {
            mw.visitVarInsn(21, context.var("boolean"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;B)Z");
        } else if (propertyClass == BigDecimal.class) {
            mw.visitVarInsn(25, context.var("decimal"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Z");
        } else if (propertyClass == String.class) {
            mw.visitVarInsn(25, context.var("string"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Z");
        } else if (propertyClass.isEnum()) {
            mw.visitVarInsn(25, context.var("enum"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Z");
        } else if (List.class.isAssignableFrom(propertyClass)) {
            mw.visitVarInsn(25, context.var("list"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Z");
        } else {
            mw.visitVarInsn(25, context.var("object"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "apply", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Z");
        }
    }

    private void _processValue(MethodVisitor mw, FieldInfo property, Context context) {
        Class<?> propertyClass = property.getFieldClass();
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.obj());
        mw.visitVarInsn(25, context.fieldName());
        if (propertyClass == Byte.TYPE) {
            mw.visitVarInsn(21, context.var("byte"));
            mw.visitMethodInsn(184, ASMUtils.getType(Byte.class), "valueOf", "(B)Ljava/lang/Byte;");
        } else if (propertyClass == Short.TYPE) {
            mw.visitVarInsn(21, context.var("short"));
            mw.visitMethodInsn(184, ASMUtils.getType(Short.class), "valueOf", "(S)Ljava/lang/Short;");
        } else if (propertyClass == Integer.TYPE) {
            mw.visitVarInsn(21, context.var("int"));
            mw.visitMethodInsn(184, ASMUtils.getType(Integer.class), "valueOf", "(I)Ljava/lang/Integer;");
        } else if (propertyClass == Character.TYPE) {
            mw.visitVarInsn(21, context.var("char"));
            mw.visitMethodInsn(184, ASMUtils.getType(Character.class), "valueOf", "(C)Ljava/lang/Character;");
        } else if (propertyClass == Long.TYPE) {
            mw.visitVarInsn(22, context.var("long", 2));
            mw.visitMethodInsn(184, ASMUtils.getType(Long.class), "valueOf", "(J)Ljava/lang/Long;");
        } else if (propertyClass == Float.TYPE) {
            mw.visitVarInsn(23, context.var("float"));
            mw.visitMethodInsn(184, ASMUtils.getType(Float.class), "valueOf", "(F)Ljava/lang/Float;");
        } else if (propertyClass == Double.TYPE) {
            mw.visitVarInsn(24, context.var("double", 2));
            mw.visitMethodInsn(184, ASMUtils.getType(Double.class), "valueOf", "(D)Ljava/lang/Double;");
        } else if (propertyClass == Boolean.TYPE) {
            mw.visitVarInsn(21, context.var("boolean"));
            mw.visitMethodInsn(184, ASMUtils.getType(Boolean.class), "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (propertyClass == BigDecimal.class) {
            mw.visitVarInsn(25, context.var("decimal"));
        } else if (propertyClass == String.class) {
            mw.visitVarInsn(25, context.var("string"));
        } else if (propertyClass.isEnum()) {
            mw.visitVarInsn(25, context.var("enum"));
        } else if (List.class.isAssignableFrom(propertyClass)) {
            mw.visitVarInsn(25, context.var("list"));
        } else {
            mw.visitVarInsn(25, context.var("object"));
        }
        mw.visitVarInsn(58, context.original());
        mw.visitVarInsn(25, context.original());
        mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processValue", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
        mw.visitVarInsn(58, context.processValue());
    }

    private void _processKey(MethodVisitor mw, FieldInfo property, Context context) {
        Class<?> propertyClass = property.getFieldClass();
        mw.visitVarInsn(25, context.serializer());
        mw.visitVarInsn(25, context.obj());
        mw.visitVarInsn(25, context.fieldName());
        if (propertyClass == Byte.TYPE) {
            mw.visitVarInsn(21, context.var("byte"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;B)Ljava/lang/String;");
        } else if (propertyClass == Short.TYPE) {
            mw.visitVarInsn(21, context.var("short"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;S)Ljava/lang/String;");
        } else if (propertyClass == Integer.TYPE) {
            mw.visitVarInsn(21, context.var("int"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;I)Ljava/lang/String;");
        } else if (propertyClass == Character.TYPE) {
            mw.visitVarInsn(21, context.var("char"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;C)Ljava/lang/String;");
        } else if (propertyClass == Long.TYPE) {
            mw.visitVarInsn(22, context.var("long", 2));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;J)Ljava/lang/String;");
        } else if (propertyClass == Float.TYPE) {
            mw.visitVarInsn(23, context.var("float"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;F)Ljava/lang/String;");
        } else if (propertyClass == Double.TYPE) {
            mw.visitVarInsn(24, context.var("double", 2));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;D)Ljava/lang/String;");
        } else if (propertyClass == Boolean.TYPE) {
            mw.visitVarInsn(21, context.var("boolean"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Z)Ljava/lang/String;");
        } else if (propertyClass == BigDecimal.class) {
            mw.visitVarInsn(25, context.var("decimal"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        } else if (propertyClass == String.class) {
            mw.visitVarInsn(25, context.var("string"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        } else if (propertyClass.isEnum()) {
            mw.visitVarInsn(25, context.var("enum"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        } else if (List.class.isAssignableFrom(propertyClass)) {
            mw.visitVarInsn(25, context.var("list"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        } else {
            mw.visitVarInsn(25, context.var("object"));
            mw.visitMethodInsn(184, ASMUtils.getType(FilterUtils.class), "processKey", "(Lcom/alibaba/fastjson/serializer/JSONSerializer;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        }
        mw.visitVarInsn(58, context.fieldName());
    }

    private void _if_write_null(MethodVisitor mw, FieldInfo fieldInfo, Context context) {
        Class<?> propertyClass = fieldInfo.getFieldClass();
        Label _if = new Label();
        Label _else = new Label();
        Label _write_null = new Label();
        Label _end_if = new Label();
        mw.visitLabel(_if);
        boolean writeNull = false;
        boolean writeNullNumberAsZero = false;
        boolean writeNullStringAsEmpty = false;
        boolean writeNullBooleanAsFalse = false;
        boolean writeNullListAsEmpty = false;
        JSONField annotation = fieldInfo.getAnnotation(JSONField.class);
        if (annotation != null) {
            for (SerializerFeature feature : annotation.serialzeFeatures()) {
                if (feature == SerializerFeature.WriteMapNullValue) {
                    writeNull = true;
                    continue;
                }
                if (feature == SerializerFeature.WriteNullNumberAsZero) {
                    writeNullNumberAsZero = true;
                    continue;
                }
                if (feature == SerializerFeature.WriteNullStringAsEmpty) {
                    writeNullStringAsEmpty = true;
                    continue;
                }
                if (feature == SerializerFeature.WriteNullBooleanAsFalse) {
                    writeNullBooleanAsFalse = true;
                    continue;
                }
                if (feature != SerializerFeature.WriteNullListAsEmpty) continue;
                writeNullListAsEmpty = true;
            }
        }
        if (!writeNull) {
            mw.visitVarInsn(25, context.var("out"));
            mw.visitFieldInsn(178, ASMUtils.getType(SerializerFeature.class), "WriteMapNullValue", "L" + ASMUtils.getType(SerializerFeature.class) + ";");
            mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "isEnabled", "(L" + ASMUtils.getType(SerializerFeature.class) + ";)Z");
            mw.visitJumpInsn(153, _else);
        }
        mw.visitLabel(_write_null);
        mw.visitVarInsn(25, context.var("out"));
        mw.visitVarInsn(21, context.var("seperator"));
        mw.visitVarInsn(25, context.fieldName());
        if (propertyClass == String.class || propertyClass == Character.class) {
            if (writeNullStringAsEmpty) {
                mw.visitLdcInsn("");
                mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;Ljava/lang/String;)V");
            } else {
                mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldNullString", "(CLjava/lang/String;)V");
            }
        } else if (Number.class.isAssignableFrom(propertyClass)) {
            if (writeNullNumberAsZero) {
                mw.visitInsn(3);
                mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;I)V");
            } else {
                mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldNullNumber", "(CLjava/lang/String;)V");
            }
        } else if (propertyClass == Boolean.class) {
            if (writeNullBooleanAsFalse) {
                mw.visitInsn(3);
                mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldValue", "(CLjava/lang/String;Z)V");
            } else {
                mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldNullBoolean", "(CLjava/lang/String;)V");
            }
        } else if (Collection.class.isAssignableFrom(propertyClass) || propertyClass.isArray()) {
            if (writeNullListAsEmpty) {
                mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldEmptyList", "(CLjava/lang/String;)V");
            } else {
                mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldNullList", "(CLjava/lang/String;)V");
            }
        } else {
            mw.visitMethodInsn(182, ASMUtils.getType(SerializeWriter.class), "writeFieldNull", "(CLjava/lang/String;)V");
        }
        this._seperator(mw, context);
        mw.visitJumpInsn(167, _end_if);
        mw.visitLabel(_else);
        mw.visitLabel(_end_if);
    }

    private void _seperator(MethodVisitor mw, Context context) {
        mw.visitVarInsn(16, 44);
        mw.visitVarInsn(54, context.var("seperator"));
    }

    static class Context {
        private final String className;
        private int variantIndex = 8;
        private Map<String, Integer> variants = new HashMap<String, Integer>();

        public Context(String className) {
            this.className = className;
        }

        public int serializer() {
            return 1;
        }

        public String getClassName() {
            return this.className;
        }

        public int obj() {
            return 2;
        }

        public int paramFieldName() {
            return 3;
        }

        public int paramFieldType() {
            return 4;
        }

        public int fieldName() {
            return 5;
        }

        public int original() {
            return 6;
        }

        public int processValue() {
            return 7;
        }

        public int getVariantCount() {
            return this.variantIndex;
        }

        public int var(String name) {
            Integer i = this.variants.get(name);
            if (i == null) {
                this.variants.put(name, this.variantIndex++);
            }
            i = this.variants.get(name);
            return i;
        }

        public int var(String name, int increment) {
            Integer i = this.variants.get(name);
            if (i == null) {
                this.variants.put(name, this.variantIndex);
                this.variantIndex += increment;
            }
            i = this.variants.get(name);
            return i;
        }
    }
}

