/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.support.spring;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastJsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private Charset charset = UTF8;
    private SerializerFeature[] serializerFeature;

    public FastJsonHttpMessageConverter() {
        super(new MediaType[]{new MediaType("application", "json", UTF8), new MediaType("application", "*+json", UTF8)});
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public SerializerFeature[] getFeatures() {
        return this.serializerFeature;
    }

    public void setFeatures(SerializerFeature ... features) {
        this.serializerFeature = features;
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = inputMessage.getBody();
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            if (len <= 0) continue;
            baos.write(buf, 0, len);
        }
        byte[] bytes = baos.toByteArray();
        if (this.charset == UTF8) {
            return JSON.parseObject(bytes, clazz, new Feature[0]);
        }
        return JSON.parseObject(bytes, 0, bytes.length, this.charset.newDecoder(), clazz, new Feature[0]);
    }

    protected void writeInternal(Object obj, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        byte[] bytes;
        OutputStream out = outputMessage.getBody();
        if (this.charset == UTF8) {
            bytes = this.serializerFeature != null ? JSON.toJSONBytes(obj, this.serializerFeature) : JSON.toJSONBytes(obj, new SerializerFeature[0]);
        } else {
            String text = this.serializerFeature != null ? JSON.toJSONString(obj, this.serializerFeature) : JSON.toJSONString(obj);
            bytes = text.getBytes(this.charset);
        }
        out.write(bytes);
    }
}

