/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultFieldDeserializer;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.EnumDeserializer;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.JavaBeanInfo;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessable;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.parser.deserializer.ExtraTypeProvider;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanDeserializer
implements ObjectDeserializer {
    private final FieldDeserializer[] fieldDeserializers;
    private final FieldDeserializer[] sortedFieldDeserializers;
    private final Map<String, FieldDeserializer> alterNameFieldDeserializers;
    protected final Class<?> clazz;
    public final JavaBeanInfo beanInfo;
    private ConcurrentMap<String, Object> extraFieldDeserializers;
    private transient long[] smartMatchHashArray;
    private transient int[] smartMatchHashArrayMapping;

    public JavaBeanDeserializer(ParserConfig config, Class<?> clazz, Type type) {
        this(config, clazz, type, JavaBeanInfo.build(clazz, clazz.getModifiers(), type, false, true, true, true, config.propertyNamingStrategy));
    }

    public JavaBeanDeserializer(ParserConfig config, Class<?> clazz, Type type, JavaBeanInfo beanInfo) {
        FieldDeserializer fieldDeserializer;
        this.clazz = clazz;
        this.beanInfo = beanInfo;
        HashMap<String, FieldDeserializer> alterNameFieldDeserializers = null;
        this.sortedFieldDeserializers = new FieldDeserializer[beanInfo.sortedFields.length];
        for (FieldInfo fieldInfo : beanInfo.sortedFields) {
            this.sortedFieldDeserializers[i] = fieldDeserializer = config.createFieldDeserializer(config, clazz, fieldInfo);
            for (String name : fieldInfo.alternateNames) {
                if (alterNameFieldDeserializers == null) {
                    alterNameFieldDeserializers = new HashMap<String, FieldDeserializer>();
                }
                alterNameFieldDeserializers.put(name, fieldDeserializer);
            }
        }
        this.alterNameFieldDeserializers = alterNameFieldDeserializers;
        this.fieldDeserializers = new FieldDeserializer[beanInfo.fields.length];
        for (FieldInfo fieldInfo : beanInfo.fields) {
            this.fieldDeserializers[i] = fieldDeserializer = this.getFieldDeserializer(fieldInfo.name);
        }
    }

    protected Object createInstance(DefaultJSONParser parser, Type type) {
        Object object;
        if (type instanceof Class && this.clazz.isInterface()) {
            Class clazz = (Class)type;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            boolean ordered = (parser.lexer.features & Feature.OrderedField.mask) != 0;
            JSONObject object2 = new JSONObject(ordered);
            Object proxy = Proxy.newProxyInstance(loader, new Class[]{clazz}, (InvocationHandler)object2);
            return proxy;
        }
        if (this.beanInfo.defaultConstructor == null && this.beanInfo.factoryMethod == null) {
            return null;
        }
        if (this.beanInfo.factoryMethod != null && this.beanInfo.defaultConstructorParameterSize > 0) {
            return null;
        }
        try {
            Constructor<?> constructor = this.beanInfo.defaultConstructor;
            object = this.beanInfo.defaultConstructorParameterSize == 0 ? (constructor != null ? constructor.newInstance(new Object[0]) : this.beanInfo.factoryMethod.invoke(null, new Object[0])) : constructor.newInstance(parser.contex.object);
            if (parser != null && (parser.lexer.features & Feature.InitStringFieldAsEmpty.mask) != 0) {
                for (FieldInfo fieldInfo : this.beanInfo.fields) {
                    if (fieldInfo.fieldClass != String.class) continue;
                    fieldInfo.set(object, "");
                }
            }
        }
        catch (Exception e) {
            throw new JSONException("create instance error, class " + this.clazz.getName(), e);
        }
        return object;
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        return this.deserialze(parser, type, fieldName, null);
    }

    private <T> T deserialzeArrayMapping(DefaultJSONParser parser, Type type, Object fieldName, Object object) {
        JSONLexer lexer = parser.lexer;
        object = this.createInstance(parser, type);
        int size = this.sortedFieldDeserializers.length;
        for (int i = 0; i < size; ++i) {
            int seperator = i == size - 1 ? 93 : 44;
            FieldDeserializer fieldDeser = this.sortedFieldDeserializers[i];
            FieldInfo fieldInfo = fieldDeser.fieldInfo;
            Class<?> fieldClass = fieldInfo.fieldClass;
            try {
                if (fieldClass == Integer.TYPE) {
                    int intValue = (int)lexer.scanLongValue();
                    if (fieldInfo.fieldAccess) {
                        fieldInfo.field.setInt(object, intValue);
                    } else {
                        fieldDeser.setValue(object, new Integer(intValue));
                    }
                    if (lexer.ch == ',') {
                        int index;
                        lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        lexer.token = 16;
                        continue;
                    }
                    if (lexer.ch == ']') {
                        int index;
                        lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        lexer.token = 15;
                        continue;
                    }
                    lexer.nextToken();
                    continue;
                }
                if (fieldClass == String.class) {
                    String strVal;
                    if (lexer.ch == '\"') {
                        strVal = lexer.scanStringValue('\"');
                    } else if (lexer.ch == 'n' && lexer.text.startsWith("null", lexer.bp)) {
                        lexer.bp += 4;
                        int index = lexer.bp;
                        lexer.ch = (char)(lexer.bp >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        strVal = null;
                    } else {
                        throw new JSONException("not match string. feild : " + fieldName);
                    }
                    if (fieldInfo.fieldAccess) {
                        fieldInfo.field.set(object, strVal);
                    } else {
                        fieldDeser.setValue(object, strVal);
                    }
                    if (lexer.ch == ',') {
                        int index;
                        lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        lexer.token = 16;
                        continue;
                    }
                    if (lexer.ch == ']') {
                        int index;
                        lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        lexer.token = 15;
                        continue;
                    }
                    lexer.nextToken();
                    continue;
                }
                if (fieldClass == Long.TYPE) {
                    long longValue = lexer.scanLongValue();
                    if (fieldInfo.fieldAccess) {
                        fieldInfo.field.setLong(object, longValue);
                    } else {
                        fieldDeser.setValue(object, new Long(longValue));
                    }
                    if (lexer.ch == ',') {
                        int index;
                        lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        lexer.token = 16;
                        continue;
                    }
                    if (lexer.ch == ']') {
                        int index;
                        lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        lexer.token = 15;
                        continue;
                    }
                    lexer.nextToken();
                    continue;
                }
                if (fieldClass == Boolean.TYPE) {
                    boolean booleanValue = lexer.scanBoolean();
                    if (fieldInfo.fieldAccess) {
                        fieldInfo.field.setBoolean(object, booleanValue);
                    } else {
                        fieldDeser.setValue(object, booleanValue);
                    }
                    if (lexer.ch == ',') {
                        int index;
                        lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        lexer.token = 16;
                        continue;
                    }
                    if (lexer.ch == ']') {
                        int index;
                        lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        lexer.token = 15;
                        continue;
                    }
                    lexer.nextToken();
                    continue;
                }
                if (fieldClass.isEnum()) {
                    Enum value;
                    char ch = lexer.ch;
                    if (ch == '\"') {
                        String enumName = lexer.scanSymbol(parser.symbolTable);
                        value = enumName == null ? null : (Enum)Enum.valueOf(fieldClass, enumName);
                    } else if (ch >= '0' && ch <= '9') {
                        int ordinal = (int)lexer.scanLongValue();
                        EnumDeserializer enumDeser = (EnumDeserializer)((DefaultFieldDeserializer)fieldDeser).getFieldValueDeserilizer(parser.config);
                        value = enumDeser.ordinalEnums[ordinal];
                    } else {
                        throw new JSONException("illegal enum." + lexer.info());
                    }
                    fieldDeser.setValue(object, value);
                    if (lexer.ch == ',') {
                        int index;
                        lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        lexer.token = 16;
                        continue;
                    }
                    if (lexer.ch == ']') {
                        int index;
                        lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        lexer.token = 15;
                        continue;
                    }
                    lexer.nextToken();
                    continue;
                }
                if (fieldClass == Date.class && lexer.ch == '1') {
                    long longValue = lexer.scanLongValue();
                    fieldDeser.setValue(object, new Date(longValue));
                    if (lexer.ch == ',') {
                        int index;
                        lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        lexer.token = 16;
                        continue;
                    }
                    if (lexer.ch == ']') {
                        int index;
                        lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                        lexer.token = 15;
                        continue;
                    }
                    lexer.nextToken();
                    continue;
                }
                if (lexer.ch == '[') {
                    int index;
                    lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                    lexer.token = 14;
                } else if (lexer.ch == '{') {
                    int index;
                    lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
                    lexer.token = 12;
                } else {
                    lexer.nextToken();
                }
                fieldDeser.parseField(parser, object, fieldInfo.fieldType, null);
                if (!(seperator == 93 ? lexer.token != 15 : seperator == 44 && lexer.token != 16)) continue;
                throw new JSONException("syntax error");
            }
            catch (IllegalAccessException e) {
                throw new JSONException("set " + fieldInfo.name + "error", e);
            }
        }
        if (lexer.ch == ',') {
            int index;
            lexer.ch = (char)((index = ++lexer.bp) >= lexer.len ? 26 : (int)lexer.text.charAt(index));
            lexer.token = 16;
        } else {
            lexer.nextToken();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName, Object object) {
        if (type == JSON.class || type == JSONObject.class) {
            return (T)parser.parse();
        }
        JSONLexer lexer = parser.lexer;
        int token = lexer.token;
        if (token == 8) {
            lexer.nextToken(16);
            return null;
        }
        boolean disableCircularReferenceDetect = lexer.disableCircularReferenceDetect;
        ParseContext context = parser.contex;
        if (object != null && context != null) {
            context = context.parent;
        }
        ParseContext childContext = null;
        try {
            int size;
            HashMap<String, Integer> fieldValues;
            block168: {
                fieldValues = null;
                if (token == 13) {
                    lexer.nextToken(16);
                    if (object == null) {
                        object = this.createInstance(parser, type);
                    }
                    Object object2 = object;
                    return (T)object2;
                }
                if (token == 14) {
                    boolean isSupportArrayToBean;
                    boolean bl = isSupportArrayToBean = this.beanInfo.supportBeanToArray || (lexer.features & Feature.SupportArrayToBean.mask) != 0;
                    if (isSupportArrayToBean) {
                        T t = this.deserialzeArrayMapping(parser, type, fieldName, object);
                        return t;
                    }
                }
                if (token != 12 && token != 16) {
                    String strVal;
                    if (lexer.isBlankInput()) {
                        T isSupportArrayToBean = null;
                        return isSupportArrayToBean;
                    }
                    if (token == 4 && (strVal = lexer.stringVal()).length() == 0) {
                        lexer.nextToken();
                        T t = null;
                        return t;
                    }
                    StringBuffer buf = new StringBuffer().append("syntax error, expect {, actual ").append(lexer.info());
                    if (fieldName instanceof String) {
                        buf.append(", fieldName ").append(fieldName);
                    }
                    throw new JSONException(buf.toString());
                }
                if (parser.resolveStatus == 2) {
                    parser.resolveStatus = 0;
                }
                String typeKey = this.beanInfo.typeKey;
                long matchFieldHash = 0L;
                int fieldIndex = 0;
                size = this.sortedFieldDeserializers.length;
                while (true) {
                    String key = null;
                    FieldDeserializer fieldDeser = null;
                    FieldInfo fieldInfo = null;
                    Class<?> fieldClass = null;
                    if (matchFieldHash != 0L) {
                        fieldDeser = this.getFieldDeserializerByHash(matchFieldHash);
                        if (fieldDeser != null) {
                            fieldInfo = fieldDeser.fieldInfo;
                            fieldClass = fieldInfo.fieldClass;
                        }
                        matchFieldHash = 0L;
                    }
                    if (fieldDeser == null) {
                        if (fieldIndex < size) {
                            fieldDeser = this.sortedFieldDeserializers[fieldIndex];
                            fieldInfo = fieldDeser.fieldInfo;
                            fieldClass = fieldInfo.fieldClass;
                            ++fieldIndex;
                        } else {
                            ++fieldIndex;
                        }
                    }
                    boolean matchField = false;
                    boolean valueParsed = false;
                    Object fieldValue = null;
                    int fieldValueInt = 0;
                    long fieldValueLong = 0L;
                    float fieldValueFloat = 0.0f;
                    double fieldValueDouble = 0.0;
                    if (fieldDeser != null) {
                        long fieldHashCode = fieldInfo.nameHashCode;
                        if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
                            fieldValueInt = lexer.scanFieldInt(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else if (fieldClass == Long.TYPE || fieldClass == Long.class) {
                            fieldValueLong = lexer.scanFieldLong(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else if (fieldClass == String.class) {
                            fieldValue = lexer.scanFieldString(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else if (fieldClass == Date.class) {
                            fieldValue = lexer.scanFieldDate(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else if (fieldClass == Boolean.TYPE || fieldClass == Boolean.class) {
                            fieldValue = lexer.scanFieldBoolean(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else if (fieldClass == Float.TYPE || fieldClass == Float.class) {
                            fieldValueFloat = lexer.scanFieldFloat(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else if (fieldClass == Double.TYPE || fieldClass == Double.class) {
                            fieldValueDouble = lexer.scanFieldDouble(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else if (fieldInfo.isEnum && parser.config.getDeserializer(fieldClass) instanceof EnumDeserializer) {
                            long enumNameHashCode = lexer.scanFieldSymbol(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                                fieldValue = fieldDeser.getEnumByHashCode(enumNameHashCode);
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else if (fieldClass == int[].class) {
                            fieldValue = lexer.scanFieldIntArray(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else if (fieldClass == float[].class) {
                            fieldValue = lexer.scanFieldFloatArray(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else if (fieldClass == double[].class) {
                            fieldValue = lexer.scanFieldDoubleArray(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else if (fieldClass == float[][].class) {
                            fieldValue = lexer.scanFieldFloatArray2(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else if (fieldClass == double[][].class) {
                            fieldValue = lexer.scanFieldDoubleArray2(fieldHashCode);
                            if (lexer.matchStat > 0) {
                                matchField = true;
                                valueParsed = true;
                            } else if (lexer.matchStat == -2) {
                                matchFieldHash = lexer.fieldHash;
                                continue;
                            }
                        } else {
                            if (!lexer.matchField(fieldInfo.nameHashCode)) continue;
                            matchField = true;
                        }
                    }
                    if (!matchField) {
                        key = lexer.scanSymbol(parser.symbolTable);
                        if (key == null) {
                            token = lexer.token;
                            if (token == 13) {
                                lexer.nextToken(16);
                                break block168;
                            }
                            if (token == 16) continue;
                        }
                        if ("$ref" == key && context != null) {
                            Object ref;
                            lexer.nextTokenWithChar(':');
                            token = lexer.token;
                            if (token == 4) {
                                ref = lexer.stringVal();
                                if ("@".equals(ref)) {
                                    object = context.object;
                                } else if ("..".equals(ref)) {
                                    ParseContext parentContext = context.parent;
                                    if (parentContext.object != null) {
                                        object = parentContext.object;
                                    } else {
                                        parser.addResolveTask(new DefaultJSONParser.ResolveTask(parentContext, (String)ref));
                                        parser.resolveStatus = 1;
                                    }
                                } else if ("$".equals(ref)) {
                                    ParseContext rootContext = context;
                                    while (rootContext.parent != null) {
                                        rootContext = rootContext.parent;
                                    }
                                    if (rootContext.object != null) {
                                        object = rootContext.object;
                                    } else {
                                        parser.addResolveTask(new DefaultJSONParser.ResolveTask(rootContext, (String)ref));
                                        parser.resolveStatus = 1;
                                    }
                                } else {
                                    parser.addResolveTask(new DefaultJSONParser.ResolveTask(context, (String)ref));
                                    parser.resolveStatus = 1;
                                }
                            } else {
                                throw new JSONException("illegal ref, " + JSONToken.name(token));
                            }
                            lexer.nextToken(13);
                            if (lexer.token != 13) {
                                throw new JSONException("illegal ref");
                            }
                            lexer.nextToken(16);
                            parser.setContext(context, object, fieldName);
                            ref = object;
                            return (T)ref;
                        }
                        if (typeKey != null && typeKey.equals(key) || "@type" == key) {
                            lexer.nextTokenWithChar(':');
                            if (lexer.token == 4) {
                                Object typedObject;
                                String typeName = lexer.stringVal();
                                lexer.nextToken(16);
                                if (type instanceof Class && typeName.equals(((Class)type).getName())) {
                                    if (lexer.token != 13) continue;
                                    lexer.nextToken();
                                    break block168;
                                }
                                ObjectDeserializer deserizer = this.getSeeAlso(parser.config, this.beanInfo, typeName);
                                Class<?> userType = null;
                                if (deserizer == null) {
                                    userType = parser.config.checkAutoType(typeName, this.clazz, lexer.features);
                                    Class<?> expectClass = TypeUtils.getClass(type);
                                    if (expectClass == null || userType != null && expectClass.isAssignableFrom(userType)) {
                                        deserizer = parser.config.getDeserializer(userType);
                                    } else {
                                        throw new JSONException("type not match");
                                    }
                                }
                                if (deserizer instanceof JavaBeanDeserializer) {
                                    JavaBeanDeserializer javaBeanDeserializer = deserizer;
                                    typedObject = javaBeanDeserializer.deserialze(parser, userType, fieldName, null);
                                    if (typeKey != null) {
                                        FieldDeserializer typeKeyFieldDeser = javaBeanDeserializer.getFieldDeserializer(typeKey);
                                        typeKeyFieldDeser.setValue(typedObject, typeName);
                                    }
                                } else {
                                    typedObject = deserizer.deserialze(parser, userType, fieldName);
                                }
                                Object t = typedObject;
                                return t;
                            }
                            throw new JSONException("syntax error");
                        }
                    }
                    if (object == null && fieldValues == null) {
                        object = this.createInstance(parser, type);
                        if (object == null) {
                            fieldValues = new HashMap<String, Integer>(this.fieldDeserializers.length);
                        }
                        if (!disableCircularReferenceDetect) {
                            childContext = parser.setContext(context, object, fieldName);
                        }
                    }
                    if (matchField) {
                        if (!valueParsed) {
                            fieldDeser.parseField(parser, object, type, fieldValues);
                        } else {
                            if (object == null) {
                                if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
                                    fieldValue = fieldValueInt;
                                } else if (fieldClass == Long.TYPE || fieldClass == Long.class) {
                                    fieldValue = fieldValueLong;
                                } else if (fieldClass == Float.TYPE || fieldClass == Float.class) {
                                    fieldValue = new Float(fieldValueFloat);
                                } else if (fieldClass == Double.TYPE || fieldClass == Double.class) {
                                    fieldValue = new Double(fieldValueDouble);
                                }
                                fieldValues.put(fieldInfo.name, (Integer)fieldValue);
                            } else if (fieldValue == null) {
                                try {
                                    if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
                                        if (fieldInfo.fieldAccess && fieldClass == Integer.TYPE) {
                                            fieldDeser.setValue(object, fieldValueInt);
                                        }
                                        fieldDeser.setValue(object, (Object)fieldValueInt);
                                    }
                                    if (fieldClass == Long.TYPE || fieldClass == Long.class) {
                                        if (fieldInfo.fieldAccess && fieldClass == Long.TYPE) {
                                            fieldDeser.setValue(object, fieldValueLong);
                                        }
                                        fieldDeser.setValue(object, (Object)fieldValueLong);
                                    }
                                    if (fieldClass == Float.TYPE || fieldClass == Float.class) {
                                        if (fieldInfo.fieldAccess && fieldClass == Float.TYPE) {
                                            fieldDeser.setValue(object, fieldValueFloat);
                                        }
                                        fieldDeser.setValue(object, new Float(fieldValueFloat));
                                    }
                                    if (fieldClass == Double.TYPE || fieldClass == Double.class) {
                                        if (fieldInfo.fieldAccess && fieldClass == Double.TYPE) {
                                            fieldDeser.setValue(object, fieldValueDouble);
                                        }
                                        fieldDeser.setValue(object, new Double(fieldValueDouble));
                                    }
                                    fieldDeser.setValue(object, fieldValue);
                                }
                                catch (IllegalAccessException ex) {
                                    throw new JSONException("set property error, " + fieldInfo.name, ex);
                                }
                            } else {
                                fieldDeser.setValue(object, fieldValue);
                            }
                            if (lexer.matchStat == 4) {
                                break block168;
                            }
                        }
                    } else {
                        boolean match = this.parseField(parser, key, object, type, fieldValues);
                        if (!match) {
                            if (lexer.token != 13) continue;
                            lexer.nextToken();
                            break block168;
                        }
                        if (lexer.token == 17) {
                            throw new JSONException("syntax error, unexpect token ':'");
                        }
                    }
                    if (lexer.token == 16) continue;
                    if (lexer.token == 13) {
                        lexer.nextToken(16);
                        break block168;
                    }
                    if (lexer.token == 18 || lexer.token == 1) break;
                }
                throw new JSONException("syntax error, unexpect token " + JSONToken.name(lexer.token));
            }
            if (object == null) {
                if (fieldValues == null) {
                    object = this.createInstance(parser, type);
                    if (childContext == null) {
                        childContext = parser.setContext(context, object, fieldName);
                    }
                    Object fieldIndex = object;
                    return (T)fieldIndex;
                }
                String[] paramNames = this.beanInfo.creatorConstructorParameters;
                size = paramNames != null ? paramNames.length : this.fieldDeserializers.length;
                Object[] params = new Object[size];
                for (int i = 0; i < size; ++i) {
                    FieldInfo fieldInfo = this.fieldDeserializers[i].fieldInfo;
                    Object param = paramNames != null ? fieldValues.remove(fieldInfo.name) : fieldValues.get(fieldInfo.name);
                    if (param == null) {
                        param = TypeUtils.defaultValue(fieldInfo.fieldClass);
                    }
                    params[i] = param;
                }
                if (this.beanInfo.creatorConstructor != null) {
                    try {
                        object = this.beanInfo.creatorConstructor.newInstance(params);
                    }
                    catch (Exception e) {
                        throw new JSONException("create instance error, " + this.beanInfo.creatorConstructor.toGenericString(), e);
                    }
                    if (paramNames != null) {
                        for (Map.Entry entry : fieldValues.entrySet()) {
                            FieldDeserializer fieldDeserializer = this.getFieldDeserializer((String)entry.getKey());
                            if (fieldDeserializer == null) continue;
                            fieldDeserializer.setValue(object, entry.getValue());
                        }
                    }
                } else if (this.beanInfo.factoryMethod != null) {
                    try {
                        object = this.beanInfo.factoryMethod.invoke(null, params);
                    }
                    catch (Exception e) {
                        throw new JSONException("create factory method error, " + this.beanInfo.factoryMethod.toString(), e);
                    }
                }
            }
            Object object3 = object;
            return (T)object3;
        }
        finally {
            if (childContext != null) {
                childContext.object = object;
            }
            parser.setContext(context);
        }
    }

    protected FieldDeserializer getFieldDeserializerByHash(long fieldHash) {
        for (int i = 0; i < this.sortedFieldDeserializers.length; ++i) {
            FieldDeserializer fieldDeserializer = this.sortedFieldDeserializers[i];
            if (fieldDeserializer.fieldInfo.nameHashCode != fieldHash) continue;
            return fieldDeserializer;
        }
        return null;
    }

    protected FieldDeserializer getFieldDeserializer(String key) {
        if (key == null) {
            return null;
        }
        if (this.beanInfo.ordered) {
            for (int i = 0; i < this.sortedFieldDeserializers.length; ++i) {
                FieldDeserializer fieldDeserializer = this.sortedFieldDeserializers[i];
                if (!fieldDeserializer.fieldInfo.name.equalsIgnoreCase(key)) continue;
                return fieldDeserializer;
            }
            return null;
        }
        int low = 0;
        int high = this.sortedFieldDeserializers.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            String fieldName = this.sortedFieldDeserializers[mid].fieldInfo.name;
            int cmp = fieldName.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return this.sortedFieldDeserializers[mid];
        }
        if (this.alterNameFieldDeserializers != null) {
            return this.alterNameFieldDeserializers.get(key);
        }
        return null;
    }

    private boolean parseField(DefaultJSONParser parser, String key, Object object, Type objectType, Map<String, Object> fieldValues) {
        JSONLexer lexer = parser.lexer;
        FieldDeserializer fieldDeserializer = this.getFieldDeserializer(key);
        if (fieldDeserializer == null) {
            long smartKeyHash = TypeUtils.fnv_64_lower(key);
            if (this.smartMatchHashArray == null) {
                long[] hashArray = new long[this.sortedFieldDeserializers.length];
                for (int i = 0; i < this.sortedFieldDeserializers.length; ++i) {
                    hashArray[i] = TypeUtils.fnv_64_lower(this.sortedFieldDeserializers[i].fieldInfo.name);
                }
                Arrays.sort(hashArray);
                this.smartMatchHashArray = hashArray;
            }
            int pos = Arrays.binarySearch(this.smartMatchHashArray, smartKeyHash);
            boolean is = false;
            if (pos < 0 && (is = key.startsWith("is"))) {
                smartKeyHash = TypeUtils.fnv_64_lower(key.substring(2));
                pos = Arrays.binarySearch(this.smartMatchHashArray, smartKeyHash);
            }
            if (pos >= 0) {
                int deserIndex;
                if (this.smartMatchHashArrayMapping == null) {
                    int[] mapping = new int[this.smartMatchHashArray.length];
                    Arrays.fill(mapping, -1);
                    for (int i = 0; i < this.sortedFieldDeserializers.length; ++i) {
                        int p = Arrays.binarySearch(this.smartMatchHashArray, TypeUtils.fnv_64_lower(this.sortedFieldDeserializers[i].fieldInfo.name));
                        if (p < 0) continue;
                        mapping[p] = i;
                    }
                    this.smartMatchHashArrayMapping = mapping;
                }
                if ((deserIndex = this.smartMatchHashArrayMapping[pos]) != -1) {
                    fieldDeserializer = this.sortedFieldDeserializers[deserIndex];
                    Class<?> fieldClass = fieldDeserializer.fieldInfo.fieldClass;
                    if (is && fieldClass != Boolean.TYPE && fieldClass != Boolean.class) {
                        fieldDeserializer = null;
                    }
                }
            }
        }
        int mask = Feature.SupportNonPublicField.mask;
        if (fieldDeserializer == null && ((parser.lexer.features & mask) != 0 || (this.beanInfo.parserFeatures & mask) != 0)) {
            Object deserOrField;
            if (this.extraFieldDeserializers == null) {
                ConcurrentHashMap<String, Object> extraFieldDeserializers = new ConcurrentHashMap<String, Object>(1, 0.75f, 1);
                for (Class<?> c = this.clazz; c != null && c != Object.class; c = c.getSuperclass()) {
                    Field[] fields;
                    for (Field field : fields = c.getDeclaredFields()) {
                        int fieldModifiers;
                        String fieldName = field.getName();
                        if (this.getFieldDeserializer(fieldName) != null || ((fieldModifiers = field.getModifiers()) & 0x10) != 0 || (fieldModifiers & 8) != 0) continue;
                        extraFieldDeserializers.put(fieldName, field);
                    }
                }
                this.extraFieldDeserializers = extraFieldDeserializers;
            }
            if ((deserOrField = this.extraFieldDeserializers.get(key)) != null) {
                if (deserOrField instanceof FieldDeserializer) {
                    fieldDeserializer = (FieldDeserializer)deserOrField;
                } else {
                    Field field = (Field)deserOrField;
                    field.setAccessible(true);
                    FieldInfo fieldInfo = new FieldInfo(key, field.getDeclaringClass(), field.getType(), field.getGenericType(), field, 0, 0);
                    fieldDeserializer = new DefaultFieldDeserializer(parser.config, this.clazz, fieldInfo);
                    this.extraFieldDeserializers.put(key, fieldDeserializer);
                }
            }
        }
        if (fieldDeserializer == null) {
            this.parseExtra(parser, object, key);
            return false;
        }
        lexer.nextTokenWithChar(':');
        fieldDeserializer.parseField(parser, object, objectType, fieldValues);
        return true;
    }

    void parseExtra(DefaultJSONParser parser, Object object, String key) {
        Object value;
        JSONLexer lexer = parser.lexer;
        if ((parser.lexer.features & Feature.IgnoreNotMatch.mask) == 0) {
            throw new JSONException("setter not found, class " + this.clazz.getName() + ", property " + key);
        }
        lexer.nextTokenWithChar(':');
        Type type = null;
        List<ExtraTypeProvider> extraTypeProviders = parser.extraTypeProviders;
        if (extraTypeProviders != null) {
            for (ExtraTypeProvider extraProvider : extraTypeProviders) {
                type = extraProvider.getExtraType(object, key);
            }
        }
        Object object2 = value = type == null ? parser.parse() : parser.parseObject(type);
        if (object instanceof ExtraProcessable) {
            ExtraProcessable extraProcessable = (ExtraProcessable)object;
            extraProcessable.processExtra(key, value);
            return;
        }
        List<ExtraProcessor> extraProcessors = parser.extraProcessors;
        if (extraProcessors != null) {
            for (ExtraProcessor process : extraProcessors) {
                process.processExtra(object, key, value);
            }
        }
    }

    public Object createInstance(Map<String, Object> map, ParserConfig config) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object object = null;
        if (this.beanInfo.creatorConstructor == null) {
            object = this.createInstance(null, this.clazz);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                FieldDeserializer fieldDeser = this.getFieldDeserializer(entry.getKey());
                if (fieldDeser == null) continue;
                Object value = entry.getValue();
                Method method = fieldDeser.fieldInfo.method;
                if (method != null) {
                    Type paramType = method.getGenericParameterTypes()[0];
                    value = TypeUtils.cast(value, paramType, config);
                    method.invoke(object, value);
                    continue;
                }
                Field field = fieldDeser.fieldInfo.field;
                Type paramType = fieldDeser.fieldInfo.fieldType;
                value = TypeUtils.cast(value, paramType, config);
                field.set(object, value);
            }
            return object;
        }
        FieldInfo[] fieldInfoList = this.beanInfo.fields;
        int size = fieldInfoList.length;
        Object[] params = new Object[size];
        for (int i = 0; i < size; ++i) {
            FieldInfo fieldInfo = fieldInfoList[i];
            Object param = map.get(fieldInfo.name);
            if (param == null) {
                param = TypeUtils.defaultValue(fieldInfo.fieldClass);
            }
            params[i] = param;
        }
        if (this.beanInfo.creatorConstructor != null) {
            try {
                object = this.beanInfo.creatorConstructor.newInstance(params);
            }
            catch (Exception e) {
                throw new JSONException("create instance error, " + this.beanInfo.creatorConstructor.toGenericString(), e);
            }
        }
        return object;
    }

    protected JavaBeanDeserializer getSeeAlso(ParserConfig config, JavaBeanInfo beanInfo, String typeName) {
        if (beanInfo.jsonType == null) {
            return null;
        }
        for (Class<?> seeAlsoClass : beanInfo.jsonType.seeAlso()) {
            ObjectDeserializer seeAlsoDeser = config.getDeserializer(seeAlsoClass);
            if (!(seeAlsoDeser instanceof JavaBeanDeserializer)) continue;
            JavaBeanDeserializer seeAlsoJavaBeanDeser = (JavaBeanDeserializer)seeAlsoDeser;
            JavaBeanInfo subBeanInfo = seeAlsoJavaBeanDeser.beanInfo;
            if (subBeanInfo.typeName.equals(typeName)) {
                return seeAlsoJavaBeanDeser;
            }
            JavaBeanDeserializer subSeeAlso = this.getSeeAlso(config, subBeanInfo, typeName);
            if (subSeeAlso == null) continue;
            return subSeeAlso;
        }
        return null;
    }
}

