/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONPOJOBuilder;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.modules.ObjectReaderAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.BeanUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;

public class Fastjson1xReaderModule
implements ObjectReaderModule {
    final ObjectReaderProvider provider;
    final ReaderAnnotationProcessor annotationProcessor;

    public Fastjson1xReaderModule(ObjectReaderProvider provider) {
        this.provider = provider;
        this.annotationProcessor = new ReaderAnnotationProcessor();
    }

    public ObjectReader getObjectReader(ObjectReaderProvider provider, Type type) {
        if (type == JSON.class) {
            return new JSONImpl();
        }
        return null;
    }

    public ObjectReaderAnnotationProcessor getAnnotationProcessor() {
        return this.annotationProcessor;
    }

    class ReaderAnnotationProcessor
    implements ObjectReaderAnnotationProcessor {
        ReaderAnnotationProcessor() {
        }

        public void getBeanInfo(BeanInfo beanInfo, Class<?> objectClass) {
            Class mixInSource = Fastjson1xReaderModule.this.provider.getMixIn(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                this.getBeanInfo(beanInfo, mixInSource.getAnnotation(JSONType.class));
                BeanUtils.staticMethod((Class)mixInSource, method -> {
                    JSONCreator jsonCreator = method.getAnnotation(JSONCreator.class);
                    if (jsonCreator != null) {
                        Method targetMethod = null;
                        try {
                            targetMethod = objectClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (targetMethod != null) {
                            beanInfo.createMethod = targetMethod;
                            String[] createParameterNames = jsonCreator.parameterNames();
                            if (createParameterNames.length != 0) {
                                beanInfo.createParameterNames = createParameterNames;
                            }
                        }
                    }
                });
                BeanUtils.constructor((Class)mixInSource, constructor -> {
                    JSONCreator jsonCreator = constructor.getAnnotation(JSONCreator.class);
                    if (jsonCreator != null) {
                        Constructor targetConstructor = null;
                        try {
                            targetConstructor = objectClass.getDeclaredConstructor(constructor.getParameterTypes());
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (targetConstructor != null) {
                            beanInfo.creatorConstructor = targetConstructor;
                            String[] createParameterNames = jsonCreator.parameterNames();
                            if (createParameterNames.length != 0) {
                                beanInfo.createParameterNames = createParameterNames;
                            }
                        }
                    }
                });
            }
            this.getBeanInfo(beanInfo, objectClass.getAnnotation(JSONType.class));
            BeanUtils.staticMethod(objectClass, method -> {
                JSONCreator jsonCreator = method.getAnnotation(JSONCreator.class);
                if (jsonCreator != null) {
                    beanInfo.createMethod = method;
                    String[] createParameterNames = jsonCreator.parameterNames();
                    if (createParameterNames.length != 0) {
                        beanInfo.createParameterNames = createParameterNames;
                    }
                }
            });
            BeanUtils.constructor(objectClass, constructor -> {
                JSONCreator jsonCreator = constructor.getAnnotation(JSONCreator.class);
                if (jsonCreator != null) {
                    beanInfo.creatorConstructor = constructor;
                    String[] createParameterNames = jsonCreator.parameterNames();
                    if (createParameterNames.length != 0) {
                        beanInfo.createParameterNames = createParameterNames;
                    }
                }
            });
        }

        void getBeanInfo(BeanInfo beanInfo, JSONType jsonType) {
            String typeName;
            String jsonTypeKey;
            if (jsonType == null) {
                return;
            }
            Class<?>[] classes = jsonType.seeAlso();
            if (classes.length != 0) {
                beanInfo.seeAlso = classes;
                beanInfo.seeAlsoNames = new String[classes.length];
                for (int i = 0; i < classes.length; ++i) {
                    Class<?> item = classes[i];
                    BeanInfo itemBeanInfo = new BeanInfo();
                    this.getBeanInfo(itemBeanInfo, item);
                    String typeName2 = itemBeanInfo.typeName;
                    if (typeName2 == null || typeName2.isEmpty()) {
                        typeName2 = item.getSimpleName();
                    }
                    beanInfo.seeAlsoNames[i] = typeName2;
                }
                beanInfo.readerFeatures |= JSONReader.Feature.SupportAutoType.mask;
            }
            if (!(jsonTypeKey = jsonType.typeKey()).isEmpty()) {
                beanInfo.typeKey = jsonTypeKey;
            }
            if (!(typeName = jsonType.typeName()).isEmpty()) {
                beanInfo.typeName = typeName;
            }
            beanInfo.namingStrategy = jsonType.naming().name();
            for (BeanInfo feature : jsonType.parseFeatures()) {
                switch (1.$SwitchMap$com$alibaba$fastjson$parser$Feature[feature.ordinal()]) {
                    case 1: {
                        beanInfo.readerFeatures |= JSONReader.Feature.SupportAutoType.mask;
                    }
                    case 2: {
                        beanInfo.readerFeatures |= JSONReader.Feature.SupportArrayToBean.mask;
                    }
                    case 3: {
                        beanInfo.readerFeatures |= JSONReader.Feature.InitStringFieldAsEmpty.mask;
                    }
                }
            }
            Class<?> builderClass = jsonType.builder();
            if (builderClass != Void.TYPE && builderClass != Void.class) {
                beanInfo.builder = builderClass;
                JSONPOJOBuilder jsonBuilder = builderClass.getAnnotation(JSONPOJOBuilder.class);
                if (jsonBuilder != null) {
                    String buildMethodName = jsonBuilder.buildMethod();
                    beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, (String)buildMethodName);
                    String withPrefix = jsonBuilder.withPrefix();
                    if (!withPrefix.isEmpty()) {
                        beanInfo.builderWithPrefix = withPrefix;
                    }
                }
                if (beanInfo.buildMethod == null) {
                    beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, (String)"build");
                }
                if (beanInfo.buildMethod == null) {
                    beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, (String)"create");
                }
            }
        }

        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Constructor constructor, int paramIndex, Parameter parameter) {
            Class mixInSource = Fastjson1xReaderModule.this.provider.getMixIn(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Constructor mixInConstructor = null;
                try {
                    mixInConstructor = mixInSource.getDeclaredConstructor(constructor.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (mixInConstructor != null) {
                    Parameter mixInParam = mixInConstructor.getParameters()[paramIndex];
                    this.getFieldInfo(fieldInfo, mixInParam.getAnnotation(JSONField.class));
                }
            }
            this.getFieldInfo(fieldInfo, parameter.getAnnotation(JSONField.class));
        }

        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method, int paramIndex, Parameter parameter) {
            Class mixInSource = Fastjson1xReaderModule.this.provider.getMixIn(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Executable mixInMethod = null;
                try {
                    mixInMethod = mixInSource.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (mixInMethod != null) {
                    Parameter mixInParam = mixInMethod.getParameters()[paramIndex];
                    this.getFieldInfo(fieldInfo, mixInParam.getAnnotation(JSONField.class));
                }
            }
            this.getFieldInfo(fieldInfo, parameter.getAnnotation(JSONField.class));
        }

        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Field field) {
            Class mixInSource = Fastjson1xReaderModule.this.provider.getMixIn(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Field mixInField = null;
                try {
                    mixInField = mixInSource.getDeclaredField(field.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mixInField != null) {
                    this.getFieldInfo(fieldInfo, mixInSource, mixInField);
                }
            }
            this.getFieldInfo(fieldInfo, field.getAnnotation(JSONField.class));
        }

        public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method) {
            int modifiers;
            Class mixInSource = Fastjson1xReaderModule.this.provider.getMixIn(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Method mixInMethod = null;
                try {
                    mixInMethod = mixInSource.getDeclaredMethod(method.getName(), method.getParameterTypes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mixInMethod != null) {
                    this.getFieldInfo(fieldInfo, mixInSource, mixInMethod);
                }
            }
            this.getFieldInfo(fieldInfo, method.getAnnotation(JSONField.class));
            String fieldName = BeanUtils.getterName((String)method.getName(), null);
            Field declaredField = null;
            try {
                declaredField = objectClass.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (declaredField != null && !Modifier.isPublic(modifiers = declaredField.getModifiers()) && !Modifier.isStatic(modifiers)) {
                this.getFieldInfo(fieldInfo, objectClass, declaredField);
            }
        }

        private void getFieldInfo(FieldInfo fieldInfo, JSONField jsonField) {
            String[] alternateNames;
            String jsonFieldFormat;
            if (jsonField == null) {
                return;
            }
            String jsonFieldName = jsonField.name();
            if (jsonFieldName != null && !jsonFieldName.isEmpty()) {
                fieldInfo.fieldName = jsonFieldName;
            }
            if ((jsonFieldFormat = jsonField.format()) != null && !jsonFieldFormat.isEmpty()) {
                if (jsonFieldFormat.indexOf(84) != -1 && !jsonFieldFormat.contains("'T'")) {
                    jsonFieldFormat = jsonFieldFormat.replaceAll("T", "'T'");
                }
                fieldInfo.format = jsonFieldFormat;
            }
            if ((alternateNames = jsonField.alternateNames()).length != 0) {
                if (fieldInfo.alternateNames == null) {
                    fieldInfo.alternateNames = alternateNames;
                } else {
                    Feature[] nameSet = new LinkedHashSet();
                    for (String alternateName : alternateNames) {
                        nameSet.add(alternateName);
                    }
                    String[] stringArray = fieldInfo.alternateNames;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String alternateName;
                        alternateName = stringArray[i];
                        nameSet.add(alternateName);
                    }
                    fieldInfo.alternateNames = nameSet.toArray(new String[nameSet.size()]);
                }
            }
            fieldInfo.ignore = !jsonField.deserialize();
            for (Feature feature : jsonField.parseFeatures()) {
                switch (feature) {
                    case SupportAutoType: {
                        fieldInfo.features |= JSONReader.Feature.SupportAutoType.mask;
                    }
                    case SupportArrayToBean: {
                        fieldInfo.features |= JSONReader.Feature.SupportArrayToBean.mask;
                    }
                    case InitStringFieldAsEmpty: {
                        fieldInfo.features |= JSONReader.Feature.InitStringFieldAsEmpty.mask;
                    }
                }
            }
            int ordinal = jsonField.ordinal();
            if (ordinal != 0) {
                fieldInfo.ordinal = ordinal;
            }
        }
    }

    static class JSONImpl
    implements ObjectReader {
        JSONImpl() {
        }

        public Object readObject(JSONReader jsonReader, long features) {
            if (jsonReader.isObject()) {
                return jsonReader.read(JSONObject.class);
            }
            if (jsonReader.isArray()) {
                return jsonReader.read(JSONArray.class);
            }
            throw new JSONException("read json error");
        }
    }
}

