/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.client.AliHBaseDirectImplFactory;
import com.alibaba.hbase.client.AliHBaseThriftImplFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;

public abstract class AliHBaseImplFactory {
    public abstract AliHBaseAPIProxy getHBaseAPIProxyImpl(TableName var1) throws IOException;

    public abstract void close() throws IOException;

    public abstract Configuration getConf();

    public static AliHBaseImplFactory create(Configuration conf) throws IOException {
        String serverlessStr;
        String host;
        boolean useThrift = false;
        if (AliHBaseConstants.isHBaseUEConnectionString(conf, conf.get("hbase.zookeeper.quorum"))) {
            conf.set("hbase.client.endpoint", conf.get("hbase.zookeeper.quorum"));
        }
        if ((host = conf.get("hbase.client.endpoint").trim()).startsWith("http://") || host.startsWith("https://")) {
            useThrift = true;
        }
        if (host.contains(serverlessStr = conf.get("hbase.serverless.identifier", "-hbase-serverless"))) {
            useThrift = true;
        }
        if (conf.get("hbase.client.use.thrift") != null) {
            useThrift = conf.getBoolean("hbase.client.use.thrift", false);
        }
        if (useThrift) {
            return new AliHBaseThriftImplFactory(conf);
        }
        return new AliHBaseDirectImplFactory(conf);
    }
}

