/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseDirectImplFactory;
import com.alibaba.hbase.client.AliHBaseUEConnection;
import com.alibaba.lindorm.client.SystemService;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliHBaseUEClientService
implements ClientProtos.ClientService.BlockingInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AliHBaseUEClientService.class);
    public static boolean isTest;
    private SystemService systemService;

    public AliHBaseUEClientService(AliHBaseUEConnection connection) {
        AliHBaseDirectImplFactory factory = (AliHBaseDirectImplFactory)connection.getFactory();
        try {
            this.systemService = factory.getSystemService();
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Create systemService exception ", e);
        }
    }

    public ClientProtos.MutateResponse mutate(RpcController rpcController, ClientProtos.MutateRequest mutateRequest) throws ServiceException {
        throw new UnsupportedOperationException("mutate(rpcController,mutateRequest) not supported");
    }

    public ClientProtos.ScanResponse scan(RpcController rpcController, ClientProtos.ScanRequest scanRequest) throws ServiceException {
        throw new UnsupportedOperationException("scan(rpcController,scanRequest) not supported");
    }

    public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController rpcController, ClientProtos.BulkLoadHFileRequest bulkLoadHFileRequest) throws ServiceException {
        this.checkBulkLoadSupported(bulkLoadHFileRequest);
        List paths = bulkLoadHFileRequest.getFamilyPathList();
        ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>(paths.size());
        for (ClientProtos.BulkLoadHFileRequest.FamilyPath fp : paths) {
            familyPaths.add(new Pair<byte[], String>(fp.getFamily().toByteArray(), fp.getPath()));
        }
        try {
            byte[][] regionInfos = HRegionInfo.parseRegionName((byte[])bulkLoadHFileRequest.getRegion().getValue().toByteArray());
            TableName tb = TableName.valueOf((byte[])regionInfos[0]);
            boolean bulkloadResult = this.systemService.bulkLoadLdFiles(this.systemService.getLConnection().getAllIDC().get(0), tb.getNamespaceAsString(), tb.getQualifierAsString(), regionInfos[1], familyPaths);
            if (!bulkloadResult) {
                throw new IOException("Bulkload region fail: " + Bytes.toStringBinary(bulkLoadHFileRequest.getRegion().getValue().toByteArray()));
            }
        }
        catch (Exception e) {
            LOG.info("BulkLoad failed, it can be retried later ", (Throwable)e);
            throw new ServiceException("BulkLoad exception ", (Throwable)e);
        }
        ClientProtos.BulkLoadHFileResponse.Builder builder = ClientProtos.BulkLoadHFileResponse.newBuilder();
        builder.setLoaded(true);
        return builder.build();
    }

    private void checkBulkLoadSupported(ClientProtos.BulkLoadHFileRequest bulkLoadHFileRequest) {
        List<String> allIdcs = this.systemService.getLConnection().getAllIDC();
        if (allIdcs.size() > 1 && !isTest) {
            throw new IllegalStateException("BulkLoad only support single idc now , current cluster idc count : " + allIdcs.size());
        }
    }

    public ClientProtos.CoprocessorServiceResponse execService(RpcController rpcController, ClientProtos.CoprocessorServiceRequest coprocessorServiceRequest) throws ServiceException {
        throw new UnsupportedOperationException("execService(rpcController,coprocessorServiceRequest) not supported");
    }

    public ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController rpcController, ClientProtos.CoprocessorServiceRequest coprocessorServiceRequest) throws ServiceException {
        throw new UnsupportedOperationException("execRegionServerService(rpcController,coprocessorServiceRequest) not supported");
    }

    public ClientProtos.MultiResponse multi(RpcController rpcController, ClientProtos.MultiRequest multiRequest) throws ServiceException {
        throw new UnsupportedOperationException("multi(rpcController,multiRequest) not supported");
    }

    public ClientProtos.GetResponse get(RpcController rpcController, ClientProtos.GetRequest getRequest) throws ServiceException {
        throw new UnsupportedOperationException("get(rpcController,getRequest) not supported");
    }
}

