/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient;

import com.alibaba.hbase.haclient.ClusterSwitchUtil;
import com.alibaba.hbase.haclient.StrUtil;
import com.alibaba.hbase.protobuf.generated.ClusterSwitchProto;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class AdminUtil {
    private static final String NODE_PREFIX = "1x";

    public static Pair<HTableDescriptor, byte[][]> toCreateInfo(byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        Pair result = new Pair();
        try {
            Pair<String, List<String>> createInfoStringPair = AdminUtil.toCreateInfoStringPair(data);
            String tableDescriptorString = (String)createInfoStringPair.getFirst();
            List splitKeyList = (List)createInfoStringPair.getSecond();
            HTableDescriptor tableDescriptor = AdminUtil.getTableDescriptorFromString(tableDescriptorString);
            byte[][] splitKeys = AdminUtil.getSplitKeysFromStringList(splitKeyList);
            result.setFirst((Object)tableDescriptor);
            result.setSecond((Object)splitKeys);
            return result;
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    public static byte[] toCreateInfoBytes(Pair<HTableDescriptor, byte[][]> createInfo) {
        ClusterSwitchProto.CreateInfo.Builder builder = ClusterSwitchProto.CreateInfo.newBuilder();
        byte[] tableDescriptorBytes = ((HTableDescriptor)createInfo.getFirst()).toByteArray();
        builder.setTableDescriptor(Bytes.toStringBinary((byte[])tableDescriptorBytes));
        byte[][] splitKeys = (byte[][])createInfo.getSecond();
        if (splitKeys != null) {
            for (int i = 0; i < splitKeys.length; ++i) {
                builder.addSplitKeys(Bytes.toStringBinary((byte[])splitKeys[i]));
            }
        }
        return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
    }

    public static HTableDescriptor toModifyInfo(byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        try {
            String tableDescriptorString = AdminUtil.toModifyInfoString(data);
            HTableDescriptor tableDescriptor = AdminUtil.getTableDescriptorFromString(tableDescriptorString);
            return tableDescriptor;
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    public static byte[] toModifyInfoBytes(HTableDescriptor tableDescriptor) {
        ClusterSwitchProto.ModifyInfo.Builder builder = ClusterSwitchProto.ModifyInfo.newBuilder();
        byte[] tableDescriptorBytes = tableDescriptor.toByteArray();
        builder.setTableDescriptor(Bytes.toStringBinary((byte[])tableDescriptorBytes));
        return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<HTableDescriptor, byte[][]> getCreateInfoFromZk(String zkCluster, Configuration conf, String node) throws IOException, KeeperException {
        Configuration createConf = ClusterSwitchUtil.createConfWithConnectKey(zkCluster, conf);
        try (ZooKeeperWatcher zk = new ZooKeeperWatcher(createConf, "GetCreateInfo", null, false);){
            Pair<HTableDescriptor, byte[][]> createInfo;
            if (ZKUtil.checkExists((ZooKeeperWatcher)zk, (String)node) == -1) {
                Pair<HTableDescriptor, byte[][]> pair = null;
                return pair;
            }
            byte[] data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zk, (String)node, null);
            Pair<HTableDescriptor, byte[][]> pair = createInfo = AdminUtil.toCreateInfo(data);
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HTableDescriptor getModifyInfoFromZk(String zkCluster, Configuration conf, String node) throws IOException, KeeperException {
        Configuration modifyConf = ClusterSwitchUtil.createConfWithConnectKey(zkCluster, conf);
        try (ZooKeeperWatcher zk = new ZooKeeperWatcher(modifyConf, "GetModifyInfo", null, false);){
            HTableDescriptor modifyInfo;
            if (ZKUtil.checkExists((ZooKeeperWatcher)zk, (String)node) == -1) {
                HTableDescriptor hTableDescriptor = null;
                return hTableDescriptor;
            }
            byte[] data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zk, (String)node, null);
            HTableDescriptor hTableDescriptor = modifyInfo = AdminUtil.toModifyInfo(data);
            return hTableDescriptor;
        }
    }

    public static void setCreateInfoNode(Configuration clientConf, HTableDescriptor tableDescriptor, byte[][] splitKey) throws IOException, KeeperException {
        byte[] data = AdminUtil.toCreateInfoBytes((Pair<HTableDescriptor, byte[][]>)new Pair((Object)tableDescriptor, (Object)splitKey));
        String parentNode = clientConf.get(ClusterSwitchUtil.ZOOKEEPER_CREATE_NODE, ClusterSwitchUtil.ZOOKEEPER_CREATE_NODE_DEFAULT);
        String node = NODE_PREFIX + StrUtil.generateRandomString(5);
        AdminUtil.setDataToZK(clientConf, parentNode, node, data);
    }

    public static void setModifyInfoNode(Configuration clientConf, HTableDescriptor tableDescriptor) throws IOException, KeeperException {
        byte[] data = AdminUtil.toModifyInfoBytes(tableDescriptor);
        String parentNode = clientConf.get(ClusterSwitchUtil.ZOOKEEPER_MODIFY_NODE, ClusterSwitchUtil.ZOOKEEPER_MODIFY_NODE_DEFAULT);
        String node = NODE_PREFIX + StrUtil.generateRandomString(5);
        AdminUtil.setDataToZK(clientConf, parentNode, node, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDataToZK(Configuration clientConf, String parentNode, String node, byte[] data) throws IOException, KeeperException {
        try (ZooKeeperWatcher zk = AdminUtil.getZkWatcher(clientConf);){
            String baseNode = ClusterSwitchUtil.getBaseNode(clientConf.get("haclient.base.node", "/haclient"), clientConf.get("haclient.cluster.id"));
            String createNode = ZKUtil.joinZNode((String)baseNode, (String)parentNode);
            ZKUtil.createNodeIfNotExistsNoWatch((ZooKeeperWatcher)zk, (String)baseNode, null, (CreateMode)CreateMode.PERSISTENT);
            ZKUtil.createNodeIfNotExistsNoWatch((ZooKeeperWatcher)zk, (String)createNode, null, (CreateMode)CreateMode.PERSISTENT);
            String dataNode = ZKUtil.joinZNode((String)createNode, (String)node);
            if (ZKUtil.checkExists((ZooKeeperWatcher)zk, (String)dataNode) == -1) {
                ZKUtil.createNodeIfNotExistsNoWatch((ZooKeeperWatcher)zk, (String)dataNode, (byte[])data, (CreateMode)CreateMode.PERSISTENT);
            } else {
                ZKUtil.setData((ZooKeeperWatcher)zk, (String)dataNode, (byte[])data);
            }
        }
    }

    public static ZooKeeperWatcher getZkWatcher(Configuration clientConf) throws IOException {
        String endpoint = clientConf.get("hbase.client.endpoint");
        Configuration conf = new Configuration();
        if (!ClusterSwitchUtil.isValidEndpoint(endpoint)) {
            throw new IOException("Endpoint " + endpoint + " has invalid format, vaild format is " + "hostname:port");
        }
        conf.set("hbase.zookeeper.quorum", endpoint.split(":")[0]);
        conf.set("hbase.zookeeper.property.clientPort", endpoint.split(":")[1]);
        ZooKeeperWatcher zk = new ZooKeeperWatcher(conf, "GetData", null, false);
        return zk;
    }

    public static HTableDescriptor getTableDescriptorFromString(String tableDescriptorString) throws DeserializationException, IOException {
        HTableDescriptor tableDescriptor = HTableDescriptor.parseFrom((byte[])Bytes.toBytesBinary((String)tableDescriptorString));
        return tableDescriptor;
    }

    public static byte[][] getSplitKeysFromStringList(List<String> splitKeyList) {
        Object splitKeys = null;
        if (!splitKeyList.isEmpty()) {
            splitKeys = new byte[splitKeyList.size()][];
            for (int i = 0; i < splitKeyList.size(); ++i) {
                splitKeys[i] = Bytes.toBytesBinary((String)splitKeyList.get(i));
            }
        }
        return splitKeys;
    }

    public static Pair<String, List<String>> toCreateInfoStringPair(byte[] data) throws DeserializationException, IOException {
        ProtobufUtil.expectPBMagicPrefix((byte[])data);
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        ClusterSwitchProto.CreateInfo.Builder builder = ClusterSwitchProto.CreateInfo.newBuilder();
        ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)prefixLen, (int)(data.length - prefixLen));
        ClusterSwitchProto.CreateInfo createInfo = builder.build();
        String tableDescriptorString = createInfo.getTableDescriptor();
        List<String> splitKeyList = createInfo.getSplitKeysList();
        return new Pair((Object)tableDescriptorString, splitKeyList);
    }

    public static String toModifyInfoString(byte[] data) throws DeserializationException, IOException {
        ProtobufUtil.expectPBMagicPrefix((byte[])data);
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        ClusterSwitchProto.ModifyInfo.Builder builder = ClusterSwitchProto.ModifyInfo.newBuilder();
        ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)prefixLen, (int)(data.length - prefixLen));
        ClusterSwitchProto.ModifyInfo modifyInfo = builder.build();
        String tableDescriptorString = modifyInfo.getTableDescriptor();
        return tableDescriptorString;
    }
}

