/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.hbase.haclient.ClusterSwitchUtil;
import com.alibaba.hbase.haclient.ConnectInfo;
import com.alibaba.hbase.haclient.ConnectInfoUtil;
import com.alibaba.hbase.haclient.SwitchCommand;
import com.alibaba.hbase.haclient.dualservice.DualUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class ClusterSwitcher
implements Closeable {
    static final Log LOG = LogFactory.getLog(ClusterSwitcher.class);
    private Configuration masterConf;
    private Configuration originalConf;
    private ConnectInfo connectInfo;
    private List<Configuration> slaveConfs = new ArrayList<Configuration>();
    private ExecutorService executor;
    private int totalClusters;
    private boolean skipCheck = false;
    private boolean isListAction = false;
    private boolean isSwitchAction = false;
    private boolean isSetConnectAction = false;
    private boolean isGetConnectAction = false;
    private boolean isGetLinkCountAction = false;
    private String targetClusterKey = null;
    private Options options = new Options();

    public ClusterSwitcher(ConnectInfo connectInfo, Configuration conf) throws IOException {
        this.connectInfo = connectInfo;
        this.originalConf = conf;
        if (StringUtils.isBlank((String)conf.get("haclient.cluster.id"))) {
            throw new IOException("haclient cluster id can not be blank");
        }
        this.addOptions();
        this.init();
    }

    private void init() throws IOException {
        String masterClusterKey = this.connectInfo.getMasterWatchZK();
        this.masterConf = ClusterSwitchUtil.createConfWithConnectKey(masterClusterKey, this.originalConf);
        LOG.info((Object)("Master cluster: " + this.masterConf));
        List<String> slaveClusterKeys = this.connectInfo.getSlaveWatchZKList();
        int clusterCount = 1;
        for (String slaveClusterKey : slaveClusterKeys) {
            Configuration slaveConf = ClusterSwitchUtil.createConfWithConnectKey(slaveClusterKey, this.originalConf);
            LOG.info((Object)("Slave cluster " + clusterCount + " : " + slaveClusterKey));
            this.slaveConfs.add(slaveConf);
            ++clusterCount;
        }
        this.totalClusters = clusterCount;
        this.executor = Threads.getBoundedCachedThreadPool((int)this.totalClusters, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, (ThreadFactory)Threads.newDaemonThreadFactory((String)"ClusterSwitcher"));
    }

    private boolean checkIfHBaseCluster(String rootNode, ZooKeeperWatcher zkw) throws KeeperException {
        if (ZKUtil.checkExists((ZooKeeperWatcher)zkw, (String)rootNode) == -1) {
            return false;
        }
        List hbaseNodes = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)rootNode);
        return hbaseNodes.contains("master") && hbaseNodes.contains("rs");
    }

    protected SwitchCommand getCommandFrom(Configuration conf) throws IOException, KeeperException, InterruptedException {
        String redirectNode = conf.get(ClusterSwitchUtil.ZOOKEEPER_REDIRECT_NODE, ClusterSwitchUtil.ZOOKEEPER_REDIRECT_NODE_DEFAULT);
        byte[] data = this.getDataFrom(conf, redirectNode);
        if (data == null) {
            return SwitchCommand.NOCOMMAND;
        }
        SwitchCommand ret = ClusterSwitchUtil.toSwitchCommand(data);
        LOG.debug((Object)("Get Command:" + ret + " from " + conf.get("hbase.zookeeper.quorum") + redirectNode));
        return ret;
    }

    protected ConnectInfo getConnectInfoFrom(Configuration conf) throws IOException, KeeperException, InterruptedException {
        String connectNode = conf.get(ClusterSwitchUtil.ZOOKEEPER_CONNECT_NODE, ClusterSwitchUtil.ZOOKEEPER_CONNECT_NODE_DEFAULT);
        byte[] data = this.getDataFrom(conf, connectNode);
        if (data == null) {
            return null;
        }
        ConnectInfo result = ConnectInfoUtil.toConnectInfo(data);
        LOG.debug((Object)("Get ConnectInfo:" + result + " from " + conf.get("hbase.zookeeper.quorum") + connectNode));
        return result;
    }

    protected List<String> getDualTablesFrom(Configuration conf) throws IOException, KeeperException, InterruptedException {
        String dualTableNode = conf.get(ClusterSwitchUtil.ZOOKEEPER_DUAL_TABLE_NODE, ClusterSwitchUtil.ZOOKEEPER_DUAL_TABLE_NODE_DEFAULT);
        byte[] data = this.getDataFrom(conf, dualTableNode);
        if (data == null) {
            return null;
        }
        List<String> result = DualUtil.toDualTables(data);
        LOG.debug((Object)("Get dual tables:" + result + " from " + conf.get("hbase.zookeeper.quorum") + dualTableNode));
        return result;
    }

    protected Map<String, JSONObject> getDualTraceFrom(Configuration conf) throws IOException, KeeperException, InterruptedException {
        String dualTraceNode = conf.get(ClusterSwitchUtil.ZOOKEEPER_DUAL_TRACE_NODE, ClusterSwitchUtil.ZOOKEEPER_DUAL_TRACE_NODE_DEFAULT);
        Map<String, byte[]> data = this.getChildDataFrom(conf, dualTraceNode);
        if (data == null || data.isEmpty()) {
            return null;
        }
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
        for (String key : data.keySet()) {
            result.put(key, JSONObject.parseObject((String)DualUtil.getDualTraceMetrics(data.get(key))));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer getLinkCountFrom(Configuration conf) throws IOException, KeeperException, InterruptedException {
        String linkNode = conf.get(ClusterSwitchUtil.ZOOKEEPER_LINK_NODE, ClusterSwitchUtil.ZOOKEEPER_LINK_NODE_DEFAULT);
        try (ZooKeeperWatcher zk = new ZooKeeperWatcher(conf, "GetLinkCount", null, false);){
            String baseNode = ClusterSwitchUtil.getBaseNode(conf.get("haclient.base.node", "/haclient"), this.originalConf.get("haclient.cluster.id"));
            if (ZKUtil.checkExists((ZooKeeperWatcher)zk, (String)baseNode) == -1) {
                Integer n = 0;
                return n;
            }
            String targetNode = ZKUtil.joinZNode((String)baseNode, (String)linkNode);
            if (ZKUtil.checkExists((ZooKeeperWatcher)zk, (String)targetNode) == -1) {
                Integer n = 0;
                return n;
            }
            int count = ZKUtil.getNumberOfChildren((ZooKeeperWatcher)zk, (String)targetNode);
            LOG.debug((Object)("Get Link Count :" + count + " from " + conf.get("hbase.zookeeper.quorum") + linkNode));
            Integer n = count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getDataFrom(Configuration conf, String nodeName) throws IOException, KeeperException, InterruptedException {
        try (ZooKeeperWatcher zk = new ZooKeeperWatcher(conf, "GetCommand", null, false);){
            byte[] data;
            String baseNode = ClusterSwitchUtil.getBaseNode(conf.get("haclient.base.node", "/haclient"), this.originalConf.get("haclient.cluster.id"));
            if (ZKUtil.checkExists((ZooKeeperWatcher)zk, (String)baseNode) == -1) {
                byte[] byArray = null;
                return byArray;
            }
            String targetNode = ZKUtil.joinZNode((String)baseNode, (String)nodeName);
            if (ZKUtil.checkExists((ZooKeeperWatcher)zk, (String)targetNode) == -1) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zk, (String)targetNode, null);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, byte[]> getChildDataFrom(Configuration conf, String nodeName) throws IOException, KeeperException, InterruptedException {
        try (ZooKeeperWatcher zk = new ZooKeeperWatcher(conf, "GetCommand", null, false);){
            String baseNode = ClusterSwitchUtil.getBaseNode(conf.get("haclient.base.node", "/haclient"), this.originalConf.get("haclient.cluster.id"));
            if (ZKUtil.checkExists((ZooKeeperWatcher)zk, (String)baseNode) == -1) {
                Map<String, byte[]> map = null;
                return map;
            }
            String targetNode = ZKUtil.joinZNode((String)baseNode, (String)nodeName);
            if (ZKUtil.checkExists((ZooKeeperWatcher)zk, (String)targetNode) == -1) {
                Map<String, byte[]> map = null;
                return map;
            }
            HashMap<String, byte[]> result = new HashMap<String, byte[]>();
            List nodes = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zk, (String)targetNode);
            for (String node : nodes) {
                byte[] data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)zk, (String)ZKUtil.joinZNode((String)targetNode, (String)node), null);
                if (data == null || data.length <= 0) continue;
                result.put(node, data);
            }
            HashMap<String, byte[]> hashMap = result;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkClusterKey(String targetClusterKey) throws IOException, KeeperException {
        if ((targetClusterKey = targetClusterKey.trim()) == null) {
            throw new IOException("targetClusterKey should not b e null!");
        }
        if (targetClusterKey.length() == 0) {
            return;
        }
        if (ClusterSwitchUtil.isValidEndpoint(targetClusterKey)) {
            return;
        }
        if (!ClusterSwitchUtil.isValidClusterKey(targetClusterKey)) {
            throw new IOException(targetClusterKey + " is not a valid clusterkey, should be host1,host2:port:/baseNode");
        }
        Configuration configuration = new Configuration(this.masterConf);
        ClusterSwitchUtil.applyClusterKeyToConf(configuration, targetClusterKey);
        try (ZooKeeperWatcher zk = new ZooKeeperWatcher(configuration, "checkCluster", null, false);){
            if (!this.checkIfHBaseCluster(configuration.get("zookeeper.znode.parent", "/hbase"), zk)) {
                throw new IOException(targetClusterKey + " is not a valid cluster, " + "a HBase cluster should have /master and /rs node under znode parent");
            }
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
    }

    protected int switchTo(String targetClusterKey, long ts, boolean skipCheck) throws IOException, KeeperException, InterruptedException {
        if (!skipCheck) {
            this.checkClusterKey(targetClusterKey);
        }
        SwitchCommand command = new SwitchCommand(targetClusterKey, ts);
        CountDownLatch latch = new CountDownLatch(this.totalClusters);
        ArrayList<SendCommandRunner> runners = new ArrayList<SendCommandRunner>();
        SendCommandRunner runner = new SendCommandRunner(latch, this.masterConf, command);
        runners.add(runner);
        this.executor.submit(runner);
        for (Configuration slaveConf : this.slaveConfs) {
            runner = new SendCommandRunner(latch, slaveConf, command);
            runners.add(runner);
            this.executor.submit(runner);
        }
        latch.await();
        int totalSuccess = 0;
        for (SendCommandRunner sendCommandRunner : runners) {
            if (sendCommandRunner.hasError()) {
                LOG.warn((Object)("Command " + command + " hasn't been set on cluster " + ClusterSwitchUtil.getZooKeeperClusterKey(sendCommandRunner.getConf()) + " since "), sendCommandRunner.getError());
                continue;
            }
            ++totalSuccess;
        }
        return totalSuccess;
    }

    protected List<Pair<String, SwitchCommand>> listCurrentSwitchCommands() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(this.totalClusters);
        ArrayList<GetCommandRunner> runners = new ArrayList<GetCommandRunner>();
        GetCommandRunner runner = new GetCommandRunner(latch, this.masterConf);
        runners.add(runner);
        this.executor.submit(runner);
        for (Configuration conf : this.slaveConfs) {
            runner = new GetCommandRunner(latch, conf);
            runners.add(runner);
            this.executor.submit(runner);
        }
        latch.await();
        ArrayList<Pair<String, SwitchCommand>> results = new ArrayList<Pair<String, SwitchCommand>>();
        for (GetCommandRunner getCommandRunner : runners) {
            String clusterKey = ClusterSwitchUtil.getZooKeeperClusterKey(getCommandRunner.getConf());
            if (getCommandRunner.hasError()) {
                LOG.warn((Object)("GetCommand failed on cluster " + clusterKey + " since "), getCommandRunner.getError());
            }
            Pair result = new Pair((Object)clusterKey, getCommandRunner.getResult());
            results.add((Pair<String, SwitchCommand>)result);
        }
        return results;
    }

    protected List<Pair<String, Integer>> listCurrentLinkCount() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(this.totalClusters);
        ArrayList<GetLinkCountRunner> runners = new ArrayList<GetLinkCountRunner>();
        GetLinkCountRunner runner = new GetLinkCountRunner(latch, this.masterConf);
        runners.add(runner);
        this.executor.submit(runner);
        for (Configuration conf : this.slaveConfs) {
            runner = new GetLinkCountRunner(latch, conf);
            runners.add(runner);
            this.executor.submit(runner);
        }
        latch.await();
        ArrayList<Pair<String, Integer>> results = new ArrayList<Pair<String, Integer>>();
        for (GetLinkCountRunner getLinkCountRunner : runners) {
            String clusterKey = ClusterSwitchUtil.getZooKeeperClusterKey(getLinkCountRunner.getConf());
            if (getLinkCountRunner.hasError()) {
                LOG.warn((Object)("GetCommand failed on cluster " + clusterKey + " since "), getLinkCountRunner.getError());
            }
            Pair result = new Pair((Object)clusterKey, getLinkCountRunner.getResult());
            results.add((Pair<String, Integer>)result);
        }
        return results;
    }

    public int switchTo(String targetClusterKey) throws IOException, KeeperException, InterruptedException {
        return this.switchTo(targetClusterKey, System.currentTimeMillis(), false);
    }

    public void setConnectNode() throws IOException, KeeperException {
        Configuration conf = ClusterSwitchUtil.createConfWithConnectKey(this.connectInfo.getZkClusterKey(), null);
        this.sendConnectInfo(conf, this.connectInfo);
    }

    public ConnectInfo getConnectNode() throws IOException, KeeperException, InterruptedException {
        Configuration conf = ClusterSwitchUtil.createConfWithConnectKey(this.connectInfo.getZkClusterKey(), null);
        return this.getConnectInfoFrom(conf);
    }

    public void setDualTables(List<String> dualTables) throws IOException, KeeperException {
        Configuration conf = ClusterSwitchUtil.createConfWithConnectKey(this.connectInfo.getZkClusterKey(), null);
        this.sendDualTable(conf, dualTables);
    }

    public List<String> getDualTables() throws IOException, KeeperException, InterruptedException {
        Configuration conf = ClusterSwitchUtil.createConfWithConnectKey(this.connectInfo.getZkClusterKey(), null);
        return this.getDualTablesFrom(conf);
    }

    public Map<String, JSONObject> getDualTrace() throws IOException, KeeperException, InterruptedException {
        Configuration conf = ClusterSwitchUtil.createConfWithConnectKey(this.connectInfo.getZkClusterKey(), null);
        return this.getDualTraceFrom(conf);
    }

    public String getCurrentActiveCluster() throws InterruptedException, IOException {
        List<Pair<String, SwitchCommand>> results = this.listCurrentSwitchCommands();
        SwitchCommand commandWithMinTs = SwitchCommand.NOCOMMAND;
        for (Pair<String, SwitchCommand> result : results) {
            SwitchCommand current = (SwitchCommand)result.getSecond();
            if (current == null) continue;
            if (current.getTs() > commandWithMinTs.getTs()) {
                commandWithMinTs = (SwitchCommand)result.getSecond();
                continue;
            }
            if (current.getTs() != commandWithMinTs.getTs() || current.equals(commandWithMinTs)) continue;
            throw new IOException("There is two command have same timestamp but with different target cluster, one is " + current + ", the other one is " + commandWithMinTs + ", please issue a new switch command to fix this.");
        }
        if (commandWithMinTs.isSwitchBackToMaster()) {
            return this.connectInfo.getActiveConnectKey();
        }
        return commandWithMinTs.getClusterKey();
    }

    public Map<String, Integer> getCurrentLinkCount() throws InterruptedException, IOException {
        List<Pair<String, Integer>> zkCountPairs = this.listCurrentLinkCount();
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        for (Pair<String, Integer> zkCountPair : zkCountPairs) {
            String clusterKey = ConnectInfoUtil.getClusterKeyFromConnectInfo(this.connectInfo, (String)zkCountPair.getFirst());
            results.put(clusterKey, (Integer)zkCountPair.getSecond());
        }
        return results;
    }

    private void sendCommand(Configuration conf, String targetClusterKey, long ts) throws IOException, KeeperException {
        String redirectNode = conf.get(ClusterSwitchUtil.ZOOKEEPER_REDIRECT_NODE, ClusterSwitchUtil.ZOOKEEPER_REDIRECT_NODE_DEFAULT);
        byte[] data = ClusterSwitchUtil.toSwitchCommandBytes(targetClusterKey, ts);
        this.sendCommand(conf, data, redirectNode);
        LOG.debug((Object)("Set targetClusterKey=" + targetClusterKey + ", ts=" + ts + " on " + redirectNode));
    }

    private void sendConnectInfo(Configuration conf, ConnectInfo connectInfo) throws IOException, KeeperException {
        String connectNode = conf.get(ClusterSwitchUtil.ZOOKEEPER_CONNECT_NODE, ClusterSwitchUtil.ZOOKEEPER_CONNECT_NODE_DEFAULT);
        byte[] data = ConnectInfoUtil.toConnectInfoBytes(connectInfo);
        this.sendCommand(conf, data, connectNode);
    }

    private void sendDualTable(Configuration conf, List<String> dualTables) throws IOException, KeeperException {
        if (dualTables == null || dualTables.isEmpty()) {
            return;
        }
        String dualTableNode = conf.get(ClusterSwitchUtil.ZOOKEEPER_DUAL_TABLE_NODE, ClusterSwitchUtil.ZOOKEEPER_DUAL_TABLE_NODE_DEFAULT);
        byte[] data = DualUtil.toDualTablesBytes(dualTables);
        this.sendCommand(conf, data, dualTableNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(Configuration conf, byte[] data, String nodeName) throws IOException, KeeperException {
        try (ZooKeeperWatcher zk = new ZooKeeperWatcher(conf, "ClusterSwitcher", null, false);){
            String baseNode = ClusterSwitchUtil.getBaseNode(conf.get("haclient.base.node", "/haclient"), this.originalConf.get("haclient.cluster.id"));
            ZKUtil.createNodeIfNotExistsNoWatch((ZooKeeperWatcher)zk, (String)baseNode, null, (CreateMode)CreateMode.PERSISTENT);
            String targetNode = ZKUtil.joinZNode((String)baseNode, (String)nodeName);
            if (ZKUtil.checkExists((ZooKeeperWatcher)zk, (String)targetNode) == -1) {
                ZKUtil.createNodeIfNotExistsNoWatch((ZooKeeperWatcher)zk, (String)targetNode, (byte[])data, (CreateMode)CreateMode.PERSISTENT);
            } else {
                ZKUtil.setData((ZooKeeperWatcher)zk, (String)targetNode, (byte[])data);
            }
        }
    }

    private void addOptions() {
        this.options.addOption("switchTo", "switchTo", true, "Switch to the giving cluster. Empty string means switch back to master cluster");
        this.options.addOption("skipCheck", "skipCheck", false, "Skip check when switch clusters.\nWARNING: Skip check may make client switch to a invalid cluster");
        this.options.addOption("getCurrentActive", "getCurrentActive", false, "Get current active cluster");
        this.options.addOption("setConnectNode", "setConnectNode", false, "set connent info to connect node");
        this.options.addOption("getConnectNode", "getConnectNode", false, "get connent info to connect node");
    }

    private void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("ClusterSwitch", this.options, true);
    }

    private boolean parseOptions(String[] args) throws ParseException, IOException {
        if (args.length == 0) {
            this.printUsage();
            return false;
        }
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.options, args);
        int commandCount = 0;
        if (cmd.hasOption("switchTo")) {
            this.isSwitchAction = true;
            this.targetClusterKey = cmd.getOptionValue("switchTo").trim();
            ++commandCount;
        }
        if (cmd.hasOption("skipCheck")) {
            this.skipCheck = true;
        }
        if (cmd.hasOption("getCurrentActive")) {
            this.isListAction = true;
            ++commandCount;
        }
        if (cmd.hasOption("setConnectNode")) {
            this.isSetConnectAction = true;
            ++commandCount;
        }
        if (cmd.hasOption("getConnectNode")) {
            this.isGetConnectAction = true;
            ++commandCount;
        }
        if (cmd.hasOption("getLinkCount")) {
            this.isGetLinkCountAction = true;
            ++commandCount;
        }
        if (commandCount > 1) {
            System.out.println("Only one command can execute at the same time");
            this.printUsage();
            return false;
        }
        if (!(this.isSwitchAction || this.isListAction || this.isSetConnectAction || this.isGetConnectAction || this.isGetLinkCountAction)) {
            System.out.println("Please specify the command to execute.");
            this.printUsage();
            return false;
        }
        return true;
    }

    private int run(String[] args) throws Exception {
        if (!this.parseOptions(args)) {
            return 1;
        }
        if (this.isListAction) {
            String currentActive = this.getCurrentActiveCluster();
            System.out.println("Current Active cluster is: " + currentActive);
        } else if (this.isSwitchAction) {
            int success;
            if (this.skipCheck) {
                System.out.println("WARNING: skipCheck is set, target cluster won't be validated. Clients could be switched to a invalid cluster");
            }
            if (this.targetClusterKey == null || this.targetClusterKey.isEmpty()) {
                System.out.println("Target cluster is not given, will switch to master cluster: " + this.connectInfo.getActiveConnectKey());
            }
            if ((success = this.switchTo(this.targetClusterKey, System.currentTimeMillis(), this.skipCheck)) == this.totalClusters) {
                System.out.println("Switch to " + this.targetClusterKey + " is successfully pushed to all " + success + " clusters");
            } else if (success == 0) {
                System.out.println("Switch to " + this.targetClusterKey + " is failed on all " + this.totalClusters + "clusters, please refer to the log for more details.");
            } else {
                System.out.println("Switch to " + this.targetClusterKey + " is successfully pushed to " + success + " clusters, " + (this.totalClusters - success) + " cluster(s) are failed, please refer to the log for more details.");
            }
        } else {
            if (this.isSetConnectAction) {
                try {
                    this.setConnectNode();
                }
                catch (Exception e) {
                    System.out.println("Set connect info failed : " + e);
                    return -1;
                }
            }
            if (this.isGetConnectAction) {
                try {
                    ConnectInfo connectInfo = this.getConnectNode();
                    System.out.println("ConnectInfo is: " + connectInfo);
                }
                catch (Exception e) {
                    System.out.println("Get connect info failed : " + e);
                    return -1;
                }
            }
            if (this.isGetLinkCountAction) {
                try {
                    Map<String, Integer> linkCounts = this.getCurrentLinkCount();
                    for (Map.Entry<String, Integer> linkCount : linkCounts.entrySet()) {
                        System.out.println("Cluster : " + linkCount.getKey() + " with link count " + linkCount.getValue());
                    }
                }
                catch (Exception e) {
                    System.out.println("Get link count failed : " + e);
                    return -1;
                }
            }
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        ConnectInfo connectInfo = ConnectInfoUtil.getConnectInfoFromXML("hbase-site.xml");
        if (connectInfo.getZkClusterKey() == null) {
            System.out.println("ConnectInfo::zkClusterKey is null");
            System.exit(-1);
        }
        Configuration conf = HBaseConfiguration.create();
        ClusterSwitcher switcher = new ClusterSwitcher(connectInfo, conf);
        System.exit(switcher.run(args));
    }

    private abstract class Runner<T>
    implements Runnable {
        private CountDownLatch latch;
        private T result = null;
        private Throwable throwable = null;
        protected Configuration configuration;

        public Runner(CountDownLatch latch, Configuration conf) {
            this.latch = latch;
            this.configuration = conf;
        }

        public Configuration getConf() {
            return this.configuration;
        }

        public boolean hasError() {
            return this.throwable != null;
        }

        public T getResult() {
            return this.result;
        }

        public Throwable getError() {
            return this.throwable;
        }

        public abstract T task() throws IOException, KeeperException, InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.result = this.task();
            }
            catch (Throwable t) {
                this.throwable = t;
            }
            finally {
                this.latch.countDown();
            }
        }
    }

    private class GetLinkCountRunner
    extends Runner<Integer> {
        public GetLinkCountRunner(CountDownLatch latch, Configuration conf) {
            super(latch, conf);
        }

        @Override
        public Integer task() throws IOException, KeeperException, InterruptedException {
            return ClusterSwitcher.this.getLinkCountFrom(this.configuration);
        }
    }

    private class GetCommandRunner
    extends Runner<SwitchCommand> {
        public GetCommandRunner(CountDownLatch latch, Configuration conf) {
            super(latch, conf);
        }

        @Override
        public SwitchCommand task() throws IOException, KeeperException, InterruptedException {
            return ClusterSwitcher.this.getCommandFrom(this.configuration);
        }
    }

    private class SendCommandRunner
    extends Runner<Boolean> {
        private SwitchCommand command;

        public SendCommandRunner(CountDownLatch latch, Configuration conf, SwitchCommand command) {
            super(latch, conf);
            this.command = command;
        }

        @Override
        public Boolean task() throws IOException, KeeperException, InterruptedException {
            SwitchCommand oldCommand = ClusterSwitcher.this.getCommandFrom(this.configuration);
            if (oldCommand.getTs() >= this.command.getTs()) {
                LOG.warn((Object)("Old command " + oldCommand + " has a ts greater or equal than current command " + this.command));
            }
            ClusterSwitcher.this.sendCommand(this.configuration, this.command.getClusterKey(), this.command.getTs());
            return true;
        }
    }
}

