/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.hbase.haclient.dualservice.DualCallable;
import com.alibaba.hbase.haclient.dualservice.DualContext;
import com.alibaba.hbase.haclient.dualservice.DualMetrics;
import com.alibaba.hbase.haclient.dualservice.DualScannerCallable;
import com.alibaba.hbase.haclient.dualservice.DualScannerResult;
import com.alibaba.hbase.haclient.dualservice.DualTrace;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.util.Threads;

public class DualExecutor {
    private Configuration conf;
    private ThreadPoolExecutor dualActiveThreadPool = null;
    private static ThreadPoolExecutor dualStandbyThreadPool = null;
    private boolean traceEnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public DualExecutor(Configuration conf) {
        this.conf = conf;
        int activeDualThreads = conf.getInt("hbase.dualservice.active.executor.thread", 100);
        int activeQueueSize = conf.getInt("hbase.dualservice.active.executor.queue", 256);
        int standbyDualThreads = conf.getInt("hbase.dualservice.standby.executor.thread", 10);
        int standbyQueueSize = conf.getInt("hbase.dualservice.standby.executor.queue", 256);
        this.dualActiveThreadPool = new ThreadPoolExecutor(activeDualThreads, activeDualThreads, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(activeQueueSize), Threads.newDaemonThreadFactory((String)"DualService-Active-Executor"), new ThreadPoolExecutor.AbortPolicy());
        if (dualStandbyThreadPool == null) {
            Class<DualExecutor> clazz = DualExecutor.class;
            // MONITORENTER : com.alibaba.hbase.haclient.dualservice.DualExecutor.class
            if (dualStandbyThreadPool == null) {
                dualStandbyThreadPool = new ThreadPoolExecutor(standbyDualThreads, standbyDualThreads, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(standbyQueueSize), Threads.newDaemonThreadFactory((String)"DualService-Standby-Executor"), new ThreadPoolExecutor.AbortPolicy());
            }
            // MONITOREXIT : clazz
        }
        this.traceEnable = conf.getBoolean("hbase.dualservice.trace.enable", true);
    }

    public static String createTableConfKey(String tableName, String confKey) {
        return tableName + "." + confKey;
    }

    public Result dualGet(HTable activeTable, HTable standbyTable, byte[] tableName, Get get2, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = new DualContext(tableName, glitchTimeout, operationTimeout);
        DualCallable activeCallable = new DualCallable(dualContext, activeTable, get2, ActionType.GET, Role.ACTIVE);
        DualCallable standbyCallable = new DualCallable(dualContext, standbyTable, get2, ActionType.GET, Role.STANDBY);
        DualMetrics getMetrics = null;
        if (this.traceEnable) {
            getMetrics = DualTrace.getInstance().getMetrics(DualTrace.GET);
        }
        return (Result)this.doDualOperation(activeCallable, standbyCallable, dualContext, getMetrics);
    }

    public Void dualPut(HTable activeTable, HTable standbyTable, byte[] tableName, Put put2, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = new DualContext(tableName, glitchTimeout, operationTimeout);
        DualCallable activeCallable = new DualCallable(dualContext, activeTable, put2, ActionType.PUT, Role.ACTIVE);
        DualCallable standbyCallable = new DualCallable(dualContext, standbyTable, put2, ActionType.PUT, Role.STANDBY);
        DualMetrics putMetrics = null;
        if (this.traceEnable) {
            putMetrics = DualTrace.getInstance().getMetrics(DualTrace.PUT);
        }
        return (Void)this.doDualOperation(activeCallable, standbyCallable, dualContext, putMetrics);
    }

    public Void dualDelete(HTable activeTable, HTable standbyTable, byte[] tableName, Delete delete, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = new DualContext(tableName, glitchTimeout, operationTimeout);
        DualCallable activeCallable = new DualCallable(dualContext, activeTable, delete, ActionType.DELETE, Role.ACTIVE);
        DualCallable standbyCallable = new DualCallable(dualContext, standbyTable, delete, ActionType.DELETE, Role.STANDBY);
        DualMetrics deleteMetrics = null;
        if (this.traceEnable) {
            deleteMetrics = DualTrace.getInstance().getMetrics(DualTrace.DELETE);
        }
        return (Void)this.doDualOperation(activeCallable, standbyCallable, dualContext, deleteMetrics);
    }

    public Result[] dualBatchGet(HTable activeTable, HTable standbyTable, byte[] tableName, List<Get> gets, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = new DualContext(tableName, glitchTimeout, operationTimeout);
        DualCallable activeCallable = new DualCallable(dualContext, activeTable, gets, ActionType.BATCHGET, Role.ACTIVE);
        DualCallable standbyCallable = new DualCallable(dualContext, standbyTable, gets, ActionType.BATCHGET, Role.STANDBY);
        DualMetrics batchGetMetrics = null;
        if (this.traceEnable) {
            batchGetMetrics = DualTrace.getInstance().getMetrics(DualTrace.BATCHGET);
        }
        return (Result[])this.doDualOperation(activeCallable, standbyCallable, dualContext, batchGetMetrics);
    }

    public Void dualBatchPut(HTable activeTable, HTable standbyTable, byte[] tableName, List<Put> puts, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = new DualContext(tableName, glitchTimeout, operationTimeout);
        DualCallable activeCallable = new DualCallable(dualContext, activeTable, puts, ActionType.BATCHPUT, Role.ACTIVE);
        DualCallable standbyCallable = new DualCallable(dualContext, standbyTable, puts, ActionType.BATCHPUT, Role.STANDBY);
        DualMetrics batchPutMetrics = null;
        if (this.traceEnable) {
            batchPutMetrics = DualTrace.getInstance().getMetrics(DualTrace.BATCHPUT);
        }
        return (Void)this.doDualOperation(activeCallable, standbyCallable, dualContext, batchPutMetrics);
    }

    public Void dualBatchDelete(HTable activeTable, HTable standbyTable, byte[] tableName, List<Delete> deletes, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = new DualContext(tableName, glitchTimeout, operationTimeout);
        DualCallable activeCallable = new DualCallable(dualContext, activeTable, deletes, ActionType.BATCHDELETE, Role.ACTIVE);
        DualCallable standbyCallable = new DualCallable(dualContext, standbyTable, deletes, ActionType.BATCHDELETE, Role.STANDBY);
        DualMetrics batchDeleteMetrics = null;
        if (this.traceEnable) {
            batchDeleteMetrics = DualTrace.getInstance().getMetrics(DualTrace.BATCHDELETE);
        }
        return (Void)this.doDualOperation(activeCallable, standbyCallable, dualContext, batchDeleteMetrics);
    }

    public DualScannerResult dualNext(ResultScanner activeScanner, ResultScanner standbyScanner, byte[] tableName, int glitchTimeout, int operationTimeout) throws IOException {
        DualContext dualContext = new DualContext(tableName, glitchTimeout, operationTimeout);
        DualScannerCallable activeCallable = new DualScannerCallable(dualContext, activeScanner, Role.ACTIVE);
        DualScannerCallable standbyCallable = new DualScannerCallable(dualContext, standbyScanner, Role.STANDBY);
        DualMetrics scanMetrics = null;
        if (this.traceEnable) {
            scanMetrics = DualTrace.getInstance().getMetrics(DualTrace.SCAN);
        }
        return (DualScannerResult)this.doDualOperation(activeCallable, standbyCallable, dualContext, scanMetrics);
    }

    private <T> T doDualOperation(Callable<T> activeCallable, Callable<T> standbyCallable, DualContext<T> dualContext, DualMetrics metrics) throws IOException {
        Future<T> activeFuture = null;
        Future<T> standbyFuture = null;
        try {
            if (this.dualActiveThreadPool != null && this.dualActiveThreadPool.getQueue().size() < 10) {
                dualContext.start();
                activeFuture = this.dualActiveThreadPool.submit(activeCallable);
                T result = dualContext.getResultInGlitchTimeout();
                if (dualContext.usePrimaryAsResult() != null) {
                    T t = result;
                    return t;
                }
                boolean dualsubmit = false;
                if (dualStandbyThreadPool != null && dualStandbyThreadPool.getQueue().size() < 10) {
                    standbyFuture = dualStandbyThreadPool.submit(standbyCallable);
                    dualsubmit = true;
                }
                if (this.traceEnable && dualsubmit) {
                    metrics.addDualExecuteHistogram();
                }
                dualContext.waitOperationTimeout();
                if (this.traceEnable && dualContext.useStandbyAsResult()) {
                    metrics.addDualRealHistogram(System.currentTimeMillis() - dualContext.getStart());
                }
                T t = dualContext.getResult();
                return t;
            }
            T result = activeCallable.call();
            return result;
        }
        finally {
            if (activeFuture != null && !activeFuture.isDone()) {
                activeFuture.cancel(true);
            }
            if (standbyFuture != null && !standbyFuture.isDone()) {
                standbyFuture.cancel(true);
            }
        }
    }

    public void close() {
        if (this.dualActiveThreadPool != null) {
            this.dualActiveThreadPool.shutdown();
        }
    }

    public static enum Role {
        ACTIVE,
        STANDBY;

    }

    public static enum ActionType {
        GET,
        PUT,
        DELETE,
        BATCHGET,
        BATCHPUT,
        BATCHDELETE;

    }
}

