/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.LindormTableService;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.ipc.ClientCompletableFuture;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.tableservice.LMutationResult;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.Delete;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;

public class LDelete
extends DmlOperation
implements Delete {
    public static final String DELETE_COLUMNS_ATTR = "COLUMNS";
    public static final String DELETE_TIMESTAMP_ATTR = "TIMESTAMP";
    public static final String DELETE_TYPE_ATTR = "TYPE";
    public static final String DELETE_STREAM_ATTR = "STREAM";
    private Condition where;
    private List<ColumnKey> columnsToDelete = null;
    private Long timestamp = null;
    private DeleteType type = null;

    public LDelete() {
    }

    public LDelete(LindormTableService service) {
        super(service);
    }

    @Override
    public Delete from(String tableName) throws LindormException {
        if (this.service != null) {
            this.namespace = this.service.getNamespace();
        }
        this.tableName = tableName;
        return this;
    }

    @Override
    public Delete columns(String ... columns) {
        if (columns != null && columns.length > 0) {
            this.columnsToDelete = CollectionUtils.newArrayListWithCapacity(columns.length);
            for (String col : columns) {
                if (col == null || col.isEmpty()) {
                    throw new IllegalArgumentException("Column name to delete must not be null or empty.");
                }
                this.columnsToDelete.add(new ColumnKey(Bytes.toBytes(col)));
            }
        } else {
            this.columnsToDelete = null;
        }
        return this;
    }

    @Override
    public Delete columns(byte[] ... columns) {
        if (columns != null && columns.length > 0) {
            this.columnsToDelete = CollectionUtils.newArrayListWithCapacity(columns.length);
            for (byte[] col : columns) {
                if (col == null || col.length == 0) {
                    throw new IllegalArgumentException("Column name to delete must not be null or empty.");
                }
                this.columnsToDelete.add(new ColumnKey(col));
            }
        } else {
            this.columnsToDelete = null;
        }
        return this;
    }

    @Override
    public Delete columns(List<ColumnKey> columns) {
        if (columns != null && columns.size() > 0) {
            for (ColumnKey ck : columns) {
                if (ck != null) continue;
                throw new IllegalArgumentException("Column key must not be null.");
            }
            this.columnsToDelete = columns;
        } else {
            this.columnsToDelete = null;
        }
        return this;
    }

    @Override
    public Delete where(Condition where) {
        if (where == null) {
            throw new IllegalArgumentException("DELETE must have a valid WHERE clause, but has null.");
        }
        this.where = where;
        return this;
    }

    @Override
    public Delete timestamp(long timestamp) {
        this.timestamp = timestamp;
        this.type = DeleteType.ALL;
        return this;
    }

    @Override
    public Delete timestamp(long timestamp, boolean deleteAllVersions) {
        this.timestamp = timestamp;
        this.type = deleteAllVersions ? DeleteType.ALL : DeleteType.SINGLE;
        return this;
    }

    private LServerCallable<LMutationResult> buildDeleteCallable() {
        return new LServerCallable<LMutationResult>((DmlOperation)this, OperationContext.OperationType.DELETE){

            @Override
            public LMutationResult call() throws Exception {
                return this.server.delete(LDelete.this);
            }
        };
    }

    @Override
    public Future<Integer> executeAsync() throws LindormException {
        final ClientCompletableFuture<Integer> future = new ClientCompletableFuture<Integer>();
        this.executeAsync(new AsyncCallback<Integer>(){

            @Override
            public void onComplete(Integer result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public void executeAsync(AsyncCallback<Integer> callback) throws LindormException {
        this.validate();
        this.setupRouteKey();
        OperationContext.OperationType operationType = OperationContext.OperationType.DELETE;
        RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        LServerCallable<LMutationResult> deleteCallable = this.buildDeleteCallable();
        Object eagleEyeContext = this.service.startEagleeyeTraceAsync(this.tableName, operationType);
        AsyncDeleteHandler asyncDeleteHandler = new AsyncDeleteHandler(callback, operationType, System.currentTimeMillis(), eagleEyeContext);
        retryingCaller.withRetriesAsync(deleteCallable, asyncDeleteHandler);
    }

    @Override
    public int execute() throws LindormException {
        this.validate();
        long start = System.currentTimeMillis();
        this.service.startEagleeyeTrace(this.tableName, OperationContext.OperationType.DELETE);
        try {
            this.setupRouteKey();
            LDelete delete = this;
            LServerCallable<LMutationResult> deleteCallable = this.buildDeleteCallable();
            LMutationResult result = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser()).withRetries(deleteCallable);
            this.handleResultAttributes(delete, result);
            this.service.getLConnection().getTableMetricsManager().onOperationSuccess(this.namespace, this.tableName, OperationContext.OperationType.DELETE, System.currentTimeMillis() - start, 1);
            int n = result.getNumberOfRowsAffected();
            return n;
        }
        catch (Throwable t) {
            String msg = this.buildErrorMsg(OperationContext.OperationType.DELETE, t, System.currentTimeMillis() - start);
            LindormException error = new LindormException(msg);
            this.service.getLConnection().getTableMetricsManager().onOperationError(this.namespace, this.tableName, OperationContext.OperationType.DELETE, error);
            throw error;
        }
        finally {
            this.service.endEagleeyeTrace();
        }
    }

    public List<ColumnKey> getColumnsToDelete() {
        return this.columnsToDelete;
    }

    public Condition getWhere() {
        return this.where;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public DeleteType getType() {
        return this.type;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.columnsToDelete != null) {
            byte[] data = SchemaUtils.columnKeysToBytes(this.columnsToDelete);
            this.setAttribute(DELETE_COLUMNS_ATTR, data);
        }
        if (this.timestamp != null) {
            assert (this.type != null);
            this.setAttribute(DELETE_TIMESTAMP_ATTR, Bytes.toBytes(this.timestamp));
            this.setAttribute(DELETE_TYPE_ATTR, this.type.getValueBytes());
        }
        super.writeTo(out);
        assert (this.where != null);
        WritableUtils.writeVInt(out, ExpressionType.getOrdinal(this.where));
        this.where.writeTo(out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.where = (Condition)ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
        assert (this.where != null);
        this.where.readFrom(in);
        this.handleAttributes();
    }

    private void handleAttributes() throws IOException {
        byte[] timestampBytes;
        byte[] columnBytes = this.getAttribute(DELETE_COLUMNS_ATTR);
        if (columnBytes != null && columnBytes.length > 0) {
            this.columnsToDelete = SchemaUtils.bytesToColumnKeys(columnBytes);
        }
        if ((timestampBytes = this.getAttribute(DELETE_TIMESTAMP_ATTR)) != null && timestampBytes.length > 0) {
            this.timestamp = Bytes.toLong(timestampBytes);
            this.type = DeleteType.fromValue(this.getAttribute(DELETE_TYPE_ATTR)[0]);
        }
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("DELETE ");
        if (this.columnsToDelete != null && this.columnsToDelete.size() > 0) {
            for (ColumnKey ck : this.columnsToDelete) {
                str.append(ck.toString());
                str.append(",");
            }
            str.setLength(str.length() - 1);
        }
        str.append(" FROM ");
        str.append(this.tableName);
        str.append(" WHERE ");
        str.append(this.where.toString());
        if (this.timestamp != null) {
            if (this.type == DeleteType.ALL) {
                str.append(" TS <= ");
            } else {
                str.append(" TS == ");
            }
            str.append(this.timestamp);
        }
        return str.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LDelete)) {
            return false;
        }
        LDelete other = (LDelete)obj;
        return this.where.equals(other.where);
    }

    @Override
    protected byte[] computeRowKey(TableMeta meta) throws LindormException {
        return CompilerUtils.getRowKeyForRouting(meta, this.where);
    }

    private void validate() throws LindormException {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalRequestException("Table name must not be null or empty for DELETE.");
        }
        if (this.where == null) {
            throw new IllegalRequestException("Empty WHERE clause for DELETE " + this.tableName);
        }
    }

    private class AsyncDeleteHandler
    extends DmlOperation.AsyncLMutationResultHandler<Integer> {
        public AsyncDeleteHandler(AsyncCallback<Integer> callback, OperationContext.OperationType operationType, long startTime, Object eagleEyeContext) {
            super(LDelete.this, callback, operationType, startTime, eagleEyeContext);
        }

        @Override
        protected Integer getReturnValue(LMutationResult result) {
            return result.getNumberOfRowsAffected();
        }
    }

    public static enum DeleteType {
        ALL(1),
        SINGLE(2);

        private byte value;
        private byte[] valueBytes;

        private DeleteType(byte v) {
            this.value = v;
            this.valueBytes = new byte[]{v};
        }

        public byte getValue() {
            return this.value;
        }

        public byte[] getValueBytes() {
            return this.valueBytes;
        }

        public static DeleteType fromValue(byte v) {
            switch (v) {
                case 1: {
                    return ALL;
                }
                case 2: {
                    return SINGLE;
                }
            }
            throw new IllegalArgumentException("Unknown delete type value: " + v);
        }
    }
}

