/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.CoveredColumnType;
import com.alibaba.lindorm.client.core.meta.FamilyAttributes;
import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.IndexUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.schema.IndexState;
import com.alibaba.lindorm.client.schema.IndexedColumnSchema;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LIndexDescriptor
extends VersionedObjectWithAttributes {
    private static final String INDEX_CONDITION_ATTR = "PARTIAL_INDEX";
    private static final String INDEX_STORE_PK_NULLS_ATTR = "STORE_PK_NULLS_INDEX";
    private static final String INDEX_STORE_PK_TS_ATTR = "STORE_PK_TS_INDEX";
    private static final String FIRST_INDEXCOLUMN_PK_HASHED = "FIRST_INDEXCOLUMN_PK_HASHED";
    private static final String INDEX_STATE = "INDEX_STATE";
    private String namespace;
    private String indexName;
    private String dataTableName;
    private Condition indexCondition;
    private boolean storePkNulls;
    private boolean storePkTS;
    private IndexState indexState;
    private List<ColumnKey> coveredColumns = new ArrayList<ColumnKey>();
    private List<IndexedColumnSchema> indexedColumns = new ArrayList<IndexedColumnSchema>();
    private FamilyAttributes familyAttributes = new FamilyAttributes();
    private TableAttributes tableAttributes = new TableAttributes();

    public LIndexDescriptor() {
    }

    public LIndexDescriptor(String namespace, LindormIndexDescriptor indexDescriptor) {
        this.namespace = namespace;
        this.indexName = indexDescriptor.getIndexName();
        this.dataTableName = indexDescriptor.getDataTableName();
        this.indexedColumns = indexDescriptor.getIndexedColumns();
        this.coveredColumns = indexDescriptor.getCoveredColumns();
        this.familyAttributes = indexDescriptor.getFamilyAttributes();
        this.tableAttributes = indexDescriptor.getTableAttributes();
        this.indexCondition = indexDescriptor.getIndexCondition();
        this.storePkNulls = indexDescriptor.isStorePkNulls();
        this.indexState = indexDescriptor.getIndexState();
        this.storePkTS = indexDescriptor.isStorePkTS();
    }

    public LindormIndexDescriptor createIndexDescriptor() {
        LindormIndexDescriptor desc = new LindormIndexDescriptor(this.indexName, this.dataTableName);
        desc.setCoveredColumns(this.coveredColumns);
        desc.setIndexedColumns(this.indexedColumns);
        desc.setFamilyAttributes(this.familyAttributes);
        desc.setTableAttributes(this.tableAttributes);
        desc.where(this.indexCondition);
        desc.setStorePkNulls(this.storePkNulls);
        desc.setIndexState(this.indexState);
        desc.setStorePkTS(this.storePkTS);
        return desc;
    }

    public LindormIndexDescriptor createLocalIndexDescriptor() {
        LindormIndexDescriptor lid = this.createIndexDescriptor();
        lid.setLocalIndex();
        lid.setStorePkNulls(false);
        return lid;
    }

    public IndexState getIndexState() {
        return this.indexState;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getDataTableName() {
        return this.dataTableName;
    }

    public void setDataTableName(String dataTableName) {
        this.dataTableName = dataTableName;
    }

    public List<ColumnKey> getCoveredColumns() {
        return this.coveredColumns;
    }

    public void setCoveredColumns(List<ColumnKey> coveredColumns) {
        this.coveredColumns = coveredColumns;
    }

    public List<IndexedColumnSchema> getIndexedColumns() {
        return this.indexedColumns;
    }

    public void setIndexedColumns(List<IndexedColumnSchema> indexedColumns) {
        this.indexedColumns = indexedColumns;
    }

    public FamilyAttributes getFamilyAttributes() {
        return this.familyAttributes;
    }

    public void setFamilyAttributes(FamilyAttributes familyAttributes) {
        this.familyAttributes = familyAttributes;
    }

    public TableAttributes getTableAttributes() {
        return this.tableAttributes;
    }

    public void setTableAttributes(TableAttributes tableAttributes) {
        this.tableAttributes = tableAttributes;
    }

    private void setupAttributes() throws IOException {
        IndexedColumnSchema firstIndexedColumnSchema;
        if (this.indexCondition != null) {
            this.setAttribute(INDEX_CONDITION_ATTR, SchemaUtils.conditionToBytes(this.indexCondition));
        }
        if (this.storePkNulls) {
            this.setAttribute(INDEX_STORE_PK_NULLS_ATTR, Bytes.toBytes(this.storePkNulls));
        }
        if (this.storePkTS) {
            this.setAttribute(INDEX_STORE_PK_TS_ATTR, Bytes.toBytes(this.storePkTS));
        }
        if ((firstIndexedColumnSchema = this.indexedColumns.get(0)).isHashed()) {
            this.setAttribute(FIRST_INDEXCOLUMN_PK_HASHED, Bytes.toBytes(firstIndexedColumnSchema.isHashed()));
        }
        if (null != this.indexState) {
            this.setAttribute(INDEX_STATE, Bytes.toBytes(this.indexState.ordinal()));
        }
    }

    private void initFromAttributes() throws IOException {
        byte[] indexStateBytes;
        byte[] storePkTSBytes;
        byte[] storePkNullsBytes;
        byte[] whereBytes = this.getAttribute(INDEX_CONDITION_ATTR);
        if (whereBytes != null) {
            this.indexCondition = SchemaUtils.bytesToCondition(whereBytes);
        }
        if ((storePkNullsBytes = this.getAttribute(INDEX_STORE_PK_NULLS_ATTR)) != null) {
            this.storePkNulls = Bytes.toBoolean(storePkNullsBytes);
        }
        if ((storePkTSBytes = this.getAttribute(INDEX_STORE_PK_TS_ATTR)) != null) {
            this.storePkTS = Bytes.toBoolean(storePkTSBytes);
        }
        if (null != (indexStateBytes = this.getAttribute(INDEX_STATE))) {
            this.indexState = IndexState.values()[Bytes.toInt(indexStateBytes)];
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        WritableUtils.writeString(out, this.namespace);
        WritableUtils.writeString(out, this.indexName);
        WritableUtils.writeString(out, this.dataTableName);
        CoveredColumnType coveredColumnType = IndexUtils.resolveIndexCoveredColumnType(this.coveredColumns);
        WritableUtils.writeVInt(out, coveredColumnType.ordinal());
        if (!IndexUtils.isFullCover(coveredColumnType)) {
            WritableUtils.writeVInt(out, this.coveredColumns.size());
            for (ColumnKey columnKey : this.coveredColumns) {
                columnKey.writeTo(out);
            }
        }
        WritableUtils.writeVInt(out, this.indexedColumns.size());
        for (IndexedColumnSchema ic : this.indexedColumns) {
            ic.getColumnKey().writeTo(out);
            WritableUtils.writeVInt(out, ic.getSortOrder().ordinal());
        }
        this.familyAttributes.writeTo(out);
        this.tableAttributes.writeTo(out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        ColumnKey columnKey;
        int i;
        super.readFrom(in);
        this.namespace = WritableUtils.readString(in);
        this.indexName = WritableUtils.readString(in);
        this.dataTableName = WritableUtils.readString(in);
        this.coveredColumns = CollectionUtils.newArrayList();
        CoveredColumnType coveredColumnType = CoveredColumnType.values()[WritableUtils.readVInt(in)];
        if (coveredColumnType == CoveredColumnType.DYNAMIC) {
            this.coveredColumns.add(LindormIndexDescriptor.COVERED_DYNAMIC_COLUMNS);
        } else if (coveredColumnType == CoveredColumnType.ALL) {
            this.coveredColumns.add(LindormIndexDescriptor.COVERED_ALL_COLUMNS_IN_SCHEMA);
        } else {
            int numOfCoveredColumns = WritableUtils.readVInt(in);
            for (i = 0; i < numOfCoveredColumns; ++i) {
                columnKey = new ColumnKey();
                columnKey.readFrom(in);
                this.coveredColumns.add(columnKey);
            }
        }
        int numOfIndexedColumns = WritableUtils.readVInt(in);
        this.indexedColumns = CollectionUtils.newArrayListWithCapacity(numOfIndexedColumns);
        for (i = 0; i < numOfIndexedColumns; ++i) {
            columnKey = new ColumnKey();
            columnKey.readFrom(in);
            SortOrder sortOrder = SortOrder.values()[WritableUtils.readVInt(in)];
            this.indexedColumns.add(new IndexedColumnSchema(columnKey, sortOrder));
        }
        this.familyAttributes.readFrom(in);
        this.tableAttributes.readFrom(in);
        this.initFromAttributes();
        byte[] hashedPk = this.getAttribute(FIRST_INDEXCOLUMN_PK_HASHED);
        if (hashedPk != null) {
            this.indexedColumns.get(0).setHashed(Bytes.toBoolean(hashedPk));
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Index [").append(this.namespace).append(".").append(this.dataTableName).append(".").append(this.indexName).append("]");
        if (!this.indexedColumns.isEmpty()) {
            stringBuilder.append(", indexed columns:");
            for (IndexedColumnSchema ics : this.indexedColumns) {
                stringBuilder.append(ics).append(",");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        stringBuilder.append(", storePkNulls:" + this.storePkNulls);
        stringBuilder.append(", storePkTS:" + this.storePkTS);
        if (null != this.indexState) {
            stringBuilder.append(", index state:" + (Object)((Object)this.indexState));
        }
        if (!this.coveredColumns.isEmpty()) {
            stringBuilder.append(", covered columns:");
            for (ColumnKey columnKey : this.coveredColumns) {
                stringBuilder.append(columnKey.toString()).append(",");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        stringBuilder.append(", family attribute:").append(SchemaUtils.tableMetaAttributesToString(this.familyAttributes));
        stringBuilder.append(", table attribute:").append(SchemaUtils.tableMetaAttributesToString(this.tableAttributes));
        return stringBuilder.toString();
    }
}

