/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.tableservice.LSelect;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.QueryResults;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LDRemoteException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LQueryResults
implements QueryResults {
    private LSelect select;
    private PartialResult cache = null;
    private boolean needLoadingCache = true;
    private long numberOfRpcs = 0L;

    public LQueryResults(LSelect select) {
        this.select = select;
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){
            Row next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = LQueryResults.this.next();
                        return this.next != null;
                    }
                    catch (LindormException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }

            @Override
            public Row next() {
                if (!this.hasNext()) {
                    return null;
                }
                Row temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Row next() throws LindormException {
        if (this.needLoadingCache && (this.cache == null || this.cache.rows.size() == 0)) {
            this.loadCache();
        }
        if (this.cache.rows.size() > 0) {
            Row r = (Row)this.cache.rows.poll();
            if (r != null) {
                r.setOrderedColumns(this.cache.orderedColumns);
            }
            return r;
        }
        this.needLoadingCache = false;
        return null;
    }

    @Override
    public List<Row> next(int maxNumberOfRows) throws LindormException {
        Row r;
        if (maxNumberOfRows < 1) {
            throw new IllegalRequestException("maxNumberOfRows must >= 1, but has " + maxNumberOfRows);
        }
        ArrayList<Row> rows = new ArrayList<Row>(maxNumberOfRows);
        for (int i = 0; i < maxNumberOfRows && (r = this.next()) != null; ++i) {
            rows.add(r);
        }
        return rows;
    }

    private void loadCache() throws LindormException {
        if (!this.prepareContext()) {
            this.needLoadingCache = false;
            return;
        }
        this.cache = this.select.next();
        ++this.numberOfRpcs;
        if (this.cache == null || this.cache.rows.size() == 0) {
            this.needLoadingCache = false;
        }
    }

    private boolean prepareContext() {
        SelectContext ctx;
        if (this.cache != null) {
            if (!LQueryResults.hasMore(this.cache.getContext())) {
                return false;
            }
            ctx = this.cache.context;
        } else {
            ctx = new SelectContext();
            if (this.select.hasOffset()) {
                ctx.setOffset(this.select.getOffset());
            }
            if (this.select.hasLimit()) {
                ctx.setLimit(this.select.getLimit());
            }
        }
        this.select.setContext(ctx);
        return true;
    }

    public static boolean hasMore(SelectContext ctx) {
        boolean noValidSubPlan;
        boolean noNextPK = ctx.getNextStartPrimaryKey() == null;
        boolean isMultiScan = ctx.isMultiScanQuery();
        boolean bl = noValidSubPlan = ctx.getSubPlanIndex() == LSelect.INVALID_SUBPLAN_INDEX;
        if (noNextPK && isMultiScan && noValidSubPlan) {
            return false;
        }
        return !noNextPK || isMultiScan;
    }

    public long getNumberOfRpcs() {
        return this.numberOfRpcs;
    }

    public PartialResult getCache() {
        return this.cache;
    }

    public static PartialResult mergePartialResult(PartialResult old, PartialResult current) {
        assert (current != null);
        if (old == null) {
            return current;
        }
        old.getRows().addAll(current.getRows());
        LinkedList<Row> rows = old.getRows();
        int size = old.getEstimatedSize() + current.getEstimatedSize();
        return new PartialResult(rows, current.getContext(), size);
    }

    public static class PartialResult
    extends VersionedObjectWithAttributes {
        private LinkedList<Row> rows;
        private SelectContext context;
        private List<Throwable> errors = null;
        private int estimatedSize = 0;
        private List<ColumnKey> orderedColumns = null;

        public PartialResult() {
        }

        public PartialResult(LinkedList<Row> rows, SelectContext context) {
            this(rows, context, 0);
        }

        public PartialResult(LinkedList<Row> rows, SelectContext context, int extimatedSize) {
            this.rows = rows;
            this.context = context;
            this.estimatedSize = extimatedSize;
        }

        public LinkedList<Row> getRows() {
            return this.rows;
        }

        public void setRows(LinkedList<Row> rows) {
            this.rows = rows;
        }

        public boolean isEmptyResult() {
            return this.rows == null || this.rows.size() == 0;
        }

        public void setOrderedColumns(List<ColumnKey> orderedColumns) {
            this.orderedColumns = orderedColumns;
        }

        public int getRowNum() {
            if (this.rows == null) {
                return 0;
            }
            return this.rows.size();
        }

        public SelectContext getContext() {
            return this.context;
        }

        public void setContext(SelectContext context) {
            this.context = context;
        }

        public int getEstimatedSize() {
            if (this.estimatedSize == 0 && this.rows != null && !this.rows.isEmpty()) {
                for (Row r : this.rows) {
                    this.estimatedSize += r.getEstimatedSize();
                }
            }
            return this.estimatedSize;
        }

        public boolean isPartialResultDone() {
            if (this.errors != null && this.errors.size() != 0) {
                return false;
            }
            if (this.context.isMultiGetQuery()) {
                for (boolean isSucess : this.context.getMultiGetStatus()) {
                    if (isSucess) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean hasErrors() {
            return this.errors != null && this.errors.size() > 0;
        }

        public List<Throwable> getErrors() {
            return this.errors;
        }

        public void addError(Throwable error) {
            if (this.errors == null) {
                this.errors = new ArrayList<Throwable>();
            }
            this.errors.add(error);
        }

        public void addErrors(List<Throwable> errors) {
            if (this.errors == null) {
                this.errors = new ArrayList<Throwable>();
            }
            this.errors.addAll(errors);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            if (this.rows == null || this.rows.isEmpty()) {
                WritableUtils.writeVInt(out, 0);
            } else {
                WritableUtils.writeVInt(out, this.rows.size());
                for (Row oneRow : this.rows) {
                    oneRow.writeTo(out);
                }
            }
            this.context.writeTo(out);
            if (this.errors != null && this.errors.size() > 0) {
                out.writeBoolean(true);
                WritableUtils.writeVInt(out, this.errors.size());
                for (Throwable t : this.errors) {
                    WritableUtils.writeString(out, t.getClass().getName());
                    WritableUtils.writeString(out, StringUtils.stringifyException(t));
                }
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            super.readFrom(in);
            int rowCount = WritableUtils.readVInt(in);
            this.rows = new LinkedList();
            for (int i = 0; i < rowCount; ++i) {
                Row r = new Row();
                r.readFrom(in);
                this.rows.add(r);
            }
            this.context = new SelectContext();
            this.context.readFrom(in);
            boolean hasError = in.readBoolean();
            if (hasError) {
                this.errors = new ArrayList<Throwable>();
                int num = WritableUtils.readVInt(in);
                for (int i = 0; i < num; ++i) {
                    String klass = WritableUtils.readString(in);
                    String desc = WritableUtils.readString(in);
                    this.errors.add(new LDRemoteException(klass, desc).unwrapRemoteException());
                }
            }
        }
    }

    public static class SelectContext
    extends VersionedObjectWithAttributes {
        private static final String ATTR_KEY_OFFSET = "OFFSET";
        private static final String RESUME_ROW = "_resume_";
        private SelectTypeEnum selectType = SelectTypeEnum.NORMAL;
        private byte[] nextStartPrimaryKey = null;
        private int limit = -1;
        private short subPlanIndex = 0;
        private boolean[] multiGetStatus = null;
        private int offset;
        private int batchCount;
        private transient TableMeta indexMeta;
        private transient boolean localIndex;
        private int alreadyReturnedSize = 0;

        public int getAlreadyReturnedSize() {
            return this.alreadyReturnedSize;
        }

        public void setAlreadyReturnedSize(int alreadyReturnedSize) {
            this.alreadyReturnedSize = alreadyReturnedSize;
        }

        public void setLocalIndex() {
            this.localIndex = true;
        }

        public boolean isLocalIndex() {
            return this.localIndex;
        }

        public void setIndexMeta(TableMeta indexMeta) {
            this.indexMeta = indexMeta;
        }

        public TableMeta getIndexMeta() {
            return this.indexMeta;
        }

        public void setNextStartPrimaryKey(byte[] nextStartPrimaryKey) {
            this.nextStartPrimaryKey = nextStartPrimaryKey;
        }

        public byte[] getNextStartPrimaryKey() {
            return this.nextStartPrimaryKey;
        }

        public byte[] getResumeRow() {
            return this.getAttribute(RESUME_ROW);
        }

        public void setResumeRow(byte[] resumeRow) {
            if (resumeRow != null) {
                this.setAttribute(RESUME_ROW, resumeRow);
            }
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public int getLimit() {
            return this.limit;
        }

        public short getSubPlanIndex() {
            return this.subPlanIndex;
        }

        public void setSubPlanIndex(short subPlanIndex) {
            this.subPlanIndex = subPlanIndex;
        }

        public boolean isMultiScanQuery() {
            return this.selectType.equals((Object)SelectTypeEnum.MULTISCAN);
        }

        public void setMultiScanQuery() {
            this.selectType = SelectTypeEnum.MULTISCAN;
        }

        public void cleanStatus() {
            this.multiGetStatus = null;
            this.alreadyReturnedSize = 0;
        }

        public boolean isMultiGetQuery() {
            return this.selectType.equals((Object)SelectTypeEnum.MULTIGET);
        }

        public boolean[] getMultiGetStatus() {
            return this.multiGetStatus;
        }

        public void setMultiGetQuery(int numOfGet) {
            this.selectType = SelectTypeEnum.MULTIGET;
            this.multiGetStatus = new boolean[numOfGet];
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
            this.setAttribute(ATTR_KEY_OFFSET, Bytes.toBytes(offset));
        }

        public int getBatchReturnCount() {
            return this.batchCount;
        }

        public void setBatchReturnCount(int batchCount) {
            this.batchCount = batchCount;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            if (this.offset > 0) {
                this.setAttribute(ATTR_KEY_OFFSET, Bytes.toBytes(this.offset));
            }
            super.writeTo(out);
            Bytes.writeByteArray(out, this.nextStartPrimaryKey);
            WritableUtils.writeVInt(out, this.limit);
            WritableUtils.writeVInt(out, this.alreadyReturnedSize);
            WritableUtils.writeString(out, this.selectType.toString());
            if (this.selectType.equals((Object)SelectTypeEnum.MULTISCAN)) {
                WritableUtils.writeVInt(out, this.subPlanIndex);
            }
            if (this.multiGetStatus != null) {
                WritableUtils.writeVInt(out, this.multiGetStatus.length);
                for (boolean status : this.multiGetStatus) {
                    out.writeBoolean(status);
                }
            } else {
                WritableUtils.writeVInt(out, 0);
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            int num;
            super.readFrom(in);
            byte[] offsetBytes = this.getAttribute(ATTR_KEY_OFFSET);
            if (offsetBytes != null) {
                this.offset = Bytes.toInt(offsetBytes);
            }
            this.nextStartPrimaryKey = Bytes.readByteArrayNullable(in);
            this.limit = WritableUtils.readVInt(in);
            this.alreadyReturnedSize = WritableUtils.readVInt(in);
            this.selectType = SelectTypeEnum.valueOf(WritableUtils.readString(in));
            if (this.selectType.equals((Object)SelectTypeEnum.MULTISCAN)) {
                this.subPlanIndex = (short)WritableUtils.readVInt(in);
            }
            if ((num = WritableUtils.readVInt(in)) != 0) {
                this.multiGetStatus = new boolean[num];
                for (int i = 0; i < num; ++i) {
                    this.multiGetStatus[i] = in.readBoolean();
                }
            }
        }

        private static enum SelectTypeEnum {
            NORMAL,
            MULTIGET,
            MULTISCAN;

        }
    }
}

