/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.meta.CoveredColumnType;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.meta.TableType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.exception.ColumnNotFoundException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.IndexedColumnSchema;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.Mutability;
import java.util.HashSet;
import java.util.List;

public class IndexUtils {
    public static final String MAX_INDEX_NUM_KEY = "lindorm.max.index.number";
    public static final int DEFAULT_MAX_INDEX_NUM = 5;
    public static final String MAX_NUM_INDEXED_NON_PRIMARY_KEY_COLUMNS = "lindorm.indexed.non.primary.key.columns.max";
    public static final int DEFAULT_MAX_NUM_INDEXED_NON_PRIMARY_KEY_COLUMNS = 3;
    public static final String MAX_NUM_COVERED_COLUMNS = "lindorm.covered.columns.max";
    public static final int DEFAULT_MAX_NUM_COVERED_COLUMNS = 5;
    public static final String SINGLE_ZONE_CHECK_KEY = "lindorm.single.zone.check.index";
    public static boolean DEFAULT_SINGLE_ZONE_CHECK = true;
    public static final String INDEX_NAMES_KEY = "INDEX_NAMES";
    public static final byte[] INDEX_NAMES_KEY_BYTES = Bytes.toBytes("INDEX_NAMES");
    public static final String INDEX_META_KEY = "INDEX_META";
    public static final String INDEX_ID_KEY = "INDEX_ID";
    public static final byte[] INDEX_ID_KEY_BYTES = Bytes.toBytes("INDEX_ID");
    public static final String SILENCE_INDEXES_KEY = "SILENCE_INDEXES";
    public static final byte[] SILENCE_INDEXES_KEY_BYTES = Bytes.toBytes("SILENCE_INDEXES");
    public static final String INDEX_COVERED_COLUMN_TYPE = "INDEX_COVERED_TYPE";
    public static final String INDEX_STATE_KEY = "INDEX_STATE";
    public static final String INDEX_NAME_KEY = "INDEX_NAME";
    public static final String INDEX_CREATE_CONDITION_KEY = "INDEX_CREATE_CONDITION";
    public static final String INDEX_STORE_PK_NULLS_KEY = "INDEX_STORE_PK_NULLS";
    public static final String INDEX_STORE_PK_TS_KEY = "INDEX_STORE_PK_TS";

    public static ColumnKey getDataColumnKeyForDynamicColumn(String indexQualifier) {
        int splitPoint = indexQualifier.indexOf(SchemaUtils.COLUMN_NAME_SEPARATOR);
        String family = indexQualifier.substring(0, splitPoint);
        String qualifier = indexQualifier.substring(splitPoint + 1);
        return new ColumnKey(family, qualifier);
    }

    public static byte[] getIndexColumnQualifier(ColumnKey dataColumnKey, CoveredColumnType ccType) {
        byte[] indexQualifier = ccType != CoveredColumnType.DYNAMIC ? dataColumnKey.getQualifier() : dataColumnKey.getFullName();
        return indexQualifier;
    }

    public static boolean needQualifierConversion(CoveredColumnType ccType) {
        return ccType == CoveredColumnType.DYNAMIC;
    }

    public static boolean isFullCover(CoveredColumnType ccType) {
        return ccType == CoveredColumnType.ALL || ccType == CoveredColumnType.DYNAMIC;
    }

    public static ColumnKey getNonPKIndexColumnKey(ColumnKey dataColumnKey, CoveredColumnType ccType) {
        byte[] indexQualifier = IndexUtils.getIndexColumnQualifier(dataColumnKey, ccType);
        return new ColumnKey(SchemaUtils.DEFAULT_FAMILY_NAME_BYTES, indexQualifier);
    }

    public static ColumnKey getNonPKIndexColumnKey(ColumnKey dataColumnKey, TableMeta indexTableMeta) {
        CoveredColumnType ccType = indexTableMeta.getCoveredColumnType();
        byte[] indexQualifier = IndexUtils.getIndexColumnQualifier(dataColumnKey, ccType);
        return new ColumnKey(IndexUtils.getIndexFamily(indexTableMeta), indexQualifier);
    }

    public static byte[] getIndexFamily(TableMeta indexMeta) {
        if (indexMeta.isLocalIndex()) {
            return SchemaUtils.DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES;
        }
        return SchemaUtils.DEFAULT_FAMILY_NAME_BYTES;
    }

    public static ColumnKey getIndexColumnKey(ColumnKey dataColumnKey, TableMeta indexTableMeta) {
        LColumn idxLColumn = indexTableMeta.resolveColumnNoThrow(dataColumnKey);
        boolean isPK = idxLColumn != null ? idxLColumn.isPrimaryKey() : false;
        CoveredColumnType ccType = indexTableMeta.getCoveredColumnType();
        if (ccType == CoveredColumnType.DYNAMIC) {
            return isPK ? new ColumnKey(dataColumnKey.getFullName()) : new ColumnKey(IndexUtils.getIndexFamily(indexTableMeta), dataColumnKey.getFullName());
        }
        if (indexTableMeta.isLocalIndex()) {
            return isPK ? new ColumnKey(dataColumnKey.getQualifier()) : new ColumnKey(IndexUtils.getIndexFamily(indexTableMeta), dataColumnKey.getQualifier());
        }
        return new ColumnKey(null, dataColumnKey.getQualifier());
    }

    public static LColumn resolveIndexColumnFromDataTable(ColumnKey dataColumnKey, TableMeta dataTableMeta) throws ColumnNotFoundException {
        LColumn colInDataTable = dataTableMeta.resolveColumnNoThrow(dataColumnKey);
        if (colInDataTable == null) {
            throw new ColumnNotFoundException("Column " + dataColumnKey.toString() + " not found in data table " + dataTableMeta.getTableName() + ", please check your DDL and retry.");
        }
        return colInDataTable;
    }

    public static CoveredColumnType resolveIndexCoveredColumnType(List<ColumnKey> coveredColumnsSchema) {
        CoveredColumnType ccType = CoveredColumnType.NONE;
        if (coveredColumnsSchema != null && coveredColumnsSchema.size() > 0) {
            ccType = coveredColumnsSchema.get(0) == LindormIndexDescriptor.COVERED_ALL_COLUMNS_IN_SCHEMA ? CoveredColumnType.ALL : (coveredColumnsSchema.get(0) == LindormIndexDescriptor.COVERED_DYNAMIC_COLUMNS ? CoveredColumnType.DYNAMIC : CoveredColumnType.SPECIFIC);
        }
        return ccType;
    }

    public static void createIndexTableSchema(LindormIndexDescriptor desc, TableMeta dataTableMeta, TableMeta indexTableMeta) throws LindormException {
        LColumn meta;
        List<LColumn> columnSchema = indexTableMeta.getAllColumns();
        List<LColumn> pksInDataTable = dataTableMeta.getPkColumns();
        List<IndexedColumnSchema> indexedColumnsSchema = desc.getIndexedColumns();
        List<ColumnKey> coveredColumnsSchema = desc.getCoveredColumns();
        TableType indexTableType = IndexUtils.resolveIndexTableType(desc, dataTableMeta);
        indexTableMeta.setType(indexTableType);
        CoveredColumnType ccType = IndexUtils.resolveIndexCoveredColumnType(desc.getCoveredColumns());
        indexTableMeta.setCoveredColumnType(ccType);
        HashSet<ColumnKey> indexPKColumnSet = CollectionUtils.newHashSetWithExpectedSize(pksInDataTable.size());
        int position = 0;
        for (IndexedColumnSchema ic : indexedColumnsSchema) {
            meta = LColumn.createIndexColumnMeta(ic, position, dataTableMeta, indexTableMeta);
            meta.setStoreNull(desc.isStorePkNulls());
            columnSchema.add(meta);
            indexPKColumnSet.add(meta.getDataColumnKey());
            ++position;
        }
        for (LColumn pk : pksInDataTable) {
            if (indexPKColumnSet.contains(pk.getColumnKey())) continue;
            meta = pk.deepCopy(position);
            if (desc.isLocalIndex()) {
                meta.setFamilyName(SchemaUtils.DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES);
            }
            meta.setDataColumnKey(pk.getColumnKey());
            meta.setDataColumnMeta(pk);
            meta.setStoreNull(desc.isStorePkNulls());
            columnSchema.add(meta);
            ++position;
        }
        columnSchema.add(SchemaUtils.getDefaultColumnMeta(indexTableMeta));
        if (ccType != CoveredColumnType.NONE && ccType == CoveredColumnType.SPECIFIC) {
            for (ColumnKey ck : coveredColumnsSchema) {
                meta = LColumn.createIndexColumnMeta(ck, dataTableMeta, indexTableMeta, position);
                ++position;
                columnSchema.add(meta);
            }
        }
    }

    public static TableType resolveIndexTableType(LindormIndexDescriptor desc, TableMeta dataTableMeta) throws LindormException {
        Mutability mutability = dataTableMeta.getTableAttributes().getMutability();
        List<IndexedColumnSchema> indexedColumnsSchema = desc.getIndexedColumns();
        if (null == indexedColumnsSchema || indexedColumnsSchema.isEmpty()) {
            throw new IllegalRequestException("There must be at least one IndexedColumnSchema, but has none.");
        }
        boolean localIndex = desc.isLocalIndex();
        if (IndexUtils.isPkReorderIndex(desc, dataTableMeta)) {
            switch (mutability) {
                case MUTABLE_ALL: {
                    return TableType.PK_REORDER_UDT_INDEX;
                }
            }
            return localIndex ? TableType.PK_REORDER_LOCAL_INDEX : TableType.PK_REORDER_INDEX;
        }
        if (IndexUtils.isSingleColumnIndex(desc, dataTableMeta)) {
            switch (mutability) {
                case MUTABLE_ALL: {
                    return TableType.SINGLE_COLUMN_UDT_INDEX;
                }
            }
            return localIndex ? TableType.SINGLE_COLUMN_LOCAL_INDEX : TableType.SINGLE_COLUMN_INDEX;
        }
        switch (mutability) {
            case MUTABLE_ALL: {
                return TableType.MULTI_COLUMN_UDT_INDEX;
            }
        }
        return localIndex ? TableType.MULTI_COLUMN_LOCAL_INDEX : TableType.MULTI_COLUMN_INDEX;
    }

    private static boolean isPkReorderIndex(LindormIndexDescriptor desc, TableMeta dataTableMeta) throws LindormException {
        List<IndexedColumnSchema> indexedColumnsSchema = desc.getIndexedColumns();
        for (IndexedColumnSchema ics : indexedColumnsSchema) {
            if (IndexUtils.isPrimaryKey(ics, dataTableMeta)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSingleColumnIndex(LindormIndexDescriptor desc, TableMeta dataTableMeta) throws LindormException {
        List<IndexedColumnSchema> indexedColumnsSchema = desc.getIndexedColumns();
        if (IndexUtils.isPrimaryKey(indexedColumnsSchema.get(0), dataTableMeta)) {
            return false;
        }
        for (int i = 1; i < indexedColumnsSchema.size(); ++i) {
            if (IndexUtils.isPrimaryKey(indexedColumnsSchema.get(i), dataTableMeta)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrimaryKey(IndexedColumnSchema indexedColumnSchema, TableMeta dataTableMeta) throws LindormException {
        LColumn dataLColumn = dataTableMeta.resolveColumn(indexedColumnSchema.getColumnKey());
        return dataLColumn.isPrimaryKey();
    }
}

