/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.LindormWideColumnService;
import com.alibaba.lindorm.client.core.tableservice.LQueryResults;
import com.alibaba.lindorm.client.core.widecolumnservice.WPartialResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WScan;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WScanner
implements Iterable<WResult> {
    private LinkedList<WResult> cache = new LinkedList();
    private WScan wScan;
    protected String tableName;
    private boolean needLoadingCache = true;
    protected LindormWideColumnService wideColumnService;
    private int rpcCount;

    public WScanner(LindormWideColumnService wideColumnService, WScan wScan, String tableName) throws LindormException {
        this.wideColumnService = wideColumnService;
        this.tableName = tableName;
        this.rpcCount = 0;
        try {
            if (wScan != null) {
                this.wScan = new WScan(wScan);
            }
        }
        catch (IOException e) {
            throw new LindormException("failed to deep copy WScan while init WScanner", e);
        }
    }

    @Override
    public Iterator<WResult> iterator() {
        return new Iterator<WResult>(){
            WResult next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = WScanner.this.next();
                        return this.next != null;
                    }
                    catch (LindormException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }

            @Override
            public WResult next() {
                if (!this.hasNext()) {
                    return null;
                }
                WResult temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void loadCache() throws LindormException {
        WPartialResult result = this.wideColumnService.scan(this.tableName, this.wScan);
        ++this.rpcCount;
        boolean reachLimit = false;
        if (result != null && result.getResults() != null) {
            List<WResult> wResultList = result.getResults();
            if (this.wScan.getLimit() >= 0) {
                int nextScanLimit = this.wScan.getLimit() - wResultList.size();
                if (nextScanLimit == 0) {
                    this.cache.addAll(wResultList);
                    reachLimit = true;
                } else if (nextScanLimit < 0) {
                    int overflowRowCount = -nextScanLimit;
                    this.cache.addAll(wResultList.subList(0, wResultList.size() - overflowRowCount));
                    reachLimit = true;
                } else {
                    this.cache.addAll(wResultList);
                }
                this.wScan.setLimit(nextScanLimit);
            } else {
                this.cache.addAll(result.getResults());
            }
        }
        if (!this.hasMore(result) || reachLimit) {
            this.needLoadingCache = false;
        } else {
            this.wScan.setStartRowKey(result.getNextStartKey());
            this.wScan.setResumeRow(result.getResumeRow());
            this.wScan.setOffset(this.wScan.getOffset() - result.getSkipped());
            this.wScan.setSelectContext(result.getSelectContext());
        }
    }

    private boolean hasMore(WPartialResult result) {
        if (result == null) {
            return false;
        }
        if (result.getNextStartKey() != null) {
            return true;
        }
        LQueryResults.SelectContext context = result.getSelectContext();
        return context != null && LQueryResults.hasMore(context);
    }

    public WResult next() throws LindormException {
        while (this.needLoadingCache && this.cache.size() == 0) {
            this.loadCache();
        }
        if (!this.cache.isEmpty()) {
            return this.cache.poll();
        }
        return null;
    }

    public int getRpcCount() {
        return this.rpcCount;
    }
}

