/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.haclient.AdminUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.AliHBaseAdminInterface;
import org.apache.hadoop.hbase.client.AliHBaseMultiClusterConnection;
import org.apache.hadoop.hbase.client.AliHBaseUEAdmin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.index.AliHBaseIndexDescriptor;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class AliHBaseMultiAdmin
extends HBaseAdmin
implements AliHBaseAdminInterface {
    private static final Log LOG = LogFactory.getLog(AliHBaseMultiAdmin.class);
    private volatile HBaseAdmin currentHBaseAdmin = null;
    private long switchCount = 0L;
    private AliHBaseMultiClusterConnection connection;

    public AliHBaseMultiAdmin(AliHBaseMultiClusterConnection connection, HBaseAdmin hbaseAdmin) throws IOException {
        super((ClusterConnection)connection);
        this.currentHBaseAdmin = hbaseAdmin;
        this.connection = connection;
        this.switchCount = connection.getSwitchCount();
    }

    private HBaseAdmin getCurrentHBaseAdmin() throws IOException {
        if (this.switchCount < this.connection.getSwitchCount()) {
            AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(this.connection.getConfiguration().get("hbase.cluster.type"));
            if (!(this.currentHBaseAdmin instanceof HBaseAdmin) || clusterType != AliHBaseConstants.ClusterType.HBASE) {
                HBaseAdmin newHBaseAdmin = this.connection.getHBaseAdmin();
                HBaseAdmin lastHBaseAdmin = this.currentHBaseAdmin;
                this.currentHBaseAdmin = newHBaseAdmin;
                if (lastHBaseAdmin != null) {
                    try {
                        lastHBaseAdmin.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("last hbaseAdmin close failed" + e));
                    }
                }
            }
            this.switchCount = this.connection.getSwitchCount();
        }
        return this.currentHBaseAdmin;
    }

    public int getOperationTimeout() {
        return this.currentHBaseAdmin.getOperationTimeout();
    }

    public void abort(String why, Throwable e) {
        this.currentHBaseAdmin.abort(why, e);
    }

    public boolean isAborted() {
        return this.currentHBaseAdmin.isAborted();
    }

    public Configuration getConfiguration() {
        return this.currentHBaseAdmin.getConfiguration();
    }

    public boolean tableExists(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().tableExists(tableName);
    }

    public HConnection getConnection() {
        return this.connection;
    }

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        try {
            return this.getCurrentHBaseAdmin().isMasterRunning();
        }
        catch (IOException e) {
            LOG.error((Object)("isMasterRunning failed : " + e));
            return true;
        }
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.getCurrentHBaseAdmin().listTables();
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        return this.listTables();
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables();
    }

    public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTables();
    }

    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        return this.listTables();
    }

    public TableName[] listTableNames() throws IOException {
        return this.getCurrentHBaseAdmin().listTableNames();
    }

    public TableName[] listTableNames(Pattern pattern) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(String regex) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        return this.listTableNames();
    }

    public HTableDescriptor getTableDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        return this.getCurrentHBaseAdmin().getTableDescriptor(tableName);
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
        return this.getCurrentHBaseAdmin().listTableDescriptorsByNamespace(name);
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        return this.getCurrentHBaseAdmin().listTableNamesByNamespace(name);
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        return this.getCurrentHBaseAdmin().getTableDescriptorsByTableName(tableNames);
    }

    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        return this.getCurrentHBaseAdmin().getTableDescriptors(names);
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.getCurrentHBaseAdmin().createTable(desc, splitKeys);
        try {
            AdminUtil.setCreateInfoNode(this.connection.getOriginalConf(), desc, splitKeys);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void createTableAsync(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.getCurrentHBaseAdmin().createTableAsync(desc, splitKeys);
    }

    public void deleteTable(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().deleteTable(tableName);
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        this.getCurrentHBaseAdmin().truncateTable(tableName, preserveSplits);
    }

    public void enableTable(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().enableTable(tableName);
    }

    public void enableTableAsync(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().enableTableAsync(tableName);
    }

    public void disableTable(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().disableTable(tableName);
    }

    public void disableTableAsync(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().disableTableAsync(tableName);
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().isTableEnabled(tableName);
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().isTableDisabled(tableName);
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.isTableEnabled(tableName);
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.getCurrentHBaseAdmin().isTableAvailable(tableName, splitKeys);
    }

    public void addColumn(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().addColumn(tableName, columnFamily);
    }

    public void deleteColumn(TableName tableName, byte[] columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().deleteColumn(tableName, columnFamily);
    }

    public void modifyColumn(TableName tableName, HColumnDescriptor descriptor) throws IOException {
        this.getCurrentHBaseAdmin().modifyColumn(tableName, descriptor);
    }

    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        this.getCurrentHBaseAdmin().modifyNamespace(descriptor);
    }

    public void deleteNamespace(String name) throws IOException {
        this.getCurrentHBaseAdmin().deleteNamespace(name);
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        return this.getCurrentHBaseAdmin().getNamespaceDescriptor(name);
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        return this.getCurrentHBaseAdmin().listNamespaceDescriptors();
    }

    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        this.getCurrentHBaseAdmin().createNamespace(descriptor);
    }

    public void flush(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().flush(tableName);
    }

    public void flushRegion(byte[] regionName) throws IOException {
        this.getCurrentHBaseAdmin().flushRegion(regionName);
    }

    public void compact(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().compact(tableName);
    }

    public void compactRegion(byte[] regionName) throws IOException {
        this.getCurrentHBaseAdmin().compactRegion(regionName);
    }

    public void compact(TableName tableName, byte[] columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().compact(tableName, columnFamily);
    }

    public void compactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().compactRegion(regionName, columnFamily);
    }

    public void compact(String tableNameOrRegionName) throws IOException {
        this.getCurrentHBaseAdmin().compact(tableNameOrRegionName);
    }

    public void compact(byte[] tableNameOrRegionName) throws IOException {
        this.getCurrentHBaseAdmin().compact(tableNameOrRegionName);
    }

    public void compact(String tableOrRegionName, String columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().compact(tableOrRegionName, columnFamily);
    }

    public void compact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().compact(tableNameOrRegionName, columnFamily);
    }

    public void compactRegionServer(ServerName sn, boolean major) throws IOException, InterruptedException {
        this.getCurrentHBaseAdmin().compactRegionServer(sn, major);
    }

    public void majorCompact(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().majorCompact(tableName);
    }

    public void majorCompactRegion(byte[] regionName) throws IOException {
        this.getCurrentHBaseAdmin().majorCompactRegion(regionName);
    }

    public void majorCompact(TableName tableName, byte[] columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().majorCompact(tableName, columnFamily);
    }

    public void majorCompact(String tableNameOrRegionName) throws IOException {
        this.getCurrentHBaseAdmin().majorCompact(tableNameOrRegionName);
    }

    public void majorCompact(byte[] tableNameOrRegionName) throws IOException {
        this.getCurrentHBaseAdmin().majorCompact(tableNameOrRegionName);
    }

    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().majorCompactRegion(regionName, columnFamily);
    }

    public void majorCompact(String tableNameOrRegionName, String columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().majorCompact(tableNameOrRegionName, columnFamily);
    }

    public void majorCompact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().majorCompact(tableNameOrRegionName, columnFamily);
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.getCurrentHBaseAdmin().disableTables(regex);
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        return this.getCurrentHBaseAdmin().disableTables(pattern);
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.getCurrentHBaseAdmin().enableTables(regex);
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        return this.getCurrentHBaseAdmin().enableTables(pattern);
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        return this.getCurrentHBaseAdmin().deleteTables(regex);
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        return this.getCurrentHBaseAdmin().deleteTables(pattern);
    }

    public void closeRegion(String regionname, String serverName) throws IOException {
        this.getCurrentHBaseAdmin().closeRegion(regionname, serverName);
    }

    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        this.getCurrentHBaseAdmin().closeRegion(regionname, serverName);
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        return this.getCurrentHBaseAdmin().closeRegionWithEncodedRegionName(encodedRegionName, serverName);
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        this.getCurrentHBaseAdmin().closeRegion(sn, hri);
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        return this.getCurrentHBaseAdmin().getOnlineRegions(sn);
    }

    public void move(byte[] encodedRegionName, byte[] destServerName) throws IOException {
        this.getCurrentHBaseAdmin().move(encodedRegionName, destServerName);
    }

    public void assign(byte[] regionName) throws IOException {
        this.getCurrentHBaseAdmin().assign(regionName);
    }

    public void unassign(byte[] regionName, boolean force) throws IOException {
        this.getCurrentHBaseAdmin().unassign(regionName, force);
    }

    public void offline(byte[] regionName) throws IOException {
        this.getCurrentHBaseAdmin().offline(regionName);
    }

    public boolean setBalancerRunning(boolean on, boolean synchronous) throws IOException {
        return this.getCurrentHBaseAdmin().setBalancerRunning(on, synchronous);
    }

    public boolean balancer() throws IOException {
        return this.getCurrentHBaseAdmin().balancer();
    }

    public boolean isBalancerEnabled() throws IOException {
        return this.getCurrentHBaseAdmin().isBalancerEnabled();
    }

    public boolean enableCatalogJanitor(boolean enable) throws IOException {
        return this.getCurrentHBaseAdmin().enableCatalogJanitor(enable);
    }

    public int runCatalogScan() throws IOException {
        return this.getCurrentHBaseAdmin().runCatalogScan();
    }

    public boolean isCatalogJanitorEnabled() throws IOException {
        return this.getCurrentHBaseAdmin().isCatalogJanitorEnabled();
    }

    public void mergeRegions(byte[] encodedNameOfRegionA, byte[] encodedNameOfRegionB, boolean forcible) throws IOException {
        this.getCurrentHBaseAdmin().mergeRegions(encodedNameOfRegionA, encodedNameOfRegionB, forcible);
    }

    public void split(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().split(tableName);
    }

    public void splitRegion(byte[] regionName) throws IOException {
        this.getCurrentHBaseAdmin().splitRegion(regionName);
    }

    public void split(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.getCurrentHBaseAdmin().split(tableNameOrRegionName);
    }

    public void split(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.getCurrentHBaseAdmin().split(tableNameOrRegionName);
    }

    public void split(TableName tableName, byte[] splitPoint) throws IOException {
        this.getCurrentHBaseAdmin().split(tableName, splitPoint);
    }

    public void splitRegion(byte[] regionName, byte[] splitPoint) throws IOException {
        this.getCurrentHBaseAdmin().splitRegion(regionName, splitPoint);
    }

    public void split(String tableNameOrRegionName, String splitPoint) throws IOException {
        this.getCurrentHBaseAdmin().split(tableNameOrRegionName, splitPoint);
    }

    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException {
        this.getCurrentHBaseAdmin().split(tableNameOrRegionName, splitPoint);
    }

    public void split(ServerName sn, HRegionInfo hri, byte[] splitPoint) throws IOException {
        this.getCurrentHBaseAdmin().split(sn, hri, splitPoint);
    }

    public void modifyTable(TableName tableName, HTableDescriptor htd) throws IOException {
        this.getCurrentHBaseAdmin().modifyTable(tableName, htd);
        try {
            AdminUtil.setModifyInfoNode(this.connection.getOriginalConf(), htd);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf((byte[])tableName), htd);
    }

    public void modifyTable(String tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf((String)tableName), htd);
    }

    public synchronized void shutdown() throws IOException {
        this.getCurrentHBaseAdmin().shutdown();
    }

    public synchronized void stopMaster() throws IOException {
        this.getCurrentHBaseAdmin().stopMaster();
    }

    public synchronized void stopRegionServer(String hostnamePort) throws IOException {
        this.getCurrentHBaseAdmin().stopRegionServer(hostnamePort);
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return this.getCurrentHBaseAdmin().getClusterStatus();
    }

    public ProcedureInfo[] listProcedures() throws IOException {
        return this.getCurrentHBaseAdmin().listProcedures();
    }

    public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getTableRegions(tableName);
    }

    public synchronized void close() throws IOException {
        this.getCurrentHBaseAdmin().close();
    }

    public synchronized byte[][] rollHLogWriter(String serverName) throws IOException, FailedLogCloseException {
        return this.getCurrentHBaseAdmin().rollHLogWriter(serverName);
    }

    public synchronized void rollWALWriter(ServerName serverName) throws IOException, FailedLogCloseException {
        this.getCurrentHBaseAdmin().rollWALWriter(serverName);
    }

    public String[] getMasterCoprocessors() {
        try {
            return this.getCurrentHBaseAdmin().getMasterCoprocessors();
        }
        catch (IOException e) {
            LOG.error((Object)("getMasterCoprocessors failed : " + e));
            return null;
        }
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getCompactionState(tableName);
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] regionName) throws IOException {
        return this.getCurrentHBaseAdmin().getCompactionStateForRegion(regionName);
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(String tableNameOrRegionName) throws IOException, InterruptedException {
        return this.getCurrentHBaseAdmin().getCompactionState(tableNameOrRegionName);
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        return this.getCurrentHBaseAdmin().getCompactionState(tableNameOrRegionName);
    }

    public void snapshot(String snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName);
    }

    public void snapshot(String snapshotName, String tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName);
    }

    public void snapshot(byte[] snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type flushType) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName, flushType);
    }

    public void snapshot(byte[] snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName);
    }

    public void snapshot(byte[] snapshotName, byte[] tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName);
    }

    public void snapshot(String snapshotName, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName, type);
    }

    public void snapshot(String snapshotName, String tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName, type);
    }

    public void snapshot(String snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName, type);
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.getCurrentHBaseAdmin().snapshot(snapshot);
    }

    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        return this.getCurrentHBaseAdmin().takeSnapshotAsync(snapshot);
    }

    public boolean isSnapshotFinished(HBaseProtos.SnapshotDescription snapshot) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        return this.getCurrentHBaseAdmin().isSnapshotFinished(snapshot);
    }

    public void restoreSnapshot(byte[] snapshotName) throws IOException, RestoreSnapshotException {
        this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName);
    }

    public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName);
    }

    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName, takeFailSafeSnapshot);
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName, takeFailSafeSnapshot);
    }

    public void cloneSnapshot(byte[] snapshotName, byte[] tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        this.getCurrentHBaseAdmin().cloneSnapshot(snapshotName, tableName);
    }

    public void cloneSnapshot(byte[] snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        this.getCurrentHBaseAdmin().cloneSnapshot(snapshotName, tableName);
    }

    public void cloneSnapshot(String snapshotName, String tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        this.getCurrentHBaseAdmin().cloneSnapshot(snapshotName, tableName);
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        this.getCurrentHBaseAdmin().cloneSnapshot(snapshotName, tableName);
    }

    public byte[] execProcedureWithRet(String signature, String instance, Map<String, String> props) throws IOException {
        return this.getCurrentHBaseAdmin().execProcedureWithRet(signature, instance, props);
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        this.getCurrentHBaseAdmin().execProcedure(signature, instance, props);
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        return this.getCurrentHBaseAdmin().isProcedureFinished(signature, instance, props);
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        return this.getCurrentHBaseAdmin().listSnapshots();
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(String regex) throws IOException {
        return this.getCurrentHBaseAdmin().listSnapshots(regex);
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        return this.getCurrentHBaseAdmin().listSnapshots(pattern);
    }

    public int getMasterInfoPort() throws IOException {
        return this.getCurrentHBaseAdmin().getMasterInfoPort();
    }

    public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getTableRegions(tableName);
    }

    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) throws IOException {
        return this.getCurrentHBaseAdmin().abortProcedure(procId, mayInterruptIfRunning);
    }

    public Future<Boolean> abortProcedureAsync(long procId, boolean mayInterruptIfRunning) throws IOException {
        return this.getCurrentHBaseAdmin().abortProcedureAsync(procId, mayInterruptIfRunning);
    }

    public long getLastMajorCompactionTimestamp(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getLastMajorCompactionTimestamp(tableName);
    }

    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
        return this.getCurrentHBaseAdmin().getLastMajorCompactionTimestampForRegion(regionName);
    }

    public void deleteSnapshot(byte[] snapshotName) throws IOException {
        this.getCurrentHBaseAdmin().deleteSnapshot(snapshotName);
    }

    public void deleteSnapshot(String snapshotName) throws IOException {
        this.getCurrentHBaseAdmin().deleteSnapshot(snapshotName);
    }

    public void deleteSnapshots(String regex) throws IOException {
        this.getCurrentHBaseAdmin().deleteSnapshots(regex);
    }

    public void deleteSnapshots(Pattern pattern) throws IOException {
        this.getCurrentHBaseAdmin().deleteSnapshots(pattern);
    }

    public void setQuota(QuotaSettings quota) throws IOException {
        this.getCurrentHBaseAdmin().setQuota(quota);
    }

    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) throws IOException {
        return this.getCurrentHBaseAdmin().getQuotaRetriever(filter);
    }

    public CoprocessorRpcChannel coprocessorService() {
        try {
            return this.getCurrentHBaseAdmin().coprocessorService();
        }
        catch (IOException e) {
            LOG.error((Object)("coprocessorService failed : " + e));
            return null;
        }
    }

    public CoprocessorRpcChannel coprocessorService(ServerName serverName) {
        try {
            return this.getCurrentHBaseAdmin().coprocessorService(serverName);
        }
        catch (IOException e) {
            LOG.error((Object)("coprocessorService failed : " + e));
            return null;
        }
    }

    public void updateConfiguration(ServerName server) throws IOException {
        this.getCurrentHBaseAdmin().updateConfiguration(server);
    }

    public void updateConfiguration() throws IOException {
        this.getCurrentHBaseAdmin().updateConfiguration();
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getAlterStatus(tableName);
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getAlterStatus(tableName);
    }

    @Override
    public List<AliHBaseIndexDescriptor> describeIndex(TableName dataTableName) throws IOException {
        if (this.isHBaseUE()) {
            return ((AliHBaseUEAdmin)this.currentHBaseAdmin).describeIndex(dataTableName);
        }
        throw new UnsupportedOperationException("describeIndex not supported by HBase, please use HBaseUE instead.");
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor) throws IOException {
        if (!this.isHBaseUE()) {
            throw new UnsupportedOperationException("createIndex not supported by HBase, please use HBaseUE instead.");
        }
        ((AliHBaseUEAdmin)this.currentHBaseAdmin).createIndex(indexDescriptor);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[][] splitKeys) throws IOException {
        if (!this.isHBaseUE()) {
            throw new UnsupportedOperationException("createIndex not supported by HBase, please use HBaseUE instead.");
        }
        ((AliHBaseUEAdmin)this.currentHBaseAdmin).createIndex(indexDescriptor, splitKeys);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (!this.isHBaseUE()) {
            throw new UnsupportedOperationException("createIndex not supported by HBase, please use HBaseUE instead.");
        }
        ((AliHBaseUEAdmin)this.currentHBaseAdmin).createIndex(indexDescriptor, startKey, endKey, numRegions);
    }

    @Override
    public void deleteIndex(String indexName, TableName dataTable) throws IOException {
        if (!this.isHBaseUE()) {
            throw new UnsupportedOperationException("createIndex not supported by HBase, please use HBaseUE instead.");
        }
        ((AliHBaseUEAdmin)this.currentHBaseAdmin).deleteIndex(indexName, dataTable);
        throw new UnsupportedOperationException("createIndex not supported");
    }

    @Override
    public void offlineIndex(String indexName, TableName dataTable) throws IOException {
        if (!this.isHBaseUE()) {
            throw new UnsupportedOperationException("offlineIndex not supported by HBase, please use HBaseUE instead.");
        }
        ((AliHBaseUEAdmin)this.currentHBaseAdmin).offlineIndex(indexName, dataTable);
    }

    private boolean isHBaseUE() {
        AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(this.connection.getConfiguration().get("hbase.cluster.type"));
        return this.currentHBaseAdmin instanceof AliHBaseUEAdmin && clusterType == AliHBaseConstants.ClusterType.HBASEUE;
    }
}

